/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.SearchDBObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchQueue
extends Thread {
    private boolean isCompleted = false;
    private boolean shutDown = false;
    private Hashtable objects = null;
    private Object obj = new Object();
    private int totalCount = 0;
    private Hashtable tableProps = null;
    protected String tableKey = "OBJECT_GUID";
    public static Logger reportLogger = Logger.getLogger("ReportLogger");

    public SearchQueue() {
        this.objects = new Hashtable();
        reportLogger.log(Level.INFO, "Initialiazing Report Queue");
        this.start();
    }

    public boolean isCompleted() {
        if (this.shutDown) {
            if (this.totalCount > 0) {
                reportLogger.log(Level.INFO, "BUG : It Should not happen " + this.totalCount);
            }
            return true;
        }
        return this.isCompleted;
    }

    public void shutDown() {
        this.shutDown = true;
    }

    public void setTableProps(Hashtable props) {
        this.tableProps = props;
    }

    public synchronized void waitForUpdate(long t) {
        try {
            super.wait(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToQueue(String objectClass, String guid, Hashtable map, Hashtable relationalMap) {
        this.isCompleted = false;
        Object object = this.obj;
        synchronized (object) {
            ++this.totalCount;
            SearchDBObject dbObject = (SearchDBObject)this.objects.get(objectClass);
            if (dbObject == null) {
                dbObject = new SearchDBObject(objectClass);
                this.objects.put(objectClass, dbObject);
            }
            dbObject.add(guid, map, relationalMap);
            if (this.totalCount >= 500) {
                this.notifyAll();
            }
        }
    }

    public void checkForNextUpdate() {
        if (this.totalCount >= 500) {
            while (!this.isCompleted) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            int count = 0;
            Hashtable objs = null;
            Object object = this.obj;
            synchronized (object) {
                if (this.totalCount == 0) {
                    return;
                }
                count = this.totalCount;
                this.totalCount = 0;
                objs = this.objects;
                this.objects = new Hashtable();
            }
            String domainName = (String)this.tableProps.get("domainName");
            Long generationId = (Long)this.tableProps.get("generationId");
            Enumeration e = objs.keys();
            while (e.hasMoreElements()) {
                SearchDBObject dbObject = (SearchDBObject)objs.get(e.nextElement());
                ArrayList guidList = dbObject.getGuidList();
                Hashtable tableMap = dbObject.getTableMap();
                Hashtable multipleMap = dbObject.getMultipleMap();
                String baseTableName = dbObject.getBaseTable();
                String resultTableName = dbObject.getResultTable();
                DBObjectUtil.addOrUpdate(baseTableName, this.tableKey, guidList, tableMap, multipleMap);
                this.updateResult(generationId, resultTableName, guidList);
            }
            reportLogger.log(Level.INFO, "Completing the Updation with the total count of " + count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateResult(Long generationId, String resultTableName, ArrayList guids) {
        ReportHandler.addSIDReportResult(generationId, resultTableName, guids);
    }

    public void checkAndProcess() {
        this.waitForUpdate(500L);
        this.process();
        if (this.totalCount == 0) {
            this.isCompleted = true;
        }
    }

    @Override
    public void run() {
        try {
            while (!this.shutDown) {
                this.checkAndProcess();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

