/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.scheduler.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.alarm.DownTimeAlarm;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.license.alarm.LicenseUsageHandler;
import com.manageengine.ads.fw.mail.MailHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class ServerUtil {
    public static final String[] MAIL_PARAMS = new String[]{"MAIL_SERVER", "SMTP_PORT", "FROM_ADDRESS", "MAIL_SERVER_USER", "MAIL_SERVER_PWD", "USE_SECURE_CONNECTION", "HTML_FORMAT", "ADMIN_MAIL_ID", "NOTIFY_LICENSE_EXPIRY", "NOTIFY_DOWN_TIME", "NOTIFY_SECONDARY", "NOTIFY_LIC_EXPIRY_DAYS", "NOTIFY_UNUSED_LICENSE_LIMIT"};
    public static final String[] ADS_MAIL_PARAMS = new String[]{"SERVER_NAME", "PORT", "FROM_MAIL_ID", "USER_NAME", "PASSWORD", "CONNECTION_SECURITY_ID", "ENABLE_HTML_FORMAT", "ADMIN_MAIL_ID"};
    public static final String[] PROXY_PARAMS = new String[]{"SERVER_NAME", "PORT", "USER_NAME", "PASSWORD"};
    public static final String[] PROXY_PROPS = new String[]{"https.proxyHost", "https.proxyPort", "https.proxyUser", "https.proxyPassword"};
    private static final String SMPP_ADDRESS_TON = "[{\"0\":\"Unknown\"},{\"1\":\"International\"},{\"2\":\"National\"},{\"3\":\"Network Specific\"},{\"4\":\"Subscriber Number\"},{\"5\":\"Alphanumeric\"},{\"6\":\"Abbreviated\"}]";
    private static final String SMPP_ADDRESS_NPI = "[{\"0\":\"Unknown\"},{\"1\":\"ISDN\"},{\"3\":\"Data\"},{\"4\":\"Telex\"},{\"6\":\"Land Mobile\"},{\"8\":\"National\"},{\"9\":\"Private\"},{\"10\":\"ERMES\"},{\"14\":\"Internet (IP)\"},{\"18\":\"WAP Client Id \"}]";
    public static final String SUPPORTED_TIME_OUT = "[{\"5\":\"5\"},{\"10\":\"10\"},{\"15\":\"15\"},{\"20\":\"20\"},{\"25\":\"25\"},{\"30\":\"30\"}]";
    public static final String SUPPORTED_BIND_TYPE = "[{\"2\":\"Bind Transmitter\"},{\"9\":\"Bind Transceiver\"}]";

    public static Properties getMailServerSettings() {
        Properties prop = new Properties();
        try {
            JSONObject adsMailProp = MailHandler.getMailSettings();
            JSONObject adsConnSecurity = MailHandler.getConnectionSecurity();
            if (adsMailProp.has("SERVER_NAME") && adsMailProp.get("SERVER_NAME") != null) {
                for (int i = 0; i < ADS_MAIL_PARAMS.length; ++i) {
                    String key = MAIL_PARAMS[i];
                    if (adsMailProp.has(ADS_MAIL_PARAMS[i]) && adsMailProp.get(ADS_MAIL_PARAMS[i]) != null) {
                        if ("CONNECTION_SECURITY_ID".equals(ADS_MAIL_PARAMS[i]) && adsConnSecurity.has(adsMailProp.get(ADS_MAIL_PARAMS[i]).toString())) {
                            prop.put(key, adsConnSecurity.get(adsMailProp.get(ADS_MAIL_PARAMS[i]).toString()));
                            continue;
                        }
                        prop.put(key, adsMailProp.get(ADS_MAIL_PARAMS[i]));
                        continue;
                    }
                    prop.put(key, "");
                }
            } else {
                Row r;
                String mailServer = "";
                DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADSMExchangeServers", (Criteria)null);
                if (!o.isEmpty() && (mailServer = (String)(r = o.getFirstRow("ADSMExchangeServers")).get("SERVER_NAME")).indexOf("/") > 0) {
                    mailServer = mailServer.substring(mailServer.lastIndexOf("/") + 1);
                }
                String[] ar = new String[]{mailServer, "25", "noreply@adselfserviceplus.com", "", "", "", "", "", "", "", "", "", ""};
                for (int i = 0; i < MAIL_PARAMS.length - 1; ++i) {
                    String key = MAIL_PARAMS[i];
                    prop.put(key, ar[i]);
                }
            }
            String adminMailId = "";
            if (adsMailProp.has("ADMIN_MAIL_ID") && adsMailProp.getString("ADMIN_MAIL_ID") != null) {
                adminMailId = adsMailProp.get("ADMIN_MAIL_ID") != null ? (String)adsMailProp.get("ADMIN_MAIL_ID") : "";
            }
            boolean htmlFormat = false;
            if (adsMailProp.has("ENABLE_HTML_FORMAT")) {
                htmlFormat = (Boolean)adsMailProp.get("ENABLE_HTML_FORMAT");
            }
            prop.put("HTML_FORMAT", htmlFormat ? "true" : "false");
            prop.put("ADMIN_MAIL_ID", adminMailId);
            prop.put("NOTIFY_LICENSE_EXPIRY", SchedulerUtil.getTaskInputAdminStatus("LicenseExpirySchedule") == 3 ? "true" : "false");
            prop.put("NOTIFY_LIC_EXPIRY_DAYS", ServerUtil.getNotifyDaysJSON());
            JSONObject usageCount = LicenseUsageHandler.getUsageCount((String)"DomainUsers");
            JSONArray notifyUnusedLicLimit = usageCount != null && usageCount.has("DomainUsers") ? usageCount.getJSONArray("DomainUsers") : new JSONArray("[-1]");
            prop.put("NOTIFY_UNUSED_LICENSE_LIMIT", notifyUnusedLicLimit);
            prop.put("NOTIFY_DOWN_TIME", ServerUtil.getDownTimeAlarmStatus() != false ? "true" : "false");
            String notifySecondary = ADSMPersUtil.getSyMParameter("NOTIFY_SECONDARY") != null ? ADSMPersUtil.getSyMParameter("NOTIFY_SECONDARY") : "false";
            prop.put("NOTIFY_SECONDARY", notifySecondary);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static boolean setMailServerSettings(Properties prop) {
        JSONObject adsMailProp = new JSONObject();
        boolean updated = false;
        try {
            boolean toBeUpdate = false;
            Properties p = ServerUtil.getMailServerSettings();
            for (String key : MAIL_PARAMS) {
                String formProp = (String)prop.get(key);
                if (formProp == null || formProp.equalsIgnoreCase(String.valueOf(p.get(key)))) continue;
                toBeUpdate = true;
                break;
            }
            if (toBeUpdate) {
                JSONObject adsConnSecurity = MailHandler.getConnectionSecurity();
                for (int i = 0; i < ADS_MAIL_PARAMS.length; ++i) {
                    String key = ADS_MAIL_PARAMS[i];
                    if (prop.get(MAIL_PARAMS[i]) != null) {
                        if ("USE_SECURE_CONNECTION".equals(MAIL_PARAMS[i])) {
                            Iterator objIterator = adsConnSecurity.keys();
                            while (objIterator.hasNext()) {
                                String secId = (String)objIterator.next();
                                if (!adsConnSecurity.getString(secId).equalsIgnoreCase(prop.get(MAIL_PARAMS[i]).toString())) continue;
                                adsMailProp.put(key, (Object)secId);
                                break;
                            }
                            if (adsMailProp.has("CONNECTION_SECURITY_ID")) continue;
                            adsMailProp.put("CONNECTION_SECURITY_ID", (Object)"");
                            continue;
                        }
                        adsMailProp.put(key, prop.get(MAIL_PARAMS[i]));
                        continue;
                    }
                    adsMailProp.put(key, (Object)"");
                }
                adsMailProp.put("ENABLE_HTML_FORMAT", prop.getProperty("HTML_FORMAT").equals("true"));
                MailHandler.setMailSettings((JSONObject)adsMailProp, (boolean[])new boolean[0]);
                SchedulerUtil.setTaskInputAdminStatus("LicenseExpirySchedule", prop.getProperty("NOTIFY_LICENSE_EXPIRY").equals("true") ? 3 : 4);
                ServerUtil.updateDownTimeAlarm(prop.getProperty("NOTIFY_DOWN_TIME").equals("true"));
                if (prop.getProperty("NOTIFY_LICENSE_EXPIRY").equals("true")) {
                    if (prop.getProperty("NOTIFY_LIC_EXPIRY_DAYS") != null) {
                        JSONArray Json = new JSONArray("[" + prop.getProperty("NOTIFY_LIC_EXPIRY_DAYS") + "]");
                        LicenseManager.setLicenseExpiryDays((JSONArray)Json);
                    }
                    if (prop.getProperty("NOTIFY_UNUSED_LICENSE_LIMIT") != null && !prop.getProperty("NOTIFY_UNUSED_LICENSE_LIMIT").equals("")) {
                        JSONArray usageCount = new JSONArray("[" + prop.getProperty("NOTIFY_UNUSED_LICENSE_LIMIT").trim() + "]");
                        JSONObject usageJson = new JSONObject();
                        usageJson.put("DomainUsers", (Object)usageCount);
                        LicenseUsageHandler.setUsageCount((JSONObject)usageJson);
                    }
                } else {
                    LicenseUsageHandler.setUsageCount((JSONObject)new JSONObject("{\"DomainUsers\":[-1]}"));
                }
                ADSMPersUtil.updateSyMParameter("NOTIFY_SECONDARY", prop.getProperty("NOTIFY_SECONDARY"));
                com.manageengine.ads.fw.util.CommonUtil.setProductParamValue((String)com.manageengine.ads.fw.util.CommonUtil.getProductId().toString(), (String)"NOTIFY_SECONDARY", (String)prop.getProperty("NOTIFY_SECONDARY"));
                updated = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return updated;
    }

    public static JSONObject getSMSSettings() {
        JSONObject smsSettings = new JSONObject();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSProvider", (Criteria)null);
            if (!obj.isEmpty()) {
                JSONArray providers = new JSONArray();
                Iterator providerIt = obj.getRows("ADSSMSProvider");
                while (providerIt.hasNext()) {
                    Row providerRow = (Row)providerIt.next();
                    Long providerId = (Long)providerRow.get("PROVIDER_ID");
                    JSONObject provider = new JSONObject();
                    for (Object object : providerRow.getColumns()) {
                        String cN;
                        Object rowValue = providerRow.get(cN = (String)object);
                        provider.put(cN, rowValue != null ? rowValue : "");
                    }
                    providers.put((Object)provider);
                    Criteria accCri = new Criteria(Column.getColumn((String)"ADSSMSServerConfig", (String)"PROVIDER_ID"), (Object)providerId, 0);
                    accCri = accCri.and(new Criteria(Column.getColumn((String)"ADSSMSServerConfig", (String)"IS_SELECTED"), (Object)true, 0));
                    DataObject accDO = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSServerConfig", accCri);
                    if (accDO.isEmpty()) continue;
                    JSONObject smsAccount = new JSONObject();
                    Row accRow = accDO.getRow("ADSSMSServerConfig");
                    for (Object object : accRow.getColumns()) {
                        String cN;
                        Object rowValue = accRow.get(cN = (String)object);
                        smsAccount.put(cN, rowValue != null ? rowValue : "");
                    }
                    smsSettings.put("SMS_ACCOUNT", (Object)smsAccount);
                    Criteria apiCri = new Criteria(Column.getColumn((String)"ADSSMSAPISettings", (String)"PROVIDER_ID"), (Object)providerId, 0);
                    DataObject apiDO = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSAPISettings", apiCri);
                    if (!apiDO.isEmpty()) {
                        JSONArray apiSettings = new JSONArray();
                        Iterator apiIt = apiDO.getRows("ADSSMSAPISettings");
                        while (apiIt.hasNext()) {
                            JSONObject settings = new JSONObject();
                            Row apiRows = (Row)apiIt.next();
                            for (Object object : apiRows.getColumns()) {
                                String cN;
                                Object rowValue = apiRows.get(cN = (String)object);
                                settings.put(cN, rowValue != null ? rowValue : "");
                            }
                            apiSettings.put((Object)settings);
                        }
                        smsSettings.put("API_SETTINGS", (Object)apiSettings);
                    }
                    smsSettings.put("SELECTED_PROVIDER", (Object)((String)providerRow.get("PROVIDER_NAME")));
                }
                smsSettings.put("PROVIDERS", (Object)providers);
                smsSettings.put("CUSTOM_SMS_TYPE", (Object)new JSONArray("['HTTP', 'SMTP','SMPP']"));
                smsSettings.put("ADDRESS_TON", (Object)new JSONArray(SMPP_ADDRESS_TON));
                smsSettings.put("ADDRESS_NPI", (Object)new JSONArray(SMPP_ADDRESS_NPI));
                smsSettings.put("SUPPORTED_TIME_OUT", (Object)new JSONArray(SUPPORTED_TIME_OUT));
                smsSettings.put("SUPPORTED_BIND_TYPE", (Object)new JSONArray(SUPPORTED_BIND_TYPE));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return smsSettings;
    }

    public static void setSMSSettings(JSONObject smsSettings) {
        try {
            JSONArray jsonArr;
            JSONObject jsonObj;
            Long providerId = smsSettings.getLong("PROVIDER_ID");
            if (!smsSettings.isNull("API_SETTINGS") && !(jsonObj = (jsonArr = smsSettings.getJSONArray("API_SETTINGS")).getJSONObject(0)).isNull("API_TYPE")) {
                String apiType = jsonObj.getString("API_TYPE");
                Criteria c = new Criteria(Column.getColumn((String)"ADSSMSAPISettings", (String)"PROVIDER_ID"), (Object)providerId, 0);
                c = c.and(new Criteria(Column.getColumn((String)"ADSSMSAPISettings", (String)"API_TYPE"), (Object)apiType, 0));
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSAPISettings", c);
                Row r = !obj.isEmpty() ? obj.getRow("ADSSMSAPISettings") : new Row("ADSSMSAPISettings");
                Iterator keys = jsonObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    r.set(key, jsonObj.get(key));
                }
                if (!obj.isEmpty()) {
                    obj.updateRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(obj);
                } else {
                    obj.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).add(obj);
                }
            }
            if (!smsSettings.isNull("SMS_ACCOUNT")) {
                Row r;
                DataObject obj = null;
                jsonObj = smsSettings.getJSONObject("SMS_ACCOUNT");
                if (!jsonObj.isNull("IS_SELECTED") && !(obj = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSServerConfig", (Criteria)null)).isEmpty()) {
                    Iterator rows = obj.getRows("ADSSMSServerConfig");
                    while (rows.hasNext()) {
                        r = (Row)rows.next();
                        r.set("IS_SELECTED", (Object)false);
                        obj.updateRow(r);
                    }
                    CommonUtil.getPersistenceLite().update(obj);
                }
                Criteria c = new Criteria(Column.getColumn((String)"ADSSMSServerConfig", (String)"PROVIDER_ID"), (Object)providerId, 0);
                obj = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSServerConfig", c);
                r = !obj.isEmpty() ? obj.getRow("ADSSMSServerConfig") : new Row("ADSSMSServerConfig");
                Iterator keys = jsonObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (jsonObj.get(key).equals("")) continue;
                    r.set(key, jsonObj.get(key));
                }
                if (!obj.isEmpty()) {
                    obj.updateRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(obj);
                } else {
                    r.set("NO_OF_SMS_SENT", (Object)"0");
                    obj.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).add(obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isSMSAddonConfigured() {
        try {
            ArrayList<String> smsTables = new ArrayList<String>();
            smsTables.add("ADSSMSProvider");
            smsTables.add("ADSSMSAPISettings");
            Criteria crit = new Criteria(Column.getColumn((String)"ADSSMSProvider", (String)"PROVIDER_NAME"), (Object)"Clickatell", 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(smsTables, crit);
            if (!obj.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Long getSMSSentCount(String providerName) {
        Long noOfSMSSent = new Long(0L);
        try {
            ArrayList<String> smsTables = new ArrayList<String>();
            smsTables.add("ADSSMSProvider");
            smsTables.add("ADSSMSServerConfig");
            Criteria crit = new Criteria(Column.getColumn((String)"ADSSMSProvider", (String)"PROVIDER_NAME"), (Object)providerName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(smsTables, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("ADSSMSServerConfig");
                noOfSMSSent = Long.parseLong((String)r.get("NO_OF_SMS_SENT"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return noOfSMSSent;
    }

    public static void setSMSSentCount(String providerName, Long noOfSMSSent) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSSMSProvider", (String)"PROVIDER_NAME"), (Object)providerName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSProvider", c);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("ADSSMSProvider");
                Long providerId = (Long)r.get("PROVIDER_ID");
                JSONObject smsAccount = new JSONObject();
                smsAccount.put("PROVIDER_ID", (Object)providerId);
                smsAccount.put("NO_OF_SMS_SENT", (Object)noOfSMSSent.toString());
                JSONObject smsSettings = new JSONObject();
                smsSettings.put("PROVIDER_ID", (Object)providerId);
                smsSettings.put("SMS_ACCOUNT", (Object)smsAccount);
                ServerUtil.setSMSSettings(smsSettings);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getProxySettings() {
        Properties prop = new Properties();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSProxySettings", (Criteria)null);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("ADSProxySettings");
                String[] arr$ = PROXY_PARAMS;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String key;
                    String rowValue = (String)r.get(key = arr$[i$]);
                    prop.put(key, rowValue != null ? rowValue : "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static void setProxySettings(Properties prop) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSProxySettings", (String)"UNIQUE_ID"), null, 1);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
            if (!prop.isEmpty()) {
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row r = new Row("ADSProxySettings");
                for (String str : PROXY_PARAMS) {
                    r.set(str, (Object)((String)prop.get(str)));
                }
                obj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(obj);
            }
            ServerUtil.setSystemProxySettings();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSystemProxySettings() {
        ServerUtil.setSystemProxySettings(ServerUtil.getProxySettings());
    }

    public static void setSystemProxySettings(Properties prop) {
        try {
            for (int i = 0; i < PROXY_PARAMS.length; ++i) {
                String str = PROXY_PARAMS[i];
                if (prop.get(str) != null && !"".equals((String)prop.get(str))) {
                    System.setProperty(PROXY_PROPS[i], (String)prop.get(str));
                    continue;
                }
                System.clearProperty(PROXY_PROPS[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toggleHtmlStatus(Boolean toggleTo) {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMailSettings", (Criteria)null);
            Row r = dataObject.getFirstRow("ADSMailSettings");
            r.set("ENABLE_HTML_FORMAT", (Object)toggleTo);
            dataObject.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Boolean getDownTimeAlarmStatus() {
        Boolean isDownTimeEnabled = true;
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"ADSProducts", (String)"PRODUCT_NAME"), (Object)com.manageengine.ads.fw.util.CommonUtil.getProductName(), 0);
            DataObject dTDO = CommonUtil.getPersistence(new boolean[0]).get("ADSDownTimeSettings", cri);
            if (!dTDO.isEmpty()) {
                Row dTRow = dTDO.getFirstRow("ADSDownTimeSettings");
                isDownTimeEnabled = (Boolean)dTRow.get("IS_ENABLED");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDownTimeEnabled;
    }

    public static void updateDownTimeAlarm(Boolean isEnabled) {
        try {
            JSONObject settings = new JSONObject().put("PRODUCT_NAME", (Object)com.manageengine.ads.fw.util.CommonUtil.getProductName());
            settings.put("IS_ENABLED", (Object)isEnabled);
            DownTimeAlarm.updateDownTimeSettings((JSONObject)settings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getNotifyDaysJSON() {
        JSONArray jArr = new JSONArray();
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"ADSLicenseExpiration", (String)"IS_ENABLED"), (Object)true, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSLicenseExpiration", cri);
            Iterator it = obj.getRows("ADSLicenseExpiration");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                jArr.put(r.get("DAYS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jArr;
    }

    public static void setNotifyDaysJSON(JSONArray noOfDays) {
        try {
            String[] subject = new String[]{"adssp.header.tab_component.license.subject_expired", "adssp.header.tab_component.license.subject_expires_today", "adssp.header.tab_component.license.subject_expires_tomorrow", "adssp.header.tab_component.license.subject_yet_to_expire"};
            String[] content = new String[]{"adssp.header.tab_component.license.license_expired", "adssp.header.tab_component.license.license_expires_today", "adssp.header.tab_component.license.license_expires_tomorrow", "adssp.header.tab_component.license.license_yet_to_expire"};
            String[] subjectAMS = new String[]{"adssp.header.tab_component.license.subject_ams_expired", "adssp.header.tab_component.license.subject_ams_expires_today", "adssp.header.tab_component.license.subject_ams_expires_tomorrow", "adssp.header.tab_component.license.subject_ams_yet_to_expire"};
            String[] contentAMS = new String[]{"adssp.header.tab_component.license.ams_expired", "adssp.header.tab_component.license.ams_expires_today", "adssp.header.tab_component.license.ams_expires_tomorrow", "adssp.header.tab_component.license.ams_yet_to_expire"};
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < noOfDays.length(); ++i) {
                int keyIndex = 2;
                int days = noOfDays.getInt(i);
                if (days > 1) {
                    keyIndex = 3;
                } else if (days == 1) {
                    keyIndex = 2;
                } else if (days == 0) {
                    keyIndex = 1;
                } else if (days < 0) {
                    keyIndex = 0;
                }
                Row r = new Row("ADSLicenseExpiration");
                r.set("DAYS", (Object)noOfDays.getInt(i));
                r.set("SUBJECT", (Object)subject[keyIndex]);
                r.set("CONTENT", (Object)content[keyIndex]);
                r.set("SUBJECT_AMS", (Object)subjectAMS[keyIndex]);
                r.set("CONTENT_AMS", (Object)contentAMS[keyIndex]);
                obj.addRow(r);
            }
            Criteria c = new Criteria(Column.getColumn((String)"ADSLicenseExpiration", (String)"DAYS"), null, 1);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateUnlimitedLicenseProps() {
        try {
            Properties mailSettings = ServerUtil.getMailServerSettings();
            String isLicExpiryEnabled = (String)mailSettings.get("NOTIFY_LICENSE_EXPIRY");
            if (isLicExpiryEnabled.equals("true")) {
                JSONArray licExpiryDays = (JSONArray)mailSettings.get("NOTIFY_LIC_EXPIRY_DAYS");
                if (licExpiryDays == null || licExpiryDays.length() <= 0) {
                    SchedulerUtil.setTaskInputAdminStatus("LicenseExpirySchedule", 4);
                }
                LicenseUsageHandler.setUsageCount((JSONObject)new JSONObject("{\"DomainUsers\":[-1]}"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

