/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class StrUtil {
    private static Logger logger = Logger.getLogger(StrUtil.class.getName());

    public static String getString(Properties p, String key) {
        String str = "";
        if (key == null || p == null) {
            return str;
        }
        if (p.get(key) == null) {
            return str;
        }
        ArrayList l = (ArrayList)p.get(key);
        if (l == null || l.size() == 0) {
            return str;
        }
        return (String)l.get(l.size() - 1);
    }

    public static boolean isValidEmailID(String mailId) {
        boolean matcher = false;
        if (mailId != null && (mailId = mailId.toLowerCase()).indexOf(" ") == -1) {
            Pattern p = Pattern.compile(".+@.+\\.[a-zA-Z]+");
            Matcher m = p.matcher(mailId);
            matcher = m.matches();
        }
        return matcher;
    }

    public static String scriptEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"\n", "\r"};
        String[] escapedChars = new String[]{"\\\\n", "\\\\r"};
        String ret = str;
        for (int i = 0; i < chars.length; ++i) {
            if (!ret.contains(chars[i])) continue;
            ret = ret.replaceAll(chars[i], escapedChars[i]);
        }
        return ret;
    }

    public static String htmlUnescape(String str) {
        if (str != null) {
            String[] keys = new String[]{"&amp;", "&gt;", "&lt;", "&quot;", "&#39;"};
            String[] vals = new String[]{"&", ">", "<", "\"", "'"};
            for (int i = 0; i < keys.length; ++i) {
                String s = keys[i];
                if (!str.contains(s)) continue;
                str = str.replaceAll(s, vals[i]);
            }
        }
        return str;
    }

    public static String queryEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"'"};
        String ret = str;
        for (String s : chars) {
            if (!ret.contains(s)) continue;
            ret = ret.replaceAll("'", "''");
        }
        return ret;
    }

    public static String customScriptEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"\\", "\"", "'"};
        String ret = str;
        for (String s : chars) {
            if (!ret.contains(s)) continue;
            ret = s.equalsIgnoreCase("\\") ? ret.replaceAll("\\\\", "\\\\\\\\") : ret.replaceAll(s, "\\\\" + s);
        }
        return ret;
    }

    public static String ginaPasswordEscape(String str) {
        if (str == null) {
            return null;
        }
        String ret = str;
        String s = "\"";
        if (ret.contains(s)) {
            ret = ret.replaceAll(s, "\\\\" + s);
        }
        return ret;
    }

    public static String jsonEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"\\", "\""};
        String ret = str;
        for (String s : chars) {
            if (!ret.contains(s)) continue;
            ret = s.equalsIgnoreCase("\\") ? ret.replaceAll("\\\\", "\\\\") : ret.replaceAll(s, "\\" + s);
        }
        return ret;
    }

    public static String powerShellEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"`", "$", "\""};
        String ret = str;
        for (String s : chars) {
            if (ret.contains(s) && !s.equalsIgnoreCase("\"")) {
                ret = ret.replace(s, "`" + s);
            }
            if (!ret.contains(s) || !s.equalsIgnoreCase("\"")) continue;
            ret = ret.replace(s, "`\\" + s);
        }
        return ret;
    }

    public static String remcomEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"^", "&", "<", ">", "|", "\""};
        String ret = str;
        ret = ret.replaceAll("\r\n", " ").replaceAll("\n", " ");
        for (String s : chars) {
            if (s.equalsIgnoreCase("\"")) {
                ret = ret.replaceAll("\"", "\\\\\"\\\\\"");
                continue;
            }
            if (!ret.contains(s)) continue;
            ret = ret.replaceAll(Pattern.quote(s), Matcher.quoteReplacement("^" + s));
        }
        return ret;
    }

    public static String decodeURIComponent(String str) {
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&quot;", "\"");
        str = str.replaceAll("&#39;", "'");
        str = str.replaceAll("%3D", "=");
        str = str.replaceAll("%40", "@");
        str = str.replaceAll("%23", "#");
        str = str.replaceAll("%24", "$");
        str = str.replaceAll("%25", "%");
        str = str.replaceAll("%26", "^");
        str = str.replaceAll("%2F", "/");
        str = str.replaceAll("%3F", "?");
        str = str.replaceAll("%2B", "+");
        str = str.replaceAll("%22", "\"");
        str = str.replaceAll("%5C", "\\");
        str = str.replaceAll("%2C", ",");
        return str;
    }

    public static String decodeURIComponentWithEscapeSequence(String str) {
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "\\\\\\\\<");
        str = str.replaceAll("&gt;", "\\\\\\\\>");
        return str;
    }

    public static String encodeURIComponent(String str) {
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll("'", "&#39;");
        return str;
    }

    public static String ldapEscape(String unescapedString) {
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < unescapedString.length(); ++i) {
            char curChar = unescapedString.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block10;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block10;
                }
                case '(': {
                    sb.append("\\28");
                    continue block10;
                }
                case ')': {
                    sb.append("\\29");
                    continue block10;
                }
                case '&': {
                    sb.append("\\26");
                    continue block10;
                }
                case '$': {
                    sb.append("\\24");
                    continue block10;
                }
                case '#': {
                    sb.append("\\23");
                    continue block10;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block10;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    public static String getJSONString(ArrayList list) {
        StringBuffer sbuf = new StringBuffer();
        try {
            for (int i = 0; i < list.size(); ++i) {
                Hashtable hash = (Hashtable)list.get(i);
                Enumeration e = hash.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String val = (String)hash.get(key);
                    if (sbuf.length() != 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append("\"" + key + "\":\"" + val + "\"");
                }
            }
            if (sbuf.length() != 0) {
                sbuf.insert(0, "{");
                sbuf.append("}");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Error Message in JSON Form : " + sbuf.toString());
        return sbuf.toString();
    }

    public static String escapeSplChars(String input) {
        if (input != null && input.indexOf("$") != -1 || input.indexOf("\\") != -1 || input.indexOf("/") != -1 || input.indexOf("%") != -1) {
            return input.replaceAll("[\\\\]", "\\\\\\\\").replaceAll("[\\$]", "\\\\\\$").replaceAll("[\\/]", "\\\\\\/").replaceAll("[\\%]", "\\\\\\%");
        }
        return input;
    }

    public static String generateUniqueCode(int len, AdventNetResourceBundle rb) {
        String chars = rb.getString("adssp.common.unique.code");
        return StrUtil.generateUniqueCode(len, chars);
    }

    public static String generateUniqueCode(int len, String chars) {
        Random r = new Random();
        chars = chars.trim();
        char[] buf = new char[len];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = chars.charAt(r.nextInt(chars.length()));
        }
        return new String(buf);
    }

    public static String truncate(String s, int len) {
        try {
            int temp = s.length();
            if (temp > len) {
                return s.substring(0, len - 1);
            }
        }
        catch (Exception e) {
            return s;
        }
        return s;
    }

    public static String stringToHex(String str) {
        StringBuffer uniString = new StringBuffer();
        try {
            byte[] bytesData = str.getBytes("UTF-16BE");
            uniString = new StringBuffer(bytesData.length * 2);
            for (int i = 0; i < bytesData.length; ++i) {
                String hexByteStr = Integer.toHexString(bytesData[i] & 0xFF).toUpperCase();
                if (hexByteStr.length() == 1) {
                    uniString.append("0");
                }
                uniString.append(hexByteStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uniString.toString();
    }

    public static int stringSplitCount(String message, int limit) {
        double msgLength = message.length();
        int count = (int)Math.ceil(msgLength / (double)limit);
        logger.log(Level.INFO, "Splited Count : " + count);
        return count;
    }

    public static String getPartialMailID(String email) {
        int atIndex = email.indexOf("@");
        int dotLastIndex = email.lastIndexOf(46);
        char[] charMail = email.toCharArray();
        if (atIndex > 2) {
            Arrays.fill(charMail, 2, atIndex, '*');
        }
        if (dotLastIndex != -1 && email.substring(atIndex + 1, dotLastIndex).length() > 2) {
            Arrays.fill(charMail, atIndex + 3, dotLastIndex, '*');
        }
        return new String(charMail);
    }

    public static String getPartialMobNo(String mob) {
        char[] charMob = mob.toCharArray();
        if (charMob.length > 4) {
            Arrays.fill(charMob, 2, charMob.length - 2, '*');
        }
        return new String(charMob);
    }

    public static String getCanonicalName(String distinguishedName, int hierarchyLevel) {
        String canonicalName = null;
        try {
            LdapName dn = new LdapName(distinguishedName);
            List<Rdn> rdns = dn.getRdns();
            for (int i = 0; i < rdns.size() - hierarchyLevel; ++i) {
                Rdn rdn = rdns.get(i);
                canonicalName = rdn.getType().equalsIgnoreCase("DC") ? rdn.getValue() + (canonicalName == null ? "" : "." + canonicalName) : canonicalName + "/" + rdn.getValue();
            }
        }
        catch (InvalidNameException ine) {
            logger.log(Level.INFO, "Invalid LDAP name : " + distinguishedName);
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage());
        }
        return canonicalName;
    }

    public static String getCanonicalName(String distinguishedName) {
        String canonicalName = StrUtil.getCanonicalName(distinguishedName, 0);
        return canonicalName == null ? distinguishedName : canonicalName;
    }

    public static String getNameFromDN(String distinguishedName) {
        String name = null;
        try {
            LdapName dn = new LdapName(distinguishedName);
            List<Rdn> rdns = dn.getRdns();
            if (rdns.size() > 0) {
                Rdn rdn = rdns.get(rdns.size() - 1);
                name = (String)rdn.getValue();
            }
        }
        catch (InvalidNameException ine) {
            logger.log(Level.INFO, "Invalid LDAP name : " + distinguishedName);
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage());
        }
        return name;
    }

    public static String getFormatedNumber(String mobileNo, String provider) {
        if ("Clickatell".equals(provider)) {
            return mobileNo.replaceAll("[^0-9]+", "");
        }
        if ("GSMModem".equals(provider)) {
            return mobileNo.replaceAll("[^+0-9]+", "");
        }
        if ("SMTPCustomSMS".equals(provider) || "HTTPCustomSMS".equals(provider) || "SMPPCustomSMS".equals(provider)) {
            String customSMSFormat = ADSMPersUtil.getSyMParameter(provider);
            if (customSMSFormat != null) {
                return mobileNo.replaceAll(customSMSFormat, "");
            }
            return "SMPPCustomSMS".equals(provider) ? mobileNo : mobileNo.replaceAll("[^0-9]+", "");
        }
        return mobileNo;
    }

    public static boolean isMultiByteString(String str) {
        boolean retVal = false;
        try {
            if (str.length() != str.getBytes("UTF-8").length) {
                retVal = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static String sshEscape(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("\"", "\\\\\\\\\\\\\"").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)").replaceAll("'", "\\\\'");
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    public static String XSSEscape(String str) {
        if (str == null) {
            return null;
        }
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("\"", "&quot;");
        String[] chars = new String[]{"\\", "\"", "'"};
        String ret = str;
        for (String s : chars) {
            if (!ret.contains(s)) continue;
            ret = s.equalsIgnoreCase("\\") ? ret.replaceAll("\\\\", "\\\\\\\\") : ret.replaceAll(s, "\\\\" + s);
        }
        return ret;
    }

    public static boolean isValidMobileNo(String mobile) {
        boolean matcher = false;
        if (mobile.length() >= 6 && mobile != null && mobile.indexOf(" ") == -1) {
            Pattern p = Pattern.compile("^[0-9+\\(\\)\\-]+");
            Matcher m = p.matcher(mobile);
            matcher = m.matches();
        }
        return matcher;
    }

    public static ArrayList<String> getMacrosFromString(String str) {
        ArrayList<String> macroList = new ArrayList<String>();
        try {
            int secondIndex;
            String PERCENT = "%";
            int firstIndex = str.indexOf(PERCENT);
            while (firstIndex != -1 && (secondIndex = str.indexOf(PERCENT, firstIndex + 1)) != -1) {
                if (firstIndex + 1 != secondIndex) {
                    macroList.add(str.substring(firstIndex + 1, secondIndex));
                }
                firstIndex = str.indexOf(PERCENT, secondIndex + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return macroList;
    }

    public static String getCNFromDN(String distinguishedName) {
        StringBuffer cn = new StringBuffer();
        try {
            LdapName dn = new LdapName(distinguishedName);
            List<Rdn> rdns = dn.getRdns();
            int l = rdns.size();
            Rdn rdn = rdns.get(l - 1);
            cn.append(rdn.getValue());
        }
        catch (InvalidNameException ine) {
            logger.log(Level.INFO, "Invalid LDAP name : " + distinguishedName);
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.getMessage());
        }
        return cn.toString();
    }
}

