/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class TabCustomization {
    public static final Long MYINFO_TAB_ID = 1L;
    public static final Long CHANGE_PWD_TAB_ID = 2L;
    public static final Long ENROLLMENT_TAB_ID = 3L;
    public static final Long MY_GROUP_TAB_ID = 4L;
    public static final Long LINK_ACCOUNT_TAB_ID = 5L;
    public static final Long PERSONALIZE_TAB_ID = 6L;
    public static final Long UNAVAILABLE_TAB_ID = 7L;
    public static String[] mobileMtdArray = new String[]{"enrollment", "changePwd"};
    public static String[] mobileTabArray = new String[]{"Enrollment", "ChangePwd"};
    public static String[] mobileUrlArray = new String[]{"mEnrollment.do?isHome=true", "mSelfChangePassword.do?isHome=true"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getTabDetails(Long policyId, HttpServletRequest request) {
        JSONObject tabDetails = new JSONObject();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"SSPTabSettings"));
            Join join = new Join(Table.getTable((String)"SSPTabSettings"), Table.getTable((String)"SSPDomainUserTabs"), new String[]{"TAB_ID"}, new String[]{"TAB_ID"}, 2);
            Criteria crit = new Criteria(new Column("SSPTabSettings", "POLICY_ID"), (Object)policyId, 0);
            query.setCriteria(crit);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)"SSPTabSettings", (String)"TAB_ID"));
            query.addSelectColumn(Column.getColumn((String)"SSPTabSettings", (String)"PRIORITY"));
            query.addSelectColumn(Column.getColumn((String)"SSPTabSettings", (String)"IS_DEFAULT"));
            query.addSelectColumn(Column.getColumn((String)"SSPTabSettings", (String)"TAB_DISPLAY_NAME"));
            query.addSelectColumn(Column.getColumn((String)"SSPDomainUserTabs", (String)"DU_TAB_URL"));
            query.addSelectColumn(Column.getColumn((String)"SSPDomainUserTabs", (String)"TECHNICIAN_TAB_URL"));
            query.addSelectColumn(Column.getColumn((String)"SSPDomainUserTabs", (String)"TAB_NAME"));
            RelationalAPI relApi = RelationalAPI.getInstance();
            connection = relApi.getConnection();
            dataSet = relApi.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                JSONObject json = new JSONObject();
                Long tabId = (Long)dataSet.getValue("TAB_ID");
                json.put("TAB_ID", (Object)tabId);
                json.put("TAB_NAME", (Object)((String)dataSet.getValue("TAB_NAME")));
                json.put("TAB_DISPLAY_NAME", (Object)rb.getString((String)dataSet.getValue("TAB_DISPLAY_NAME")));
                json.put("DU_TAB_URL", (Object)((String)dataSet.getValue("DU_TAB_URL")));
                json.put("TECHNICIAN_TAB_URL", (Object)((String)dataSet.getValue("TECHNICIAN_TAB_URL")));
                json.put("PRIORITY", (Object)((Long)dataSet.getValue("PRIORITY")));
                json.put("IS_DEFAULT", (Object)((Boolean)dataSet.getValue("IS_DEFAULT")));
                tabDetails.put(Long.toString(tabId), (Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return tabDetails;
    }

    public static JSONObject getTabDetails(DataObject dataObject, HttpServletRequest request) {
        JSONObject tabDetails = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Iterator iterator = dataObject.getRows("SSPTabSettings");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long tabId = (Long)row.get("TAB_ID");
                JSONObject json = new JSONObject();
                json.put("TAB_ID", (Object)tabId);
                json.put("IS_DEFAULT", (Object)((Boolean)row.get("IS_DEFAULT")));
                json.put("PRIORITY", (Object)((Long)row.get("PRIORITY")));
                json.put("TAB_DISPLAY_NAME", (Object)rb.getString((String)row.get("TAB_DISPLAY_NAME")));
                tabDetails.put(Long.toString(tabId), (Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabDetails;
    }

    public static String getDefaultTabId(Long policyId) {
        String tabId = null;
        try {
            Row row;
            Criteria crit = new Criteria(Column.getColumn((String)"SSPTabSettings", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPTabSettings", (String)"IS_DEFAULT"), (Object)1L, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPTabSettings", crit);
            if (!dataObject.isEmpty() && (row = dataObject.getFirstRow("SSPTabSettings")) != null) {
                tabId = (String)row.get("TAB_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabId;
    }

    public static JSONObject getDUTabs() {
        JSONObject tabDetails = new JSONObject();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPDomainUserTabs", (Criteria)null);
            Iterator iterator = obj.getRows("SSPDomainUserTabs");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long tabId = (Long)row.get("TAB_ID");
                Long priority = (Long)row.get("PRIORITY");
                JSONObject json = new JSONObject();
                json.put("TAB_ID", (Object)tabId);
                json.put("TAB_NAME", (Object)((String)row.get("TAB_NAME")));
                json.put("TAB_DISPLAY_NAME", (Object)((String)row.get("TAB_DISPLAY_NAME")));
                json.put("DU_TAB_URL", (Object)((String)row.get("DU_TAB_URL")));
                json.put("TECHNICIAN_TAB_URL", (Object)((String)row.get("TECHNICIAN_TAB_URL")));
                json.put("PRIORITY", (Object)priority);
                json.put("IS_DEFAULT", (Object)(priority.equals(1L) ? Boolean.TRUE : Boolean.FALSE));
                tabDetails.put(Long.toString(tabId), (Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabDetails;
    }

    public static Object getTabPriority(JSONObject tabProp, Long tabId) {
        Object priority = null;
        try {
            priority = ((JSONObject)tabProp.get(Long.toString(tabId))).get("PRIORITY");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return priority;
    }

    public static Properties getTabDetails(Long tabId) {
        Properties prop = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPDomainUserTabs", (String)"TAB_ID"), (Object)tabId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPDomainUserTabs", crit);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getRow("SSPDomainUserTabs");
                prop.put("id", r.get("TAB_ID"));
                prop.put("displayName", r.get("TAB_DISPLAY_NAME"));
                prop.put("userTabUrl", r.get("DU_TAB_URL"));
                prop.put("technicianTabUrl", r.get("TECHNICIAN_TAB_URL"));
                prop.put("name", r.get("TAB_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }
}

