/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TechnicianUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getRolesForId(Long loginId) {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            Table baseTable = Table.getTable((String)"ADMPRoles");
            Table joinTable = Table.getTable((String)"ADMPUsersRoleMapping");
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 2);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)"ADMPRoles", (String)"ADMP_ROLE_NAME"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"LOGIN_ID"), (Object)loginId, 0);
            query.setCriteria(criteria);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                list.add((String)dataSet.getValue("ADMP_ROLE_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static Properties getURLVsActionIds() {
        Properties pro = new Properties();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSSPOperationURLs", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator iterator = obj.getRows("ADSSPOperationURLs");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    pro.setProperty(r.get("ACTION_URL").toString(), r.get("ACTION_ID").toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Long> getRoleMappedActionIDs(Long loginID) {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADMPUsersRoleMapping"));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"LOGIN_ID"), (Object)loginID, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)"ADSSPRolePermissions", (String)"ACTION_ID"));
            query.addSelectColumn(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"LOGIN_ID"));
            query.addSelectColumn(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_ROLE_ID"));
            Join roleJoin = new Join("ADMPUsersRoleMapping", "ADSSPRolePermissions", new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 2);
            query.addJoin(roleJoin);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                list.add((Long)dataSet.getValue("ACTION_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static Properties getURLVsActionIds(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Properties URLVsActionIds = (Properties)session.getAttribute("TOTAL_ACTION_ID");
        if (URLVsActionIds == null) {
            URLVsActionIds = TechnicianUtil.getURLVsActionIds();
            session.setAttribute("TOTAL_ACTION_ID", (Object)URLVsActionIds);
        }
        return URLVsActionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getTechnicians(String domainName) {
        ArrayList<String> techList = new ArrayList<String>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Table aaaLogin = Table.getTable((String)"AaaLogin");
            Table userRoleMapping = Table.getTable((String)"ADMPUsersRoleMapping");
            SelectQueryImpl query = new SelectQueryImpl(aaaLogin);
            Criteria domainCrit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0);
            Join usersRole = new Join(aaaLogin, userRoleMapping, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1);
            Join roleName = new Join(userRoleMapping, Table.getTable((String)"ADMPRoles"), new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 1);
            domainCrit.and(new Criteria(Column.getColumn((String)"ADMPRoles", (String)"ADMP_ROLE_NAME"), (Object)"SelfService Portal", 1));
            domainCrit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)"1", 1));
            query.addJoin(usersRole);
            query.addJoin(roleName);
            query.setCriteria(domainCrit);
            query.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                techList.add((String)dataSet.getValue("NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return techList;
    }
}

