/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class TimeZoneUtil {
    public static HashMap getCustomDateFormat(Long loggedOnUserId) {
        return TimeZoneUtil.getCustomDateFormat(loggedOnUserId, null, null);
    }

    public static HashMap getCustomDateFormat(Long loggedOnUserId, HttpServletRequest request) {
        return TimeZoneUtil.getCustomDateFormat(loggedOnUserId, request, null);
    }

    public static HashMap getCustomDateFormat(Long loggedOnUserId, HttpServletRequest request, Locale locale) {
        SimpleDateFormat simpleDateFormat = null;
        HashMap<String, Object> customDateFormatMap = new HashMap<String, Object>();
        try {
            String[] userPersonalProps = new String[]{"TIME_ZONE", "TIME_FORMAT", "DATE_FORMAT"};
            Hashtable hash = UserUtil.getUserPersonal(loggedOnUserId, userPersonalProps);
            Locale userLocale = locale != null ? locale : (request != null ? ResourceBundleMgr.getInstance().getClientLocale(request) : Locale.getDefault());
            String dateFormat = (String)hash.get("DATE_FORMAT");
            String timeFormat = (String)hash.get("TIME_FORMAT");
            TimeZone timeZone = TimeZone.getTimeZone((String)hash.get("TIME_ZONE"));
            if (dateFormat != null && timeFormat != null) {
                String simpleDateTimeFmt = dateFormat + " " + timeFormat;
                simpleDateFormat = new SimpleDateFormat(simpleDateTimeFmt, userLocale);
            } else {
                simpleDateFormat = new SimpleDateFormat();
            }
            simpleDateFormat.setTimeZone(timeZone);
            customDateFormatMap.put("simpleDateFormat", simpleDateFormat);
            customDateFormatMap.put("timeFormat", timeFormat);
            customDateFormatMap.put("dateFormat", dateFormat);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return customDateFormatMap;
    }

    public static HashMap getCustomDateFormat(HttpServletRequest request) {
        HttpSession session;
        SimpleDateFormat tzDateFmt = null;
        HashMap customDateFormatMap = null;
        if (request != null && (customDateFormatMap = (HashMap)(session = request.getSession()).getAttribute("CUSTOM_DATE_FORMAT")) != null) {
            tzDateFmt = (SimpleDateFormat)customDateFormatMap.get("simpleDateFormat");
        }
        if (tzDateFmt == null) {
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnUserId = cred != null ? cred.getLoginId() : 1L;
            return TimeZoneUtil.getCustomDateFormat(loggedOnUserId);
        }
        return customDateFormatMap;
    }

    public static Hashtable getSystemTimeZone() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        hash.put("TIME_ZONE", TimeZone.getDefault().getID());
        return hash;
    }

    public static Properties getAvailableTimeZones(HttpServletRequest request) {
        Properties timeZoneProps = new Properties();
        ArrayList<String> timeZoneList = new ArrayList<String>();
        ArrayList<String> timeZoneDisplayNameList = new ArrayList<String>();
        Date date = new Date();
        String[] TimeZoneIds = TimeZone.getAvailableIDs();
        Locale locale = ResourceBundleMgr.getInstance().getClientLocale(request);
        for (int i = 0; i < TimeZoneIds.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone(TimeZoneIds[i]);
            String tzName = tz.getDisplayName(tz.inDaylightTime(date), 1, locale);
            int rawOffset = tz.getRawOffset();
            int hour = rawOffset / 3600000;
            int minute = Math.abs(rawOffset / 60000) % 60;
            timeZoneList.add(TimeZoneIds[i]);
            timeZoneDisplayNameList.add(tzName + "(" + TimeZoneIds[i] + ")" + " GMT " + hour + ":" + minute);
        }
        timeZoneProps.put("TIME_ZONE_ID_LIST", timeZoneList);
        timeZoneProps.put("TIMe_ZONE_DISP_LIST", timeZoneDisplayNameList);
        return timeZoneProps;
    }

    public static String getTimeInCustomFormat(Long value, HttpServletRequest request) {
        HashMap customDateFormatMap = TimeZoneUtil.getCustomDateFormat(request);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        return TimeZoneUtil.getTimeInCustomFormat(value, customDateFormatMap, rb);
    }

    public static String getTimeInCustomFormat(Long value, HashMap customDateFormatMap, AdventNetResourceBundle rb) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)customDateFormatMap.get("simpleDateFormat");
        String timeFormat = (String)customDateFormatMap.get("timeFormat");
        long time = value;
        long currTime = System.currentTimeMillis();
        DateFormat df = simpleDateFormat.getDateInstance();
        Date date = new Date(time);
        String formattedDate = df.format(date);
        Date currentdate = new Date(currTime);
        String formattedCurrentDate = df.format(currentdate);
        SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
        sdf.setTimeZone(simpleDateFormat.getTimeZone());
        if (formattedDate.equals(formattedCurrentDate)) {
            formattedDate = rb.getString("adssp.reports.adreport.status.today") + " " + sdf.format(date);
            return formattedDate;
        }
        currentdate = new Date(currTime -= 86400000L);
        formattedCurrentDate = df.format(currentdate);
        if (formattedDate.equals(formattedCurrentDate)) {
            formattedDate = rb.getString("adssp.reports.adreport.status.yesterday") + " " + sdf.format(date);
            return formattedDate;
        }
        formattedDate = simpleDateFormat.format(date);
        return formattedDate;
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static String getDate(String format, Date date, int noDaysAfter) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, noDaysAfter);
        return formatter.format(cal.getTime());
    }

    public static Date getDate(Date date, int noDaysAfter) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, noDaysAfter);
        return cal.getTime();
    }

    public static Long getDateInMillis(Date date, int noDaysAfter) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, noDaysAfter);
        return cal.getTimeInMillis();
    }

    public static Long getDateInMillis(Long dateInMillis, int noDaysAfter) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateInMillis);
        cal.add(5, noDaysAfter);
        return cal.getTimeInMillis();
    }

    public static int dateCompare(String date1, String date2, String format) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            Date dateObj1 = formatter.parse(date1);
            Date dateObj2 = formatter.parse(date2);
            return dateObj1.compareTo(dateObj2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int dateCompare(Long date1, Long date2) {
        try {
            Calendar calendar1 = Calendar.getInstance();
            calendar1.setTimeInMillis(date1);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTimeInMillis(date2);
            return calendar1.compareTo(calendar2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String getPresentDateTime(HttpServletRequest request, Long loginId) {
        Long value = System.currentTimeMillis();
        HashMap customDateFormatMap = new HashMap();
        customDateFormatMap = loginId == null ? TimeZoneUtil.getCustomDateFormat(request) : TimeZoneUtil.getCustomDateFormat(loginId, request, ResourceBundleMgr.getInstance().getClientLocale(loginId, request));
        return TimeZoneUtil.getPresentDateTime(value, customDateFormatMap);
    }

    public static Long getRemainingTimeToday() {
        Long time = 0L;
        try {
            Calendar c = Calendar.getInstance();
            c.add(5, 1);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            time = c.getTimeInMillis() - System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return time;
    }

    public static String getPresentDateTime(Long value, HashMap customDateFormatMap) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)customDateFormatMap.get("simpleDateFormat");
        String timeFormat = (String)customDateFormatMap.get("timeFormat");
        long time = value;
        DateFormat df = simpleDateFormat.getDateInstance();
        Date date = new Date(time);
        String formattedDate = df.format(date);
        SimpleDateFormat sdf = new SimpleDateFormat(timeFormat);
        sdf.setTimeZone(simpleDateFormat.getTimeZone());
        formattedDate = simpleDateFormat.format(date);
        return formattedDate;
    }
}

