/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Function;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class UserUtil {
    private static Logger logger = Logger.getLogger(UserUtil.class.getName());
    private static String[] usersListProp = new String[]{"SAM_ACCOUNT_NAME", "DN_STRING", "OU_NAME", "OBJECT_GUID"};
    private static final String AAA_LOGIN = "AaaLogin";
    private static final String ADSM_USER_GENERAL_DETAILS = "ADSMUserGeneralDetails";
    public static final String LOGIN_ID = "LOGIN_ID";
    public static final String DOMAINNAME = "DOMAINNAME";
    public static final String NAME = "NAME";
    public static Properties cachedADValues = new Properties();
    public static ArrayList cachedADList = new ArrayList();
    private static Object obj = new Object();

    public static String getSID(String domainName, String logonName) {
        String sid;
        block7: {
            sid = null;
            try {
                Row r = UserUtil.getSIDRow(domainName, logonName);
                if (r != null) {
                    sid = (String)r.get("SID_STRING");
                }
                if (r != null && sid != null && !sid.equals("")) break block7;
                Properties properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_NAME");
                ArrayList<String> attrList = new ArrayList<String>();
                attrList.add("objectSID");
                String searchString = "(&(objectClass=user)(objectCategory=person)(samAccountName=" + StrUtil.ldapEscape(logonName) + "))";
                ArrayList list = null;
                try {
                    list = UserUtil.getLDAPValues(properties, properties.getProperty("DEFAULT_NAMING_CONTEXT"), attrList, searchString, logonName, false);
                }
                catch (NativeException ne) {
                    ne.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (list != null && list.size() > 0) {
                    Properties props = (Properties)list.get(0);
                    ArrayList sidList = (ArrayList)props.get("objectSID");
                    sid = (String)sidList.get(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sid;
    }

    public static Row getSIDRow(String domainName, String logonName) {
        Row r = null;
        try {
            String tableName = CommonUtil.getDomainUserTableName(domainName);
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)logonName, 0);
            DataObject obj1 = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (!obj1.isEmpty()) {
                r = obj1.getFirstRow(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public static boolean isUserExistInDomain(String loginName, String domainName) {
        boolean usersava = false;
        try {
            Properties properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_NAME");
            ArrayList<String> attrList = new ArrayList<String>();
            attrList.add("name");
            String searchString = "(&(objectClass=user)(objectCategory=person)(samAccountName=" + StrUtil.ldapEscape(loginName) + "))";
            ArrayList list = null;
            try {
                list = UserUtil.getLDAPValues(properties, properties.getProperty("DEFAULT_NAMING_CONTEXT"), attrList, searchString, loginName, false);
            }
            catch (NativeException ne) {
                ne.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (list != null && list.size() != 0) {
                usersava = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return usersava;
    }

    public static String getUserDNFrmAD(String domainName, String samAccName) {
        try {
            Properties properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_NAME");
            return UserUtil.getObjectString(samAccName, properties, "distinguishedName").toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Properties getUserData(String domainName, String samAccName) {
        Properties userPro = new Properties();
        try {
            String[] ldapNames = new String[]{"distinguishedName", "objectGUID", "displayName"};
            String[] colNames = new String[]{"DN_STRING", "OBJECT_GUID", "DISPLAY_NAME"};
            String tableName = CommonUtil.getDomainUserTableName(domainName);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)samAccName, 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                for (int i = 0; i < colNames.length; ++i) {
                    if (r.get(colNames[i]) == null) continue;
                    userPro.setProperty(ldapNames[i], (String)r.get(colNames[i]));
                }
                return userPro;
            }
            return UserUtil.getUserObjectDetails(samAccName, domainName, ldapNames);
        }
        catch (Exception e) {
            e.printStackTrace();
            return userPro;
        }
    }

    public static String getUserDNFrmDB(String domainName, String samAccName) {
        try {
            String tableName = CommonUtil.getDomainUserTableName(domainName);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)samAccName, 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                String userDN = (String)r.get("DN_STRING");
                return userDN.toLowerCase();
            }
            return UserUtil.getUserDNFrmAD(domainName, samAccName).toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Properties getUserProps(DataObject usersDO, String tableName, String samAccName, String[] cols, String[] keys) {
        Properties props = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)samAccName, 0, false);
            Row r = usersDO.getRow(tableName, crit);
            if (r != null) {
                for (int i = 0; i < cols.length; ++i) {
                    String val = (String)r.get(cols[i]);
                    val = val == null ? "" : val;
                    props.put(keys[i], val);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public static String getObjectString(String loginName, Properties properties, String ldapName) {
        String string = null;
        try {
            ArrayList<String> attList = new ArrayList<String>();
            attList.add(ldapName);
            ArrayList disList = (ArrayList)UserUtil.getObjValList(loginName, properties, attList).get(ldapName);
            if (!disList.isEmpty()) {
                string = (String)disList.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return string;
    }

    public static Properties getObjValList(String loginName, Properties properties, ArrayList attrList) {
        return UserUtil.getObjValList(loginName, properties, attrList, "samAccountName");
    }

    public static Properties getObjValList(String loginName, Properties properties, ArrayList attrList, String uniqueAttribute) {
        Properties ret = new Properties();
        try {
            loginName = StrUtil.ldapEscape(loginName);
            String searchString = "(&(objectClass=user)(objectCategory=person)(" + uniqueAttribute + "=" + loginName + "))";
            ArrayList list = null;
            boolean realTime = false;
            try {
                if (properties.get("REAL_TIME") != null && ((Boolean)properties.get("REAL_TIME")).booleanValue()) {
                    realTime = true;
                }
                list = UserUtil.getLDAPValues(properties, properties.getProperty("DEFAULT_NAMING_CONTEXT"), attrList, searchString, loginName, realTime);
            }
            catch (NativeException ne) {
                ne.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (list != null && list.size() > 0) {
                ret = (Properties)list.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getReqUserAttribute(Long loginId, String columnName) {
        String ret = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)AAA_LOGIN, (String)LOGIN_ID), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(AAA_LOGIN, c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(AAA_LOGIN);
                String domainName = (String)r.get(DOMAINNAME);
                String samAccName = (String)r.get(NAME);
                ret = UserUtil.getReqUserAttribute(samAccName, domainName, columnName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getReqUserAttribute(String samAccName, String domainName, String columnName) {
        String ret = null;
        try {
            Row row;
            String mailNickName;
            String tableName = CommonUtil.getDomainUserTableName(domainName);
            Criteria cr = new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)samAccName, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, cr);
            if (!dObj.isEmpty() && (mailNickName = (String)(row = dObj.getFirstRow(tableName)).get(columnName)) != null) {
                ret = mailNickName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Properties getUserObjectDetails(String loginName, String domainName, String[] props, Boolean needDN) {
        return UserUtil.getUserObjectDetails(loginName, domainName, props, needDN, "samAccountName");
    }

    public static Properties getUserObjectDetails(String loginName, String domainName, String[] props, Boolean needDN, String uniqueAttribute) {
        return UserUtil.getUserObjectDetails(loginName, domainName, props, needDN, uniqueAttribute, false);
    }

    public static Properties getUserObjectDetails(String loginName, String domainName, String[] props, Boolean needDN, String uniqueAttribute, boolean realTimeADValue) {
        Properties ret = new Properties();
        try {
            ArrayList<String> attributeList = new ArrayList<String>();
            for (int i = 0; i < props.length; ++i) {
                attributeList.add(props[i]);
            }
            loginName = StrUtil.ldapEscape(loginName);
            String searchString = "(&(objectClass=user)(objectCategory=person)(" + uniqueAttribute + "=" + loginName + "))";
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
            if (needDN.booleanValue()) {
                domainDetails.put("NEED_DN", "true");
            }
            ArrayList list = new ArrayList();
            try {
                list = UserUtil.getLDAPValues(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString, loginName, realTimeADValue);
            }
            catch (NativeException ne) {
                ne.printStackTrace();
                String errVal = ne.getExceptionCode();
                ret.put("ERR_CODE", errVal);
                String errMsg = ne.getExceptionMsg();
                ret.put("ERR_MSG", errMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (list.size() > 0) {
                Properties p = (Properties)list.get(0);
                for (int i = 0; i < props.length; ++i) {
                    ArrayList values = (ArrayList)p.get(props[i]);
                    if (values == null || values.size() <= 0) continue;
                    if (needDN.booleanValue()) {
                        ret.put(props[i], values);
                        continue;
                    }
                    ret.put(props[i], values.get(0));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Hashtable getLogonNameFromUPN(String userName) {
        Properties loginUserProp;
        int backSlashindex = userName.indexOf("\\");
        int atIndex = userName.indexOf("@");
        String domainName = "";
        String loginName = "";
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (backSlashindex != -1) {
            domainName = DomainHandler.getDomainData("DOMAIN_FLAT_NAME", userName.substring(0, backSlashindex), "DOMAIN_NAME");
            loginName = userName.substring(backSlashindex + 1);
        } else if (atIndex != -1 && !(loginUserProp = ADAuthHandler.getLoginUserDetails(userName)).isEmpty() && loginUserProp != null) {
            domainName = DomainHandler.getDomainData("DOMAIN_NAME", (String)loginUserProp.get("DOMAIN_NAME"), "DOMAIN_NAME");
            if (loginUserProp.get("SAM_ACCOUNT_NAME") != null) {
                loginName = (String)loginUserProp.get("SAM_ACCOUNT_NAME");
            }
        }
        domainName = domainName == null ? "" : domainName;
        hash.put("userName", loginName);
        hash.put("domainName", domainName);
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getUserObjectDetails(String loginName, String domainName, String[] props, Boolean needDN, Boolean checkOtherLoginAttributes) {
        Hashtable names;
        Properties ret = new Properties();
        ret.put("multipleAccountsMatched", (Object)false);
        int backSlashindex = loginName.indexOf("\\");
        int atIndex = loginName.indexOf("@");
        String loginNameUPN = loginName;
        if (checkOtherLoginAttributes.booleanValue()) {
            Boolean isUpnPresent = false;
            Boolean isSamAccountNamePresent = false;
            ArrayList<String> ldapAttributes = new ArrayList<String>();
            ArrayList list = new ArrayList();
            ArrayList loginAttrList = new ArrayList();
            loginAttrList = DomainUtil.getLoginAttributeList();
            for (int j = 0; j < loginAttrList.size(); ++j) {
                Properties p = (Properties)loginAttrList.get(j);
                String ldapName = (String)p.get("LDAP_NAME");
                Boolean enableStatus = (Boolean)p.get("ENABLE_STATUS");
                if (ldapName.equals("userPrincipalName") && !isUpnPresent.booleanValue()) {
                    if (enableStatus.booleanValue()) {
                        isUpnPresent = true;
                        continue;
                    }
                    isUpnPresent = false;
                    continue;
                }
                if (!enableStatus.booleanValue()) continue;
                ldapAttributes.add(ldapName);
            }
            try {
                Hashtable names2;
                String ldpStr;
                ArrayList<String> attributeList = new ArrayList<String>();
                for (int i = 0; i < props.length; ++i) {
                    if (props[i].equalsIgnoreCase("samAccountName")) {
                        isSamAccountNamePresent = true;
                    }
                    attributeList.add(props[i]);
                }
                if (!isSamAccountNamePresent.booleanValue()) {
                    attributeList.add("samAccountName");
                }
                if (ldapAttributes.size() > 0) {
                    loginName = StrUtil.ldapEscape(loginName);
                    StringBuilder query = new StringBuilder();
                    query.append("(&(objectClass=user)(objectCategory=person)");
                    for (int index = 0; index < ldapAttributes.size(); ++index) {
                        if (index == 0) {
                            query.append("(|");
                        }
                        ldpStr = "(" + ldapAttributes.get(index) + "=" + loginName + ")";
                        query.append(ldpStr);
                        if (index != ldapAttributes.size() - 1) continue;
                        query.append("))");
                    }
                    String searchString = query.toString();
                    Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
                    if (needDN.booleanValue()) {
                        domainDetails.put("NEED_DN", "true");
                    }
                    try {
                        list = UserUtil.getLDAPValues(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString, null, false);
                        if (list.size() > 0) {
                            ret.put("domainName", domainName);
                        }
                    }
                    catch (NativeException ne) {
                        ne.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (isUpnPresent.booleanValue() && (atIndex != -1 || backSlashindex != -1) && list.size() <= 1 && (names2 = UserUtil.getLogonNameFromUPN(loginNameUPN)).get("userName") != "" && names2.get("domainName") != "" && domainName.equalsIgnoreCase((String)names2.get("domainName"))) {
                    loginName = (String)names2.get("userName");
                    domainName = (String)names2.get("domainName");
                    StringBuilder query = new StringBuilder();
                    query.append("(&(objectClass=user)(objectCategory=person)");
                    ldpStr = "(samAccountName=" + loginName + "))";
                    query.append(ldpStr);
                    String searchString = query.toString();
                    Properties domainDetailsUPN = DomainHandler.getConfiguredValues(domainName, new Long(1L));
                    if (needDN.booleanValue()) {
                        domainDetailsUPN.put("NEED_DN", "true");
                    }
                    ArrayList listUPN = new ArrayList();
                    try {
                        listUPN = UserUtil.getLDAPValues(domainDetailsUPN, domainDetailsUPN.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString, loginName, false);
                        if (list.size() == 0 && listUPN.size() > 0) {
                            ret.put("domainName", domainName);
                        }
                        String samAccNameList = "";
                        if (list.size() > 0) {
                            Properties p = (Properties)list.get(0);
                            ArrayList values = (ArrayList)p.get("samAccountName");
                            samAccNameList = (String)values.get(0);
                        }
                        for (int k = 0; k < listUPN.size(); ++k) {
                            Properties pUPN = (Properties)listUPN.get(k);
                            ArrayList valuesUPN = (ArrayList)pUPN.get("samAccountName");
                            String samAccNameListUPN = (String)valuesUPN.get(0);
                            if (samAccNameList.equals(samAccNameListUPN)) continue;
                            list.add(listUPN.get(k));
                        }
                    }
                    catch (NativeException ne) {
                        ne.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (list.size() > 1) {
                    ret.put("multipleAccountsMatched", (Object)true);
                    String names3 = "";
                    for (int i = 0; i < list.size(); ++i) {
                        Properties p = (Properties)list.get(i);
                        ArrayList values = (ArrayList)p.get("samAccountName");
                        names3 = names3 + (String)values.get(0);
                        if (i == list.size() - 1) continue;
                        names3 = names3 + ", ";
                    }
                    String logg = "Multiple accounts with the names : [ " + names3 + " ] matched with the entered criteria.";
                    logger.log(Level.INFO, logg);
                }
                if (list.size() <= 0) return ret;
                Properties p = (Properties)list.get(0);
                for (int i = 0; i < props.length; ++i) {
                    ArrayList values = (ArrayList)p.get(props[i]);
                    if (values == null || values.size() <= 0) continue;
                    if (needDN.booleanValue()) {
                        ret.put(props[i], values);
                        continue;
                    }
                    ret.put(props[i], values.get(0));
                }
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace();
                return ret;
            }
        }
        if ((atIndex != -1 || backSlashindex != -1) && (names = UserUtil.getLogonNameFromUPN(loginNameUPN)).get("userName") != "" && names.get("domainName") != "" && domainName.equalsIgnoreCase((String)names.get("domainName"))) {
            loginName = (String)names.get("userName");
            domainName = (String)names.get("domainName");
        }
        ret = UserUtil.getUserObjectDetails(loginName, domainName, props, needDN);
        ret.put("multipleAccountsMatched", (Object)false);
        return ret;
    }

    public static Properties getUserObjectDetails(String loginName, String domainName, String[] props) {
        return UserUtil.getUserObjectDetails(loginName, domainName, props, false);
    }

    public static ArrayList getManagers(String domainName, String[] props, String ouDN, Long hideDisabledUsers) {
        ArrayList list = new ArrayList();
        try {
            String searchString = "(&(objectcategory=person)(objectClass=user)";
            if (hideDisabledUsers.equals(1L)) {
                searchString = searchString + "(!(userAccountControl:1.2.840.113556.1.4.803:=2))";
            }
            searchString = searchString + "(!(sAMAccountType=805306370))(directReports=*))";
            list = ouDN == null ? UserUtil.executeADQuery(domainName, props, searchString) : UserUtil.executeADQuery(domainName, props, searchString, ouDN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getUnManagedUsers(String domainName, String[] props, Boolean managerAlone, String ouDN, Long hideDisabledUsers) {
        ArrayList list = new ArrayList();
        try {
            String searchString = "(&(objectcategory=person)(objectClass=user)";
            if (hideDisabledUsers.equals(1L)) {
                searchString = searchString + "(!(userAccountControl:1.2.840.113556.1.4.803:=2))";
            }
            searchString = searchString + "(!(sAMAccountType=805306370))(!manager=*)(" + (managerAlone != false ? "" : "!") + "directReports=*))";
            list = ouDN == null ? UserUtil.executeADQuery(domainName, props, searchString) : UserUtil.executeADQuery(domainName, props, searchString, ouDN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Properties getUserAttValues(String domainName, String[] props, String searchString) {
        return UserUtil.getUserAttValues(domainName, props, searchString, null);
    }

    public static ArrayList executeADQuery(String domainName, String[] props, String searchQuery) {
        return UserUtil.executeADQuery(domainName, props, searchQuery, DomainHandler.getDefaultNamingContext(domainName));
    }

    public static Properties getUserTempPwd(Long loginId) {
        Properties userProps = new Properties();
        try {
            String tempPwd = "-";
            String pwdLastSet = "-";
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)LOGIN_ID), (Object)loginId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersPersonal", crit);
            if (!o.isEmpty()) {
                Row r = o.getFirstRow("ADMPUsersPersonal");
                tempPwd = r.get("TEMP_PWD") != null ? (String)r.get("TEMP_PWD") : "-";
                pwdLastSet = ((Long)r.get("PASSWORD_LAST_SET")).toString();
            }
            userProps.put("TEMP_PWD", tempPwd);
            userProps.put("PASSWORD_LAST_SET", pwdLastSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userProps;
    }

    public static Properties getUserAccountDetails(String objectGuid) {
        Properties ret = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMUserAccountDetails", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADSMUserAccountDetails", crit);
            if (!o.isEmpty()) {
                Row r = o.getFirstRow("ADSMUserAccountDetails");
                List columnList = r.getColumns();
                for (Object object : columnList) {
                    String colNam = (String)object;
                    String val = "-";
                    if (r.get(colNam) != null) {
                        val = r.get(colNam).toString();
                    }
                    ret.put(colNam, val);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void setUserTempPwd(String pwdLastSet, String tempPwd, Long loginId, String objectGuid) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)LOGIN_ID), (Object)loginId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersPersonal", crit);
            if (!o.isEmpty()) {
                Row r = o.getRow("ADMPUsersPersonal");
                r.set("TEMP_PWD", (Object)tempPwd);
                r.set("PASSWORD_LAST_SET", (Object)pwdLastSet);
                o.updateRow(r);
            } else {
                Row r = new Row("ADMPUsersPersonal");
                r.set(LOGIN_ID, (Object)loginId);
                r.set("TEMP_PWD", (Object)tempPwd);
                r.set("PASSWORD_LAST_SET", (Object)pwdLastSet);
                o.addRow(r);
            }
            CommonUtil.getPersistenceLite().update(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setUserPersonal(Long loginId, Hashtable hash) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)LOGIN_ID), (Object)loginId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersPersonal", crit);
            if (!hash.containsKey("TEMP_PWD")) {
                hash.put("TEMP_PWD", "-");
            }
            if (!o.isEmpty()) {
                Row r = o.getFirstRow("ADMPUsersPersonal");
                Enumeration e = hash.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = (String)hash.get(key);
                    r.set(key, (Object)value);
                }
                o.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(o);
            } else {
                Row r = new Row("ADMPUsersPersonal");
                Enumeration e = hash.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = (String)hash.get(key);
                    r.set(key, (Object)value);
                }
                o.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(o);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getUserPersonal(Long loginId, ArrayList list) {
        String[] elements = new String[list.size()];
        list.toArray(elements);
        return UserUtil.getUserPersonal(loginId, elements, false);
    }

    public static Hashtable getUserPersonal(Long loginId, String[] elements) {
        return UserUtil.getUserPersonal(loginId, elements, false);
    }

    public static Hashtable getUserPersonal(Long loginId, String[] elements, Boolean isFrmCache) {
        Hashtable hash = new Hashtable();
        try {
            Long[] userIds;
            String tN = "ADMPUsersPersonal";
            for (Long userId : userIds = new Long[]{loginId, 1L}) {
                DataObject o;
                Criteria c = new Criteria(Column.getColumn((String)tN, (String)LOGIN_ID), (Object)userId, 0);
                DataObject dataObject = o = isFrmCache != false ? CommonUtil.getCachedPersistence().get(tN, c) : CommonUtil.getPersistence(new boolean[0]).get(tN, c);
                if (!o.isEmpty()) {
                    Row r = o.getFirstRow(tN);
                    for (int i = 0; i < elements.length; ++i) {
                        Object val = r.get(elements[i]);
                        if (val == null) continue;
                        hash.put(elements[i], val.toString());
                    }
                }
                if (!hash.isEmpty() && userId != 1L || loginId.equals(1L)) break;
            }
            if ("THEME_COLOR".equalsIgnoreCase(elements[0]) && hash.get("THEME_COLOR") == null) {
                hash.put(elements[0], "5499dd");
                hash.put(elements[1], "verdana");
                hash.put(elements[2], "10px");
            }
            if (Arrays.asList(elements).contains("TIME_ZONE") && hash.get("TIME_ZONE") == null || !ADMPRoleHandler.isAdminUser(loginId)) {
                hash = UserUtil.getUserPersonalForOperators(hash, tN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    private static Hashtable getUserPersonalForOperators(Hashtable hash, String tN) {
        String[] formats = new String[]{"TIME_ZONE", "DATE_FORMAT", "TIME_FORMAT"};
        Hashtable temp = new Hashtable();
        temp = hash;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tN, (String)LOGIN_ID), (Object)1L, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tN, crit);
            if (!obj.isEmpty()) {
                Row ro = obj.getFirstRow(tN);
                for (int j = 0; j < formats.length; ++j) {
                    Object val = ro.get(formats[j]);
                    if (val == null && formats[j].equalsIgnoreCase("TIME_ZONE")) {
                        Hashtable sysTimeZone = TimeZoneUtil.getSystemTimeZone();
                        val = sysTimeZone.get("TIME_ZONE");
                    }
                    hash.put(formats[j], val.toString());
                }
            }
        }
        catch (Exception e) {
            hash = temp;
            e.printStackTrace();
        }
        return hash;
    }

    public static Boolean isUserPermitted(HttpServletRequest request, String domainName, Properties userPro) {
        Boolean ret = false;
        try {
            Hashtable hash;
            String userDN = ((String)((ArrayList)userPro.get("distinguishedName")).get(0)).toLowerCase();
            String objGUID = (String)((ArrayList)userPro.get("objectGUID")).get(0);
            ArrayList userGroups = (ArrayList)userPro.get("memberOf");
            String primaryGroup = GroupUtil.getPrimaryGroup(domainName, (String)((ArrayList)userPro.get("primaryGroupID")).get(0));
            if (primaryGroup != null) {
                userGroups.add(primaryGroup);
            }
            if (!((Boolean)(hash = PolicyHandler.checkUserPermission(domainName, userDN, userGroups)).get("status")).booleanValue()) {
                request.setAttribute("login_status", (Object)"adssp.login.common.error.permission_denied");
                return false;
            }
            if (PolicyHandler.isUserRestricted(objGUID).booleanValue()) {
                request.setAttribute("login_status", (Object)"adssp.login.common.error.permission_denied_restrict");
                return false;
            }
            ret = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        Cookie[] cookie = request.getCookies();
        String value = "";
        if (cookie != null) {
            for (int i = 0; i < cookie.length; ++i) {
                String param = cookie[i].getName();
                if (!param.equalsIgnoreCase(name)) continue;
                value = cookie[i].getValue();
            }
        }
        return value;
    }

    public static Boolean isRTLEnabled(HttpServletRequest request) {
        Boolean value = false;
        try {
            Row r;
            String direction;
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Long localeId = ResourceBundleMgr.getInstance().getClientLocaleId(loginId);
            if (loginId == null) {
                localeId = ResourceBundleMgr.getInstance().getLocaleId(ResourceBundleMgr.getInstance().getUserLocale(request).toString());
            }
            Criteria crit = new Criteria(new Column("LocaleDetails", "LOCALE_ID"), (Object)localeId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("LocaleDetails", crit);
            if (!dObj.isEmpty() && (direction = (String)(r = dObj.getFirstRow("LocaleDetails")).get("DIRECTION")).equalsIgnoreCase("rtl")) {
                value = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return value;
    }

    public static Properties getUserGeneralDetail(String samAccountName, String domainName, String[] reqPropName) {
        Properties prop = new Properties();
        try {
            String tableName = ADSM_USER_GENERAL_DETAILS;
            Criteria crit = new Criteria(new Column(ADSM_USER_GENERAL_DETAILS, "SAM_ACCOUNT_NAME"), (Object)samAccountName, 0);
            crit = crit.and(new Column(ADSM_USER_GENERAL_DETAILS, "DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(ADSM_USER_GENERAL_DETAILS, crit);
            if (!dObj.isEmpty()) {
                String colValue = null;
                Row r = dObj.getFirstRow(ADSM_USER_GENERAL_DETAILS);
                for (String propName : reqPropName) {
                    colValue = r.get(propName) != null ? (String)r.get(propName) : "";
                    prop.put(propName, colValue);
                }
            } else {
                prop = UserUtil.getUserObjectDetails(samAccountName, domainName, reqPropName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static ArrayList executeADQuery(String domainName, String[] props, String searchQuery, String ouDN) {
        ArrayList list = new ArrayList();
        try {
            ArrayList<String> attributeList = new ArrayList<String>();
            for (int i = 0; i < props.length; ++i) {
                attributeList.add(props[i]);
            }
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
            try {
                list = ADHandler.getObjectsWithOutListener(domainDetails, ouDN, attributeList, searchQuery);
            }
            catch (NativeException ne) {
                ne.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return UserUtil.removeRestrictedUsers(list, domainName);
    }

    public static ArrayList getDirectReports(String domainName, String[] props, String managerDN, ArrayList<String> domainVsOus, Long hideDisabledUsers) {
        ArrayList list = new ArrayList();
        try {
            String searchString = "(&(objectcategory=person)(objectClass=user)";
            if (hideDisabledUsers.equals(1L)) {
                searchString = searchString + "(!(userAccountControl:1.2.840.113556.1.4.803:=2))";
            }
            searchString = searchString + "(!(sAMAccountType=805306370))(manager=" + CommonUtil.escapeSpecialCharacters(managerDN) + "))";
            if (domainVsOus != null) {
                for (String domainVsOu : domainVsOus) {
                    list.addAll(UserUtil.executeADQuery(domainName, props, searchString, domainVsOu));
                }
            } else {
                list = UserUtil.executeADQuery(domainName, props, searchString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Properties getUserAttValues(String domainName, String[] props, String searchString, ArrayList<String> domainVsOus) {
        Properties ret = new Properties();
        try {
            searchString = "(&(objectcategory=person)(objectClass=user)" + searchString + ")";
            ArrayList list = new ArrayList();
            if (domainVsOus != null) {
                for (String domainVsOu : domainVsOus) {
                    list.addAll(UserUtil.executeADQuery(domainName, props, searchString, domainVsOu));
                }
            } else {
                list = UserUtil.executeADQuery(domainName, props, searchString);
            }
            if (list.size() > 0) {
                Properties p = (Properties)list.get(0);
                for (int i = 0; i < props.length; ++i) {
                    ArrayList values = (ArrayList)p.get(props[i]);
                    if (values == null || values.size() <= 0) continue;
                    ret.put(props[i], values);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static ArrayList removeRestrictedUsers(ArrayList list, String domainName) {
        try {
            String sidTableName = CommonUtil.getDomainUserTableName(domainName);
            String[] staleUsers = EnrollUtil.getStaleUsers(sidTableName);
            ArrayList<String> staleUsersList = new ArrayList<String>(Arrays.asList(staleUsers));
            for (int i = 0; i < list.size(); ++i) {
                String guid = (String)((ArrayList)((Properties)list.get(i)).get("objectGUID")).get(0);
                if (!staleUsersList.contains(guid)) continue;
                list.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean isNewlyCreatedUser(String userName, String domainName) {
        try {
            String[] reqprops = new String[]{"LOGON_NAME"};
            Properties userProperties = UserUtil.getUserGeneralDetail(userName, domainName, reqprops);
            if (userProperties.getProperty("SAM_ACCOUNT_NAME") == null) {
                String[] attrList = new String[]{"whenCreated", "whenChanged"};
                Properties p = UserUtil.getUserObjectDetails(userName, domainName, attrList);
                Long whenCreatedAD = Long.parseLong(p.getProperty("whenCreated"));
                Long whenChangedAD = Long.parseLong(p.getProperty("whenChanged"));
                if (whenChangedAD - whenCreatedAD < 600000000L) {
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean comparePwdLastSet(String userName, String domainName, Long loginId, String pwdLastSetAD) {
        String[] elements = new String[]{"PASSWORD_LAST_SET"};
        Hashtable ht = UserUtil.getUserPersonal(loginId, elements);
        Long pwdLastSetinDB = Long.parseLong((String)ht.get("PASSWORD_LAST_SET"));
        Long pwdLastSetinAD = Long.parseLong(pwdLastSetAD);
        boolean retValue = true;
        try {
            int diffInt = pwdLastSetinAD.compareTo(pwdLastSetinDB);
            if (diffInt == 0) {
                retValue = false;
            } else {
                Hashtable<String, String> pwdDetails = new Hashtable<String, String>();
                pwdDetails.put("PASSWORD_LAST_SET", pwdLastSetAD);
                logger.log(Level.INFO, "Updating PASSWORD_LAST_SET attribute from comparePwdLastSet method");
                UserUtil.setUserPersonal(loginId, pwdDetails);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, e.toString() + " occured in comparePwdLastSet");
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList removeRestrictedUsersByDN(String[] groupMembers, String domainName) {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(groupMembers));
        try {
            RelationalAPI rapi = RelationalAPI.getInstance();
            connection = rapi.getConnection();
            ArrayList<String> staleUsersList = new ArrayList<String>();
            String usersTable = ADSM_USER_GENERAL_DETAILS;
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table(usersTable));
            selectQuery.addSelectColumn(Column.getColumn((String)usersTable, (String)"DISTINGUISHED_NAME"));
            Join join = new Join(new Table(usersTable), new Table("StaleAccountUsers"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            selectQuery.addJoin(join);
            dataSet = rapi.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                staleUsersList.add(dataSet.getString("DISTINGUISHED_NAME"));
            }
            list.removeAll(staleUsersList);
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return list;
    }

    public static Hashtable getUserNameAndDomainName(String userName, String domainName) {
        return UserUtil.getUserNameAndDomainName(userName, domainName, new String[]{"distinguishedName", "memberOf", "primaryGroupID", "objectSID", "objectGUID", "samAccountName"});
    }

    public static Hashtable getUserNameAndDomainName(String userName, String domainName, String[] attrib) {
        boolean isOtherLoginAttrEnabled = ADSMPersUtil.getSyMParameter("otherLoginAttributes").equals("true");
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        Properties userProp = new Properties();
        try {
            ArrayList domainList = new ArrayList();
            Properties p = new Properties();
            if (domainName != null && !domainName.equals("")) {
                p.put("DOMAIN_NAME", domainName);
                domainList.add(p);
            } else {
                domainList = DomainHandler.getDomainList();
                p.put("DOMAIN_NAME", DomainHandler.getDefaultDomain());
                domainList.remove(p);
                domainList.add(0, p);
            }
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domProp = (Properties)domainList.get(i);
                String domName = (String)domProp.get("DOMAIN_NAME");
                userProp = UserUtil.getUserObjectDetails(userName, domName, attrib, (Boolean)true, isOtherLoginAttrEnabled);
                if (!userProp.containsKey("samAccountName")) continue;
                userName = (String)((ArrayList)userProp.get("samAccountName")).get(0);
                domainName = domName;
                break;
            }
            if (userName.indexOf("\\") != -1 || userName.indexOf("@") != -1) {
                Hashtable names = UserUtil.getLogonNameFromUPN(userName);
                if (domainName == null || domainName.equals("")) {
                    domainName = "";
                    if (names.get("userName") != "" && names.get("domainName") != "") {
                        userName = (String)names.get("userName");
                        domainName = (String)names.get("domainName");
                    }
                } else if (!userProp.containsKey("samAccountName") && names.get("userName") != "" && names.get("domainName") != "") {
                    userName = (String)names.get("userName");
                }
                if (userName != null && !userName.equals("") && domainName != null && !domainName.equals("")) {
                    userProp = UserUtil.getUserObjectDetails(userName, domainName, attrib, true);
                    userProp.put("multipleAccountsMatched", (Object)false);
                }
            }
            domainName = domainName == null ? "" : domainName;
            hash.put("userName", userName);
            hash.put("domainName", domainName);
            hash.put("userProp", userProp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getUsersCount(Hashtable queryData) {
        Integer count = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String userTable = CommonUtil.getDomainUserTableName((String)queryData.get("DOMAIN_NAME"));
            queryData.put("IS_COUNT_QUERY", true);
            SelectQuery sq = UserUtil.getSQForUsersList(queryData);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getUsersList(Hashtable queryData) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQuery sq = UserUtil.getSQForUsersList(queryData);
            RelationalAPI relApi = RelationalAPI.getInstance();
            connection = relApi.getConnection();
            dataSet = relApi.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                String[] columns = (String[])queryData.get("SELECT_COLUMNS");
                if (columns == null) {
                    columns = usersListProp;
                }
                Properties p = new Properties();
                for (String str : columns) {
                    String val = dataSet.getString(str);
                    if (val == null) {
                        val = "-";
                    }
                    p.put(str, val);
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeQuietly(connection, dataSet);
                throw throwable;
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        DBUtil.closeQuietly(connection, dataSet);
        return list;
    }

    public static SelectQuery getSQForUsersList(Hashtable queryData) {
        String userTable = CommonUtil.getDomainUserTableName((String)queryData.get("DOMAIN_NAME"));
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)userTable));
        try {
            int numOfObjects;
            Join join = new Join(Table.getTable((String)userTable), Table.getTable((String)"StaleAccountUsers"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            sq.addJoin(join);
            Join grpJoin = new Join(Table.getTable((String)userTable), Table.getTable((String)"ADSMGroupMembers"), new String[]{"OBJECT_GUID"}, new String[]{"GROUP_MEMBER_OBJECTGUID"}, 1);
            sq.addJoin(grpJoin);
            Criteria criteria = new Criteria(Column.getColumn((String)"StaleAccountUsers", (String)"OBJECT_GUID"), null, 0);
            String searchString = QueryUtil.mickeyCriteriaEscape((String)queryData.get("SEARCH_STRING"));
            if (searchString != null && !"".equals(searchString)) {
                String[] stringArray;
                if (queryData.get("SEARCH_COLUMNS") == null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "SAM_ACCOUNT_NAME";
                } else {
                    stringArray = (String[])queryData.get("SEARCH_COLUMNS");
                }
                String[] searchColumns = stringArray;
                Criteria searchCrit = null;
                for (String columnName : searchColumns) {
                    Criteria crit = new Criteria(Column.getColumn((String)userTable, (String)columnName), (Object)searchString, 12, false);
                    searchCrit = searchCrit == null ? crit : searchCrit.or(crit);
                }
                criteria = criteria.and(searchCrit);
            }
            ArrayList ouList = (ArrayList)queryData.get("OU_LIST");
            HashSet<String> ouDNSet = new HashSet<String>();
            if (ouList != null && !ouList.isEmpty()) {
                ouDNSet.addAll(ouList);
            }
            Criteria containerCrit = null;
            ArrayList ouGuidList = (ArrayList)queryData.get("OU_GUID_LIST");
            if (ouGuidList != null && !ouGuidList.isEmpty()) {
                Criteria ouGuidCrit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)ouGuidList.toArray(), 8, false);
                DataObject ouObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMOUDetails", ouGuidCrit);
                if (!ouObj.isEmpty()) {
                    Iterator ouItr = ouObj.getRows("ADSMOUDetails");
                    while (ouItr.hasNext()) {
                        Row ouRow = (Row)ouItr.next();
                        ouDNSet.add((String)ouRow.get("DISTINGUISHED_NAME"));
                    }
                }
            }
            if (ouDNSet != null && !ouDNSet.isEmpty()) {
                ouList = OUUtil.getParentOUs(new ArrayList(ouDNSet));
                Criteria ouCrit = null;
                for (int i = 0; i < ouList.size(); ++i) {
                    String ouDN = (String)ouList.get(i);
                    Criteria crite = new Criteria(Column.getColumn((String)userTable, (String)"DN_STRING"), (Object)QueryUtil.mickeyCriteriaEscape(ouDN), 11, false);
                    ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
                }
                containerCrit = ouCrit;
            }
            String groupTable = CommonUtil.getDomainGroupTableName((String)queryData.get("DOMAIN_NAME"));
            ArrayList<Object> grpList = (ArrayList<Object>)queryData.get("GROUP_GUID_LIST");
            if (grpList != null && !grpList.isEmpty()) {
                DataObject obj = DataAccess.get((String)groupTable, (Criteria)new Criteria(Column.getColumn((String)groupTable, (String)"OBJECT_GUID"), (Object)grpList.toArray(), 8, false));
                grpList = new ArrayList<Object>();
                if (!obj.isEmpty()) {
                    Iterator it = obj.getRows(groupTable);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        grpList.add(r.get("OBJECT_GUID"));
                    }
                }
            }
            if (grpList != null && !grpList.isEmpty()) {
                Criteria grpCrit = new Criteria(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"), (Object)grpList.toArray(), 8, false);
                containerCrit = containerCrit == null ? grpCrit : containerCrit.or(grpCrit);
                Criteria grpTableCrit = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"OBJECT_GUID"), (Object)grpList.toArray(), 8, false);
                grpTableCrit = grpTableCrit.and(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DOMAIN_NAME"), (Object)((String)queryData.get("DOMAIN_NAME")), 0, false));
                containerCrit = containerCrit == null ? grpTableCrit : containerCrit.or(grpTableCrit);
                Function c = Column.createFunction((String)"CONCAT", (Object[])new Object[]{"%", Column.getColumn((String)userTable, (String)"PRIMARY_GROUP_ID")});
                c.setType(-15);
                Join grpTableJoin = new Join(Table.getTable((String)userTable), Table.getTable((String)"ADSMGroupGeneralDetails"), new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"SID_STRING"), (Object)c, 2), 1);
                sq.addJoin(grpTableJoin);
            }
            criteria = criteria.and(containerCrit);
            sq.setCriteria(criteria);
            if (queryData.get("IS_COUNT_QUERY") != null && ((Boolean)queryData.get("IS_COUNT_QUERY")).booleanValue()) {
                sq.addSelectColumn(Column.getColumn((String)userTable, (String)"SAM_ACCOUNT_NAME").distinct().count());
                return sq;
            }
            if (queryData.get("DISTINCT_COLUMN") != null) {
                String colName = queryData.get("DISTINCT_COLUMN").toString();
                sq.addSelectColumn(Column.getColumn((String)userTable, (String)colName, (String)colName));
                sq.setDistinct(true);
            } else {
                if (!sq.getSelectColumns().contains(Column.getColumn((String)userTable, (String)"SAM_ACCOUNT_NAME"))) {
                    sq.addSelectColumn(Column.getColumn((String)userTable, (String)"SAM_ACCOUNT_NAME"));
                }
                sq.setDistinct(true);
            }
            String[] columns = (String[])queryData.get("SELECT_COLUMNS");
            if (columns == null) {
                columns = usersListProp;
            }
            for (int i = 0; i < columns.length; ++i) {
                if (sq.getSelectColumns().contains(Column.getColumn((String)userTable, (String)columns[i]))) continue;
                sq.addSelectColumn(Column.getColumn((String)userTable, (String)columns[i]));
            }
            String sortColumnName = (String)queryData.get("SORT_COLUMN");
            Boolean ascending = (Boolean)queryData.get("ASCENDING");
            if (sortColumnName == null) {
                sortColumnName = "SAM_ACCOUNT_NAME";
            }
            if (ascending == null) {
                ascending = true;
            }
            sq.addSortColumn(new SortColumn(userTable, sortColumnName, ascending.booleanValue()));
            int startIndex = queryData.get("START_INDEX") != null ? (Integer)queryData.get("START_INDEX") : -1;
            int n = numOfObjects = queryData.get("NUM_OF_OBJECTS") != null ? (Integer)queryData.get("NUM_OF_OBJECTS") : 0;
            if (startIndex != -1) {
                sq.setRange(new Range(startIndex, numOfObjects));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserObjectGUIDFromName(String name) {
        DataSet dataset = null;
        Connection connection = null;
        String objectGuid = null;
        try {
            Table pnRegAppTable = Table.getTable((String)AAA_LOGIN);
            SelectQueryImpl sQuery = new SelectQueryImpl(pnRegAppTable);
            Join join2 = new Join(Table.getTable((String)AAA_LOGIN), Table.getTable((String)ADSM_USER_GENERAL_DETAILS), new String[]{DOMAINNAME, NAME}, new String[]{"DOMAIN_NAME", "SAM_ACCOUNT_NAME"}, 2);
            sQuery.addJoin(join2);
            sQuery.addSelectColumn(Column.getColumn((String)ADSM_USER_GENERAL_DETAILS, (String)"OBJECT_GUID"));
            Criteria c1 = new Criteria(Column.getColumn((String)AAA_LOGIN, (String)NAME), (Object)name, 0);
            sQuery.setCriteria(c1);
            RelationalAPI relation = RelationalAPI.getInstance();
            connection = relation.getConnection();
            dataset = relation.executeQuery((Query)sQuery, connection);
            if (dataset.next()) {
                objectGuid = dataset.getValue("OBJECT_GUID").toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataset != null) {
                try {
                    dataset.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return objectGuid;
    }

    public static JSONObject getUserAccountDetails(String name, String domainName) {
        JSONObject accountDO = null;
        try {
            accountDO = new JSONObject();
            Criteria c = new Criteria(Column.getColumn((String)AAA_LOGIN, (String)NAME), (Object)name, 0);
            c = c.and(new Criteria(Column.getColumn((String)AAA_LOGIN, (String)DOMAINNAME), (Object)domainName, 0));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(AAA_LOGIN, c);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow(AAA_LOGIN);
                for (String columnName : row.getColumns()) {
                    Object colValue = row.get(columnName);
                    accountDO.put(columnName, colValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return accountDO;
    }

    public static JSONObject getUserDetailsFromLoginId(Long loginId, String[] columnNames, JSONObject userProps) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)AAA_LOGIN, (String)LOGIN_ID), (Object)loginId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(AAA_LOGIN, c);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow(AAA_LOGIN);
                int len = columnNames.length;
                while (len-- > 0) {
                    userProps.put(columnNames[len], (Object)((String)r.get(columnNames[len])));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userProps;
    }

    public static String getPasswordLastset(Long loginId) throws Exception {
        JSONObject userObj = new JSONObject();
        UserUtil.getUserDetailsFromLoginId(loginId, new String[]{DOMAINNAME, NAME}, userObj);
        Properties p = UserUtil.getUserObjectDetails(userObj.getString(NAME), userObj.getString(DOMAINNAME), new String[]{"pwdLastSet"});
        return (String)p.get("pwdLastSet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getLDAPValues(Properties domainDetails, String distinguishedName, ArrayList attributeList, String searchString, String loginName, boolean realTime) throws Exception {
        Properties prop;
        Boolean needADCall = false;
        Object object = obj;
        synchronized (object) {
            Properties p;
            long t;
            int deleteEndIndex = 0;
            int i = 1;
            while (cachedADList.size() > i * 500 && (t = ((Long)(p = (Properties)cachedADValues.get(cachedADList.get(i * 500))).get("TIME")).longValue()) + 30000L <= System.currentTimeMillis()) {
                deleteEndIndex = i * 500;
                ++i;
            }
            if (deleteEndIndex != 0) {
                List list = cachedADList.subList(0, deleteEndIndex);
                cachedADValues.keySet().removeAll(list);
                cachedADList.removeAll(list);
            }
            if (cachedADList.size() > 5000) {
                List list = cachedADList.subList(0, 1000);
                cachedADValues.keySet().removeAll(list);
                cachedADList.removeAll(list);
            }
        }
        Properties properties = prop = loginName != null ? (Properties)cachedADValues.get(domainDetails.getProperty("DOMAIN_NAME") + "\\" + loginName) : null;
        if (prop != null && !realTime) {
            long time = (Long)prop.get("TIME");
            if (time + 30000L > System.currentTimeMillis()) {
                for (int i = 0; i < attributeList.size(); ++i) {
                    if (prop.get(((String)attributeList.get(i)).toLowerCase()) != null) continue;
                    needADCall = true;
                    break;
                }
            } else {
                prop = null;
                needADCall = true;
            }
            if (!needADCall.booleanValue()) {
                Properties newProp = new Properties();
                for (int i = 0; i < attributeList.size(); ++i) {
                    ArrayList list = new ArrayList();
                    list.addAll((ArrayList)prop.get(((String)attributeList.get(i)).toLowerCase()));
                    if (list.size() <= 0) continue;
                    newProp.put(attributeList.get(i), list);
                }
                ArrayList<Properties> LDAPValueList = new ArrayList<Properties>();
                LDAPValueList.add(newProp);
                return LDAPValueList;
            }
        }
        if (prop == null || needADCall.booleanValue() || realTime) {
            if (prop == null) {
                prop = new Properties();
                prop.put("TIME", (Object)System.currentTimeMillis());
                if (loginName != null) {
                    cachedADList.remove(domainDetails.getProperty("DOMAIN_NAME") + "\\" + loginName);
                }
            }
            ArrayList list = new ArrayList();
            list = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString);
            if (list.size() > 0) {
                Properties p = (Properties)list.get(0);
                for (int i = 0; i < attributeList.size(); ++i) {
                    ArrayList values = (ArrayList)p.get(attributeList.get(i));
                    if (values != null && values.size() > 0) {
                        prop.put(((String)attributeList.get(i)).toLowerCase(), values);
                        continue;
                    }
                    prop.put(((String)attributeList.get(i)).toLowerCase(), new ArrayList());
                }
            }
            if (loginName != null) {
                cachedADList.add(domainDetails.getProperty("DOMAIN_NAME") + "\\" + loginName);
                cachedADValues.put(domainDetails.getProperty("DOMAIN_NAME") + "\\" + loginName, prop);
            }
            return list;
        }
        return null;
    }

    public static ArrayList getUserSecondaryMailIds(String samAccName, String domainName) {
        ArrayList<String> secMailIds = new ArrayList<String>();
        try {
            Long loginId = ADMPUserHandler.getLoginId(samAccName, domainName);
            if (loginId != null) {
                Hashtable secondaryMailHash = UserUtil.getUserPersonal(loginId, new String[]{"EMAIL_ADDRESSES"});
                String allSecMails = (String)secondaryMailHash.get("EMAIL_ADDRESSES");
                String[] mails = allSecMails != null ? allSecMails.split(",") : new String[]{};
                for (int i = 0; i < mails.length && mails[i] != ""; ++i) {
                    secMailIds.add(mails[i]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return secMailIds;
    }

    public static ArrayList getUsersArrayFromGUID(ArrayList selectedUsers, String domainName) {
        ArrayList<String> usersList = new ArrayList<String>();
        try {
            String[] users = selectedUsers.toArray(new String[selectedUsers.size()]);
            String userTN = ADSM_USER_GENERAL_DETAILS;
            Criteria criteria = new Criteria(Column.getColumn((String)userTN, (String)"OBJECT_GUID"), (Object)users, 8, false);
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table(userTN));
            selectQuery.addSelectColumn(Column.getColumn((String)userTN, (String)"OBJECT_GUID"));
            selectQuery.addSelectColumn(Column.getColumn((String)userTN, (String)"SAM_ACCOUNT_NAME"));
            selectQuery.setCriteria(criteria);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(userTN);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String sAN = (String)r.get("SAM_ACCOUNT_NAME");
                    usersList.add(sAN);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return usersList;
    }
}

