/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class VpnUtil {
    public static String[] vpnConstants = new String[]{"%SERVERNAME%", "%PORTNO%"};
    public static String[] vpnParamConstants = new String[]{"VPN_SERVER_NAME", "VPN_PORT_NO"};

    public static Properties getVPNProviderSettingsParams(long providerId) {
        Properties settingsParams = new Properties();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSVPNProviderParams", (String)"ADSVPNProvider_ID"), (Object)providerId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProviderParams", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProviderParams");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String paramValue = (String)r.get("PARAM_VALUE") != null ? (String)r.get("PARAM_VALUE") : "";
                    settingsParams.put(r.get("PARAM_NAME"), paramValue);
                }
            }
            settingsParams = VpnUtil.replaceProviderSpecificValues(settingsParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settingsParams;
    }

    public static Properties replaceProviderSpecificValues(Properties settingsParams) {
        Properties params = settingsParams;
        if (params.containsKey("VPN_REALM_NAME")) {
            String vpnRealmName = (String)params.get("VPN_REALM_NAME");
            String vpnConnectCmd = (String)params.get("CONNECT_CMD");
            String realmName = "%realmname%";
            vpnConnectCmd = vpnConnectCmd.replaceAll(realmName, vpnRealmName);
            params.put("CONNECT_CMD", vpnConnectCmd);
        }
        return params;
    }

    public static Object getVpnProviderColumnValue(long providerId, String columnName) {
        ArrayList providerList = new ArrayList();
        try {
            Iterator it;
            Criteria crit = new Criteria(Column.getColumn((String)"ADSVPNProvider", (String)"VPN_PROVIDER_ID"), (Object)providerId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProvider", crit);
            if (!obj.isEmpty() && (it = obj.getRows("ADSVPNProvider")).hasNext()) {
                Row r = (Row)it.next();
                return r.get(columnName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static Properties getVPNProviderSettings() {
        Properties providerSettings = new Properties();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProviderSettings", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProviderSettings");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    long providerId = (Long)r.get("ADSVPNProvider_ID");
                    providerSettings.put("VPN_PROVIDER_ID", (Object)providerId);
                    providerSettings.put("IS_VPN_ENABLED", r.get("IS_VPN_ENABLED"));
                    providerSettings.put("VPN_SERVER_NAME", r.get("VPN_SERVER_NAME"));
                    providerSettings.put("VPN_PORT_NO", r.get("VPN_PORT_NO"));
                    providerSettings.put("VPN_TYPE", Long.toString((Long)VpnUtil.getVpnProviderColumnValue(providerId, "VPN_TYPE")));
                    providerSettings.put("VPN_SETTINGS_PARAMS", VpnUtil.getVPNProviderSettingsParams(providerId));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerSettings;
    }

    public static ArrayList getVpnProviderParams(long providerId) {
        ArrayList<Object> params = new ArrayList<Object>();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSVPNProviderParams", (String)"ADSVPNProvider_ID"), (Object)providerId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProviderParams", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProviderParams");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    params.add(r.get("PARAM_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static ArrayList getVPNProviders(Criteria crit) {
        ArrayList<Properties> providerList = new ArrayList<Properties>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ADSVPNProvider"));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"ADSVPNProvider", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSVPNProvider", (String)"PRIORITY"), true));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProvider");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    long pId = (Long)r.get("VPN_PROVIDER_ID");
                    Properties provider = new Properties();
                    provider.put("PROVIDER_ID", (Object)pId);
                    provider.put("VPN_NAME", r.get("VPN_NAME"));
                    provider.put("VPN_DISPLAY_NAME", r.get("VPN_DISPLAY_NAME"));
                    provider.put("VPN_TYPE", r.get("VPN_TYPE"));
                    provider.put("VPN_PARAMS", VpnUtil.getVpnProviderParams(pId));
                    providerList.add(provider);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerList;
    }

    public static ArrayList getVPNProviders(Long providerId) {
        ArrayList providerList = new ArrayList();
        try {
            providerList = VpnUtil.getVPNProviders(new Criteria(Column.getColumn((String)"ADSVPNProvider", (String)"VPN_PROVIDER_ID"), (Object)providerId, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerList;
    }

    public static ArrayList getVPNProviders() {
        return VpnUtil.getVPNProviders((Criteria)null);
    }

    public static boolean isVpnEnabled() {
        boolean isVpnEnabled = false;
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProviderSettings", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProviderSettings");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    if (r.get("IS_VPN_ENABLED") == null || !((Boolean)r.get("IS_VPN_ENABLED")).booleanValue()) continue;
                    isVpnEnabled = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isVpnEnabled;
    }

    public static String getCmd(long providerId, String cmdName) {
        String cmd = "";
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSVPNProviderParams", (String)"ADSVPNProvider_ID"), (Object)providerId, 0);
            c.and(new Criteria(Column.getColumn((String)"ADSVPNProviderParams", (String)cmdName), (Object)cmdName, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProviderParams", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProviderParams");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    cmd = (String)r.get(cmdName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cmd;
    }

    public static void setVpnSettingsParams(Properties prop, long vpnType) {
        try {
            long providerId = (Long)prop.get("PROVIDER_ID");
            Criteria crit = new Criteria(Column.getColumn((String)"ADSVPNProviderParams", (String)"PARAM_NAME"), (Object)"CONNECT_CMD", 3, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSVPNProviderParams", (String)"PARAM_NAME"), (Object)"DISCONNECT_CMD", 3, false));
            if (VpnUtil.isCustomVPNProvider(providerId)) {
                crit = crit.or(new Criteria(Column.getColumn((String)"ADSVPNProviderParams", (String)"ADSVPNProvider_ID"), (Object)providerId, 0));
            }
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            String[][] vpnTypeVsParams = new String[][]{{"VPN_CLIENT_LOCATION", "VPN_CLIENT_LOCATION_64", "CONNECT_CMD", "DISCONNECT_CMD"}, {"VPN_CLIENT_LOCATION", "VPN_CLIENT_LOCATION_64"}, {"PRE_SHARED_KEY"}, {"VPN_CLIENT_LOCATION", "VPN_CLIENT_LOCATION_64", "VPN_GROUP_NAME"}, {"VPN_CLIENT_LOCATION", "VPN_CLIENT_LOCATION_64", "VPN_DOMAIN_NAME"}, {"VPN_CLIENT_LOCATION", "VPN_CLIENT_LOCATION_64"}};
            for (int i = 0; i < vpnTypeVsParams[(int)vpnType].length; ++i) {
                Row row = new Row("ADSVPNProviderParams");
                row.set("ADSVPNProvider_ID", (Object)providerId);
                row.set("PARAM_NAME", (Object)vpnTypeVsParams[(int)vpnType][i]);
                row.set("PARAM_VALUE", prop.get(vpnTypeVsParams[(int)vpnType][i]));
                obj.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setVpnDisabled() {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProviderSettings", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProviderSettings");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    r.set("IS_VPN_ENABLED", (Object)false);
                    obj.updateRow(r);
                }
            }
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setVpnSettings(Properties prop, long type) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSVPNProviderSettings", (String)"PROVIDER_CONFIG_ID"), null, 1);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
            if (!prop.isEmpty()) {
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row r = new Row("ADSVPNProviderSettings");
                r.set("VPN_SERVER_NAME", prop.get("VPN_SERVER_NAME"));
                r.set("VPN_PORT_NO", prop.get("VPN_PORT_NO"));
                r.set("IS_VPN_ENABLED", prop.get("IS_VPN_ENABLED"));
                r.set("ADSVPNProvider_ID", prop.get("PROVIDER_ID"));
                obj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(obj);
            }
            VpnUtil.setVpnSettingsParams(prop, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String replaceValues(Properties prop, long providerId, String cmdName) {
        String cmd = VpnUtil.getCmd(providerId, cmdName);
        for (int i = 0; i < 4; ++i) {
            cmd = cmd.replaceAll(vpnConstants[i].toString(), prop.get(vpnParamConstants[i]).toString());
        }
        return cmd;
    }

    public static boolean isCustomVPNProvider(Long providerId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSVPNProvider", (String)"VPN_PROVIDER_ID"), (Object)providerId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSVPNProvider", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSVPNProvider");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String providerName = (String)r.get("VPN_NAME");
                    if (!providerName.equals("CUSTOM_VPN")) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

