/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtility {
    private static Logger logger = Logger.getLogger(ZipUtility.class.getName());
    ZipOutputStream cpZipOutputStream = null;
    private static GZIPOutputStream gzipOut = null;
    String strSource = "";
    String strTarget = "";
    String strSubstring = "";

    public static void addtoZip(String dir, String fName) {
        ZipUtility udZipUtility = new ZipUtility();
        udZipUtility.strSource = dir;
        udZipUtility.strTarget = dir + File.separator + fName;
        udZipUtility.zip();
    }

    private void zip() {
        try {
            File cpFile = new File(this.strSource);
            if (!cpFile.isFile() && !cpFile.isDirectory()) {
                logger.log(Level.INFO, "\nSource file/directory Not Found!");
                return;
            }
            this.strSubstring = cpFile.isDirectory() ? this.strSource : "";
            this.cpZipOutputStream = new ZipOutputStream(new FileOutputStream(this.strTarget));
            this.cpZipOutputStream.setLevel(9);
            this.zipFiles(cpFile);
            this.cpZipOutputStream.finish();
            this.cpZipOutputStream.close();
            logger.log(Level.INFO, "\n Finished creating zip file " + this.strTarget + " from source " + this.strSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void zipFiles(File cpFile) {
        if (cpFile.isDirectory()) {
            File[] fList = cpFile.listFiles();
            for (int i = 0; i < fList.length; ++i) {
                this.zipFiles(fList[i]);
            }
            return;
        }
        FileInputStream cpFileInputStream = null;
        try {
            String strAbsPath = cpFile.getAbsolutePath();
            String strZipEntryName = "";
            strZipEntryName = !this.strSubstring.equals("") ? strAbsPath.substring(this.strSource.length() + 1, strAbsPath.length()) : cpFile.getName();
            if (this.strTarget.endsWith(strZipEntryName)) return;
            byte[] b = new byte[(int)cpFile.length()];
            cpFileInputStream = new FileInputStream(cpFile);
            int i = cpFileInputStream.read(b, 0, (int)cpFile.length());
            ZipEntry cpZipEntry = new ZipEntry(strZipEntryName);
            this.cpZipOutputStream.putNextEntry(cpZipEntry);
            this.cpZipOutputStream.write(b, 0, (int)cpFile.length());
            this.cpZipOutputStream.closeEntry();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (cpFileInputStream != null) {
                try {
                    cpFileInputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipToGZip(String dir, String zFName, String gZFName) {
        FileInputStream in = null;
        try {
            int len;
            gzipOut = new GZIPOutputStream(new FileOutputStream(dir + File.separator + gZFName));
            in = new FileInputStream(dir + File.separator + zFName);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                gzipOut.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (gzipOut != null) {
                try {
                    gzipOut.finish();
                    gzipOut.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

