/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util.licensing;

import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import com.adventnet.tools.prevalent.Wield;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.ListUtils;
import org.json.JSONObject;

public class LicenseManager {
    private static LicenseManager licenseManager = null;
    public static final List<String> TOTAL_COMPONENTS = Arrays.asList("PasswordSelfService", "PasswordSelfServicePro", "DirectoryUpdate");
    public static final List<String> PASSWORD_PRO_COMPONENTS = Arrays.asList("WinLogonExtension", "PasswordSync");
    public static final List<String> FREE_COMPONENTS = Arrays.asList("ExpiryNotifier");
    public static final List<String> PROFESSIONAL_VERSION_MODULES = Arrays.asList("WinLogonExtension");
    public static final String GROUP_SUBSCRIPTION_COMPONENT = "DirectoryUpdate";
    public static final String PWD_SYNC_COMPONENT = "PasswordSync";
    public static final String GINACP_COMPONENT = "WinLogonExtension";
    private String productName = null;
    private String userType = null;
    private String licenseType = null;
    private ArrayList<String> compList = null;
    private Hashtable<String, Properties> licenseProps = new Hashtable();
    private static Logger logger = Logger.getLogger(LicenseManager.class.getName());
    public static JSONObject componentVsTileName = new JSONObject();
    public static JSONObject componentVsReports = new JSONObject();

    private LicenseManager() {
    }

    public static LicenseManager getInstance() {
        try {
            if (licenseManager == null) {
                licenseManager = new LicenseManager();
                componentVsTileName = new JSONObject(){
                    {
                        this.put("PasswordSelfService", new String[]{"PolicyConfiguration", "GroupSubscription", "Enrollment", "pwdStrength", "qaSetting", "antiHack", "DCConfiguration", "LogonCustomization", "schedule", "RestrictUsersSettings", "IAMApps", "PasswordPolicyEnforcer", "MobileAppDeployment"});
                        this.put("PasswordSelfServicePro", new String[]{"IAMApps", "GinaPolicy", "Enrollment", "LogonCustomization", "schedule", "RestrictUsersSettings"});
                        this.put("ExpiryNotifier", new String[]{"SoonToExpire"});
                        this.put(LicenseManager.GROUP_SUBSCRIPTION_COMPONENT, new String[]{"EmployeeSearch", "DirectorySelfService", "WorkflowConfiguration", "LogonCustomization", "schedule", "RestrictUsersSettings"});
                        this.put("common", new String[]{"TechnicianConfiguration", "LogoCustomization", "PersonaliseSettings", "DBBackupSchedule", "ConnectionSettings", "ServerSettings", "NTServiceSettings"});
                    }
                };
                componentVsReports = new JSONObject(){
                    {
                        this.put("PasswordSelfService", new Integer[]{1, 2, 3, 4, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 301, 302, 303, 304, 305, 306, 309});
                        this.put("PasswordSelfServicePro", new Integer[]{1, 2, 3, 4, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 301, 302, 303, 304, 305, 306, 309, 401, 402});
                        this.put("ExpiryNotifier", new Integer[]{110});
                        this.put(LicenseManager.GROUP_SUBSCRIPTION_COMPONENT, new Integer[]{1, 2, 3, 4, 103, 107, 108, 10001});
                        this.put("common", new Integer[]{111});
                    }
                };
                if (licenseManager.isFreeTool() && System.getProperty("freeTool") == null) {
                    System.setProperty("freeTool", "true");
                    CommonUtil.writeToFile(System.getProperty("server.dir") + File.separator + "conf" + File.separator + "system_properties.conf", "freeTool", "true", false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return licenseManager;
    }

    public String getProductName() {
        if (this.productName == null) {
            this.productName = Wield.getInstance().getProductName();
        }
        return this.productName;
    }

    public synchronized String getUserType() {
        if (this.userType == null) {
            try {
                this.userType = Wield.getInstance().getUserType();
                logger.log(Level.INFO, "User Type :: " + this.userType);
                if (this.userType == null) {
                    this.userType = "";
                }
                if (this.userType.equals("") || "T".equals(this.userType) && this.isCompBasedLicense()) {
                    this.userType = "F";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.userType = "F";
            }
        }
        return this.userType;
    }

    public synchronized String getLicenseType() {
        if (this.licenseType == null) {
            try {
                this.licenseType = Wield.getInstance().getLicenseTypeString();
                logger.log(Level.INFO, "License Type :: " + this.licenseType);
            }
            catch (Exception e) {
                this.licenseType = "Standard";
                e.printStackTrace();
            }
        }
        return this.licenseType;
    }

    public String getLicenseProperty(String moduleName, String propertyName) {
        Properties moduleProp = this.licenseProps.get(moduleName);
        if (moduleProp == null) {
            this.fillModuleProps(moduleName);
            moduleProp = this.licenseProps.get(moduleName);
            logger.log(Level.INFO, "Props of " + moduleName + " module :: " + moduleProp);
        }
        if (moduleProp != null) {
            return (String)moduleProp.get(propertyName);
        }
        return null;
    }

    private synchronized void fillModuleProps(String moduleName) {
        Properties moduleProps = null;
        Wield wieldInst = Wield.getInstance();
        if (moduleName.equalsIgnoreCase("UserInfo")) {
            moduleProps = new Properties();
            moduleProps.put("expiryDate", wieldInst.getEvaluationExpiryDate());
            moduleProps.put("licenseType", wieldInst.getUserType());
            moduleProps.put("companyName", wieldInst.getCompanyName());
            Long daysToExpire = wieldInst.getEvaluationDays();
            moduleProps.put("daysToExpire", daysToExpire.toString());
            moduleProps.put("licensedTo", wieldInst.getCompanyName());
        } else {
            moduleProps = wieldInst.getModuleProperties(moduleName);
        }
        if (moduleProps != null) {
            this.licenseProps.put(moduleName, moduleProps);
        }
    }

    public void resetValues() {
        logger.log(Level.INFO, "resetValues of LicenseManager is Called");
        this.licenseProps = new Hashtable();
        this.licenseType = null;
        this.userType = null;
        this.compList = null;
        this.productName = null;
    }

    public boolean isComponentLicensed(String componentName) {
        return Wield.getInstance().isModulePresent(componentName);
    }

    public boolean isModuleLicensed(String moduleName) {
        logger.log(Level.FINE, "MODULE NAME :: " + moduleName);
        if (this.isTrial() && !this.isFreeTool() || this.isFreeTool() && LicenseUtil.isALLFeaturesEnabled() || this.wasFreeTool() && LicenseUtil.isALLFeaturesEnabled() || FREE_COMPONENTS.contains(moduleName)) {
            return true;
        }
        if (this.isCompBasedLicense()) {
            logger.log(Level.FINE, "Components Based License");
            if (PASSWORD_PRO_COMPONENTS.contains(moduleName)) {
                moduleName = "PasswordSelfServicePro";
            }
            return moduleName.equalsIgnoreCase("MSSQL") ? true : this.isComponentLicensed(moduleName);
        }
        if (!this.isProfessional() && PROFESSIONAL_VERSION_MODULES.contains(moduleName) && !this.isFree()) {
            logger.log(Level.FINE, moduleName + " is part of Professional Package.");
            return false;
        }
        return true;
    }

    public boolean isTrial() {
        return this.getUserType().equalsIgnoreCase("T");
    }

    public boolean isRegistered() {
        return this.getUserType().equalsIgnoreCase("R");
    }

    public boolean isFree() {
        return this.getUserType().equalsIgnoreCase("F");
    }

    public boolean isFreeTool() {
        String uType = "";
        try {
            uType = Wield.getInstance().getUserType();
        }
        catch (Exception e) {
            uType = this.getUserType();
        }
        return "T".equalsIgnoreCase(uType) && this.getLicenseType().equalsIgnoreCase("Components") || this.wasFreeTool();
    }

    public boolean wasFreeTool() {
        return this.isFree() && (!this.isFree() || !this.getLicenseType().equalsIgnoreCase("Components")) && "true".equalsIgnoreCase(System.getProperty("freeTool"));
    }

    public boolean isCompBasedLicense() {
        return this.getLicenseType().equalsIgnoreCase("Components") || this.wasFreeTool() && !LicenseUtil.isALLFeaturesEnabled();
    }

    public boolean isProfessional() {
        return this.getLicenseType().equalsIgnoreCase("Professional");
    }

    public String getPurchasedComponents() {
        if (!this.isCompBasedLicense()) {
            return null;
        }
        if (this.compList == null) {
            this.compList = this.getPurchasedComponentsList();
        }
        return this.compList.toString();
    }

    public ArrayList<String> getPurchasedComponentsList() {
        if (!this.isCompBasedLicense()) {
            return null;
        }
        if (this.compList == null) {
            this.compList = new ArrayList();
            List components = this.isFreeTool() && !LicenseUtil.isALLFeaturesEnabled() ? FREE_COMPONENTS : ListUtils.union(TOTAL_COMPONENTS, FREE_COMPONENTS);
            for (String component : components) {
                if (!this.isModuleLicensed(component)) continue;
                this.compList.add(component);
            }
        }
        return this.compList;
    }
}

