/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.util.licensing;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.admin.authentication.EncryptDecrypt;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.metracker.METrackHandler;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.reports.LicensedUsersHandler;
import com.adventnet.sym.adsm.common.server.taskengine.ProductUsageMailer;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.WrapperUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseManager;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.tools.prevalent.Validation;
import com.adventnet.tools.prevalent.WebLicenseUpgrade;
import com.manageengine.ads.fw.license.ADSLicenseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LicenseUtil
extends ADSLicenseUtil {
    private static Logger logger = Logger.getLogger(LicenseUtil.class.getName());
    private static final String[] PWD_SELF_SERVICE_COMPONENTS = new String[]{"PasswordSelfService", "PasswordSelfServicePro"};
    private static final int LICENSED_USER_LIMIT_COUNT = 50;
    private static final float LICENSED_USER_LIMIT_PERCENTAGE = 20.0f;
    private static final String NOTIFY_ADMIN_REG = "NOTIFY_ADMIN_REG";
    private static final String NOTIFY_INSTALL_SERVICE = "NOTIFY_INSTALL_SERVICE";
    private static final String NOTIFY_REG_STATUS = "NOTIFY_REG_STATUS";
    private static final String NOTIFY_SERVICE_STATUS = "NOTIFY_SERVICE_STATUS";
    private static final int ONE_MILLION = 1000000;
    private static Properties productDetails = null;

    public static boolean isMSSQLSupported() {
        return LicenseManager.getInstance().isModuleLicensed("MSSQL");
    }

    public static int getUsedLicenseCount() {
        return LicensedUsersHandler.getUsedLicenseCount();
    }

    public static int getPurchasedUserCount() {
        String userCount = LicenseManager.getInstance().getLicenseProperty("DomainUsers", "NumberOfUsers");
        return userCount == null ? 50 : Integer.parseInt(userCount);
    }

    public static int getPurchasedDomains() {
        String count = LicenseManager.getInstance().getLicenseProperty("Domains", "NumberOfDomains");
        return count == null ? 100 : Integer.parseInt(count);
    }

    public static boolean isUserCountExceeded() throws ADSSPException {
        int purchasedCount;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        int usedCount = LicenseUtil.getUsedLicenseCount();
        if (usedCount >= (purchasedCount = LicenseUtil.getPurchasedUserCount())) {
            LicenseManager licManager = LicenseManager.getInstance();
            logger.log(Level.INFO, "Used License Count :: " + usedCount + " :::: Purchased Count :: " + purchasedCount);
            if (licManager.isFree() || licManager.isTrial()) {
                throw new ADSSPException("adssp.exception.java.license.trial_restrict");
            }
            throw new ADSSPException(MessageFormat.format(rb.getString("adssp.exception.java.license.purchase_restrict_array"), purchasedCount));
        }
        return false;
    }

    public static boolean isUnlimitedUserLicense() {
        int purchasedCount = LicenseUtil.getPurchasedUserCount();
        return purchasedCount >= 1000000;
    }

    public static JSONObject getLicenseInfo() {
        JSONObject licenseInfo = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            licenseInfo = new JSONObject();
            int purchaseCount = LicenseUtil.getPurchasedUserCount();
            int usedUsersCount = LicenseUtil.getUsedLicenseCount();
            int enrollCount = LicensedUsersHandler.getEnrolledUsersCount();
            int unusedUserCount = purchaseCount - usedUsersCount;
            int nonEnrollCount = usedUsersCount - enrollCount;
            String purchasedCount = String.valueOf(purchaseCount);
            String unUsedCount = String.valueOf(unusedUserCount);
            if (purchaseCount >= 1000000) {
                unUsedCount = purchasedCount = rb.getString("adssp.tab.license.text.unlimited_license");
            }
            licenseInfo.put("PURCHASED_USER_COUNT", (Object)purchasedCount);
            licenseInfo.put("USED_USER_COUNT", (Object)String.valueOf(usedUsersCount));
            licenseInfo.put("ENROLLED_USER_COUNT", (Object)String.valueOf(enrollCount));
            licenseInfo.put("UNUSED_USER_COUNT", (Object)unUsedCount);
            licenseInfo.put("NON_ENROLL_USER_COUNT", (Object)String.valueOf(nonEnrollCount));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return licenseInfo;
    }

    public static String getPurchasedUserCountDisplayName() {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        int purchasedCount = LicenseUtil.getPurchasedUserCount();
        String usersCountName = String.valueOf(purchasedCount);
        if (purchasedCount >= 1000000) {
            usersCountName = rb.getString("adssp.tab.license.text.unlimited_license");
        }
        return usersCountName;
    }

    public static boolean isUserCountLimitReached() throws Exception {
        JSONObject result = LicenseUtil.isLicenseLimitReached();
        return result.has("IS_LIMIT_REACHED") ? result.getBoolean("IS_LIMIT_REACHED") : false;
    }

    public static JSONObject isLicenseLimitReached() {
        JSONObject result = new JSONObject();
        try {
            String notifyUnusedLicLimit;
            boolean isLimitReached = false;
            int usedCount = LicenseUtil.getUsedLicenseCount();
            int purchasedCount = LicenseUtil.getPurchasedUserCount();
            int unusedCount = purchasedCount - usedCount;
            String string = notifyUnusedLicLimit = ADSMPersUtil.getSyMParameter("NOTIFY_UNUSED_LICENSE_LIMIT") != null ? ADSMPersUtil.getSyMParameter("NOTIFY_UNUSED_LICENSE_LIMIT") : "50";
            if (unusedCount != -1 && unusedCount <= Integer.parseInt(notifyUnusedLicLimit)) {
                isLimitReached = true;
            }
            result.put("IS_LIMIT_REACHED", isLimitReached);
            result.put("PURCHASED_LIC_COUNT", purchasedCount);
            result.put("USED_LIC_COUNT", usedCount);
            result.put("UNUSED_LIC_COUNT", unusedCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getLicenseStatus(HttpServletRequest request) {
        String licenseStatus = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        LicenseManager licManager = LicenseManager.getInstance();
        try {
            String amsExpiry;
            boolean isMSSQL = CommonUtil.isMSSQL();
            String expiryDate = licManager.getLicenseProperty("UserInfo", "expiryDate");
            boolean isFreeTool = licManager.isFreeTool();
            boolean wasFreeTool = licManager.wasFreeTool();
            if (isFreeTool || wasFreeTool) {
                expiryDate = "never";
            }
            if (licManager.isFree() && !isFreeTool && !wasFreeTool) {
                licenseStatus = rb.getString("adssp.layout.component.text.license_expired_msg");
            } else if (isMSSQL && !LicenseUtil.isMSSQLSupported()) {
                licenseStatus = rb.getString("adssp.layout.component.text.license_upgrade_prof_mssql_support");
            } else if (!expiryDate.equalsIgnoreCase("never")) {
                int daysToExpire;
                JSONObject licenseDetails = com.manageengine.ads.fw.license.LicenseManager.getLicenseDetails();
                String expireInDays = licenseDetails.has("DAYS_TO_EXPIRE") ? licenseDetails.getString("DAYS_TO_EXPIRE") : null;
                int n = daysToExpire = expireInDays != null ? Integer.parseInt(expireInDays) : 0;
                if (daysToExpire > 0) {
                    if (licManager.isTrial()) {
                        licenseStatus = daysToExpire < 15 ? MessageFormat.format(rb.getString("adssp.layout.component.text.evaluation_expiry_msg"), daysToExpire) : "adssp.layout.component.text.purchase_now";
                    } else if (licManager.isRegistered() && daysToExpire < 30) {
                        licenseStatus = MessageFormat.format(rb.getString("adssp.layout.component.text.license_expiry"), daysToExpire);
                    }
                } else if (daysToExpire < 0 || LicenseUtil.getLongForPdtExpiryDate(expiryDate) < System.currentTimeMillis()) {
                    licenseStatus = rb.getString("adssp.layout.component.text.license_got_expried");
                    String licensePath = System.getProperty("server.home") + File.separator + "lib" + File.separator + "Free.xml";
                    String status = LicenseUtil.applyAdventNetLicense(request, licensePath);
                    if ("adssp.tabcomponents.license.upgraded".equals(status)) {
                        licenseStatus = rb.getString("adssp.layout.component.text.license_expired_msg");
                    }
                } else if (daysToExpire == 0) {
                    licenseStatus = rb.getString("adssp.layout.component.text.license_gonna_expire_today");
                }
            } else if (expiryDate.equalsIgnoreCase("never") && (amsExpiry = licManager.getLicenseProperty("AMS", "Expiry")) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date amsExpiryDate = sdf.parse(amsExpiry);
                Date currentDate = new Date();
                long diff = amsExpiryDate.getTime() - currentDate.getTime();
                long days = diff / 86400000L;
                if (days > 0L && days < 30L) {
                    licenseStatus = MessageFormat.format(rb.getString("adssp.layout.component.text.ams_expiry_msg"), days);
                } else if (days < 0L) {
                    licenseStatus = rb.getString("adssp.layout.component.text.ams_license_got_expried");
                } else if (days == 0L) {
                    licenseStatus = rb.getString("adssp.layout.component.text.ams_license_expires_today");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return licenseStatus;
    }

    public static String upgradeLicense(HttpServletRequest request, String licensePath) {
        String upgradeStatus = "";
        try {
            String isSMSPurchased;
            String rootElement = LicenseUtil.getDefaultRootElement(licensePath);
            upgradeStatus = rootElement.equalsIgnoreCase("SMSGateway") ? ((isSMSPurchased = LicenseManager.getInstance().getLicenseProperty("SMSGateway", "NumberOfSMS")) != null && Long.parseLong(isSMSPurchased) > 0L ? LicenseUtil.applySMSGatewayLicense(licensePath) : "adssp.tabcomponents.license.apply_default_sms_addon_license") : LicenseUtil.applyAdventNetLicense(request, licensePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return upgradeStatus;
    }

    public static String applyAdventNetLicense(HttpServletRequest request, String licensePath) {
        String upgradeStatus = "";
        String productHomeDir = System.getProperty("server.home");
        try {
            LicenseManager licMgr = LicenseManager.getInstance();
            boolean isFreeTool = licMgr.isFreeTool();
            WebLicenseUpgrade lt = new WebLicenseUpgrade(productHomeDir, "lib", licensePath);
            boolean status = lt.isValidLicense();
            if (status) {
                upgradeStatus = "adssp.tabcomponents.license.upgraded";
                System.setProperty("licenseType", Validation.getInstance().getUserType());
                request.getSession().setAttribute("licenseType", (Object)Validation.getInstance().getUserType());
                licMgr.resetValues();
                if (isFreeTool && !licMgr.isFree() && licMgr.wasFreeTool()) {
                    System.setProperty("freeTool", "false");
                    CommonUtil.writeToFile(System.getProperty("server.dir") + File.separator + "conf" + File.separator + "system_properties.conf", "freeTool", "false", false);
                }
            } else {
                upgradeStatus = "adssp.tabcomponents.license.enter_valid_license";
            }
        }
        catch (Exception e) {
            upgradeStatus = "adssp.tabcomponents.license.contact_sales";
            e.printStackTrace();
        }
        return upgradeStatus;
    }

    public static String applySMSGatewayLicense(String licensePath) {
        String upgradeStatus = "adssp.tabcomponents.license.upgraded";
        try {
            File file = new File(licensePath);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            Document doc = docBuilderFactory.newDocumentBuilder().parse(file);
            Element ele = doc.getDocumentElement();
            String smsKey = ((Element)ele.getElementsByTagName("Properties").item(0)).getAttribute("Value");
            JSONObject apiSettings = new JSONObject(EncryptDecrypt.decrypt(smsKey));
            if (!(apiSettings.isNull("PROVIDER_NAME") || apiSettings.isNull("API_TYPE") || apiSettings.isNull("API_ID") || apiSettings.isNull("USER_NAME") || apiSettings.isNull("PASSWORD") || apiSettings.isNull("ACCESS_PARAM"))) {
                Criteria c = new Criteria(Column.getColumn((String)"ADSSMSProvider", (String)"PROVIDER_NAME"), (Object)apiSettings.getString("PROVIDER_NAME"), 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSSMSProvider", c);
                if (!obj.isEmpty()) {
                    Row r = obj.getRow("ADSSMSProvider");
                    Long providerId = (Long)r.get("PROVIDER_ID");
                    apiSettings.remove("PROVIDER_NAME");
                    apiSettings.put("PROVIDER_ID", (Object)providerId);
                    JSONObject smsSettings = new JSONObject();
                    smsSettings.put("PROVIDER_ID", (Object)providerId);
                    JSONArray apiSettingsArr = new JSONArray();
                    apiSettingsArr.put((Object)apiSettings);
                    smsSettings.put("API_SETTINGS", (Object)apiSettingsArr);
                    ServerUtil.setSMSSettings(smsSettings);
                }
            } else {
                upgradeStatus = "adssp.tabcomponents.license.enter_valid_license";
            }
        }
        catch (Exception e) {
            upgradeStatus = "adssp.tabcomponents.license.contact_sales";
            e.printStackTrace();
        }
        return upgradeStatus;
    }

    public static String getDefaultRootElement(String licensePath) {
        String rootName = "";
        try {
            File file = new File(licensePath);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            Document doc = docBuilderFactory.newDocumentBuilder().parse(file);
            Element ele = doc.getDocumentElement();
            rootName = ele.getTagName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootName;
    }

    public static String storeFile(String fileName, File formFile) throws Exception {
        FileOutputStream fout = null;
        File saveFile = null;
        FileInputStream fileInput = null;
        try {
            fileInput = new FileInputStream(formFile);
            byte[] file = new byte[((InputStream)fileInput).available()];
            ((InputStream)fileInput).read(file);
            String currentPath = System.getProperty("user.dir");
            String directory = currentPath + File.separator + "license";
            File saveDir = new File(directory);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            saveFile = new File(directory + File.separator + fileName);
            fout = new FileOutputStream(saveFile);
            fout.write(file);
            fout.close();
            logger.log(Level.INFO, "The License File " + fileName + " stored successfully...");
            String string = saveFile.getAbsolutePath();
            return string;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Exception while storing the licence file under license directory ", ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while storing the licence file under license directory ", ex);
            throw ex;
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fileInput != null) {
                    ((InputStream)fileInput).close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static long getLongForPdtExpiryDate(String expiryDate) {
        long expDateInLong = -1L;
        Calendar cal = Calendar.getInstance();
        StringTokenizer st = new StringTokenizer(expiryDate, " ");
        if (st.countTokens() == 3) {
            int yyyy = Integer.parseInt(st.nextToken());
            int mm = Integer.parseInt(st.nextToken()) - 1;
            int dd = Integer.parseInt(st.nextToken());
            cal.set(yyyy, mm, dd);
            expDateInLong = cal.getTimeInMillis();
        }
        return expDateInLong;
    }

    public static Properties getProductDetails() {
        if (productDetails != null) {
            return productDetails;
        }
        productDetails = new Properties();
        try {
            String confFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "product.conf";
            File installFile = new File(confFile);
            if (installFile.exists()) {
                productDetails.load(new FileInputStream(installFile));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return productDetails;
    }

    public static boolean isPSSModulePurchased() {
        for (String components : PWD_SELF_SERVICE_COMPONENTS) {
            if (!LicenseManager.getInstance().isModuleLicensed(components)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList getPurchasedComponentReports() {
        return LicenseUtil.getPurchasedComponentItems("reports");
    }

    public static ArrayList getPurchasedComponentTileNames() {
        return LicenseUtil.getPurchasedComponentItems("tiles");
    }

    public static ArrayList getPurchasedComponentItems(String itemType) {
        ArrayList<Object> items = new ArrayList<Object>();
        try {
            ArrayList<String> compList = LicenseManager.getInstance().getPurchasedComponentsList();
            if (LicenseManager.getInstance().isFreeTool() && compList != null) {
                LicenseManager.getInstance();
                JSONObject obj = LicenseManager.componentVsTileName;
                if (itemType.equalsIgnoreCase("reports")) {
                    LicenseManager.getInstance();
                    obj = LicenseManager.componentVsReports;
                }
                for (String component : compList) {
                    Object[] tileNames = (Object[])obj.get(component);
                    if (items.isEmpty()) {
                        items = new ArrayList<Object>(Arrays.asList(tileNames));
                        continue;
                    }
                    items.addAll(Arrays.asList(tileNames));
                }
                items.addAll(Arrays.asList((Object[])obj.get("common")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return items;
    }

    public static ArrayList arrangeTabs(ArrayList<Properties> tabList) {
        ArrayList<Object> newTabList = new ArrayList();
        try {
            ArrayList<String> compList = LicenseManager.getInstance().getPurchasedComponentsList();
            if (LicenseManager.getInstance().isFreeTool() && compList != null && compList.size() == 1 && compList.get(0).equalsIgnoreCase("ExpiryNotifier")) {
                String[] tabOrder;
                block2: for (String tabName : tabOrder = new String[]{"configuration", "reports", "admin", "support"}) {
                    for (Properties tabProp : tabList) {
                        if (!tabProp.getProperty("id").equals(tabName)) continue;
                        newTabList.add(tabProp);
                        continue block2;
                    }
                }
            } else {
                newTabList = tabList;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newTabList;
    }

    public static boolean isDirUpdPurchased() {
        boolean purchased = true;
        try {
            ArrayList<String> compList = LicenseManager.getInstance().getPurchasedComponentsList();
            if (LicenseManager.getInstance().isFreeTool() && compList != null && !compList.contains("DirectoryUpdate")) {
                purchased = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return purchased;
    }

    public static void changeFeaturesStatus(String status) {
        ADSMPersUtil.updateSyMParameter("ENABLE_ALL_FEATURES", status);
        LicenseManager.getInstance().resetValues();
    }

    public static boolean isALLFeaturesEnabled() {
        boolean result = true;
        String isEnabled = ADSMPersUtil.getSyMParameter("ENABLE_ALL_FEATURES");
        if (isEnabled == null || isEnabled != null && isEnabled.equalsIgnoreCase("false")) {
            result = false;
        }
        return result;
    }

    public static boolean isAmsLicense() {
        try {
            String expiryDate;
            JSONObject licenseDetails = com.manageengine.ads.fw.license.LicenseManager.getLicenseDetails();
            String string = expiryDate = licenseDetails.has("EXPIRY_DATE") ? licenseDetails.getString("EXPIRY_DATE") : null;
            if ("never".equalsIgnoreCase(expiryDate)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static JSONObject getNotifyStatus() {
        JSONObject notifyStatus = new JSONObject();
        long pwdExpiryNotifyCount = 0L;
        boolean regNotify = false;
        boolean installServiceNotify = false;
        boolean isFreeTool = false;
        boolean notifyUsage = false;
        boolean isRegNotiTerminated = false;
        boolean isRegLater = false;
        boolean isServLater = false;
        boolean isInstalledAsService = false;
        String isRegLate = ADSMPersUtil.getSyMParameter(NOTIFY_REG_STATUS);
        String isSerLate = ADSMPersUtil.getSyMParameter(NOTIFY_SERVICE_STATUS);
        String firstLogInTime = ADSMPersUtil.getSyMParameter("FIRST_LOG_IN");
        Long days = 0L;
        if (firstLogInTime == null) {
            ADSMPersUtil.updateSyMParameter("FIRST_LOG_IN", String.valueOf(System.currentTimeMillis()));
        } else {
            Long currentTimeInMillis = System.currentTimeMillis();
            Long diffInMillis = currentTimeInMillis - Long.parseLong(firstLogInTime);
            days = diffInMillis / 86400000L;
        }
        try {
            if (days > 15L) {
                isInstalledAsService = WrapperUtil.isInstalledAsService();
                boolean bl = isFreeTool = LicenseManager.getInstance().isFreeTool() || LicenseManager.getInstance().wasFreeTool();
                if (AuditReportHandler.isAuditTableExist("SSPSTEMailAudit")) {
                    pwdExpiryNotifyCount = METrackHandler.getCount(new String[]{"ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.password_expire_notificaiton"}, "SSPSTEMailAudit");
                }
                boolean bl2 = notifyUsage = pwdExpiryNotifyCount > 50L;
                if (!isInstalledAsService) {
                    isServLater = isSerLate != null && isSerLate.equalsIgnoreCase("LATER");
                    installServiceNotify = ProductUsageMailer.isNotifyAllowed(NOTIFY_INSTALL_SERVICE, 15);
                } else {
                    regNotify = ProductUsageMailer.isNotifyAllowed(NOTIFY_ADMIN_REG, 15);
                    isRegLater = isRegLate != null && isRegLate.equalsIgnoreCase("LATER");
                }
            }
            notifyStatus.put("REG_NOTIFY", regNotify && isFreeTool && notifyUsage);
            notifyStatus.put("INS_SRV_NOTIFY", installServiceNotify && isFreeTool && !isInstalledAsService && notifyUsage);
            notifyStatus.put("IS_REG_LATER", isRegLater && notifyUsage && isFreeTool);
            notifyStatus.put("IS_SERV_LATER", isServLater && isFreeTool && !isInstalledAsService && notifyUsage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifyStatus;
    }

    public JSONArray getLicenseParamDetails(JSONObject comp) {
        JSONArray paramArray = new JSONArray();
        try {
            JSONObject paramJSON = new JSONObject();
            if (comp.has("DomainUsers") && comp.getBoolean("DomainUsers")) {
                int enrolledUsers = LicenseUtil.getUsedLicenseCount();
                paramJSON.put("USED_COUNT", enrolledUsers);
                paramJSON.put("COMPONENT", (Object)"DomainUsers");
            }
            paramArray.put((Object)paramJSON);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paramArray;
    }

    public static boolean isTrialExpired() {
        LicenseManager licManager = LicenseManager.getInstance();
        boolean isFreeTool = licManager.isFreeTool();
        boolean wasFreeTool = licManager.wasFreeTool();
        return licManager.isFree() && !isFreeTool && !wasFreeTool;
    }
}

