/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.workflow;

import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SelfServiceHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.configuration.WorkflowConfigHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.notifications.PolicyNotifications;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFConstants;
import com.adventnet.sym.adsm.common.server.workflow.interfaces.WFProvider;
import com.adventnet.sym.adsm.common.server.workflow.interfaces.WFProviderAction;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ads.fw.util.StrUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WFRequestHandler
implements WFConstants {
    private static Logger logger = Logger.getLogger("ADSLogger");

    public static void saveRequest(JSONObject request) {
        try {
            JSONObject requestDetails = request.getJSONObject("REQUEST_DETAILS");
            JSONObject inputDetails = request.has("INPUT_DETAILS") ? request.getJSONObject("INPUT_DETAILS") : null;
            Criteria criteria = requestDetails.has("UNIQUE_ID") ? new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"UNIQUE_ID"), (Object)requestDetails.getLong("UNIQUE_ID"), 0) : null;
            WritableDataObject dO = criteria == null ? new WritableDataObject() : com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("SSPWFAllRequests", criteria);
            Row row = dO.isEmpty() ? new Row("SSPWFAllRequests") : dO.getFirstRow("SSPWFAllRequests");
            List columns = row.getColumns();
            for (String col : columns) {
                if (!requestDetails.has(col)) continue;
                row.set(col, MetaDataUtil.convert((String)requestDetails.getString(col), (String)row.getColumnType(col)));
            }
            row.set("CREATED_TIME", (Object)(request.has("CREATED_TIME") ? request.getLong("CREATED_TIME") : new Date().getTime()));
            if (dO.isEmpty()) {
                dO.addRow(row);
            } else {
                dO.updateRow(row);
            }
            if (criteria == null) {
                Row inputRow = new Row("SSPWFAllRequestInputs");
                inputRow.set("UNIQUE_ID", row.get("UNIQUE_ID"));
                inputRow.set("INPUT_OBJECT", (Object)inputDetails.toString());
                dO.addRow(inputRow);
            }
            com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).update((DataObject)dO);
            requestDetails.put("UNIQUE_ID", row.get("UNIQUE_ID"));
        }
        catch (Exception ex) {
            logger.log(Level.FINE, "", ex);
        }
    }

    public static void updateRequests(JSONObject requests, Long providerActionId) {
        WFRequestHandler.updateRequests(requests, null, providerActionId);
    }

    public static void updateRequests(JSONObject requests, Long providerId, Long providerActionId) {
        JSONArray updatedRequests = new JSONArray();
        try {
            if (requests != null && requests.length() > 0 && requests.has("REQUEST_LIST")) {
                DataObject dO;
                JSONArray requestList = requests.getJSONArray("REQUEST_LIST");
                JSONObject requestMap = new JSONObject();
                JSONObject inputDetailsMap = new JSONObject();
                String[] requestIds = new String[requestList.length()];
                for (int i = 0; i < requestList.length(); ++i) {
                    JSONObject request = requestList.getJSONObject(i).getJSONObject("REQUEST_DETAILS");
                    requestIds[i] = request.getString("REQUEST_ID");
                    requestMap.put(requestIds[i], (Object)request);
                    inputDetailsMap.put(requestIds[i], (Object)requestList.getJSONObject(i).getJSONArray("TASK_DETAILS").getJSONObject(0).getJSONArray("INPUT_DETAILS"));
                }
                Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_ID"), (Object)requestIds, 8);
                if (providerActionId != null) {
                    criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"WF_PROVIDER_ACTION_ID"), (Object)providerActionId, 0);
                }
                if (!(dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("SSPWFAllRequests", criteria)).isEmpty()) {
                    Iterator rows = dO.getRows("SSPWFAllRequests");
                    while (rows.hasNext()) {
                        Row row = (Row)rows.next();
                        Long requestId = (Long)row.get("REQUEST_ID");
                        JSONObject requestDetails = (JSONObject)requestMap.remove(requestId.toString());
                        String prevReqStatus = (String)row.get("REQUEST_STATUS");
                        String requestStatus = requestDetails.getString("REQUEST_STATUS");
                        requestDetails.put("WORKFLOW_STATUS_PREVIOUS", row.get("WORKFLOW_STATUS"));
                        requestDetails.put("REQUEST_STATUS_PREVIOUS", (Object)prevReqStatus);
                        requestDetails.put("LOGIN_ID", row.get("LOGIN_ID"));
                        requestDetails.put("WF_PROVIDER_ACTION_ID", row.get("WF_PROVIDER_ACTION_ID"));
                        row.set("WORKFLOW_STATUS", (Object)requestDetails.getString("WORKFLOW_STATUS"));
                        row.set("REQUEST_STATUS", (Object)requestStatus);
                        List columns = row.getColumns();
                        for (String col : columns) {
                            if (!requestDetails.has(col)) continue;
                            row.set(col, MetaDataUtil.convert((String)requestDetails.getString(col), (String)row.getColumnType(col)));
                        }
                        dO.updateRow(row);
                        updatedRequests.put((Object)requestDetails);
                    }
                    com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).update(dO);
                    AuditAPI.updateWorkflowAudit(updatedRequests);
                    WFRequestHandler.sendWFSelfUpdateNotification(updatedRequests, inputDetailsMap);
                }
                if (requestMap.length() > 0) {
                    for (String key : JSONObject.getNames((JSONObject)requestMap)) {
                        JSONObject requestDetail = requestMap.getJSONObject(key);
                        JSONObject domainDetails = DomainHandler.getDomainDetails(requestDetail.getString("REQUESTER_DOMAIN"));
                        Long requesterId = null;
                        if (domainDetails != null && domainDetails.length() > 0) {
                            requesterId = ADMPUserHandler.getLoginId(requestDetail.getString("REQUESTER_NAME"), domainDetails.getString("DOMAIN_NAME"));
                        }
                        if (requesterId == null) continue;
                        JSONObject newRequest = new JSONObject();
                        requestDetail.put("WF_PROVIDER_ACTION_ID", (Object)(providerActionId != null ? providerActionId : WorkflowConfigHandler.getProviderActionId(providerId, requestDetail.getString("REQUEST_ACTION_TYPE"))));
                        requestDetail.put("LOGIN_ID", (Object)requesterId);
                        newRequest.put("REQUEST_DETAILS", (Object)requestDetail);
                        newRequest.put("INPUT_DETAILS", (Object)WFRequestHandler.convertInputDetails(inputDetailsMap.getJSONArray(key)));
                        WFRequestHandler.saveRequest(newRequest);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
    }

    public static int getPendingRequestCount(Long loginId, Long providerActionId) {
        try {
            DataObject dO;
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"LOGIN_ID"), (Object)loginId, 0);
            criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_STATUS"), (Object)"adssp.workflow.request_status.open", 0);
            if (providerActionId != null) {
                criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"WF_PROVIDER_ACTION_ID"), (Object)providerActionId, 0);
            }
            return (dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("SSPWFAllRequests", criteria)).isEmpty() ? 0 : dO.size("SSPWFAllRequests");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
            return 0;
        }
    }

    public static int getPendingRequestCount(Long loginId) {
        return WFRequestHandler.getPendingRequestCount(loginId, null);
    }

    public static JSONObject getAllRequests(Long loginId, Long policyId, JSONObject params, boolean deleteUnmatchedRequest) throws Exception {
        JSONObject result = null;
        JSONObject workflowConfiguration = WFRequestHandler.getWorkflowConfiguration(policyId);
        Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
        String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
        String loginName = domainDetails.getProperty("LOGIN_NAME");
        if (workflowConfiguration != null) {
            String providerClass = workflowConfiguration.getJSONArray("configurations").getJSONObject(0).getString("providerClass");
            Long providerId = workflowConfiguration.getJSONArray("configurations").getJSONObject(0).getLong("providerId");
            WFProvider workflowProvider = (WFProvider)Class.forName(providerClass).newInstance();
            params.put("userName", (Object)loginName);
            params.put("domainName", (Object)domainName);
            if (!params.has("requestAction")) {
                params.put("requestAction", (Object)"ALL");
            }
            result = workflowProvider.getAllRequests(params);
            WFRequestHandler.updateRequests(result, providerId, null);
            if (deleteUnmatchedRequest) {
                WFRequestHandler.deleteUnMatchedRequests(result, null, loginId);
            }
        }
        return result;
    }

    public static JSONObject getRequestDetails(Long loginId, Long policyId, JSONObject params) throws Exception {
        JSONObject result = null;
        JSONObject workflowConfiguration = WFRequestHandler.getWorkflowConfiguration(policyId);
        Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
        String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
        String loginName = domainDetails.getProperty("LOGIN_NAME");
        if (workflowConfiguration != null) {
            String providerClass = workflowConfiguration.getJSONArray("configurations").getJSONObject(0).getString("providerClass");
            Long providerActionId = workflowConfiguration.getJSONArray("configurations").getJSONObject(0).getLong("providerActionId");
            WFProvider workflowProvider = (WFProvider)Class.forName(providerClass).newInstance();
            params.put("userName", (Object)loginName);
            params.put("domainName", (Object)domainName);
            result = workflowProvider.getRequestDetails(params);
            if (!result.has("ERROR_CODE")) {
                WFRequestHandler.updateRequests(result, providerActionId);
            }
        }
        return result;
    }

    private static JSONObject getWorkflowConfiguration(Long policyId) {
        JSONObject workflowConfiguration = WorkflowConfigHandler.getWorkflowConfiguration(policyId, null);
        if (workflowConfiguration != null && workflowConfiguration.length() > 0 && workflowConfiguration.has("configurations")) {
            return workflowConfiguration;
        }
        return null;
    }

    public static void getAllRequestAndUpdate() {
        try {
            JSONObject policyConfigurations = WorkflowConfigHandler.getWorkflowConfiguration();
            if (policyConfigurations != null && policyConfigurations.length() > 0) {
                JSONArray policyIds = policyConfigurations.names();
                for (int i = 0; i < policyIds.length(); ++i) {
                    Long policyId = policyIds.getLong(i);
                    JSONObject policyConfig = policyConfigurations.getJSONObject(policyId.toString());
                    if (!policyConfig.has("configurations")) continue;
                    JSONArray configurations = policyConfig.getJSONArray("configurations");
                    for (int j = 0; j < configurations.length(); ++j) {
                        JSONObject config = configurations.getJSONObject(j);
                        WFProvider provider = (WFProvider)Class.forName(config.getString("providerClass")).newInstance();
                        JSONObject params = new JSONObject();
                        params.put("requestAction", (Object)config.getString("actionName"));
                        params.put("userName", (Object)"admin");
                        params.put("domainName", (Object)CommonUtil.getApplicationDomainName());
                        params.put("isProductUser", true);
                        try {
                            JSONObject requestDetails = provider.getAllRequests(params);
                            if (requestDetails == null || requestDetails.length() <= 0 || requestDetails.has("ERROR_CODE")) continue;
                            WFRequestHandler.updateRequests(requestDetails, config.getLong("providerActionId"));
                            WFRequestHandler.deleteUnMatchedRequests(requestDetails, config.getLong("providerActionId"), null);
                            continue;
                        }
                        catch (Exception e) {
                            logger.log(Level.FINE, "", e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
    }

    public static JSONObject getWorkflowRequest(Long uniqueId) {
        JSONObject result = new JSONObject();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"UNIQUE_ID"), (Object)uniqueId, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            ArrayList<String> optionalTableList = new ArrayList<String>();
            tableList.add("SSPWFAllRequests");
            tableList.add("SSPWFProviderVsActions");
            tableList.add("SSPWFRequestActions");
            tableList.add("SSPWFAllRequestInputs");
            optionalTableList.add("SSPWFAllRequestInputs");
            DataObject dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get(tableList, optionalTableList, criteria);
            Row row = dO.getFirstRow("SSPWFAllRequests");
            JSONObject requestDetails = new JSONObject();
            for (String col : row.getColumns()) {
                requestDetails.put(col, row.get(col));
            }
            Row requestActionRow = dO.getFirstRow("SSPWFRequestActions");
            requestDetails.put("REQUEST_ACTION", requestActionRow.get("WF_ACTION_NAME"));
            result.put("REQUEST_DETAILS", (Object)requestDetails);
            if (dO.containsTable("SSPWFAllRequestInputs")) {
                Row inputRow = dO.getFirstRow("SSPWFAllRequestInputs");
                result.put("INPUT_DETAILS", (Object)new JSONObject(inputRow.get("INPUT_OBJECT").toString()));
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
        return result;
    }

    private static void createWorkflowRequest(Long uniqueId) {
        JSONObject wfRequest = WFRequestHandler.getWorkflowRequest(uniqueId);
        try {
            WFProviderAction providerAction;
            JSONObject result;
            JSONObject requestDetails = wfRequest.getJSONObject("REQUEST_DETAILS");
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(requestDetails.getLong("LOGIN_ID"));
            requestDetails.put("userName", (Object)domainDetails.getProperty("LOGIN_NAME"));
            requestDetails.put("domainName", (Object)domainDetails.getProperty("LOGIN_DOMAIN_NAME"));
            requestDetails.put("locale", (Object)Locale.US);
            JSONObject providerActionDetails = WorkflowConfigHandler.getProviderActionDetails(requestDetails.getString("WF_PROVIDER_ACTION_ID"));
            if (providerActionDetails != null && (result = (providerAction = (WFProviderAction)Class.forName(providerActionDetails.getString("WF_PROVIDER_ACTION_CLASS")).newInstance()).createRequest(wfRequest)).has("REQUEST_ID")) {
                requestDetails.put("REQUEST_ID", (Object)result.getString("REQUEST_ID"));
                WFRequestHandler.saveRequest(wfRequest);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
    }

    public static void createPendingRequests() {
        WFRequestHandler.createPendingRequests(null);
    }

    public static void createPendingRequests(Long loginId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_ID"), null, 0);
            if (loginId != null) {
                criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"LOGIN_ID"), (Object)loginId, 0);
            }
            DataObject dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("SSPWFAllRequests", criteria);
            Iterator rows = dO.getRows("SSPWFAllRequests");
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                WFRequestHandler.createWorkflowRequest((Long)row.get("UNIQUE_ID"));
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
    }

    public static JSONArray getPendingRequestDetails(Long loginId, Long providerActionId) {
        JSONArray result = new JSONArray();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"LOGIN_ID"), (Object)loginId, 0);
            criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"WF_PROVIDER_ACTION_ID"), (Object)providerActionId, 0);
            criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_STATUS"), (Object)"adssp.workflow.request_status.open", 0);
            ArrayList<String> tableList = new ArrayList<String>();
            ArrayList optionalTableList = new ArrayList();
            tableList.add("SSPWFAllRequests");
            tableList.add("SSPWFAllRequestInputs");
            DataObject dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get(tableList, criteria);
            Iterator rows = dO.getRows("SSPWFAllRequests");
            while (rows.hasNext()) {
                JSONObject request = new JSONObject();
                JSONObject requestDetails = new JSONObject();
                Row requestRow = (Row)rows.next();
                for (String col : requestRow.getColumns()) {
                    requestDetails.put(col, requestRow.get(col));
                }
                request.put("REQUEST_DETAILS", (Object)requestDetails);
                Row inputRow = dO.getRow("SSPWFAllRequestInputs", new Criteria(Column.getColumn((String)"SSPWFAllRequestInputs", (String)"UNIQUE_ID"), (Object)requestDetails.getLong("UNIQUE_ID"), 0));
                request.put("INPUT_DETAILS", (Object)new JSONObject(inputRow.get("INPUT_OBJECT").toString()));
                result.put((Object)request);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
        return result;
    }

    public static void deleteUnMatchedRequests(JSONObject requests, Long providerActionId, Long loginId) {
        try {
            if (requests != null && requests.length() > 0 && requests.has("REQUEST_LIST")) {
                JSONArray requestList = requests.getJSONArray("REQUEST_LIST");
                String[] requestIds = new String[requestList.length()];
                for (int i = 0; i < requestList.length(); ++i) {
                    JSONObject request = requestList.getJSONObject(i).getJSONObject("REQUEST_DETAILS");
                    requestIds[i] = request.getString("REQUEST_ID");
                }
                Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_ID"), (Object)requestIds, 9);
                criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_ID"), null, 1);
                if (providerActionId != null) {
                    criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"WF_PROVIDER_ACTION_ID"), (Object)providerActionId, 0);
                }
                if (loginId != null) {
                    criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"LOGIN_ID"), (Object)loginId, 0);
                }
                DataObject dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("SSPWFAllRequests", criteria);
                Iterator rows = dO.getRows("SSPWFAllRequests");
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    row.set("REQUEST_STATUS", (Object)"adssp.workflow.request_status.deleted");
                    dO.updateRow(row);
                }
                com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).update(dO);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
    }

    public static void deleteAllRequests(String domainName) {
        try {
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("AaaLogin");
            tables.add("SSPWFAllRequests");
            Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0);
            criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_STATUS"), (Object)"adssp.workflow.request_status.deleted", 1);
            DataObject dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get(tables, criteria);
            Iterator rows = dO.getRows("SSPWFAllRequests");
            while (rows.hasNext()) {
                Row row = (Row)rows.next();
                row.set("REQUEST_STATUS", (Object)"adssp.workflow.request_status.deleted");
                dO.updateRow(row);
            }
            com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).update(dO);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
    }

    public static JSONObject getAllRequestsFromDB(Long loginId, JSONObject params) throws Exception {
        JSONObject result = new JSONObject();
        JSONArray requests = new JSONArray();
        int startIndex = params.getInt("startIndex");
        int toIndex = params.getInt("toIndex");
        int resultCount = 0;
        String searchFilter = params.getString("searchFilter");
        String requestAction = params.has("requestAction") ? params.getString("requestAction") : null;
        String requestId = params.has("requestId") ? params.getString("requestId") : "";
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SSPWFAllRequests"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_ID"), false));
            query.addSelectColumn(Column.getColumn((String)"SSPWFAllRequests", (String)"*"));
            query.addJoin(new Join("SSPWFAllRequests", "SSPWFProviderVsActions", new String[]{"WF_PROVIDER_ACTION_ID"}, new String[]{"WF_PROVIDER_ACTION_ID"}, 2));
            query.addJoin(new Join("SSPWFProviderVsActions", "SSPWFRequestActions", new String[]{"WF_ACTION_ID"}, new String[]{"WF_ACTION_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"LOGIN_ID"), (Object)loginId, 0);
            if (requestId != null && !requestId.equals("")) {
                Criteria requestIdCriteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"SUBJECT"), (Object)requestId, 12);
                if (requestId.matches("^[0-9]+$")) {
                    try {
                        requestIdCriteria = requestIdCriteria.or(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_ID"), (Object)Long.valueOf(requestId), 12);
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.FINE, "", nfe);
                    }
                }
                criteria = criteria.and(requestIdCriteria);
            }
            if (searchFilter != null) {
                if (searchFilter.equals("adssp.workflow.request_status.closed")) {
                    criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_STATUS"), (Object)"adssp.workflow.request_status.open", 1);
                    criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_STATUS"), (Object)"adssp.workflow.request_status.deleted", 1);
                } else if (!searchFilter.equals("ALL")) {
                    criteria = criteria.and(Column.getColumn((String)"SSPWFAllRequests", (String)"REQUEST_STATUS"), (Object)searchFilter, 0);
                }
            }
            if (requestAction != null && !requestAction.equals("ALL")) {
                criteria = criteria.and(Column.getColumn((String)"SSPWFRequestActions", (String)"WF_ACTION_NAME"), (Object)requestAction, 0);
            }
            query.setCriteria(criteria);
            DataObject dataObject = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                resultCount = dataObject.size("SSPWFAllRequests");
                Iterator requestRows = dataObject.getRows("SSPWFAllRequests");
                while (requestRows.hasNext()) {
                    JSONObject request = new JSONObject();
                    Row row = (Row)requestRows.next();
                    List cols = row.getColumns();
                    for (String col : cols) {
                        request.put(col, row.get(col));
                    }
                    requests.put((Object)request);
                }
            } else {
                resultCount = 0;
            }
            result.put("REQUEST_COUNT", resultCount);
            result.put("REQUESTS", (Object)new JSONArray());
            if (startIndex != -1 && resultCount >= toIndex) {
                for (int index = startIndex - 1; index < toIndex; ++index) {
                    result.accumulate("REQUESTS", requests.get(index));
                }
            } else {
                result.put("REQUESTS", (Object)requests);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
        return result;
    }

    public static boolean hasRequests(Long loginId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dO = com.adventnet.sym.adsm.common.server.util.CommonUtil.getPersistence(new boolean[0]).get("SSPWFAllRequests", criteria);
            return !dO.isEmpty();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
            return false;
        }
    }

    private static JSONObject convertInputDetails(JSONArray inputDetails) {
        JSONObject result = new JSONObject();
        try {
            for (int i = 0; i < inputDetails.length(); ++i) {
                JSONObject input = inputDetails.getJSONObject(i);
                result.put(input.getString("label"), (Object)input.getString("value"));
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
        return result;
    }

    public static void sendWFSelfUpdateNotification(JSONArray updatedRequests, JSONObject inputDetailsMap) {
        try {
            if (updatedRequests != null) {
                for (int i = 0; i < updatedRequests.length(); ++i) {
                    JSONObject request = updatedRequests.getJSONObject(i);
                    String previousRequestStatus = request.has("REQUEST_STATUS_PREVIOUS") ? request.getString("REQUEST_STATUS_PREVIOUS") : "";
                    String workflowStatus = request.getString("WORKFLOW_STATUS");
                    String requestStatus = request.getString("REQUEST_STATUS");
                    if (!request.getString("REQUEST_ACTION_TYPE").equals("adssp.config.admin_tools.helpdesk.action_self_update") || previousRequestStatus.equalsIgnoreCase(requestStatus)) continue;
                    Long loginId = request.getLong("LOGIN_ID");
                    Hashtable props = PolicyHandler.getProps(loginId);
                    String domainName = (String)props.get("DomainName");
                    String loginName = (String)props.get("SamAccountName");
                    props = PolicyHandler.checkPermission(domainName, loginName);
                    Long policyId = (Long)props.get("policyId");
                    String reqId = request.getString("REQUEST_ID");
                    JSONArray inpDet = inputDetailsMap.getJSONArray(reqId);
                    Long userId = SelfServiceHandler.getUserId(loginId);
                    JSONObject providerDetail = WorkflowConfigHandler.getProviderDetail(request.getString("WF_PROVIDER_ACTION_ID"));
                    String host = providerDetail != null && providerDetail.has("HOST") ? providerDetail.getString("HOST") : "";
                    JSONArray updatedAttr = new JSONArray();
                    for (int j = 0; j < inpDet.length(); ++j) {
                        JSONObject json = new JSONObject();
                        JSONObject attributeDetails = inpDet.getJSONObject(j);
                        String label = (String)attributeDetails.get("label");
                        String value = (String)attributeDetails.get("value");
                        if (label.equalsIgnoreCase("SamAccountName") && value.equalsIgnoreCase(loginName)) continue;
                        json.put("isWorkFlow", true);
                        json.put("LDAP_NAME", (Object)label);
                        json.put("VALUE", (Object)StrUtil.encodeURIComponent((String)value));
                        updatedAttr.put((Object)json);
                    }
                    if (!requestStatus.equals("adssp.workflow.request_status.closed") || !workflowStatus.equalsIgnoreCase("adssp.workflow.workflow_status.commited")) continue;
                    HashMap customDateFormat = TimeZoneUtil.getCustomDateFormat(loginId);
                    Long updatedTime = request.getLong("UPDATED_TIME");
                    String time = TimeZoneUtil.getPresentDateTime(updatedTime, customDateFormat);
                    Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
                    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                    keyPairValue.put("dateTime", time);
                    keyPairValue.put("ipAddress", " ");
                    keyPairValue.put("hostName", " ");
                    keyPairValue.put("updatedAttributes", (String)updatedAttr);
                    ArrayList<Long> nIds = new ArrayList<Long>();
                    nIds.add(new Long(15L));
                    nIds.add(new Long(16L));
                    PolicyNotifications.sendNotification(domainName, loginName, policyId, nIds, keyPairValue);
                    keyPairValue.put("actionPhrase", rb.getString("adssp.notification.actio.self_update_admin"));
                    keyPairValue.put("action", rb.getString("adssp.admin.customize.logon.drag_drop_self_upd"));
                    PolicyNotifications.sendMailToAdmin(domainName, loginName, policyId, keyPairValue);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "", e);
        }
    }
}

