/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.workflow.implementation;

import com.adventnet.sym.adsm.common.server.workflow.implementation.ADMPProvider;
import com.adventnet.sym.adsm.common.server.workflow.interfaces.WFProviderAction;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.util.CommonUtil;
import java.net.URLEncoder;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPGroupSubscription
implements WFProviderAction {
    @Override
    public JSONObject createRequest(JSONObject wfRequest) throws Exception {
        JSONObject requestStatus = new JSONObject();
        JSONObject requestDetails = wfRequest.getJSONObject("REQUEST_DETAILS");
        JSONObject inputDetails = wfRequest.getJSONObject("INPUT_DETAILS");
        JSONArray inputNames = inputDetails.names();
        Properties params = new Properties();
        if (inputDetails.has("operation") && inputDetails.getString("operation").equalsIgnoreCase("unsubscribe") || inputDetails.has("isRemoveAllGroup")) {
            params.put("REQUEST_ACTION", "REMOVE_GROUP");
        } else {
            params.put("REQUEST_ACTION", "ADD_GROUP");
        }
        params.put("IS_MULTI_VALUED", "true");
        JSONArray requestParams = new JSONArray();
        for (int i = 0; i < inputNames.length(); ++i) {
            if (inputNames.get(i).equals("operation")) continue;
            JSONObject groupParam = new JSONObject();
            groupParam.put("GROUP_NAME", (Object)inputNames.getString(i));
            groupParam.put("GROUP_SID", (Object)inputDetails.getString(inputNames.getString(i)));
            requestParams.put((Object)groupParam);
        }
        params.put("PARAMS", URLEncoder.encode(requestParams.toString()));
        params.put("userName", requestDetails.getString("userName"));
        params.put("domainName", requestDetails.getString("domainName"));
        if (requestDetails.has("locale")) {
            params.put("locale", requestDetails.getString("locale"));
        }
        params.put("subject", URLEncoder.encode(requestDetails.getString("SUBJECT")));
        params.put("description", URLEncoder.encode(requestDetails.getString("DESCRIPTION")));
        params.put("priority", requestDetails.getString("PRIORITY"));
        params.put("mode", ADMPProvider.REQUEST_MODE);
        Long productId = CommonUtil.getProductId((String)"ManageEngine ADManager Plus");
        RestAPI api = new RestAPI();
        api.execute(productId, "CREATE_WF_REQUEST", params);
        requestStatus = api.getResponseJSON();
        return requestStatus;
    }
}

