/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.workflow.implementation;

import com.adventnet.sym.adsm.common.server.workflow.WFConstants;
import com.adventnet.sym.adsm.common.server.workflow.interfaces.WFProvider;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPProvider
implements WFProvider,
WFConstants {
    private static Logger logger = Logger.getLogger("ADSLogger");
    private static String productName = "ManageEngine ADManager Plus";
    private static String[] requestStatusArray = new String[]{"adssp.workflow.request_status.open", "adssp.workflow.request_status.closed", "adssp.workflow.request_status.rejected", "adssp.workflow.request_status.cancelled"};
    private static String[] workflowStatusArray = new String[]{"adssp.workflow.workflow_status.created", "adssp.workflow.workflow_status.reviewed", "adssp.workflow.workflow_status.approved", "adssp.workflow.workflow_status.commited", "adssp.workflow.workflow_status.rejected", "adssp.workflow.workflow_status.closed", "adssp.workflow.workflow_status.cancelled"};
    private static JSONObject searchFilterMap = new JSONObject();
    private static JSONObject requestActionMap = new JSONObject();
    private static JSONObject requestActionTypeMap = new JSONObject();
    private static JSONObject requestPriorityMap = new JSONObject();
    private static JSONObject admpToSSPNames = new JSONObject();
    private static JSONObject subjectI18n = new JSONObject();
    private static JSONObject descriptionI18n = new JSONObject();
    public static final String SELF_UPDATE = "23";
    public static final String ADD_TO_GROUP = "8";
    public static final String REMOVE_FROM_GROUP = "9";
    public static final String CHANGE_PASSWORD = "6";
    public static final String RESET_PASSWORD = "4001";
    public static final String UNLOCK_ACCOUNT = "4002";
    public static final Long REQUEST_MODE = 2L;

    @Override
    public JSONObject getAllRequests(JSONObject userDetails) throws Exception {
        JSONObject result = null;
        Long productId = CommonUtil.getProductId((String)productName);
        JSONObject params = new JSONObject();
        if (userDetails.has("requestAction")) {
            params.put("requestActions", (Object)requestActionMap.getJSONArray(userDetails.getString("requestAction")));
        } else {
            params.put("requestActions", (Object)requestActionMap.getJSONArray("ALL"));
        }
        params.put("startIndex", userDetails.has("startIndex") ? userDetails.getInt("startIndex") : -1);
        params.put("toIndex", userDetails.has("toIndex") ? userDetails.getInt("toIndex") : 25);
        if (userDetails.has("searchFilter")) {
            if (searchFilterMap.has(userDetails.getString("searchFilter"))) {
                params.put("searchFilter", (Object)searchFilterMap.getString(userDetails.getString("searchFilter")));
            } else {
                params.put("searchFilter", 0);
            }
        } else {
            params.put("searchFilter", 0);
        }
        params.put("requestId", (Object)(userDetails.has("requestId") ? userDetails.getString("requestId") : ""));
        params.put("mode", (Object)REQUEST_MODE);
        Properties requestParams = new Properties();
        if (userDetails.has("userName")) {
            requestParams.put("userName", userDetails.getString("userName"));
        }
        if (userDetails.has("domainName")) {
            requestParams.put("domainName", userDetails.getString("domainName"));
        }
        if (userDetails.has("isProductUser")) {
            requestParams.put("isProductUser", userDetails.getString("isProductUser"));
        }
        if (userDetails.has("locale")) {
            requestParams.put("locale", userDetails.getString("locale"));
        }
        requestParams.put("PARAMS", params.toString());
        RestAPI api = new RestAPI();
        api.execute(productId, "GET_ALL_WF_REQUESTS", requestParams);
        JSONObject responseJSON = api.getResponseJSON();
        result = responseJSON.has("ERROR_CODE") ? responseJSON : this.convertToSSPRequests(responseJSON);
        return result;
    }

    @Override
    public JSONObject getRequestDetails(JSONObject details) throws Exception {
        JSONObject result = null;
        Long productId = CommonUtil.getProductId((String)productName);
        Properties params = new Properties();
        params.put("REQUEST_ID", details.getString("REQUEST_ID"));
        params.put("mode", REQUEST_MODE);
        if (details.has("locale")) {
            params.put("locale", details.getString("locale"));
        }
        RestAPI api = new RestAPI();
        api.execute(productId, "GET_WF_REQ_DETAILS", params);
        JSONObject responseJSON = api.getResponseJSON();
        result = responseJSON.has("ERROR_CODE") ? responseJSON : this.convertToSSPRequest(responseJSON);
        return result;
    }

    private JSONObject convertToSSPRequests(JSONObject requests) {
        JSONObject result = new JSONObject();
        try {
            if (requests != null && requests.length() > 0) {
                JSONArray requestList = requests.getJSONArray("REQUEST_LIST");
                JSONArray sspRequestList = new JSONArray();
                for (int i = 0; i < requestList.length(); ++i) {
                    JSONObject request = requestList.getJSONObject(i);
                    sspRequestList.put((Object)this.convertToSSPRequest(request));
                }
                result.put("REQUEST_LIST", (Object)sspRequestList);
                result.put("REQUEST_COUNT", requests.getLong("REQUEST_COUNT"));
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
        return result;
    }

    private JSONObject convertToSSPRequest(JSONObject request) {
        JSONObject result = new JSONObject();
        String actionId = "";
        try {
            if (request.length() > 0) {
                if (request.has("TASK_DETAILS")) {
                    result.put("TASK_DETAILS", (Object)request.getJSONArray("TASK_DETAILS"));
                }
                result.put("HISTORY_DETAILS", request.has("HISTORY_DETAILS") ? request.getJSONArray("HISTORY_DETAILS") : null);
                JSONObject requestDetail = request.getJSONObject("REQUEST_DETAILS");
                JSONObject sspRequestDetail = new JSONObject();
                JSONArray names = requestDetail.names();
                if (!requestDetail.has("LOGIN_ID")) {
                    sspRequestDetail.put(admpToSSPNames.getString("LOGIN_ID"), (Object)"-");
                }
                for (int j = 0; j < names.length(); ++j) {
                    String name = names.getString(j);
                    if (name.equalsIgnoreCase("STATUS")) {
                        sspRequestDetail.put(admpToSSPNames.getString(name), (Object)requestStatusArray[requestDetail.getInt(name) - 1]);
                        continue;
                    }
                    if (name.equalsIgnoreCase("WORKFLOW_STATUS")) {
                        sspRequestDetail.put(admpToSSPNames.getString(name), (Object)workflowStatusArray[requestDetail.getInt(name) - 1]);
                        continue;
                    }
                    if (name.equalsIgnoreCase("PRIORITY")) {
                        sspRequestDetail.put(admpToSSPNames.getString(name), (Object)requestPriorityMap.getString(requestDetail.getString(name)));
                        continue;
                    }
                    if (name.equalsIgnoreCase("REQUEST_ACTION_ID")) {
                        actionId = requestDetail.getString(name);
                        sspRequestDetail.put(admpToSSPNames.getString(name), (Object)requestActionTypeMap.getString(actionId));
                        continue;
                    }
                    if (name.equalsIgnoreCase("LOGIN_ID")) {
                        String assignedTo = "-";
                        if (requestDetail.get(name) != JSONObject.NULL) {
                            String temp = requestDetail.getString(name);
                            JSONArray assignedArray = new JSONArray();
                            temp = temp.substring(1, temp.length() - 1);
                            String[] str = temp.split("},");
                            for (int k = 0; k < str.length; ++k) {
                                String value = str[k].trim();
                                value = k != str.length - 1 ? value.substring(1, value.length()) : value.substring(1, value.length() - 1);
                                String[] keyValuePairs = value.split(",");
                                JSONObject json = new JSONObject();
                                for (String pair : keyValuePairs) {
                                    String[] entry = pair.split("=");
                                    json.put(entry[0].trim(), (Object)entry[1].trim());
                                }
                                assignedArray.put((Object)json);
                            }
                            for (int i = 0; i < assignedArray.length(); ++i) {
                                assignedTo = i == 0 ? assignedArray.getJSONObject(i).getString("fullName") : assignedTo + ", " + assignedArray.getJSONObject(i).getString("fullName");
                            }
                        }
                        sspRequestDetail.put(admpToSSPNames.getString(name), (Object)assignedTo);
                        continue;
                    }
                    if (!admpToSSPNames.has(name)) continue;
                    sspRequestDetail.put(admpToSSPNames.getString(name), (Object)requestDetail.getString(name));
                }
                sspRequestDetail.put("SUBJECT", (Object)subjectI18n.getString(actionId));
                sspRequestDetail.put("DESCRIPTION", (Object)descriptionI18n.getString(actionId));
                result.put("REQUEST_DETAILS", (Object)sspRequestDetail);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "", e);
        }
        return result;
    }

    @Override
    public JSONArray getConfiguredDomains() throws Exception {
        Long productId = CommonUtil.getProductId((String)productName);
        RestAPI api = new RestAPI();
        api.execute(productId, "GET_WF_CONFIGURED_DOMAINS");
        return new JSONArray(api.getResponseText());
    }

    static {
        try {
            searchFilterMap.put("ALL_REQUESTS", 0);
            searchFilterMap.put("MY_REQUESTS", 1);
            searchFilterMap.put("MY_OPEN_REQUESTS", 2);
            searchFilterMap.put("MY_CLOSED_REQUESTS", 3);
            searchFilterMap.put("MY_AWAITING_EXECUTION", 6);
            searchFilterMap.put("MY_REJECTED_REQUESTS", 7);
            requestActionMap.put("ALL", (Object)new JSONArray((Object)new Long[]{23L, 8L, 9L, 6L, 4001L, 4002L}));
            requestActionMap.put("adssp.config.admin_tools.helpdesk.action_self_update", (Object)new JSONArray((Object)new Long[]{23L}));
            requestActionMap.put("adssp.config.admin_tools.helpdesk.action_grp_subscription", (Object)new JSONArray((Object)new Long[]{8L, 9L}));
            requestActionMap.put("adssp.config.admin_tools.helpdesk.action_change_pwd", (Object)new JSONArray((Object)new Long[]{6L}));
            requestActionMap.put("adssp.config.admin_tools.helpdesk.action_reset_pwd", (Object)new JSONArray((Object)new Long[]{4001L}));
            requestActionMap.put("adssp.config.admin_tools.helpdesk.action_unlock_account", (Object)new JSONArray((Object)new Long[]{4002L}));
            requestActionTypeMap.put(SELF_UPDATE, (Object)"adssp.config.admin_tools.helpdesk.action_self_update");
            requestActionTypeMap.put(ADD_TO_GROUP, (Object)"adssp.config.admin_tools.helpdesk.action_grp_subscription");
            requestActionTypeMap.put(REMOVE_FROM_GROUP, (Object)"adssp.config.admin_tools.helpdesk.action_grp_subscription");
            requestActionTypeMap.put(CHANGE_PASSWORD, (Object)"adssp.config.admin_tools.helpdesk.action_change_pwd");
            requestActionTypeMap.put(RESET_PASSWORD, (Object)"adssp.config.admin_tools.helpdesk.action_reset_pwd");
            requestActionTypeMap.put(UNLOCK_ACCOUNT, (Object)"adssp.config.admin_tools.helpdesk.action_unlock_account");
            requestPriorityMap.put("1", (Object)"adssp.workflow.request_priority.normal");
            requestPriorityMap.put("2", (Object)"adssp.workflow.request_priority.high");
            requestPriorityMap.put("3", (Object)"adssp.workflow.request_priority.medium");
            requestPriorityMap.put("4", (Object)"adssp.workflow.request_priority.low");
            admpToSSPNames.put("REQUEST_ID", (Object)"REQUEST_ID");
            admpToSSPNames.put("SUBJECT", (Object)"SUBJECT");
            admpToSSPNames.put("WORKFLOW_STATUS", (Object)"WORKFLOW_STATUS");
            admpToSSPNames.put("REQUESTER_NAME", (Object)"CREATED_BY");
            admpToSSPNames.put("LOGIN_ID", (Object)"ASSIGNED_TO");
            admpToSSPNames.put("MODIFIED_TIME", (Object)"UPDATED_TIME");
            admpToSSPNames.put("STATUS", (Object)"REQUEST_STATUS");
            admpToSSPNames.put("CREATION_TIME", (Object)"CREATED_TIME");
            admpToSSPNames.put("COMPLETED_TIME", (Object)"COMPLETED_DT");
            admpToSSPNames.put("MODIFIED_TIME", (Object)"UPDATED_TIME");
            admpToSSPNames.put("REQUEST_ACTION", (Object)"REQUEST_ACTION");
            admpToSSPNames.put("PRIORITY", (Object)"PRIORITY");
            admpToSSPNames.put("DESCRIPTION", (Object)"DESCRIPTION");
            admpToSSPNames.put("REQUEST_ACTION_ID", (Object)"REQUEST_ACTION_TYPE");
            admpToSSPNames.put("FULL_NAME", (Object)"REQUESTER_NAME");
            admpToSSPNames.put("DOMAINNAME", (Object)"REQUESTER_DOMAIN");
            subjectI18n.put(SELF_UPDATE, (Object)"adssp.workflow.modifyUser.subject");
            subjectI18n.put(ADD_TO_GROUP, (Object)"adssp.workflow.addToGroup.subject");
            subjectI18n.put(REMOVE_FROM_GROUP, (Object)"adssp.workflow.removeFromGroup.subject");
            subjectI18n.put(CHANGE_PASSWORD, (Object)"adssp.config.admin_tools.helpdesk.action_change_pwd");
            subjectI18n.put(RESET_PASSWORD, (Object)"adssp.workflow.resetPassword.subject");
            subjectI18n.put(UNLOCK_ACCOUNT, (Object)"adssp.workflow.unlockAccount.subject");
            descriptionI18n.put(SELF_UPDATE, (Object)"adssp.workflow.modifyUser.description");
            descriptionI18n.put(ADD_TO_GROUP, (Object)"adssp.workflow.addToGroup.description");
            descriptionI18n.put(REMOVE_FROM_GROUP, (Object)"adssp.workflow.removeFromGroup.description");
            descriptionI18n.put(CHANGE_PASSWORD, (Object)"adssp.config.admin_tools.helpdesk.action_change_pwd");
            descriptionI18n.put(RESET_PASSWORD, (Object)"adssp.workflow.resetPassword.description");
            descriptionI18n.put(UNLOCK_ACCOUNT, (Object)"adssp.workflow.unlockAccount.description");
        }
        catch (Exception e) {
            logger.log(Level.FINE, "", e);
        }
    }
}

