/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.server;

import com.adventnet.sym.adsm.security.server.ADMPResolver;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ServerConfig {
    private static Logger out = Logger.getLogger(ServerConfig.class.getName());

    private static void addValve(String filePath, String webPath) {
        try {
            DocumentBuilder rBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            rBuilder.setEntityResolver(new ADMPResolver(webPath));
            Document rDocument = rBuilder.parse(new File(filePath));
            boolean valveRedirectExistence = false;
            int valveCount = 0;
            boolean valveNtlmExistence = false;
            NodeList valveList = rDocument.getElementsByTagName("Valve");
            for (int l = 0; l < valveList.getLength(); ++l) {
                Node valveNode = valveList.item(l);
                String valveNodeValue = ((Element)valveNode).getAttribute("className");
                if (valveNodeValue != null && valveNodeValue.equalsIgnoreCase("com.adventnet.sym.adsm.common.server.RedirectValve")) {
                    valveRedirectExistence = true;
                    ++valveCount;
                    continue;
                }
                if (valveNodeValue == null || !valveNodeValue.equalsIgnoreCase("com.adventnet.sym.adsm.common.server.admin.authentication.AuthenticateNtlm")) continue;
                valveNtlmExistence = true;
                ServerConfig.removeValve(filePath, webPath, "com.adventnet.sym.adsm.common.server.admin.authentication.AuthenticateNtlm");
            }
            if (valveRedirectExistence) {
                out.log(Level.INFO, "Redirect Valve exists for " + valveCount + " times......  Hence removing overexistence...");
                while (valveCount > 0) {
                    ServerConfig.removeValve(filePath, webPath, "com.adventnet.sym.adsm.common.server.RedirectValve");
                    --valveCount;
                }
            }
            out.log(Level.INFO, "Add Valve starts");
            String fileName = filePath;
            Element rootElement = null;
            File logFile = new File(filePath);
            out.log(Level.INFO, "logFileName:   " + logFile.getName());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ADMPResolver(webPath));
            Document document = builder.parse(logFile);
            rootElement = document.getDocumentElement();
            out.log(Level.INFO, " RootElementName:" + rootElement.getTagName());
            NodeList childNodelist1 = rootElement.getChildNodes();
            int childNodelistLength1 = childNodelist1.getLength();
            for (int i = 0; i < childNodelistLength1; ++i) {
                Node childNode2 = childNodelist1.item(i);
                String childNodeName2 = childNode2.getNodeName();
                if (!childNodeName2.equalsIgnoreCase("Service")) continue;
                NodeList subChildNodelist1 = ((Element)childNode2).getElementsByTagName("Engine");
                int subChildNodelistlength1 = subChildNodelist1.getLength();
                for (int j = 0; j < subChildNodelistlength1; ++j) {
                    Node subChildNode2 = subChildNodelist1.item(j);
                    String subChildNodeName2 = subChildNode2.getNodeName();
                    if (!subChildNodeName2.equalsIgnoreCase("Engine")) continue;
                    NodeList grandChildNodelist1 = ((Element)subChildNode2).getElementsByTagName("Host");
                    int grandChildNodelistlength1 = grandChildNodelist1.getLength();
                    for (int k = 0; k < grandChildNodelistlength1; ++k) {
                        Node grandChildNode2 = grandChildNodelist1.item(j);
                        String grandChildNodeName2 = grandChildNode2.getNodeName();
                        if (!grandChildNodeName2.equalsIgnoreCase("Host")) continue;
                        grandChildNode2.normalize();
                        Element Connection2 = document.createElement("Valve");
                        Connection2.setAttribute("className", "com.adventnet.sym.adsm.common.server.RedirectValve");
                        Connection2.setAttribute("debug", "0");
                        grandChildNode2.appendChild(Connection2);
                        ADSMPersUtil.writeToFile2(rootElement, fileName);
                    }
                }
            }
            out.log(Level.INFO, "Add Valve finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void removeValve(String filePath, String webPath, String nodeValue) {
        try {
            out.log(Level.INFO, "Remove Valve starts");
            String fileName = filePath;
            Element rootElement = null;
            File logFile = new File(filePath);
            out.log(Level.INFO, "logFileName:   " + logFile.getName());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ADMPResolver(webPath));
            Document document = builder.parse(logFile);
            rootElement = document.getDocumentElement();
            out.log(Level.INFO, " RootElementName:" + rootElement.getTagName());
            NodeList childNodelist1 = rootElement.getChildNodes();
            int childNodelistLength1 = childNodelist1.getLength();
            for (int i = 0; i < childNodelistLength1; ++i) {
                Node childNode2 = childNodelist1.item(i);
                String childNodeName2 = childNode2.getNodeName();
                if (!childNodeName2.equalsIgnoreCase("Service")) continue;
                NodeList subChildNodelist1 = ((Element)childNode2).getElementsByTagName("Engine");
                int subChildNodelistlength1 = subChildNodelist1.getLength();
                for (int j = 0; j < subChildNodelistlength1; ++j) {
                    Node subChildNode2 = subChildNodelist1.item(j);
                    String subChildNodeName2 = subChildNode2.getNodeName();
                    if (!subChildNodeName2.equalsIgnoreCase("Engine")) continue;
                    NodeList grandChildNodelist1 = ((Element)subChildNode2).getElementsByTagName("Host");
                    int grandChildNodelistlength1 = grandChildNodelist1.getLength();
                    for (int k = 0; k < grandChildNodelistlength1; ++k) {
                        Node grandChildNode2 = grandChildNodelist1.item(j);
                        String grandChildNodeName2 = grandChildNode2.getNodeName();
                        if (!grandChildNodeName2.equalsIgnoreCase("Host")) continue;
                        NodeList valveList = ((Element)grandChildNode2).getElementsByTagName("Valve");
                        for (int l = 0; l < valveList.getLength(); ++l) {
                            Node valveNode = valveList.item(l);
                            String valveNodeValue = ((Element)valveNode).getAttribute("className");
                            if (!valveNodeValue.equalsIgnoreCase(nodeValue)) continue;
                            out.log(Level.INFO, "Removing the valve ::::" + nodeValue);
                            Node removeValve = grandChildNode2.removeChild(valveNode);
                            ADSMPersUtil.writeToFile2(rootElement, fileName);
                            out.log(Level.INFO, "Remove Valve finished");
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addValve() {
        ServerConfig.addValve("conf\\server.xml", "conf\\web.dtd");
    }

    public static void setSessionTime(int t) {
        Integer time = new Integer(t);
        String Time2 = time.toString();
        String server_Home = System.getProperty("server.home");
        try {
            String fileName = server_Home + File.separator + "conf" + File.separator + "web.xml";
            File file = new File(fileName);
            String webPath = server_Home + File.separator + "conf" + File.separator + "web.dtd";
            if (file.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                builder.setEntityResolver(new ADMPResolver(webPath));
                Document doc = builder.parse(file);
                Element docelement = doc.getDocumentElement();
                NodeList sessionList = doc.getElementsByTagName("session-config");
                Element element = (Element)sessionList.item(0);
                Node firstSessionNode = sessionList.item(0);
                NodeList firstSessionNodeList = firstSessionNode.getChildNodes();
                Node childnode = firstSessionNodeList.item(1);
                Node subchildname = childnode.getFirstChild();
                String nodevalue = subchildname.getNodeValue();
                subchildname.setNodeValue(Time2);
                TransformerFactory tranFact = TransformerFactory.newInstance();
                Transformer transfor = tranFact.newTransformer();
                DOMSource src = new DOMSource(doc);
                StreamResult dest = new StreamResult(new File(fileName));
                transfor.transform(src, dest);
            } else {
                System.out.println("File Not Found!");
            }
        }
        catch (Exception e) {
            System.out.println("Exception Thrown:" + e);
        }
    }

    public static void addSecurityConstraint(String filePath, String webPath, String transportMode) {
        try {
            out.log(Level.INFO, "Add SEC CONS starts");
            String fileName = filePath;
            Element rootElement = null;
            File logFile = new File(filePath);
            out.log(Level.INFO, "logFileName:   " + logFile.getName());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new ADMPResolver(webPath));
            Document document = builder.parse(logFile);
            rootElement = document.getDocumentElement();
            out.log(Level.INFO, " RootElementName:" + rootElement.getTagName());
            Element secConstraint = document.createElement("security-constraint");
            Element webResource = document.createElement("web-resource-collection");
            Element resourceName = document.createElement("web-resource-name");
            Element urlPattern = document.createElement("url-pattern");
            Text resText = document.createTextNode("UnSecured Core Context");
            Text urlText = document.createTextNode("*.cc");
            resourceName.appendChild(resText);
            urlPattern.appendChild(urlText);
            webResource.appendChild(resourceName);
            webResource.appendChild(urlPattern);
            Element userData = document.createElement("user-data-constraint");
            Element transport = document.createElement("transport-guarantee");
            Text transprtText = document.createTextNode(transportMode);
            transport.appendChild(transprtText);
            userData.appendChild(transport);
            secConstraint.appendChild(userData);
            secConstraint.appendChild(webResource);
            rootElement.appendChild(secConstraint);
            ADSMPersUtil.writeToFile2(rootElement, fileName);
            out.log(Level.INFO, "Add Security Constraint finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setConnectionTimeOut(String fileName, String timeOut) {
        out.log(Level.INFO, "setConnectionTimeOut starts");
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            File portFile = new File(fileName);
            Document document = factory.newDocumentBuilder().parse(portFile);
            Element rootElement = document.getDocumentElement();
            NodeList nlist = rootElement.getElementsByTagName("Service");
            for (int j = 0; j < nlist.getLength(); ++j) {
                Node nl = nlist.item(j);
                NodeList clist = ((Element)nl).getElementsByTagName("Connector");
                for (int k = 0; k < clist.getLength(); ++k) {
                    Node cl = clist.item(k);
                    String nodeName = ((Element)cl).getAttribute("name");
                    if (!nodeName.equalsIgnoreCase("SSL")) continue;
                    String portValue = ((Element)cl).getAttribute("connectionTimeout");
                    out.log(Level.INFO, "Setting connection timeout " + timeOut);
                    ((Element)cl).setAttribute("connectionTimeout", timeOut);
                    ADSMPersUtil.writeToFile2(rootElement, fileName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

