/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.mickey.installutils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortCheckerUtil {
    private static final Logger LOGGER = Logger.getLogger(PortCheckerUtil.class.getName());
    Element rootElement = null;
    String fileName = null;
    private static PortCheckerUtil pcUtil = null;
    private static final String WEB_SERVICE_NAME = "Catalina";
    public static final int NO_PROBLEM = 0;
    public static final int PORT_OCCUPIED_BY_OTHERS = 1;
    public static final int PORT_OCCUPIED_BY_PRODUCT = 2;
    public static final int PORT_OUT_OF_RANGE = 3;
    private static Vector productPorts = new Vector();

    public static PortCheckerUtil getInstance() {
        if (pcUtil == null) {
            pcUtil = new PortCheckerUtil();
        }
        return pcUtil;
    }

    public void parseXml(String filePath) {
        try {
            this.fileName = filePath;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            File portFile = new File(filePath);
            Document document = factory.newDocumentBuilder().parse(portFile);
            this.rootElement = document.getDocumentElement();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, " Error reading/parsing file {0}", filePath);
        }
    }

    public int getPort(String serviceName) {
        if (this.rootElement == null) {
            return -1;
        }
        NodeList nlist = this.rootElement.getElementsByTagName("Service");
        for (int j = 0; j < nlist.getLength(); ++j) {
            Node nl = nlist.item(j);
            String nodeName = ((Element)nl).getAttribute("name");
            if (!nodeName.equalsIgnoreCase(serviceName)) continue;
            NodeList portList = ((Element)nl).getElementsByTagName("Connector");
            Element portElement = (Element)portList.item(0);
            String portValue = portElement.getAttribute("port");
            return Integer.parseInt(portValue);
        }
        return -1;
    }

    public boolean getType(String serviceName) {
        if (this.rootElement == null) {
            return true;
        }
        NodeList nlist = this.rootElement.getElementsByTagName("Service");
        for (int j = 0; j < nlist.getLength(); ++j) {
            Node nl = nlist.item(j);
            String nodeName = ((Element)nl).getAttribute("name");
            if (!nodeName.equalsIgnoreCase(serviceName)) continue;
            String type = ((Element)nl).getAttribute("type");
            LOGGER.log(Level.FINER, "Type<->{0}", type);
            return type == null || type.equals("") || type.equals("tcp");
        }
        return true;
    }

    public boolean changePort(Properties p) {
        boolean result = false;
        NodeList nlist = this.rootElement.getElementsByTagName("Service");
        for (int j = 0; j < nlist.getLength(); ++j) {
            Node nl = nlist.item(j);
            String nodeName = ((Element)nl).getAttribute("name");
            if (p.getProperty(nodeName) == null) continue;
            NodeList portList = ((Element)nl).getElementsByTagName("Connector");
            Element portElement = (Element)portList.item(0);
            String portValue = portElement.getAttribute("port");
            String newWebPort = p.getProperty(nodeName);
            if (newWebPort == null) continue;
            portElement.setAttribute("port", newWebPort);
            result = true;
        }
        if (result) {
            this.writeToFile();
        }
        return result;
    }

    public boolean checkPortAvailability(int portNum, boolean tcp) {
        LOGGER.log(Level.FINER, "Port Num<->{0}<->{1}", new Object[]{new Integer(portNum), tcp});
        if (portNum < 0) {
            return false;
        }
        try {
            if (tcp) {
                ServerSocket sock = new ServerSocket(portNum);
                sock.close();
            } else {
                DatagramSocket ds = new DatagramSocket(portNum);
                ds.close();
            }
            return true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINER, "Port {0} occupied", new Integer(portNum));
            return false;
        }
    }

    private void writeToFile() {
        try {
            TransformerFactory fac = TransformerFactory.newInstance();
            Transformer trans = fac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(this.rootElement);
            FileWriter writer = new FileWriter(new File(this.fileName));
            StreamResult streamResult = new StreamResult(writer);
            trans.transform(domSource, streamResult);
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            System.err.println("Exception while writing file " + ex);
            ex.printStackTrace();
        }
    }

    public static void usage() {
        LOGGER.log(Level.FINER, "USAGE: PortCheckerUtil -r <samplebindingshome> [<servicename1> <servicename2>...]+ ");
        LOGGER.log(Level.FINER, "USAGE: PortCheckerUtil -i <samplebindingshome> [<servicename>=<portno> <servicename>=<portno>]+ ");
        System.exit(1);
    }

    public static void main(String arg1, String arg2, String arg3) {
        String[] args = new String[]{arg1, arg2, arg3};
        PortCheckerUtil.main(args);
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            PortCheckerUtil.usage();
        }
        if ("-r".equals(args[0])) {
            pcUtil = PortCheckerUtil.getInstance();
            pcUtil.parseXml(args[1]);
            Properties p = new Properties();
            for (int i = 2; i < args.length; ++i) {
                String APP_NAME = args[i];
                boolean available = true;
                if (pcUtil.checkPortAvailability(pcUtil.getPort(APP_NAME), pcUtil.getType(APP_NAME))) continue;
                available = false;
                String newPort = pcUtil.getUserInputPort(APP_NAME, false);
                if (newPort == null) continue;
                System.out.println("WebServer port has been updated successfully\n");
                p.setProperty(APP_NAME, newPort);
            }
            if (p.size() > 0) {
                boolean result = pcUtil.changePort(p);
                if (result) {
                    LOGGER.log(Level.FINER, "The ports were occupied initially. It is possible that another instance of server is already running");
                    System.exit(0);
                }
                System.exit(1);
            }
            System.exit(0);
        } else if ("-i".equals(args[0]) && args.length > 2) {
            pcUtil = PortCheckerUtil.getInstance();
            pcUtil.parseXml(args[1]);
            Properties p = new Properties();
            for (int i = 2; i < args.length; ++i) {
                int j = args[i].lastIndexOf("=");
                String key = args[i].substring(0, j);
                String value = args[i].substring(j + 1);
                try {
                    int port = Integer.parseInt(value);
                    p.setProperty(key, value);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.FINER, "Non integer port was provided.Quitting.");
                    System.exit(0);
                }
            }
            boolean result = pcUtil.changePort(p);
            if (result) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        } else {
            PortCheckerUtil.usage();
        }
    }

    public static int isPortUsable(String portNumber, String t) {
        try {
            boolean tcp = Boolean.parseBoolean(t);
            int port = Integer.parseInt(portNumber);
            if (port > 65535) {
                return 3;
            }
            Iterator i = productPorts.iterator();
            while (i.hasNext()) {
                int usedPort = (Integer)i.next();
                if (port != usedPort) continue;
                return 2;
            }
            pcUtil = PortCheckerUtil.getInstance();
            if (pcUtil.checkPortAvailability(port, tcp)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static void addToDefaultPortsUsed(int port) {
        productPorts.add(new Integer(port));
    }

    public static int getWebServerPort(String sampleBindingPath) {
        pcUtil = PortCheckerUtil.getInstance();
        pcUtil.parseXml(sampleBindingPath);
        return pcUtil.getPort(WEB_SERVICE_NAME);
    }

    private String getUserInputPort(String str, boolean tcp) {
        String input = null;
        String portVal = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (true) {
                pcUtil = PortCheckerUtil.getInstance();
                int oldWebServerPort = pcUtil.getPort(WEB_SERVICE_NAME);
                System.out.println("WebServer Port[" + oldWebServerPort + "] has been occupied by some other applications\n");
                System.out.print("Do you want to change the port ? Enter y/n ");
                input = in.readLine();
                if ("n".equals(input)) {
                    System.exit(1);
                    break;
                }
                if (!"y".equals(input)) continue;
                System.out.print("\nEnter the Port : ");
                LOGGER.log(Level.FINER, "Enter the {0} port", str);
                portVal = in.readLine();
                if (portVal == null) continue;
                int port = -1;
                try {
                    port = Integer.parseInt(portVal);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.FINER, "A non integer port was given.");
                    portVal = null;
                }
                if (pcUtil.checkPortAvailability(port, tcp)) break;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, " Error reading input");
            System.exit(1);
        }
        if (portVal == null) {
            System.exit(1);
        }
        return portVal;
    }
}

