/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.logging.Logger;

public class AS400LogArchiver {
    private static final Logger LOGGER = Logger.getLogger(AS400LogArchiver.class.getName());
    private String as400HostName = null;
    private String currentFileName = null;
    private String currentFileExtension = null;
    private boolean isNewEncryptedFile = false;
    private static boolean fetchVariables = true;
    private static boolean isEncryptionEnabled = false;
    private static String archiveLocation = System.getProperty("server.home") + File.separator + "archive";
    private static long fileCreationInterval = 43200000L;
    private static SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private FileWriter archiveFileWriter = null;
    private PrintWriter archivePrintWriter = null;
    private String encAlgo = System.getProperty("AESBIT", "128");
    private static int noOfTries = 1;
    private AbstractEncryptionHandler encryptionObj = null;

    public static AS400LogArchiver getInstance() {
        return new AS400LogArchiver();
    }

    public void initialize(String hostName) {
        LOGGER.info("Initializing AS400 Log Archiving for <-> " + hostName);
        this.as400HostName = hostName;
        this.setArchiveVariables();
        this.manageArchiveDirectory();
        this.manageArchiveFile();
    }

    private void initialize() {
        this.initialize(this.as400HostName);
    }

    private void setArchiveVariables() {
        LOGGER.fine("Need the fetch from database <-> " + fetchVariables);
        if (!fetchVariables) {
            return;
        }
        try {
            DataObject sysConfigDO = DataAccess.get((String)"SystemConfigurations", (Criteria)null);
            Iterator sysConfigItr = sysConfigDO.getRows("SystemConfigurations");
            while (sysConfigItr.hasNext()) {
                Row sysConfigRow = (Row)sysConfigItr.next();
                if ("sysArchiveLocation".equals((String)sysConfigRow.get("CONF_NAME"))) {
                    String sysArchiveLocation = (String)sysConfigRow.get("CONF_VALUE");
                    if ("archive".equals(sysArchiveLocation)) continue;
                    archiveLocation = sysArchiveLocation;
                    continue;
                }
                if ("sysFileCreationInterval".equals((String)sysConfigRow.get("CONF_NAME"))) {
                    fileCreationInterval = Long.parseLong((String)sysConfigRow.get("CONF_VALUE"));
                    continue;
                }
                if (!"sysEnableArchiveEncrypt".equals((String)sysConfigRow.get("CONF_NAME"))) continue;
                isEncryptionEnabled = Boolean.parseBoolean((String)sysConfigRow.get("CONF_VALUE"));
            }
            LOGGER.fine("ArchiveLocation <-> " + archiveLocation + " FileCreationInterval <-> " + fileCreationInterval + " Enable Encryption <-> " + isEncryptionEnabled);
            fetchVariables = false;
        }
        catch (Exception e) {
            LOGGER.info("Exception while setting SystemConfigurations variables ::::: " + e);
            e.printStackTrace();
        }
    }

    private void manageArchiveDirectory() {
        try {
            File archiveDir = new File(archiveLocation + File.separator + this.as400HostName);
            if (!archiveDir.exists()) {
                archiveDir.mkdirs();
                LOGGER.info("Archive directory created for <-> " + this.as400HostName);
            } else {
                LOGGER.info("Archive directory already exists for <-> " + this.as400HostName);
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception while creating archive directory ::::: " + e);
            e.printStackTrace();
        }
    }

    private void manageArchiveFile() {
        try {
            this.getLastModifiedFile();
            File currentFile = new File(archiveLocation + File.separator + this.as400HostName + File.separator + this.currentFileName);
            if (!currentFile.exists()) {
                LOGGER.info("File doesn't exists creating new file");
                this.createArchiveFile();
            } else {
                String[] currentFileTime = this.currentFileName.split(this.currentFileExtension);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(fileDateFormat.parse(currentFileTime[0]));
                long fileCreatedTime = cal.getTimeInMillis();
                if (System.currentTimeMillis() - fileCreatedTime > fileCreationInterval && currentFile.length() > 0L) {
                    LOGGER.info("Exceeds the FileCreationInterval create new file");
                    this.createArchiveFile();
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception in manageArchiveFile ::::: " + e);
            e.printStackTrace();
        }
    }

    private void getLastModifiedFile() throws Exception {
        File as400Dir = new File(archiveLocation + File.separator + this.as400HostName);
        if (this.currentFileName == null && as400Dir.isDirectory()) {
            File[] fileArray = as400Dir.listFiles();
            if (fileArray.length > 0) {
                long lastModifiedTime = 0L;
                File lastModifiedFile = null;
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].lastModified() <= lastModifiedTime) continue;
                    lastModifiedTime = fileArray[i].lastModified();
                    lastModifiedFile = fileArray[i];
                    LOGGER.fine("Last Modified file ::::: " + lastModifiedFile + " time :::::: " + lastModifiedTime);
                }
                this.currentFileName = lastModifiedFile.getName();
                if (isEncryptionEnabled) {
                    this.encryptionObj = "256".equals(this.encAlgo) ? Encryption256Bit.getInstance(this.currentFileName) : EncryptionAPI.getInstance(this.currentFileName);
                    if (!this.currentFileName.endsWith("_enc")) {
                        LOGGER.info("Archive Encryption is enabled so creating new file");
                        this.createArchiveFile();
                    }
                } else if (this.currentFileName.endsWith("_enc")) {
                    LOGGER.info("Archive Encryption is disabled so creating new file");
                    this.createArchiveFile();
                }
            } else {
                this.createArchiveFile();
            }
        }
    }

    private void createArchiveFile() throws Exception {
        this.currentFileName = fileDateFormat.format(new Date());
        if (isEncryptionEnabled) {
            if (AbstractEncryptionHandler.isDynamicEncryption()) {
                this.currentFileExtension = this.currentFileExtension + "_dyn";
                this.currentFileName = this.currentFileName + this.currentFileExtension;
            }
            if ("256".equals(this.encAlgo)) {
                this.currentFileExtension = this.currentFileExtension + "_256_enc";
                this.currentFileName = this.currentFileName + this.currentFileExtension;
                this.encryptionObj = Encryption256Bit.getInstance(this.currentFileName);
            } else {
                this.currentFileExtension = this.currentFileExtension + "_enc";
                this.currentFileName = this.currentFileName + this.currentFileExtension;
                this.encryptionObj = EncryptionAPI.getInstance(this.currentFileName);
            }
            this.isNewEncryptedFile = true;
        }
        File currentFile = new File(archiveLocation + File.separator + this.as400HostName + File.separator + this.currentFileName);
        LOGGER.info("New file <->" + this.currentFileName + " creation status <->" + currentFile.createNewFile());
    }

    public void openFile() {
        try {
            LOGGER.info("Opening the file " + this.currentFileName);
            this.archiveFileWriter = new FileWriter(archiveLocation + File.separator + this.as400HostName + File.separator + this.currentFileName, true);
            this.archivePrintWriter = new PrintWriter((Writer)new BufferedWriter(this.archiveFileWriter), false);
        }
        catch (IOException ioe) {
            LOGGER.info("Exception while opening archive file ::::: " + ioe);
            ioe.printStackTrace();
        }
    }

    public void writeLog(ArrayList logs) {
        try {
            String toWriteLog = null;
            for (int i = 0; i < logs.size(); ++i) {
                if (isEncryptionEnabled) {
                    toWriteLog = this.encryptionObj.encryptLog((String)logs.get(i));
                    toWriteLog = this.isNewEncryptedFile ? toWriteLog : "|" + toWriteLog;
                    this.isNewEncryptedFile = false;
                } else {
                    toWriteLog = (String)logs.get(i);
                }
                LOGGER.finer("Writing log to archive :::::: " + toWriteLog);
                this.archivePrintWriter.println(toWriteLog);
            }
            this.archivePrintWriter.flush();
        }
        catch (Exception ioe) {
            LOGGER.info("Exception while writing archive file ::::: " + ioe);
            ioe.printStackTrace();
            if (noOfTries < 2) {
                this.initialize();
                this.writeLog(logs);
                ++noOfTries;
            }
            noOfTries = 1;
        }
    }

    public void closeFile() {
        try {
            LOGGER.fine("Closing the file");
            this.archivePrintWriter.flush();
            this.archivePrintWriter.close();
            this.archiveFileWriter.close();
        }
        catch (IOException ioe) {
            LOGGER.info("Exception while writing archive file ::::: " + ioe);
            ioe.printStackTrace();
        }
    }

    public static void resetVariables() {
        fetchVariables = true;
    }
}

