/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AS400LogPreProcessor {
    private static final Logger LOGGER = Logger.getLogger(AS400LogPreProcessor.class.getName());
    private String hostName = null;
    private Long hostId = null;
    private static Set fetchedHostAlertSet = new HashSet();
    private static boolean fetchFilterVariables = true;
    private static HashMap alertMap = new HashMap();
    private static HashMap alertCorrelator = new HashMap();
    private static HashMap filterMap = new HashMap();
    private static boolean isMysql = "mysql".equals(System.getProperty("DBType", "mysql"));
    private NotificationManager nfManager = NotificationManager.getInstance();
    private LogForwarderFilter logforwarder = LogForwarderFilter.getInstance();

    public static AS400LogPreProcessor getInstance() {
        return new AS400LogPreProcessor();
    }

    public void initialize(String hostName, Long hostId) {
        this.hostName = hostName;
        this.hostId = hostId;
        LOGGER.info("Initializing AS400 Log Preprocessing for <-> " + hostName);
        this.setVariables();
    }

    private void setVariables() {
        try {
            LOGGER.fine("Need the fetch Alert variables from database. Host list <-> " + fetchedHostAlertSet);
            if (!fetchedHostAlertSet.contains(String.valueOf(this.hostId))) {
                this.setAlertVariables();
                fetchedHostAlertSet.add(String.valueOf(this.hostId));
            }
            LOGGER.fine("Need the fetch Filter variables from database <-> " + fetchFilterVariables);
            if (fetchFilterVariables) {
                this.setFilterVariables();
                fetchFilterVariables = false;
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception while setting variables ::::: " + e);
            e.printStackTrace();
        }
    }

    private void setAlertVariables() throws Exception {
        SelectQueryImpl alertSql = new SelectQueryImpl(new Table("NotificationType"));
        alertSql.addSelectColumn(new Column("NotificationType", "*"));
        alertSql.addSelectColumn(new Column("HostNotification", "*"));
        alertSql.addSelectColumn(new Column("HostGroupNotification", "*"));
        alertSql.addSelectColumn(new Column("HostGroupMapping", "*"));
        alertSql.addSelectColumn(new Column("LACriteria", "*"));
        alertSql.addSelectColumn(new Column("LAExpression", "*"));
        alertSql.addSelectColumn(new Column("LACriteria2Expressions", "*"));
        alertSql.addSelectColumn(new Column("ScriptDetails", "*"));
        alertSql.addJoin(new Join("NotificationType", "HostNotification", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
        alertSql.addJoin(new Join("NotificationType", "HostGroupNotification", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
        alertSql.addJoin(new Join("HostGroupNotification", "HostGroupMapping", new String[]{"GROUPID"}, new String[]{"GROUPID"}, 1));
        alertSql.addJoin(new Join("NotificationType", "LACriteria", new String[]{"NOTIFID"}, new String[]{"CRIT_ID"}, 1));
        alertSql.addJoin(new Join("LACriteria", "LACriteria2Expressions", new String[]{"CRIT_ID"}, new String[]{"CRIT_ID"}, 1));
        alertSql.addJoin(new Join("LACriteria2Expressions", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 1));
        alertSql.addJoin(new Join("NotificationType", "ScriptDetails", new String[]{"NOTIFID"}, new String[]{"NOTIFID"}, 1));
        Criteria statusCrit = new Criteria(new Column("NotificationType", "STATUS"), (Object)new Integer(1), 0);
        Criteria typeCrit = new Criteria(new Column("NotificationType", "TYPE"), (Object)new Long(-1L), 0);
        Criteria hCrit = new Criteria(new Column("HostNotification", "HOSTID"), (Object)this.hostId, 0);
        Criteria hgCrit = new Criteria(new Column("HostGroupMapping", "HOSTID"), (Object)this.hostId, 0);
        alertSql.setCriteria(statusCrit.and(typeCrit).and(hCrit.or(hgCrit)));
        DataObject alertDO = DataAccess.get((SelectQuery)alertSql);
        LOGGER.fine("AlertDO <-> " + alertDO);
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("NotificationType");
        tableList.add("LACriteria");
        tableList.add("LACriteria2Expressions");
        tableList.add("LAExpression");
        tableList.add("ScriptDetails");
        Iterator alertItr = alertDO.getRows("NotificationType");
        while (alertItr.hasNext()) {
            Row alertRow = (Row)alertItr.next();
            HashMap map = new HashMap();
            map.put("Criticality", (String)alertRow.get("CRITICALITY"));
            map.put("Occurrences", (Integer)alertRow.get("NOOFOCCURRENCE"));
            map.put("Interval", (Integer)alertRow.get("NOTIFINTERVAL"));
            DataObject tempDO = alertDO.getDataObject(tableList, alertRow);
            LOGGER.fine("Alert tempDO <-> " + tempDO);
            Iterator expItr = tempDO.getRows("LAExpression");
            while (expItr.hasNext()) {
                Row expRow = (Row)expItr.next();
                String colName = (String)expRow.get("COLUMN_NAME");
                String value = ((String)expRow.get("VALUE")).toLowerCase();
                if ("AS400SEVERITY".equals(colName)) {
                    map.put("Severity", this.convertToList(value));
                    continue;
                }
                if ("MESSAGEID".equals(colName)) {
                    map.put("MessageId", this.convertToList(value));
                    continue;
                }
                if ("USERNAME".equals(colName)) {
                    map.put("UserName", this.convertToList(value));
                    continue;
                }
                if ("JOBNAME".equals(colName)) {
                    map.put("JobName", this.convertToList(value));
                    continue;
                }
                if ("SOURCE".equals(colName)) {
                    map.put("Source", this.convertToList(value));
                    continue;
                }
                if (!"MESSAGE".equals(colName)) continue;
                map = this.processMessage(map, value);
                map.put("MessageComparator", (String)expRow.get("COMPARATOR"));
            }
            Row scriptRow = tempDO.getRow("ScriptDetails");
            if (scriptRow != null) {
                map.put("ScriptLocation", (String)scriptRow.get("LOCATION"));
                map.put("ScriptArgs", (String)scriptRow.get("ARGUMENTS"));
            }
            Set<String> hostIdSet = new HashSet<String>();
            if (alertMap.containsKey((Long)alertRow.get("NOTIFID"))) {
                HashMap oldMap = (HashMap)alertMap.get((Long)alertRow.get("NOTIFID"));
                Set oldHostIdSet = (Set)oldMap.get("HOST_ID");
                oldHostIdSet.add(String.valueOf(this.hostId));
                hostIdSet = oldHostIdSet;
            } else {
                hostIdSet.add(String.valueOf(this.hostId));
            }
            map.put("HOST_ID", hostIdSet);
            LOGGER.fine("Alert tempMap <-> " + map);
            alertMap.put((Long)alertRow.get("NOTIFID"), map);
        }
        LOGGER.fine("AlertMap <-> " + alertMap);
    }

    public void doAlert(Hashtable logMap) {
        try {
            String logMsgId = ((String)logMap.get("MSGID")).toLowerCase();
            String logMessage = ((String)logMap.get("MESSAGE")).toLowerCase();
            long logTime = Long.parseLong(logMap.get("TIME") + "");
            LOGGER.fine("Log <-> " + logMessage);
            Pattern msgContainsPattern = null;
            Pattern msgNotContainsPattern = null;
            Matcher msgContainsMatcher = null;
            Matcher msgNotContainsMatcher = null;
            Iterator itr = alertMap.keySet().iterator();
            while (itr.hasNext()) {
                StringTokenizer tokenizer;
                String comparator;
                boolean isMsg = false;
                boolean msgMatch = false;
                boolean isNotMsg = false;
                boolean msgNotMatch = false;
                ArrayList list = new ArrayList();
                Long notifID = (Long)itr.next();
                HashMap map = (HashMap)alertMap.get(notifID);
                LOGGER.fine("NotificationID <-> " + notifID);
                if (!((Set)map.get("HOST_ID")).contains(String.valueOf(this.hostId))) continue;
                String criticality = (String)map.get("Criticality");
                int occurences = (Integer)map.get("Occurrences");
                int interval = (Integer)map.get("Interval") * 1000;
                if (map.containsKey("Severity")) {
                    list = (ArrayList)map.get("Severity");
                    if (!list.contains(((String)logMap.get("SEVERITY")).toLowerCase())) continue;
                    LOGGER.fine("Severity matched");
                }
                if (map.containsKey("MessageId")) {
                    list = (ArrayList)map.get("MessageId");
                    if (!list.contains(logMsgId)) continue;
                    LOGGER.fine("MessageId matched");
                }
                if (map.containsKey("UserName")) {
                    list = (ArrayList)map.get("UserName");
                    if (!list.contains(((String)logMap.get("USERNAME")).toLowerCase())) continue;
                    LOGGER.fine("UserName matched");
                }
                if (map.containsKey("JobName")) {
                    list = (ArrayList)map.get("JobName");
                    if (!list.contains(((String)logMap.get("JOBNAME")).toLowerCase())) continue;
                    LOGGER.fine("JobName matched");
                }
                if (map.containsKey("Source")) {
                    list = (ArrayList)map.get("Source");
                    if (!list.contains(((String)logMap.get("SOURCE")).toLowerCase())) continue;
                    LOGGER.fine("Source matched");
                }
                if (map.containsKey("MessageContains")) {
                    isMsg = true;
                    String msgContains = (String)map.get("MessageContains");
                    comparator = (String)map.get("MessageComparator");
                    if ("1".equals(comparator) || "2".equals(comparator)) {
                        if (msgContainsPattern == null || !msgContains.equals(msgContainsPattern.toString())) {
                            msgContainsPattern = Pattern.compile(msgContains);
                            msgContainsMatcher = msgContainsPattern.matcher("");
                        }
                        msgContainsMatcher.reset(logMessage);
                        msgMatch = msgContainsMatcher.find();
                    } else {
                        tokenizer = new StringTokenizer(msgContains, "|");
                        while (tokenizer.hasMoreTokens()) {
                            if (logMessage.indexOf(tokenizer.nextToken()) != -1) {
                                msgMatch = true;
                                continue;
                            }
                            msgMatch = false;
                            break;
                        }
                    }
                    LOGGER.fine("MessageContains status <-> " + msgMatch);
                }
                if (map.containsKey("MessageNotContains") && (!isMsg || isMsg && msgMatch)) {
                    isNotMsg = true;
                    String msgNotContains = (String)map.get("MessageNotContains");
                    comparator = (String)map.get("MessageComparator");
                    if ("1".equals(comparator) || "3".equals(comparator)) {
                        if (msgNotContainsPattern == null || !msgNotContains.equals(msgNotContainsPattern.toString())) {
                            msgNotContainsPattern = Pattern.compile(msgNotContains);
                            msgNotContainsMatcher = msgNotContainsPattern.matcher("");
                        }
                        msgNotContainsMatcher.reset(logMessage);
                        msgNotMatch = msgNotContainsMatcher.find();
                    } else {
                        tokenizer = new StringTokenizer(msgNotContains, "|");
                        while (tokenizer.hasMoreTokens()) {
                            if (logMessage.indexOf(tokenizer.nextToken()) != -1) {
                                msgNotMatch = true;
                                break;
                            }
                            msgNotMatch = false;
                        }
                    }
                    LOGGER.fine("MessageNotContains status <-> " + msgNotMatch);
                }
                if (isMsg && !msgMatch || isNotMsg && msgNotMatch) continue;
                if (occurences > 1) {
                    if (alertCorrelator.containsKey(notifID + "," + this.hostId)) {
                        LOGGER.fine("AlertCorrelator :::::: " + alertCorrelator);
                        HashMap tempCorrelator = (HashMap)alertCorrelator.get(notifID + "," + this.hostId);
                        long lastGenerated = (Long)tempCorrelator.get("LAST_GENERATED");
                        int alertCount = (Integer)tempCorrelator.get("COUNT") + 1;
                        if (alertCount < occurences && logTime - lastGenerated < (long)interval) {
                            this.updateAlertCorrelator(notifID, new Long(logTime), new Integer(alertCount));
                            continue;
                        }
                        alertCorrelator.remove(notifID + "," + this.hostId);
                    } else {
                        this.updateAlertCorrelator(notifID, new Long(logTime), new Integer(1));
                        continue;
                    }
                }
                LOGGER.fine("Notified out");
                Hashtable<String, Object> log = new Hashtable<String, Object>();
                log.put("TIME", logTime);
                log.put("HOSTNAME", this.hostName);
                log.put("HOSTID", this.hostId);
                log.put("SOURCE", logMsgId);
                log.put("MESSAGE", logMessage);
                log.put("NOTIFID", notifID.toString());
                if (logMap.containsKey("$id$")) {
                    log.put("UUID", logMap.get("$id$"));
                }
                this.nfManager.notify(log);
                try {
                    this.logforwarder.filterAndForward(log);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception while processing alert :::::: " + e);
            e.printStackTrace();
        }
    }

    private void setFilterVariables() throws Exception {
        SelectQueryImpl filterSql = new SelectQueryImpl(new Table("SyslogFilter"));
        filterSql.addSelectColumn(new Column("SyslogFilter", "*"));
        filterSql.addSelectColumn(new Column("HostFilter", "*"));
        filterSql.addSelectColumn(new Column("HostDetails", "*"));
        filterSql.addSelectColumn(new Column("HostGroupFilter", "*"));
        filterSql.addSelectColumn(new Column("HostGroupMapping", "*"));
        filterSql.addSelectColumn(new Column("Filter2Criteria", "*"));
        filterSql.addSelectColumn(new Column("LACriteria2Expressions", "*"));
        filterSql.addSelectColumn(new Column("LAExpression", "*"));
        filterSql.addJoin(new Join("SyslogFilter", "HostFilter", new String[]{"ID"}, new String[]{"FILTERID"}, 1));
        filterSql.addJoin(new Join("HostFilter", "HostDetails", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
        filterSql.addJoin(new Join("SyslogFilter", "HostGroupFilter", new String[]{"ID"}, new String[]{"FILTERID"}, 1));
        filterSql.addJoin(new Join("HostGroupFilter", "HostGroupMapping", new String[]{"GROUPID"}, new String[]{"GROUPID"}, 1));
        filterSql.addJoin(new Join(new Table("HostGroupMapping"), new Table("HostDetails", "HGHostDetails"), new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 1));
        filterSql.addJoin(new Join("SyslogFilter", "Filter2Criteria", new String[]{"ID"}, new String[]{"FILTERID"}, 1));
        filterSql.addJoin(new Join("Filter2Criteria", "LACriteria2Expressions", new String[]{"CRITERIAID"}, new String[]{"CRIT_ID"}, 1));
        filterSql.addJoin(new Join("LACriteria2Expressions", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 1));
        Criteria statusCrit = new Criteria(new Column("SyslogFilter", "STATUS"), (Object)new Integer(1), 0);
        Criteria htypeCrit = new Criteria(new Column("HostDetails", "TYPE"), (Object)"IBM AS/400", 0);
        Criteria hgtypeCrit = new Criteria(new Column("HGHostDetails", "TYPE"), (Object)"IBM AS/400", 0);
        Criteria hCrit = new Criteria(new Column("HostFilter", "HOSTID"), (Object)this.hostId, 0);
        Criteria hgCrit = new Criteria(new Column("HostGroupMapping", "HOSTID"), (Object)this.hostId, 0);
        filterSql.setCriteria(statusCrit.and(htypeCrit.or(hgtypeCrit)).and(hCrit.or(hgCrit)));
        DataObject filterDO = DataAccess.get((SelectQuery)filterSql);
        LOGGER.fine("FilterDO <-> " + filterDO);
        ArrayList<String> tableList = new ArrayList<String>();
        tableList.add("SyslogFilter");
        tableList.add("Filter2Criteria");
        tableList.add("LACriteria2Expressions");
        tableList.add("LAExpression");
        Iterator filterItr = filterDO.getRows("SyslogFilter");
        while (filterItr.hasNext()) {
            Row filterRow = (Row)filterItr.next();
            HashMap map = new HashMap();
            DataObject tempDO = filterDO.getDataObject(tableList, filterRow);
            LOGGER.fine("Filter tempDO <-> " + tempDO);
            Iterator expItr = tempDO.getRows("LAExpression");
            while (expItr.hasNext()) {
                Row expRow = (Row)expItr.next();
                String colName = (String)expRow.get("COLUMN_NAME");
                String value = ((String)expRow.get("VALUE")).toLowerCase();
                if ("AS400SEVERITY".equals(colName)) {
                    map.put("Severity", this.convertToList(value));
                    continue;
                }
                if ("MESSAGEID".equals(colName)) {
                    map.put("MessageId", this.convertToList(value));
                    continue;
                }
                if ("USERNAME".equals(colName)) {
                    map.put("UserName", this.convertToList(value));
                    continue;
                }
                if ("JOBNAME".equals(colName)) {
                    map.put("JobName", this.convertToList(value));
                    continue;
                }
                if ("SOURCE".equals(colName)) {
                    map.put("Source", this.convertToList(value));
                    continue;
                }
                if (!"MESSAGE".equals(colName)) continue;
                map = this.processMessage(map, value);
                map.put("MessageComparator", (String)expRow.get("COMPARATOR"));
            }
            LOGGER.fine("Filter tempMap <-> " + map);
            filterMap.put((Long)filterRow.get("ID"), map);
        }
        LOGGER.fine("FilterMap <-> " + filterMap);
    }

    public boolean doFilter(Hashtable logMap) {
        try {
            String logMessage = ((String)logMap.get("MESSAGE")).toLowerCase();
            long logTime = Long.parseLong(logMap.get("TIME") + "");
            LOGGER.fine("Log <-> " + logMessage);
            Pattern msgContainsPattern = null;
            Pattern msgNotContainsPattern = null;
            Matcher msgContainsMatcher = null;
            Matcher msgNotContainsMatcher = null;
            Iterator itr = filterMap.keySet().iterator();
            while (itr.hasNext()) {
                StringTokenizer tokenizer;
                String comparator;
                boolean isMsg = false;
                boolean msgMatch = false;
                boolean isNotMsg = false;
                boolean msgNotMatch = false;
                ArrayList list = new ArrayList();
                Long filterId = (Long)itr.next();
                HashMap map = (HashMap)filterMap.get(filterId);
                LOGGER.fine("FilterID <-> " + filterId);
                if (map.containsKey("Severity")) {
                    list = (ArrayList)map.get("Severity");
                    if (!list.contains(((String)logMap.get("SEVERITY")).toLowerCase())) continue;
                    LOGGER.fine("Severity matched");
                }
                if (map.containsKey("MessageId")) {
                    list = (ArrayList)map.get("MessageId");
                    if (!list.contains(((String)logMap.get("MSGID")).toLowerCase())) continue;
                    LOGGER.fine("MessageId matched");
                }
                if (map.containsKey("UserName")) {
                    list = (ArrayList)map.get("UserName");
                    if (!list.contains(((String)logMap.get("USERNAME")).toLowerCase())) continue;
                    LOGGER.fine("UserName matched");
                }
                if (map.containsKey("JobName")) {
                    list = (ArrayList)map.get("JobName");
                    if (!list.contains(((String)logMap.get("JOBNAME")).toLowerCase())) continue;
                    LOGGER.fine("JobName matched");
                }
                if (map.containsKey("Source")) {
                    list = (ArrayList)map.get("Source");
                    if (!list.contains(((String)logMap.get("SOURCE")).toLowerCase())) continue;
                    LOGGER.fine("Source matched");
                }
                if (map.containsKey("MessageContains")) {
                    isMsg = true;
                    String msgContains = (String)map.get("MessageContains");
                    comparator = (String)map.get("MessageComparator");
                    if ("1".equals(comparator) || "2".equals(comparator)) {
                        if (msgContainsPattern == null || !msgContains.equals(msgContainsPattern.toString())) {
                            msgContainsPattern = Pattern.compile(msgContains);
                            msgContainsMatcher = msgContainsPattern.matcher("");
                        }
                        msgContainsMatcher.reset(logMessage);
                        msgMatch = msgContainsMatcher.find();
                    } else {
                        tokenizer = new StringTokenizer(msgContains, "|");
                        while (tokenizer.hasMoreTokens()) {
                            if (logMessage.indexOf(tokenizer.nextToken()) != -1) {
                                msgMatch = true;
                                continue;
                            }
                            msgMatch = false;
                            break;
                        }
                    }
                    LOGGER.fine("MessageContains status <-> " + msgMatch);
                }
                if (map.containsKey("MessageNotContains") && (!isMsg || isMsg && msgMatch)) {
                    isNotMsg = true;
                    String msgNotContains = (String)map.get("MessageNotContains");
                    comparator = (String)map.get("MessageComparator");
                    if ("1".equals(comparator) || "3".equals(comparator)) {
                        if (msgNotContainsPattern == null || !msgNotContains.equals(msgNotContainsPattern.toString())) {
                            msgNotContainsPattern = Pattern.compile(msgNotContains);
                            msgNotContainsMatcher = msgNotContainsPattern.matcher("");
                        }
                        msgNotContainsMatcher.reset(logMessage);
                        msgNotMatch = msgNotContainsMatcher.find();
                    } else {
                        tokenizer = new StringTokenizer(msgNotContains, "|");
                        while (tokenizer.hasMoreTokens()) {
                            if (logMessage.indexOf(tokenizer.nextToken()) != -1) {
                                msgNotMatch = true;
                                break;
                            }
                            msgNotMatch = false;
                        }
                    }
                    LOGGER.fine("MessageNotContains status <-> " + msgNotMatch);
                }
                if (isMsg && !msgMatch || isNotMsg && msgNotMatch) continue;
                LOGGER.fine("Filtered out");
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception while processing filter :::::: " + e);
            e.printStackTrace();
        }
        return false;
    }

    private ArrayList convertToList(String value) throws Exception {
        ArrayList<String> valueList = new ArrayList<String>();
        String[] valueArr = value.split(",");
        for (int i = 0; i < valueArr.length; ++i) {
            valueList.add(valueArr[i]);
        }
        return valueList;
    }

    private HashMap processMessage(HashMap map, String msg) {
        StringTokenizer msgTokens = new StringTokenizer(msg, "|");
        if (msgTokens.countTokens() == 1) {
            if (msg.indexOf("|") != 0) {
                map.put("MessageContains", msgTokens.nextToken().replaceAll(",", "|"));
            } else {
                map.put("MessageNotContains", msgTokens.nextToken().replaceAll(",", "|"));
            }
        } else {
            map.put("MessageContains", msgTokens.nextToken().replaceAll(",", "|"));
            map.put("MessageNotContains", msgTokens.nextToken().replaceAll(",", "|"));
        }
        return map;
    }

    private void updateAlertCorrelator(Long notifID, Long alertTime, Integer alertcount) {
        HashMap<String, Number> tempCorrelator = new HashMap<String, Number>();
        tempCorrelator.put("LAST_GENERATED", alertTime);
        tempCorrelator.put("COUNT", alertcount);
        alertCorrelator.put(notifID + "," + this.hostId, tempCorrelator);
    }

    public static void resetAlertVariables() {
        LOGGER.info("Resetting the AS400 Alert Preprocessor");
        alertMap = new HashMap();
        fetchedHostAlertSet.clear();
    }

    public static void resetFilterVariables() {
        LOGGER.info("Resetting the AS400 Filter Preprocessor");
        filterMap = new HashMap();
        fetchFilterVariables = true;
    }
}

