/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import java.io.File;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveProcessor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ArchiveProcessor.class.getName());
    int archiveDWS = -1;
    Long critTime;
    String dropquery = "";
    String dbType = System.getProperty("DBType", "mysql");
    String archiveLocation = "archive";
    Connection con = null;
    Statement stmt = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Persistence persistence = PersistenceDBUtil.getPersistence();
        String[] queryParams = new String[]{"retainArchiveLogs", "sysArchiveLocation"};
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria crt = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)queryParams, 8);
            query.setCriteria(crt);
            DataObject obj = DataAccess.get((SelectQuery)query);
            Iterator iter = obj.getRows("SystemConfigurations");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String confName = (String)row.get("CONF_NAME");
                if ("retainArchiveLogs".equals(confName)) {
                    this.archiveDWS = Integer.parseInt((String)row.get("CONF_VALUE"));
                }
                if (!"sysArchiveLocation".equals(confName)) continue;
                this.archiveLocation = (String)row.get("CONF_VALUE");
            }
            if (this.archiveDWS > -1) {
                this.critTime = new Long(System.currentTimeMillis() - (long)this.archiveDWS * 86400000L);
                Table table = new Table("SysArchivedFiles");
                SelectQueryImpl archivequery = new SelectQueryImpl(table);
                archivequery.addSelectColumn(new Column("SysArchivedFiles", "*"));
                Criteria criteria = new Criteria(new Column("SysArchivedFiles", "ARCHIVED_TIME"), (Object)this.critTime, 7);
                archivequery.setCriteria(criteria);
                DataObject dataObject = DataAccess.get((SelectQuery)archivequery);
                Iterator itrforFile = dataObject.getRows("SysArchivedFiles");
                this.con = RelationalAPI.getInstance().getConnection();
                this.stmt = this.con.createStatement();
                while (itrforFile.hasNext()) {
                    Row rIterator = (Row)itrforFile.next();
                    String fname = (String)rIterator.get("FILE_NAME");
                    String tableName = (String)rIterator.get("TABLE_NAME");
                    this.dropquery = "mssql".equals(this.dbType) ? "IF EXISTS(select * from sysobjects where name='" + tableName + "') DROP TABLE " + tableName : "Drop Table IF EXISTS " + tableName;
                    if ("archive".equals(this.archiveLocation) && !new File(fname).exists()) {
                        fname = System.getProperty("server.home") + File.separator + fname;
                    }
                    LOGGER.fine("File name to be deleted : " + fname);
                    File filetobeDeleted = new File(fname);
                    if (!filetobeDeleted.exists()) continue;
                    boolean deletionStatus = filetobeDeleted.delete();
                    if (deletionStatus) {
                        LOGGER.log(Level.INFO, "File Deleted Successfully File Name::" + fname);
                    }
                    persistence.delete(rIterator);
                    this.stmt.executeUpdate(this.dropquery);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

