/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.TimeStampingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.EAService;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Signature;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchiveZipCreator
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ArchiveZipCreator.class.getName());
    private ArrayList hostList = new ArrayList();
    private String archiveLocation = System.getProperty("server.home") + File.separator + "archive";
    private String dbArchiveLocation = "archive";
    private boolean isTimeStampingEnabled = false;
    private static SimpleDateFormat fileDateFormat = new SimpleDateFormat("dd_MM_yy_HH_mm_ss");
    private static SimpleDateFormat zipDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private boolean isZipNow = false;
    private boolean archiveEdit = false;
    private boolean agentFailOver = false;
    private DataObject sysArchiveDO = null;

    public ArchiveZipCreator(boolean zipNow) {
        this.isZipNow = zipNow;
    }

    public ArchiveZipCreator(boolean zipNow, boolean changed) {
        this.isZipNow = zipNow;
        this.archiveEdit = changed;
    }

    @Override
    public void run() {
        if (EAService.periodicTaskId == null && !this.isZipNow) {
            try {
                DataObject archiveDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"sysZipCreationInterval", 0));
                long zipInterval = Long.parseLong((String)archiveDO.getFirstValue("SystemConfigurations", "CONF_VALUE"));
                LOGGER.info("Periodic Archive Zip Task initiated with delay <-> " + zipInterval / 3600000L + " Hrs");
                ClockDaemon archiveZipTask = new ClockDaemon();
                EAService.periodicTaskId = archiveZipTask.executePeriodically(zipInterval, (Runnable)new ArchiveZipCreator(false), false);
                EAService.onceTaskId = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.archiveEdit) {
            this.checkForStatus();
            this.setArchiveVariables();
            this.createZipForHosts();
        } else {
            LOGGER.info("Archive Zip Task started");
            this.agentFailOver = this.checkForFailOver();
            if (!this.agentFailOver) {
                this.passToAgent("createZip");
                this.checkForStatus();
            }
            this.setArchiveVariables();
            this.createZipForHosts();
        }
    }

    private void setArchiveVariables() {
        try {
            DataObject archiveDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)new String[]{"sysArchiveLocation", "sysEnableArchiveTimestamping"}, 8));
            this.dbArchiveLocation = (String)archiveDO.getValue("SystemConfigurations", "CONF_VALUE", new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"sysArchiveLocation", 0));
            this.archiveLocation = "archive".equals(this.dbArchiveLocation) ? this.archiveLocation : this.dbArchiveLocation;
            this.isTimeStampingEnabled = Boolean.valueOf((String)archiveDO.getValue("SystemConfigurations", "CONF_VALUE", new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"sysEnableArchiveTimestamping", 0)));
        }
        catch (Exception e) {
            LOGGER.info("Exception while getting Archive Location ::::::: " + e);
            e.printStackTrace();
        }
    }

    private void createZipForHosts() {
        try {
            this.sysArchiveDO = DataAccess.constructDataObject();
            SelectQueryImpl hostQuery = new SelectQueryImpl(new Table("Hosts"));
            hostQuery.addSelectColumn(new Column("Hosts", "*"));
            hostQuery.addSelectColumn(new Column("HostDetails", "*"));
            hostQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
            hostQuery.setCriteria(new Criteria(new Column("HostDetails", "TYPE"), (Object)"Application", 1));
            DataObject hostDO = DataAccess.get((SelectQuery)hostQuery);
            Iterator hostItr = hostDO.getRows("Hosts");
            while (hostItr.hasNext()) {
                Row hostRow = (Row)hostItr.next();
                Long hostId = (Long)hostRow.get("HOST_ID");
                Row hdRow = hostDO.getRow("HostDetails", new Criteria(new Column("HostDetails", "HOST_ID"), (Object)hostId, 0));
                this.createZip((String)hostRow.get("DNS_NAME"), hostId, (String)hdRow.get("TYPE"));
            }
            LOGGER.fine("Archive DO ::::: " + this.sysArchiveDO);
            DataAccess.add((DataObject)this.sysArchiveDO);
        }
        catch (Exception e) {
            LOGGER.info("Exception while creating zip ::::::: " + e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZip(String hostName, Long hostId, String hostType) {
        File[] flatFiles;
        File hostDir = new File(this.archiveLocation + File.separator + hostName);
        File tempHostDir = new File(this.archiveLocation + File.separator + hostName + "_for_archive");
        if ("IBM AS/400".equals(hostType) || this.agentFailOver) {
            if (tempHostDir.exists()) {
                flatFiles = tempHostDir.listFiles();
                for (int i = 0; i < flatFiles.length; ++i) {
                    flatFiles[i].renameTo(new File(hostDir + File.separator + flatFiles[i].getName()));
                }
                LOGGER.fine("Temp folder is present so deleting status ::::: " + tempHostDir.delete());
            }
            LOGGER.fine("Renaming to temp folder status ::::: " + hostDir.renameTo(tempHostDir));
        }
        hostDir.mkdirs();
        flatFiles = tempHostDir.listFiles();
        String zipName = hostName + "_" + zipDateFormat.format(new Date());
        String zipFileName = this.archiveLocation + File.separator + zipName + ".zip";
        String dbZipFileName = this.dbArchiveLocation + "/" + zipName + ".zip";
        ZipOutputStream as400Stream = null;
        long start_time = 0L;
        try {
            LOGGER.info("Zipping for the Hosts ::::: " + hostName);
            if (flatFiles == null || flatFiles.length == 0) {
                tempHostDir.delete();
                LOGGER.info("No files hence returning");
                return;
            }
            as400Stream = new ZipOutputStream(new FileOutputStream(zipFileName));
            int dataSize = 8192;
            byte[] data = new byte[dataSize];
            Signature sign = null;
            TimeStampingAPI timeStamping = null;
            if (this.isTimeStampingEnabled) {
                timeStamping = TimeStampingAPI.getInstance();
                sign = timeStamping.getSignatureObjToSign();
            }
            for (int i = 0; i < flatFiles.length; ++i) {
                File flatFile = flatFiles[i];
                if (flatFile.length() == 0L) {
                    flatFile.delete();
                    continue;
                }
                if (!flatFile.exists()) continue;
                String flatFileName = flatFile.getName();
                LOGGER.fine("Zipping file ::::: " + flatFileName);
                flatFileName = flatFileName.endsWith("_enc") ? flatFileName.substring(0, flatFileName.length() - 4) : flatFileName;
                LOGGER.fine("Formatted Zipping file ::::: " + flatFileName);
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(fileDateFormat.parse(flatFile.getName()));
                if (start_time == 0L || cal.getTimeInMillis() < start_time) {
                    start_time = cal.getTimeInMillis();
                }
                BufferedInputStream as400Buffer = null;
                try {
                    int count;
                    as400Stream.putNextEntry(new ZipEntry(flatFile.getName()));
                    as400Buffer = new BufferedInputStream(new FileInputStream(flatFile));
                    while ((count = as400Buffer.read(data, 0, dataSize)) != -1) {
                        as400Stream.write(data, 0, count);
                        if (sign == null) continue;
                        timeStamping.updateDataIntoSignature(sign, data);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    try {
                        if (as400Buffer != null) {
                            as400Buffer.close();
                        }
                        LOGGER.fine("Finally Deleting file ::::: " + flatFile.delete());
                    }
                    catch (Exception exception) {}
                }
            }
            as400Stream = this.createProperty(as400Stream, hostType);
            as400Stream = this.createSignature(as400Stream, timeStamping, sign, zipName);
            as400Stream.close();
            LOGGER.fine("Temp Folder delete status ::::::: " + tempHostDir.delete());
            long archived_time = new File(zipFileName).lastModified();
            Row archiveRow = new Row("SysArchivedFiles");
            archiveRow.set("HOST_ID", (Object)hostId);
            archiveRow.set("FILE_NAME", (Object)dbZipFileName);
            archiveRow.set("START_TIME", (Object)new Long(start_time));
            archiveRow.set("ARCHIVED_TIME", (Object)new Long(archived_time));
            archiveRow.set("SIZE", (Object)new File(zipFileName).length());
            archiveRow.set("STATUS", (Object)new Long("0"));
            archiveRow.set("TABLE_NAME", (Object)("ArchivedTable_" + System.currentTimeMillis()));
            archiveRow.set("TYPE", (Object)"ARCHIVE");
            this.sysArchiveDO.addRow(archiveRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (as400Stream != null) {
                    as400Stream.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private ZipOutputStream createProperty(ZipOutputStream as400Stream, String hostType) throws Exception {
        LOGGER.fine("Creation property file");
        String formatName = "sys_archive";
        String os = "Unix";
        if ("Windows".equals(hostType)) {
            formatName = "win_archive";
            os = "Windows";
        } else if ("Cisco Device".equals(hostType)) {
            formatName = "cisco_archive";
            os = "Cisco Device";
        } else if ("IBM AS/400".equals(hostType)) {
            formatName = "ibm_as400";
            os = "IBM AS/400";
        }
        as400Stream.putNextEntry(new ZipEntry("archivedesc.properties"));
        as400Stream.write(("format=" + formatName + "\n").getBytes());
        as400Stream.write(("os=" + os + "\n").getBytes());
        as400Stream.write("type=Non-Application\n".getBytes());
        return as400Stream;
    }

    private ZipOutputStream createSignature(ZipOutputStream as400Stream, TimeStampingAPI timeStamping, Signature sign, String zipName) throws Exception {
        if (sign != null) {
            LOGGER.fine("Creation signature file");
            String signatureStr = timeStamping.getSignedString(sign);
            if (signatureStr != null) {
                as400Stream.putNextEntry(new ZipEntry(zipName + ".sgn"));
                as400Stream.write(signatureStr.getBytes());
            }
        }
        return as400Stream;
    }

    private void passToAgent(String action) {
        try {
            DataObject slDO = DataAccess.constructDataObject();
            Row slRow = new Row("SLUPDATE");
            slRow.set("SLID", (Object)EAService.getSLID());
            slRow.set("SERVICETYPE", (Object)EAService.slUpdateConst.get(action.toUpperCase()));
            slRow.set("SERVICEID", (Object)new Long(1L));
            slDO.addRow(slRow);
            DataAccess.add((DataObject)slDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkForStatus() {
        try {
            LOGGER.fine("Checking status if the agent finished renaming of the folders");
            Criteria crit = new Criteria(new Column("SLUPDATE", "SERVICETYPE"), (Object)EAService.slUpdateConst.get("STARTZIP"), 0);
            DataObject slDO = DataAccess.get((String)"SLUPDATE", (Criteria)crit);
            LOGGER.fine("DO :::::: " + slDO);
            if (slDO.size("SLUPDATE") > 0) {
                DataAccess.delete((Criteria)crit);
            } else {
                Thread.sleep(5000L);
                this.checkForStatus();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkForFailOver() {
        try {
            DataObject slDO = DataAccess.get((String)"SLUPDATE", (Criteria)new Criteria(new Column("SLUPDATE", "SERVICETYPE"), (Object)EAService.slUpdateConst.get("SECSTATUS"), 0));
            long agentDate = (Long)slDO.getFirstValue("SLUPDATE", "SERVICEID");
            return System.currentTimeMillis() - agentDate > 900000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

