/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ComplianceMigration {
    private Persistence persistence = null;

    public void migrateComplianceReports() {
        try {
            this.persistence = PersistenceDBUtil.getPersistence();
            HashMap auditMap = ComplianceMigration.getAuditPolicyMap();
            List rIdList = this.getReportIdList();
            HashMap criteriaMap = new HashMap();
            int rIdListSize = rIdList.size();
            for (int i = 0; i < rIdListSize; ++i) {
                System.out.println("migrating report " + rIdList.get(i));
                criteriaMap = this.getCriteriaMap(rIdList.get(i).toString());
                if (!auditMap.containsKey(criteriaMap.get("CompType"))) continue;
                this.setNewCompCrit(auditMap, criteriaMap, rIdList.get(i).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap getAuditPolicyMap() throws Exception {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        DataObject doo = DataAccess.get((String)"AuditPolicyNames", (Criteria)null);
        Iterator it = doo.getRows("AuditPolicyNames");
        while (it.hasNext()) {
            Row row = (Row)it.next();
            auditMap.put((String)row.get("POLICY_NAME"), "" + row.get("POLICY_ID"));
        }
        return auditMap;
    }

    private List getReportIdList() throws Exception {
        ArrayList<String> rIdList = new ArrayList<String>();
        DataObject selOb = DataAccess.get((String)"ReportConfig", (Criteria)new Criteria(new Column("ReportConfig", "REPORTTYPE"), (Object)"SYSLOG-CN", 0));
        Iterator laItr = selOb.get("ReportConfig", "REPORTID");
        while (laItr.hasNext()) {
            String id = "" + laItr.next();
            rIdList.add(id);
        }
        return rIdList;
    }

    private DataObject getRCDO(String rId) throws Exception {
        SelectQueryImpl selquery = new SelectQueryImpl(new Table("ReportConfig"));
        selquery.addSelectColumn(new Column("ReportConfig", "*"));
        selquery.addSelectColumn(new Column("ReportConfigToFilters", "*"));
        selquery.addSelectColumn(new Column("FilterToLAExpression", "*"));
        selquery.addSelectColumn(new Column("LAExpression", "*"));
        Join j = new Join("ReportConfig", "ReportConfigToFilters", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 1);
        Join j1 = new Join("ReportConfigToFilters", "FilterToLAExpression", new String[]{"FILTERNAME"}, new String[]{"FILTERNAME"}, 1);
        Join j2 = new Join("FilterToLAExpression", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 1);
        selquery.addJoin(j);
        selquery.addJoin(j1);
        selquery.addJoin(j2);
        selquery.setCriteria(new Criteria(new Column("ReportConfig", "REPORTID"), (Object)rId, 0));
        DataObject doo = DataAccess.get((SelectQuery)selquery);
        return doo;
    }

    private DataObject getAuditDO(String compType, String[] rbb) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("AuditPolicyNames"));
        sql.addSelectColumn(new Column("AuditPolicyNames", "*"));
        sql.addSelectColumn(new Column("AuditPolicyNamesToGroup", "*"));
        sql.addSelectColumn(new Column("AuditPolicyGroups", "*"));
        sql.addSelectColumn(new Column("AuditPolicyGroupsToRBB", "*"));
        sql.addSelectColumn(new Column("AuditPolicyRBBs", "*"));
        sql.addSelectColumn(new Column("AuditPolicyRBBsToCategory", "*"));
        sql.addSelectColumn(new Column("AuditPolicyCategory", "*"));
        String[] groupid = new String[]{"GROUPID"};
        String[] rbbid = new String[]{"RBBID"};
        sql.addJoin(new Join("AuditPolicyNames", "AuditPolicyNamesToGroup", new String[]{"POLICY_ID"}, new String[]{"POLICYID"}, 2));
        sql.addJoin(new Join("AuditPolicyNamesToGroup", "AuditPolicyGroups", groupid, new String[]{"GROUP_ID"}, 2));
        sql.addJoin(new Join("AuditPolicyNamesToGroup", "AuditPolicyGroupsToRBB", groupid, groupid, 2));
        sql.addJoin(new Join("AuditPolicyGroupsToRBB", "AuditPolicyRBBs", rbbid, new String[]{"RBB_ID"}, 2));
        sql.addJoin(new Join("AuditPolicyGroupsToRBB", "AuditPolicyRBBsToCategory", rbbid, rbbid, 2));
        sql.addJoin(new Join("AuditPolicyRBBsToCategory", "AuditPolicyCategory", new String[]{"CATEGORYID"}, new String[]{"CATEGORY_ID"}, 2));
        sql.setCriteria(new Criteria(new Column("AuditPolicyNames", "POLICY_ID"), (Object)compType, 0).and(new Criteria(new Column("AuditPolicyRBBs", "RBB_NAME"), (Object)rbb, 8)));
        DataObject doo = DataAccess.get((SelectQuery)sql);
        return doo;
    }

    private String getAuditPolicyValues(DataObject doo, String table, String column) throws Exception {
        String auditPolicyGroups = "";
        Iterator it = doo.getRows(table);
        while (it.hasNext()) {
            Row row = (Row)it.next();
            if ("".equals(auditPolicyGroups)) {
                auditPolicyGroups = (String)row.get(column);
                continue;
            }
            auditPolicyGroups = auditPolicyGroups + "','" + row.get(column);
        }
        return auditPolicyGroups;
    }

    private HashMap getCriteriaMap(String rId) throws Exception {
        DataObject selOb = this.getRCDO(rId);
        HashMap<String, String> criteriaMap = new HashMap<String, String>();
        Iterator laItr = selOb.getRows("LAExpression");
        while (laItr.hasNext()) {
            Row laRow = (Row)laItr.next();
            String columnName = (String)laRow.get("COLUMN_NAME");
            String columnValue = (String)laRow.get("VALUE");
            criteriaMap.put(columnName, columnValue);
        }
        return criteriaMap;
    }

    public HashMap setNewCompCrit(HashMap auditMap, HashMap criteriaMap) {
        return this.setNewCompCrit(auditMap, criteriaMap, "");
    }

    private HashMap setNewCompCrit(HashMap auditMap, HashMap criteriaMap, String rId) {
        HashMap<Integer, HashMap> compParamMap = new HashMap<Integer, HashMap>();
        try {
            String graphRBB;
            String compType = criteriaMap.get("CompType").toString();
            String rbb = criteriaMap.get("RBBNAME").toString();
            String[] rbbArr = this.getNewRbbList(rbb.replaceAll(",+", ",").split(","));
            compType = (String)auditMap.get(compType);
            DataObject doo = this.getAuditDO(compType, rbbArr);
            String auditPolicyGroups = this.getAuditPolicyValues(doo, "AuditPolicyGroups", "GROUP_NAME");
            String auditPolicyRBBs = this.getAuditPolicyValues(doo, "AuditPolicyRBBs", "RBB_NAME");
            String compEventCategory = this.getAuditPolicyValues(doo, "AuditPolicyCategory", "CATEGORY_NAME");
            String string = graphRBB = auditPolicyGroups.indexOf(",") == -1 ? "ComplianceOverview_Group" : "ComplianceOverview";
            if (!"".equals(rId)) {
                this.addCompReport(compType, graphRBB, auditPolicyGroups, auditPolicyRBBs, compEventCategory, rId);
            } else {
                int compParamIndex = 0;
                compParamMap.put(new Integer(compParamIndex++), this.setCompParams("CompType", "CompType", compType));
                compParamMap.put(new Integer(compParamIndex++), this.setCompParams("GraphRBB", "GraphRBB", graphRBB));
                compParamMap.put(new Integer(compParamIndex++), this.setCompParams("AuditPolicyGroups", "GROUP_NAME", auditPolicyGroups));
                compParamMap.put(new Integer(compParamIndex++), this.setCompParams("AuditPolicyRBBs", "RBB_NAME", auditPolicyRBBs));
                compParamMap.put(new Integer(compParamIndex++), this.setCompParams("AuditPolicyCategory", "CATEGORY_NAME", compEventCategory));
            }
            return compParamMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return compParamMap;
        }
    }

    private HashMap setCompParams(String tableName, String columnName, String value) {
        HashMap<String, String> compTempMap = new HashMap<String, String>();
        compTempMap.put("TABLE_NAME", tableName);
        compTempMap.put("COLUMN_NAME", columnName);
        compTempMap.put("VALUE", value);
        return compTempMap;
    }

    private void addCompReport(String compType, String graphRBB, String auditPolicyGroups, String auditPolicyRBBs, String compEventCategory, String rId) throws Exception {
        DataObject doo = this.getRCDO(rId);
        Row rptConfigRow = doo.getFirstRow("ReportConfig");
        String dbReportName = (String)rptConfigRow.get("PROFILENAME");
        Long dbReportId = (Long)rptConfigRow.get("REPORTID");
        doo = this.deleteCritRows(dbReportName, dbReportId.toString(), doo);
        Row filterRow = new Row("Filters");
        filterRow.set("FILTERNAME", (Object)(dbReportName + "_Filter"));
        doo.addRow(filterRow);
        doo = this.addLAExpression(doo, filterRow, "CompType", "CompType", compType, "=");
        doo = this.addLAExpression(doo, filterRow, "GraphRBB", "GraphRBB", graphRBB, "=");
        doo = this.addLAExpression(doo, filterRow, "AuditPolicyGroups", "GROUP_NAME", auditPolicyGroups, "IN");
        doo = this.addLAExpression(doo, filterRow, "AuditPolicyRBBs", "RBB_NAME", auditPolicyRBBs, "IN");
        doo = this.addLAExpression(doo, filterRow, "AuditPolicyCategory", "CATEGORY_NAME", compEventCategory, "IN");
        Row rptToFilt = new Row("ReportConfigToFilters");
        rptToFilt.set("FILTERNAME", filterRow.get("FILTERNAME"));
        rptToFilt.set("REPORTID", rptConfigRow.get("REPORTID"));
        rptToFilt.set("TYPE", (Object)"Include");
        doo.addRow(rptToFilt);
        DataObject rbbgDo = this.getDO("ComplianceReportOverview,ComplianceReport,ComplianceReport_Details");
        Iterator rbbgItr = rbbgDo.getRows("ReportBuildingBlockGroup");
        while (rbbgItr.hasNext()) {
            Row rbbg = (Row)rbbgItr.next();
            Row rbbgToRptCfg = new Row("ReportConfigToRBBGMapping");
            rbbgToRptCfg.set("REPORTID", rptConfigRow.get("REPORTID"));
            rbbgToRptCfg.set("RBBGID", rbbg.get("RBBGID"));
            doo.addRow(rbbgToRptCfg);
        }
        DataObject added = DataAccess.add((DataObject)doo);
    }

    private DataObject addLAExpression(DataObject doo, Row filterRow, String tableName, String columnName, String columnValue, String comparator) throws Exception {
        try {
            Row laExpRow = new Row("LAExpression");
            laExpRow.set("TABLE_NAME", (Object)tableName);
            laExpRow.set("COLUMN_NAME", (Object)columnName);
            laExpRow.set("COMPARATOR", (Object)comparator);
            laExpRow.set("VALUE", (Object)columnValue);
            doo.addRow(laExpRow);
            Row fltToLaExp = new Row("FilterToLAExpression");
            fltToLaExp.set("EXP_ID", laExpRow.get("EXP_ID"));
            fltToLaExp.set("FILTERNAME", filterRow.get("FILTERNAME"));
            doo.addRow(fltToLaExp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doo;
    }

    private DataObject getDO(String rbbgs) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("ReportBuildingBlockGroup"));
        Column cols = new Column("ReportBuildingBlockGroup", "*");
        sql.addSelectColumn(cols);
        if (rbbgs.indexOf(",") != -1) {
            sql.setCriteria(new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgs.split(","), 8));
        } else {
            sql.setCriteria(new Criteria(new Column("ReportBuildingBlockGroup", "RBBGNAME"), (Object)rbbgs, 0));
        }
        return DataAccess.get((SelectQuery)sql);
    }

    private DataObject deleteCritRows(String filterName, String rId, DataObject d) throws Exception {
        SelectQueryImpl sql = new SelectQueryImpl(new Table("Filters"));
        sql.addSelectColumn(new Column("Filters", "*"));
        sql.addSelectColumn(new Column("ReportConfigToFilters", "*"));
        sql.addSelectColumn(new Column("FilterToLAExpression", "*"));
        sql.addSelectColumn(new Column("LAExpression", "*"));
        sql.addJoin(new Join("Filters", "ReportConfigToFilters", new String[]{"FILTERNAME"}, new String[]{"FILTERNAME"}, 2));
        sql.addJoin(new Join("ReportConfigToFilters", "FilterToLAExpression", new String[]{"FILTERNAME"}, new String[]{"FILTERNAME"}, 2));
        sql.addJoin(new Join("FilterToLAExpression", "LAExpression", new String[]{"EXP_ID"}, new String[]{"EXP_ID"}, 2));
        sql.setCriteria(new Criteria(new Column("Filters", "FILTERNAME"), (Object)(filterName + "_filter"), 0));
        d = DataAccess.get((SelectQuery)sql);
        d.deleteRows("LAExpression", (Criteria)null);
        d.deleteRows("ReportConfigToFilters", (Criteria)null);
        d.deleteRows("Filters", (Criteria)null);
        this.persistence.update(d);
        sql = null;
        d = null;
        sql = new SelectQueryImpl(new Table("ReportConfig"));
        sql.addSelectColumn(new Column("ReportConfigToRBBGMapping", "*"));
        sql.addSelectColumn(new Column("ReportConfigToRBBMapping", "*"));
        sql.addSelectColumn(new Column("ReportConfigToRBBPMapping", "*"));
        sql.addJoin(new Join("ReportConfig", "ReportConfigToRBBGMapping", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 2));
        sql.addJoin(new Join("ReportConfigToRBBGMapping", "ReportConfigToRBBMapping", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 2));
        sql.addJoin(new Join("ReportConfigToRBBMapping", "ReportConfigToRBBPMapping", new String[]{"REPORTID"}, new String[]{"REPORTID"}, 2));
        sql.setCriteria(new Criteria(new Column("ReportConfig", "REPORTID"), (Object)rId, 0));
        d = DataAccess.get((SelectQuery)sql);
        d.deleteRows("ReportConfigToRBBGMapping", (Criteria)null);
        d.deleteRows("ReportConfigToRBBMapping", (Criteria)null);
        d.deleteRows("ReportConfigToRBBPMapping", (Criteria)null);
        this.persistence.update(d);
        return d;
    }

    private String[] getNewRbbList(String[] rbbArr) {
        String[] oldRbb = new String[]{"Compliance_LogonAttempts", "Compliance_SystemEvents", "Compliance_HostSessionStatus", "Compliance_FailedUserAccountValidation", "Compliance_AuditPolicyChanged", "Compliance_ObjectAccess"};
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("Compliance_LogonAttempts", "Compliance_UnsuccessfulUserLogons");
        h.put("Compliance_SystemEvents", "Compliance_SystemLogs");
        h.put("Compliance_HostSessionStatus", "Compliance_TerminalServiceSession");
        h.put("Compliance_FailedUserAccountValidation", "Compliance_UnsuccessfulUserAccountValidation");
        h.put("Compliance_AuditPolicyChanged", "Compliance_AuditPolicyChanges");
        h.put("Compliance_ObjectAccess", "Compliance_ObjectAccessed,Compliance_ObjectCreated,Compliance_ObjectModified,Compliance_ObjectDeleted,Compliance_ObjectHandle");
        String newListRbb = "";
        for (int i = 0; i < oldRbb.length; ++i) {
            String oldRbbName = oldRbb[i];
            for (int j = 0; j < rbbArr.length; ++j) {
                String rbbName = rbbArr[j];
                newListRbb = oldRbbName.equals(rbbName) ? ("".equals(newListRbb) ? h.get(rbbName).toString() : newListRbb + "," + h.get(rbbName)) : ("".equals(newListRbb) ? rbbName : newListRbb + "," + rbbName);
            }
        }
        return newListRbb.split(",");
    }
}

