/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.LaUtil;
import com.adventnet.la.util.LAClientUtil;
import com.adventnet.la.util.LAInstallUtil;
import com.adventnet.la.util.Mailer;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.HighAvailability;
import com.adventnet.sa.server.imp.ImportAppLogManager;
import com.adventnet.sa.server.imp.ImportSysEvtLogManager;
import com.adventnet.sa.server.util.CommonUtil;
import com.manageengine.ela.server.common.network.dns.inet.InetAddressHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskSpaceCheck
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(DiskSpaceCheck.class.getName());
    long servicetime = 0L;
    String serviceType = null;
    public static String toaddress = null;
    String status = null;
    public static String subject = null;
    String mailSent = null;
    long[] startTimes = new long[5];
    long quitInterval;
    long currentTime;
    int minDiskcount = 0;
    static boolean flag = false;
    Object stop = null;
    boolean minDisk = true;

    public void set(Object o) {
        this.stop = o;
    }

    @Override
    public void run() {
        try {
            ++this.minDiskcount;
            if (this.minDiskcount == 4 || !this.minDisk) {
                this.minDisk = this.checkMinDiskSpace();
            }
            if ("true".equals(System.getProperty("Secondary", "false"))) {
                this.secondaryServerAlert();
            }
            if (this.minDisk) {
                SelectQueryImpl query1 = new SelectQueryImpl(Table.getTable((String)"SystemConfigurations"));
                query1.addSelectColumn(Column.getColumn((String)"SystemConfigurations", (String)"*"));
                Criteria migCrit = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"EDMailID", 0);
                Criteria migCrit1 = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"EDStatus", 0);
                Criteria migCrit2 = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"EDSubject", 0);
                Criteria cri = migCrit.or(migCrit1).or(migCrit2);
                query1.setCriteria(cri);
                DataObject obj1 = DataAccess.get((SelectQuery)query1);
                if (obj1.size("SystemConfigurations") > 0) {
                    toaddress = (String)obj1.getValue("SystemConfigurations", "CONF_VALUE", migCrit);
                    this.status = (String)obj1.getValue("SystemConfigurations", "CONF_VALUE", migCrit1);
                    subject = (String)obj1.getValue("SystemConfigurations", "CONF_VALUE", migCrit2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isLocalMachine() throws Exception {
        String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
        HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"eventlog");
        String DBServer = null;
        String DBServerIP = null;
        if (DBParams != null) {
            DBServer = (String)DBParams.get("DBServer");
            if ("localhost".equalsIgnoreCase(DBServer)) {
                return true;
            }
            try {
                DBServerIP = InetAddressHandler.getInetAddress(DBServer).getHostAddress();
                Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
                while (n.hasMoreElements()) {
                    NetworkInterface e = n.nextElement();
                    Enumeration<InetAddress> a = e.getInetAddresses();
                    while (a.hasMoreElements()) {
                        InetAddress addr = a.nextElement();
                        if (!addr.getHostAddress().equals(DBServerIP)) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception while checking isLocalmachine with db server name " + DBServer + " --" + e.getMessage());
            }
        }
        return false;
    }

    public boolean checkMinDiskSpace() {
        try {
            if (!this.isLocalMachine()) {
                LOGGER.log(Level.INFO, "Free DiskSpace Check Skipped due to RemoteDB");
                EAService.freeSpace = true;
                return EAService.freeSpace;
            }
            this.minDiskcount = 0;
            String osName = System.getProperty("os.name", "Windows");
            LOGGER.log(Level.INFO, "checkMinDiskSpace Called");
            String pathDB = DiskSpaceCheck.getPath("database");
            long dbFreeBytes = osName.indexOf("indows") == -1 ? DiskSpaceCheck.getFreeSpaceForLinux(pathDB) : new File(pathDB).getFreeSpace();
            double dbFreeGB = (double)dbFreeBytes / 1024.0 / 1024.0 / 1024.0;
            LOGGER.log(Level.INFO, "osName :: " + osName);
            LOGGER.log(Level.INFO, "dbFreeGB :: " + dbFreeGB);
            double minDSpace = Double.parseDouble(System.getProperty("minimumDiskSpace", "2.0"));
            LOGGER.log(Level.FINE, "minimumDiskSpace :: " + minDSpace);
            boolean logthread_stopped = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"logthread_stopped", 0)).isEmpty();
            if (dbFreeGB > minDSpace && !logthread_stopped) {
                DataAccess.delete((Criteria)new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"logthread_stopped", 0));
                EAService.freeSpace = true;
                ImportSysEvtLogManager.setSuspendImport(false);
                ImportAppLogManager.setSuspendImport(false);
            }
            if (logthread_stopped && dbFreeGB < minDSpace) {
                LOGGER.log(Level.INFO, "Due to low disc space stopELALogThreads() Called");
                EAService.freeSpace = false;
                new EAService().stopELALogThreads();
                if (CommonUtil.isMailServerConfigured()) {
                    this.sendNotification(dbFreeGB, minDSpace);
                }
                this.updateSystemConfiguration();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return EAService.freeSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPath(String location) {
        boolean isPostgres = "postgres".equals(System.getProperty("DBType", "postgres"));
        String path = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            if ("database".equals(location)) {
                boolean isMssql = "mssql".equals(System.getProperty("DBType", "mysql"));
                String DBType2 = System.getProperty("DBType", "mysql");
                if (isMssql) {
                    path = System.getProperty("server.dir");
                } else {
                    conn = RelationalAPI.getInstance().getConnection();
                    stmt = conn.createStatement();
                    if (isPostgres) {
                        String query = "show data_directory";
                        rs = stmt.executeQuery(query);
                        while (rs.next()) {
                            path = (String)rs.getObject("data_directory");
                        }
                    } else {
                        String query = "show variables like \"datadir\"";
                        rs = stmt.executeQuery(query);
                        while (rs.next()) {
                            path = (String)rs.getObject("Value");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    private void sendNotification(double available, double required) {
        try {
            ResourceBundle bundle = null;
            String message = "";
            String toaddress = this.getToAddress();
            StringBuffer hnbuffer = new StringBuffer();
            bundle = ProductBundle.getInstance().getBundle();
            Map mailServerSettings = LaUtil.getMailAttributes();
            message = " Log Collection Stopped   \n \n A problem occurred during the log collection process due to insufficient disk space.\n\n \t **" + available + " GB of free disk space is available. \n\n \t ** " + required + " GB of free disk space is required. \n\n Log collection will resume when additional disk space is made available. \n \n -- ManageEngine EventLogAnalyzer";
            String server = (String)mailServerSettings.get("SmtpServer");
            String port = (String)mailServerSettings.get("SmtpServerPort");
            String username = (String)mailServerSettings.get("uName");
            String password = (String)mailServerSettings.get("pWord");
            String auth = (String)mailServerSettings.get("authenticate");
            String from = (String)mailServerSettings.get("fromId");
            String tls = (String)mailServerSettings.get("tls");
            Mailer mailer = new Mailer();
            mailer.setMailHost(server);
            mailer.setSmtpPort(port);
            mailer.setFromAddress(from);
            mailer.setToAddress(toaddress);
            mailer.setMailSubject("Log Collection Stopped due to insufficient disk space");
            if (username != null && !"".equals(username)) {
                mailer.setUserName(username);
            }
            if (password != null && !"".equals(password)) {
                mailer.setPassword(password);
            }
            if (tls != null && !"".equals(tls)) {
                mailer.setTLS(tls);
            }
            mailer.initialize();
            mailer.setAutoReplyText(message);
            mailer.constructMessage();
            boolean mailresult = mailer.sendIt();
            if (mailresult) {
                LOGGER.info("Mail send Succesfully for host:::");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getToAddress() throws Exception {
        String adminAddress;
        String toaddress = "";
        SelectQueryImpl q = new SelectQueryImpl(Table.getTable((String)"SystemConfigurations"));
        q.addSelectColumn(Column.getColumn((String)"SystemConfigurations", (String)"*"));
        Criteria c = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"EDMailID", 0);
        Criteria c1 = new Criteria(Column.getColumn((String)"SystemConfigurations", (String)"CONF_NAME"), (Object)"LAlertMail", 0);
        Criteria cri = c.or(c1);
        q.setCriteria(cri);
        DataObject result = DataAccess.get((SelectQuery)q);
        if (result.size("SystemConfigurations") > 0) {
            toaddress = (String)result.getValue("SystemConfigurations", "CONF_VALUE", c);
            String la = (String)result.getValue("SystemConfigurations", "CONF_VALUE", c1);
            if (la != null) {
                toaddress = toaddress != null ? toaddress + "," + la : la;
            }
        }
        if (!"".equals(adminAddress = this.getAdminAdress()) && adminAddress != null) {
            toaddress = toaddress + "," + adminAddress;
        }
        return toaddress;
    }

    private String getAdminAdress() throws Exception {
        String[] userType = new String[]{System.getProperty("userType", "Administrator")};
        String toaddress = "";
        SelectQueryImpl sql_aaaUser = new SelectQueryImpl(Table.getTable((String)"AaaUser"));
        sql_aaaUser.addSelectColumn(Column.getColumn((String)"AaaUser", (String)"*"));
        sql_aaaUser.addSelectColumn(Column.getColumn((String)"AaaUserContactInfo", (String)"*"));
        sql_aaaUser.addSelectColumn(Column.getColumn((String)"AaaContactInfo", (String)"*"));
        sql_aaaUser.addJoin(new Join(Table.getTable((String)"AaaUser"), Table.getTable((String)"AaaUserContactInfo"), new String[]{"USER_ID"}, new String[]{"USER_ID"}, 1));
        sql_aaaUser.addJoin(new Join(Table.getTable((String)"AaaUserContactInfo"), Table.getTable((String)"AaaContactInfo"), new String[]{"CONTACTINFO_ID"}, new String[]{"CONTACTINFO_ID"}, 1));
        sql_aaaUser.setCriteria(new Criteria(Column.getColumn((String)"AaaUser", (String)"FIRST_NAME"), (Object)userType, 8).and(new Criteria(new Column("AaaContactInfo", "EMAILID"), (Object)"aaaadmin@adventnet.com", 1)));
        DataObject obj = DataAccess.get((SelectQuery)sql_aaaUser);
        if (!obj.isEmpty()) {
            Iterator getEMail = obj.getRows("AaaContactInfo");
            while (getEMail.hasNext()) {
                Row emailRow = (Row)getEMail.next();
                if (toaddress.equals("")) {
                    toaddress = (String)emailRow.get("EMAILID");
                    continue;
                }
                toaddress = toaddress + "," + emailRow.get("EMAILID");
            }
        }
        return toaddress;
    }

    private double getFreeSpaceWin(String dir, String isFree) {
        String temp = null;
        double spc = 0.0;
        if (new File(dir).exists()) {
            try {
                Process pro = null;
                Runtime rt = Runtime.getRuntime();
                BufferedReader buff = null;
                pro = rt.exec("cmd /c cscript /nologo " + System.getProperty("server.home") + "\\troubleshooting\\" + "lowDiskSpaceWMI.vbs" + " " + dir + " " + isFree);
                buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                temp = buff.readLine();
                temp = temp.replaceAll(",", "");
                spc = Double.parseDouble(temp);
            }
            catch (Exception e) {
                e.printStackTrace();
                spc = 0.0;
            }
        }
        return spc;
    }

    public void updateSystemConfiguration() {
        try {
            DataObject udpDO = DataAccess.constructDataObject();
            Row fprow = new Row("SystemConfigurations");
            fprow.set("CONF_NAME", (Object)"logthread_stopped");
            fprow.set("CONF_VALUE", (Object)"1");
            udpDO.addRow(fprow);
            DataAccess.add((DataObject)udpDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static double getLinSpace(String path, String headerStarts) {
        double spcGB = 0.0;
        if (new File(path).exists()) {
            String command = "Avail".equals(headerStarts) ? "/bin/df " : "du -s ";
            DecimalFormat oneDigit = new DecimalFormat("0.0");
            String freeGB = "-1";
            BufferedReader buff = null;
            String temp = null;
            String strFreeBytes = null;
            long bytes = 0L;
            try {
                Runtime rt = Runtime.getRuntime();
                Process pro = rt.exec(command + path);
                buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                temp = buff.readLine();
                String[] header = null;
                while (temp != null) {
                    if (header == null) {
                        header = temp.split("\\s+");
                    }
                    strFreeBytes = temp;
                    temp = buff.readLine();
                }
                if (headerStarts.equals("Avail")) {
                    String[] values;
                    if (header.length != 0 && (values = strFreeBytes.split("\\s+"))[3] != null) {
                        long freeKB = Long.parseLong(values[3]);
                        bytes = freeKB * 1024L;
                    }
                    freeGB = oneDigit.format((double)bytes / 1.073741824E9);
                } else {
                    long freeKB = Long.parseLong(header[0]);
                    freeGB = oneDigit.format((double)freeKB / 1048576.0);
                }
                spcGB = Double.parseDouble(freeGB);
            }
            catch (Exception e) {
                spcGB = -1.0;
                e.printStackTrace();
            }
        } else {
            spcGB = -1.0;
        }
        return spcGB;
    }

    private int getIndexPosition(String path) {
        int lastIndex;
        int indexPosition = 0;
        int firstIndex = path.indexOf(47);
        indexPosition = firstIndex == (lastIndex = path.lastIndexOf(47)) ? path.length() : path.indexOf(47, 1);
        return indexPosition;
    }

    private void secondaryServerAlert() {
        Properties additionalParams = new Properties();
        int port1 = 0;
        try {
            HighAvailability portCheck;
            String protocol = LAClientUtil.getWebProtocol();
            LOGGER.log(Level.INFO, "check protocol for Mail" + protocol);
            String homeDir = System.getProperty("server.home") + File.separator + "conf" + File.separator + "server.xml";
            port1 = LAInstallUtil.getWebServerPort((String)homeDir);
            LOGGER.log(Level.INFO, "port no check for Mail ==" + port1);
            String bindAddr = System.getProperty("localIp");
            HighAvailability _tmp = portCheck = new HighAvailability();
            HighAvailability.isPortAvailable(port1, bindAddr);
            LOGGER.log(Level.INFO, "port check output  " + HighAvailability.isPortAvailable(port1, bindAddr));
            HighAvailability _tmp1 = portCheck;
            if (HighAvailability.isPortAvailable(port1, bindAddr).booleanValue()) {
                ResourceBundle bundle = null;
                String message = "";
                String toaddress = this.getToAddress();
                StringBuffer hnbuffer = new StringBuffer();
                bundle = ProductBundle.getInstance().getBundle();
                Map mailServerSettings = LaUtil.getMailAttributes();
                message = " Your primary server is currently down. Once it is up follow the below steps.\n \n 1. Stop the ELA service in Secondary server.\n\n 2.Wait for a minute for all the process to terminate. \n\n  3. Start the ELA service in Primary Server. \n\n 4.Then start the Secondary server in standby mode \n \n -- ManageEngine EventLogAnalyzer";
                String server = (String)mailServerSettings.get("SmtpServer");
                String port = (String)mailServerSettings.get("SmtpServerPort");
                String username = (String)mailServerSettings.get("uName");
                String password = (String)mailServerSettings.get("pWord");
                String auth = (String)mailServerSettings.get("authenticate");
                String from = (String)mailServerSettings.get("fromId");
                String tls = (String)mailServerSettings.get("tls");
                Mailer mailer = new Mailer();
                mailer.setMailHost(server);
                mailer.setSmtpPort(port);
                mailer.setFromAddress(from);
                mailer.setToAddress(toaddress);
                mailer.setMailSubject("Primary Server Was down");
                if (username != null && !"".equals(username)) {
                    mailer.setUserName(username);
                }
                if (password != null && !"".equals(password)) {
                    mailer.setPassword(password);
                }
                if (tls != null && !"".equals(tls)) {
                    mailer.setTLS(tls);
                }
                mailer.initialize();
                mailer.setAutoReplyText(message);
                mailer.constructMessage();
                boolean mailresult = mailer.sendIt();
                if (mailresult) {
                    LOGGER.info("Mail send Succesfully for HighAvailability Monitor:::");
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Exception while calling check the server port");
            ex.printStackTrace();
        }
    }

    public static long getFreeSpaceForLinux(String folderPath) {
        try {
            folderPath = new File(folderPath).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int pathLen = -1;
        long returnSize = -1L;
        String returnMountPoint = null;
        List<Map<String, String>> ls = DiskSpaceCheck.getMapMounts();
        for (Map<String, String> mp : ls) {
            String mountPoint = mp.get("MountPoint");
            if (!folderPath.startsWith(mountPoint)) continue;
            LOGGER.log(Level.FINE, "mountMatch:" + mountPoint);
            if (mountPoint.length() <= pathLen) continue;
            LOGGER.log(Level.FINE, "newMountPoint assumed:" + mountPoint);
            returnMountPoint = mountPoint;
            pathLen = mountPoint.length();
            returnSize = Long.valueOf(mp.get("Free"));
        }
        if (returnMountPoint == null) {
            LOGGER.log(Level.FINE, "No mount point matched!");
            returnMountPoint = folderPath;
            returnSize = new File(folderPath).getFreeSpace();
        }
        LOGGER.log(Level.FINE, "returning size of:" + returnMountPoint + ",as " + returnSize);
        return returnSize;
    }

    private static List<String> getHDDPartitions() {
        try {
            String response;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/mounts"), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((response = bufferedReader.readLine()) != null) {
                stringBuilder.append(response.replaceAll(" +", "\t") + "\n");
            }
            bufferedReader.close();
            return new ArrayList<String>(Arrays.asList(stringBuilder.toString().split("\n")));
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    private static List<Map<String, String>> getMapMounts() {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        for (String mountPoint : DiskSpaceCheck.getHDDPartitions()) {
            HashMap<String, String> result = new HashMap<String, String>();
            String[] mount = mountPoint.split("\t");
            result.put("MountPoint", mount[1]);
            result.put("Free", String.valueOf(new File(mount[1]).getFreeSpace()));
            resultList.add(result);
        }
        return resultList;
    }
}

