/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.winaccess.ADSAccessProvider;
import com.adventnet.sym.winaccess.NetworkElementProvider;
import com.adventnet.sym.winaccess.WinAccessProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainDiscovery
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DomainDiscovery.class.getName());
    private String dName = null;
    private boolean userRequest = false;

    public DomainDiscovery() {
    }

    public DomainDiscovery(String dName) {
        if (!"all".equalsIgnoreCase(dName)) {
            this.dName = dName;
        }
        this.userRequest = true;
    }

    @Override
    public void run() {
        if (!this.checkforDiscovery()) {
            LOGGER.log(Level.INFO, "Returning from Domain discovery  reason -warm start");
            return;
        }
        if (System.getProperty("os.name").indexOf("indows") < 0) {
            LOGGER.log(Level.INFO, "Domain discovery is not supported for the OS [" + System.getProperty("os.name") + "]");
            return;
        }
        try {
            NetworkElementProvider nep;
            String name = "My Network Places";
            String path = "My Network Places";
            String type = "0";
            ArrayList<NetworkElementProvider> domainList = new ArrayList<NetworkElementProvider>();
            String domainName = ADSAccessProvider.getDomainName();
            LOGGER.log(Level.FINER, "Domain Name :" + domainName);
            if (this.dName == null) {
                List networkElementList = WinAccessProvider.addNEChildren("", "", new Integer("0"));
                block4: for (int i = 0; i < networkElementList.size(); ++i) {
                    nep = (NetworkElementProvider)networkElementList.get(i);
                    List networkElementList1 = WinAccessProvider.addNEChildren(nep.name, nep.path, nep.type);
                    for (int j = 0; j < networkElementList1.size(); ++j) {
                        nep = (NetworkElementProvider)networkElementList1.get(j);
                        LOGGER.log(Level.FINER, "Name :" + nep.name + " Path :" + nep.path + " type :" + nep.type + " hasChildren :" + nep.hasChildren);
                        if (nep.type != 2) continue block4;
                        if (!nep.hasChildren) continue;
                        domainList.add(nep);
                    }
                }
                LOGGER.log(Level.FINER, "Hello there...2<->" + networkElementList.size() + "<->" + domainList.size());
            } else {
                try {
                    DataObject dobj = this.getRecord(this.dName);
                    Row row = dobj.getFirstRow("DiscoveredDomains");
                    nep = new NetworkElementProvider((String)row.get("NAME"), (String)row.get("PATH"), (int)((Long)row.get("TYPE")).longValue(), true);
                    domainList.add(nep);
                    LOGGER.log(Level.FINER, "Hello there...2.1<->" + domainList.size());
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "exception while retrieving info from db for..<->" + this.dName);
                    e.printStackTrace();
                }
            }
            DataObject domainDO = this.getDomainDO();
            for (int j = 0; j < domainList.size(); ++j) {
                int i;
                NetworkElementProvider provider = (NetworkElementProvider)domainList.get(j);
                LOGGER.log(Level.FINER, "Fetching childs for...<->" + provider.name + "<->");
                List networkElementList = WinAccessProvider.addNEChildren(provider.name, provider.path, provider.type);
                DataObject dobj = null;
                Vector<Row> dH = new Vector<Row>();
                Vector<String> dHosts = new Vector<String>();
                ArrayList<String> existingHosts = new ArrayList<String>();
                if (provider.name != null && provider.name.trim().equals("")) {
                    LOGGER.log(Level.FINER, "NULL Provider ");
                    continue;
                }
                Row prow = domainDO.getRow("DiscoveredDomains", new Criteria(new Column("DiscoveredDomains", "NAME"), (Object)provider.name, 0));
                if (dobj == null) {
                    dobj = DataAccess.constructDataObject();
                }
                if (prow == null) {
                    prow = new Row("DiscoveredDomains");
                    prow.set("NAME", (Object)provider.name);
                    prow.set("PATH", (Object)provider.path);
                    prow.set("TYPE", (Object)new Long(provider.type));
                    dobj.addRow(prow);
                } else {
                    Iterator hostItr = domainDO.getRows("DiscoveredHosts", new Criteria(new Column("DiscoveredHosts", "DID"), (Object)((Long)prow.get("DID")), 0));
                    while (hostItr.hasNext()) {
                        Row hostRow = (Row)hostItr.next();
                        existingHosts.add((String)hostRow.get("NAME"));
                    }
                }
                String hostName = null;
                String HOSTNAME = null;
                String hostname = null;
                for (i = 0; i < networkElementList.size(); ++i) {
                    NetworkElementProvider nep2 = (NetworkElementProvider)networkElementList.get(i);
                    LOGGER.log(Level.FINER, "Name :" + nep2.name + " Path :" + nep2.path + " type :" + nep2.type + " hasChildren :" + nep2.hasChildren);
                    hostName = this.trimName(nep2.name);
                    HOSTNAME = hostName.toUpperCase();
                    hostname = hostName.toLowerCase();
                    if (!(dHosts.contains(HOSTNAME) || existingHosts.contains(hostName) || existingHosts.contains(HOSTNAME) || existingHosts.contains(hostname))) {
                        Row row = new Row("DiscoveredHosts");
                        row.set("DID", prow.get("DID"));
                        row.set("NAME", (Object)this.trimName(nep2.name));
                        dH.add(row);
                        dHosts.add(HOSTNAME);
                        continue;
                    }
                    LOGGER.log(Level.INFO, "Duplicate Host Name found : " + HOSTNAME + " in Domain : " + provider.name);
                }
                LOGGER.log(Level.FINER, "Current Vector size <->" + dH.size() + "<-> elements " + dH);
                if (System.getProperty("ADSI") == null) {
                    LOGGER.log(Level.FINER, "System property Vector size <->" + System.getProperty("ADSI") + " <-> " + domainName + " <-> " + provider.name);
                    if (provider.name != null && provider.name.equals(domainName) && prow != null) {
                        LOGGER.log(Level.FINER, "Name Match Vector size <->" + provider.name + " <-> " + domainName);
                        this.mergeHosts(dH, prow, dHosts, existingHosts);
                    }
                }
                LOGGER.log(Level.FINER, "Merged Vector size <->" + dH.size() + "<-> elements " + dH);
                for (i = 0; i < dH.size(); ++i) {
                    if (dobj == null) {
                        dobj = DataAccess.constructDataObject();
                    }
                    LOGGER.log(Level.FINER, " Element at <->" + i + "<-> class  " + dH.elementAt(i).getClass().getName() + " <-> " + dH.elementAt(i));
                    Row row = (Row)dH.elementAt(i);
                    dobj.addRow(row);
                }
                if (dobj == null) continue;
                LOGGER.log(Level.FINER, "Going to update data object..." + dobj);
                DataAccess.add((DataObject)dobj);
            }
            LOGGER.log(Level.INFO, "Domain Discovery complete");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "Exception while discovering domains across networks...");
        }
    }

    private void mergeHosts(Vector dH, Row prow, Vector dHosts, ArrayList existingHosts) {
        try {
            String hostName = null;
            String HOSTNAME = null;
            Object hostname = null;
            LOGGER.log(Level.FINER, "Incomming Vector size <->" + dH.size() + "<-> elements " + dH);
            List nodeList = ADSAccessProvider.getComputers(null);
            LOGGER.log(Level.FINER, "ADSI Vector size <->" + nodeList.size() + "<-> elements " + nodeList);
            for (int i = 0; i < nodeList.size(); ++i) {
                LOGGER.log(Level.FINER, "Node element  " + nodeList.get(i) + " whole entries " + dHosts);
                hostName = (String)nodeList.get(i);
                HOSTNAME = hostName.toUpperCase();
                if (dHosts.contains(HOSTNAME) || existingHosts.contains(hostName) || existingHosts.contains(HOSTNAME) || existingHosts.contains(hostname)) continue;
                LOGGER.log(Level.FINER, "Non matching Node");
                Row row = new Row("DiscoveredHosts");
                row.set("DID", prow.get("DID"));
                row.set("NAME", nodeList.get(i));
                dH.add(row);
                dHosts.add(((String)nodeList.get(i)).toUpperCase());
            }
            LOGGER.log(Level.FINER, "Outgoing Vector size <->" + dH.size() + "<-> elements " + dH);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "Exception while (ADS) discovering Hosts across networks ...");
        }
    }

    private DataObject getRecord(String dName) {
        try {
            Table expTable = new Table("DiscoveredDomains");
            SelectQueryImpl sql = new SelectQueryImpl(expTable);
            Column col = new Column("DiscoveredDomains", "*");
            sql.addSelectColumn(col);
            sql.setCriteria(new Criteria(new Column("DiscoveredDomains", "NAME"), (Object)dName, 0));
            DataObject dobj = DataAccess.get((SelectQuery)sql);
            return dobj;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "unable to fetch Domain Discovery info for<-> " + dName);
            return null;
        }
    }

    private DataObject getDomainDO() {
        try {
            Table expTable = new Table("DiscoveredDomains");
            SelectQueryImpl sql = new SelectQueryImpl(expTable);
            sql.addSelectColumn(new Column("DiscoveredDomains", "*"));
            sql.addSelectColumn(new Column("DiscoveredHosts", "*"));
            sql.addJoin(new Join(new Table("DiscoveredDomains"), new Table("DiscoveredHosts"), new String[]{"DID"}, new String[]{"DID"}, 1));
            DataObject dobj = DataAccess.get((SelectQuery)sql);
            return dobj;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "unable to fetch Domain Discovery info for<-> " + this.dName);
            return null;
        }
    }

    private boolean checkforDiscovery() {
        if (this.userRequest) {
            return this.userRequest;
        }
        try {
            Table expTable = new Table("DiscoveredDomains");
            SelectQueryImpl sql = new SelectQueryImpl(expTable);
            Column col = new Column("DiscoveredDomains", "*");
            sql.addSelectColumn(col);
            DataObject dobj = DataAccess.get((SelectQuery)sql);
            return dobj.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.log(Level.INFO, "unable to intialize Domain Discovery ");
            return true;
        }
    }

    private String trimName(String name) {
        LOGGER.log(Level.FINER, "Input name..." + name);
        int index = -1;
        index = name.lastIndexOf("\\");
        if (index > 0) {
            name = name.substring(index + 1);
        }
        LOGGER.log(Level.FINER, "Output name..." + name);
        return name;
    }
}

