/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import HTTPClient.Codecs;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.archive.TableArchiverUtil;
import com.adventnet.db.util.CreateSchema;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.DefaultDataFormatter;
import com.adventnet.la.ExportCleanup;
import com.adventnet.la.LuceneUtil;
import com.adventnet.la.enterprise.EnterpriseException;
import com.adventnet.la.enterprise.dc.DeleteCollectorDetails;
import com.adventnet.la.enterprise.startup.StartUPUtil;
import com.adventnet.la.fieldgen.LogFormatHandler;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.la.tray.ProductTrayIcon;
import com.adventnet.la.tray.StartupUtil;
import com.adventnet.la.util.ELAPortCheckerUtil;
import com.adventnet.la.util.EnDecryptImplSingleton;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.logsearch.index.api.MigrateIndex;
import com.adventnet.logsearch.index.util.LuceneConstants;
import com.adventnet.mfw.service.Service;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.xml.Xml2DoConverter;
import com.adventnet.sa.server.ArchiveProcessor;
import com.adventnet.sa.server.ArchiveZipCreator;
import com.adventnet.sa.server.ComplianceMigration;
import com.adventnet.sa.server.DiskSpaceCheck;
import com.adventnet.sa.server.ELAExceptionHandler;
import com.adventnet.sa.server.ELAMemoryHandling;
import com.adventnet.sa.server.ELAMemoryWarning;
import com.adventnet.sa.server.ELSInitializer;
import com.adventnet.sa.server.HighAvailability;
import com.adventnet.sa.server.LogAlert;
import com.adventnet.sa.server.agent.DataQueueHandler;
import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.audit.ELAAuditImpl;
import com.adventnet.sa.server.audit.ELAAuditMessageSubscriber;
import com.adventnet.sa.server.fieldgen.LogFormatHandlerImpl;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.ImportAppLogManager;
import com.adventnet.sa.server.imp.ImportSysEvtLogManager;
import com.adventnet.sa.server.imp.ImportTempTableCleaner;
import com.adventnet.sa.server.lc.FieldRepository;
import com.adventnet.sa.server.lc.RecordStore;
import com.adventnet.sa.server.lc.SyslogServer;
import com.adventnet.sa.server.lc.VCenterTaskScheduler;
import com.adventnet.sa.server.logcollector.LogCollectorProcess;
import com.adventnet.sa.server.logcollector.LogCollectorStatus;
import com.adventnet.sa.server.nf.NotificationManager;
import com.adventnet.sa.server.util.CommonUtil;
import com.adventnet.sa.server.util.DBDiagnostics;
import com.adventnet.sa.server.util.RegistryUtil;
import com.adventnet.sa.server.vul.VulnInput;
import com.adventnet.sym.winaccess.AgentStatusUpdate;
import com.adventnet.sym.winaccess.AgentUpdate;
import com.adventnet.sym.winaccess.AgentUpgrader;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import com.manageengine.ela.server.common.device.autoconfig.InitialDeviceConfiguration;
import com.manageengine.ela.server.common.discovery.DiscoveryHandler;
import com.manageengine.ela.server.common.license.LicenseComponents;
import com.manageengine.ela.server.common.license.LicenseHandler;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import com.manageengine.ela.server.common.response.BaseStatusCode;
import com.manageengine.ela.server.common.security.ELAEncryptionAPI;
import com.manageengine.ela.server.common.security.ScharKeyHandler;
import com.manageengine.ela.server.correlation.config.CorrelationRuleHandler;
import com.manageengine.ela.server.correlation.session.ActivityHandler;
import com.manageengine.ela.server.importlog.ImportLogMigrationUtil;
import com.manageengine.ela.server.importlog.ImportScheduler;
import com.manageengine.ela.server.logflowrate.LogFlowRateUtil;
import com.me.tools.zcutil.METrack;
import com.zoho.za.dae.elastic.Node;
import com.zoho.za.dae.utils.ElasticUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.client.Client;
import org.json.JSONObject;

public class EAService
implements Service {
    private static final Logger LOGGER = Logger.getLogger(EAService.class.getName());
    SyslogServer sysListener = null;
    SyslogServer eventListener = null;
    SyslogServer oracleListener = null;
    private static EAService elLic = null;
    private ExportCleanup cleanup;
    private static boolean showPremiumFeatures = true;
    public static boolean freeSpace = true;
    private boolean isServerShutdown = false;
    private static boolean diskspaceaction = false;
    private boolean isConverted = false;
    private static Process sshProcess = null;
    public static Object onceTaskId = null;
    public static Object periodicTaskId = null;
    private Persistence persistence = null;
    private static long startTime;
    private static long startHourTime;
    private static long packetCount;
    private static long logHourCount;
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture flowScheduler = null;
    private MigrateIndexThread migrateIndexThread = null;
    private int prevLogHourRate = 0;
    private HighAvailability ipChange = null;
    public static Map<String, Long> slUpdateConst;
    public static final String ME_LOG360 = "ManageEngine Log360";
    public static boolean serviceInstallAlertTrigger;
    boolean isAdminServer = false;

    public static EAService getInstance() {
        if (elLic == null) {
            elLic = new EAService();
        }
        return elLic;
    }

    public void resetLicense() {
        LOGGER.info("Reloading license cache");
        LicenseHandler.getInstance().reLoadLicenseCache();
        this.getLicenseDetails();
        this.changeLiveULP();
        this.serverReportsCheck();
    }

    private void serverReportsCheck() {
        boolean isServerReportsCOnfigured = true;
        try {
            isServerReportsCOnfigured = LicenseHandler.getInstance().isADServerReportsEnabled();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        System.setProperty("IS_SERVERREPORTS_SHOW", "" + isServerReportsCOnfigured);
    }

    private void getLicenseDetails() {
        LicenseComponents.LicenseCategory licenseCat = LicenseHandler.getInstance().getLicenseCategory();
        if (licenseCat == LicenseComponents.LicenseCategory.PROFESSIONALNG || licenseCat == LicenseComponents.LicenseCategory.FREEEDITION) {
            showPremiumFeatures = false;
            System.setProperty("isPremium", "false");
        } else {
            showPremiumFeatures = true;
            System.setProperty("isPremium", "true");
        }
    }

    public void changeLiveULP() {
        try {
            DataObject doo = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"liveULP", 0));
            String conf = null;
            conf = "false".equals(System.getProperty("isPremium", "false")) ? "false" : System.getProperty("liveULP", "true");
            Row newRow = new Row("SystemConfigurations");
            newRow.set("CONF_NAME", (Object)"liveULP");
            newRow.set("CONF_VALUE", (Object)conf);
            if (doo.isEmpty()) {
                doo.addRow(newRow);
                DataAccess.add((DataObject)doo);
            } else {
                doo.updateRow(newRow);
                DataAccess.update((DataObject)doo);
            }
        }
        catch (Exception excpn) {
            excpn.printStackTrace();
        }
    }

    public boolean licenseCheck() {
        try {
            LicenseHandler handler = LicenseHandler.getInstance();
            int noOfLicense = handler.getTotalLicensesForOldCheck();
            int noOfHosts = handler.getTotalConfiguredELADevice() + handler.getTotalConfiguredELAApplicationDevice();
            return handler.getLicenseType() != LicenseComponents.LicenseType.FREE || noOfHosts <= noOfLicense;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void create(DataObject serviceDO) {
        LOGGER.log(Level.FINER, "event analyzer Service.createService invoked");
    }

    public void start() throws Exception {
        boolean isMssql;
        LOGGER.log(Level.FINER, "EventLog Analyzer Service.startService Invoked");
        if (!ServerDetailsBean.getInstance().isAdminServer() && !CorrelationRuleHandler.isCorrelationRulesInitialized()) {
            try {
                LOGGER.log(Level.FINER, "Booting Correlation Engine");
                CorrelationRuleHandler.initializeCorrelationRules();
                LOGGER.log(Level.FINER, "Booting Session Activity Engine");
                ActivityHandler.initializeActivities();
            }
            catch (Exception exp) {
                LOGGER.log(Level.INFO, "Correlation Engine failed to boot");
                exp.printStackTrace();
            }
        }
        Thread.setDefaultUncaughtExceptionHandler(new ELAExceptionHandler());
        this.startMemoryListener();
        if (System.getProperty("com.adventnet.la.showtray") != null && "true".equals(System.getProperty("com.adventnet.la.showtray"))) {
            boolean showTray = true;
            String confFileName = System.getProperty("server.home") + File.separator + "conf" + File.separator + "client_params.conf";
            try {
                Properties props = StartupUtil.getProperties((String)confFileName);
                showTray = Boolean.parseBoolean(props.getProperty("LAUNCH_TRAY_ICON"));
                LOGGER.log(Level.INFO, "LAUNCH_TRAY_ICON = " + showTray);
                if (!showTray) {
                    props.setProperty("LAUNCH_TRAY_ICON", "true");
                    StartupUtil.storeProperties((Properties)props, (String)confFileName);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Problem in reading client params" + e.getMessage());
            }
            if (showTray) {
                this.initializeTray();
            }
        }
        if (System.getProperty("disableDropTableFix") == null) {
            this.createTables();
        }
        if (System.getProperty("remoteIp") != null && System.getProperty("localIp") != null && System.getProperty("virtualIp") != null) {
            LOGGER.log(Level.INFO, "Called HighAvailability.IpChange()");
            this.ipChange = new HighAvailability();
            this.ipChange.getIp("..\\tools\\");
        }
        this.resetLicense();
        this.isAdminServer = this.checkInstallationType();
        this.regenerateSQLForMigration();
        String lang = this.getLanguage();
        if (this.getColdStartStauts() == 0) {
            this.startScannerSearch();
            this.updateSeqGenState();
            this.updateColdStartStatus();
            this.updateBuildProperties();
            if (System.getProperty("os.name").contains("indows")) {
                ELSInitializer.createDblink();
            }
            this.deleteUnwantedXML();
        }
        boolean bl = isMssql = "mssql".equals(System.getProperty("DBType", "postgres"));
        if (isMssql) {
            this.setSQLAuthenticationType();
        }
        boolean updateScharValues = false;
        if (ELAEncryptionAPI.getSecureKey(null, 3) == null) {
            LOGGER.info("getSecureKey is null so need to update schar values");
            updateScharValues = true;
        }
        ELAEncryptionAPI.initializeELAED();
        if (updateScharValues && !isMssql) {
            LOGGER.info("getSecureKey is null update schar values method called");
            ScharKeyHandler.handleScharXmlPopulatedValues();
        }
        this.setHighFlowParams();
        this.insertSystemConfigurations();
        this.getELAConfigurationDetails();
        EAService.initSLUpdateConstants();
        LOGGER.log(Level.INFO, "EAService.startService() Finished calling EnterpriseStartUpUtil........");
        EAService.setDynamicEncryption();
        this.migrateImportTrendTables();
        this.startSQLServerDiscovery();
        if (this.isAdminServer) {
            this.checkForCentralArchive();
            LOGGER.log(Level.INFO, "EAService inside isAdminServer check ....... and returning !! ");
            this.checkForEnterpriseMigration_11130();
            this.initMETracker();
            return;
        }
        LogIndexingAPI.getInstance().setBatchDelimiters("<-->", "<__>", "<-->");
        if ("ja".equals(lang) || "zh".equals(lang)) {
            LOGGER.info("Setting CJK Analyzer for ja/zh");
            LogIndexingAPI.getInstance().setAnalyzer(LuceneConstants.CJK_ANALYZER);
        } else {
            LogIndexingAPI.getInstance().setAnalyzer(LuceneConstants.PER_FIELD_ANALYZER);
        }
        LuceneUtil.initForELA();
        FieldRepository.get_instance().addIndexFields();
        this.checkportStatus();
        SystemCustomPatternHandler.getInstance().setLogFormatHandlerObj((LogFormatHandler)LogFormatHandlerImpl.getInstance());
        this.startListener();
        this.populateLogType();
        this.populateFreeSpce();
        if (!showPremiumFeatures) {
            LOGGER.log(Level.INFO, "Customized Premium report tabs are deleted in Non premium edition");
            this.deleteReportSelectedTab();
        }
        if (!this.licenseCheck()) {
            ImportSysEvtLogManager.setSuspendImport(true);
            ImportAppLogManager.setSuspendImport(true);
            LOGGER.log(Level.INFO, "Log Collection & Import stopped, due to License Expiry ");
        }
        this.startElaDownAlert();
        if (freeSpace) {
            LOGGER.log(Level.INFO, "LogCollector: Starting Log Collector process.");
            LogCollectorProcess.getInstance().start();
        }
        this.startDomainDiscovery();
        new Thread(new ScheduledImportTaskHandler()).start();
        this.archiveRetention();
        this.startLogAlert();
        this.invokeSubscribe();
        ELAAuditImpl.init();
        LOGGER.log(Level.INFO, "Calling ExportCleanup Thread frm startService()");
        this.cleanup = new ExportCleanup();
        ArchiveConstants.getInstance().loadArchiveSettings();
        ArchiveFileManager.getInstance().init();
        NotificationManager.getInstance().init();
        LogForwarderFilter.getInstance().init();
        DataQueueHandler.getInstance();
        VulnInput.getInstance();
        VCenterTaskScheduler.getInstance().shutdown();
        TableArchiverUtil.reinitialiseArchive();
        if (this.isConvertedMS()) {
            this.restartAgents();
        }
        this.updateAgentDetails();
        this.initMETracker();
        this.initPromotioninELA();
        if (!this.isAdminServer) {
            DBDiagnostics.getInstance().runPeriodically();
        }
        this.invokeFlowRate();
        if (new File(LogIndexingAPI.getInstance().getIndexDirPath() + File.separator + "cold.properties").exists() || new File(LogIndexingAPI.getInstance().getIndexDirPath() + File.separator + "hot.properties").exists()) {
            try {
                this.migrateIndexThread = new MigrateIndexThread();
                new Thread((Runnable)this.migrateIndexThread, "luceneMigrateIndexThread").start();
            }
            catch (Exception ex) {
                LOGGER.warning("Exception while starting migrateIndex thread at startup");
            }
        } else {
            LOGGER.info("No migration properties found, not starting the thread");
        }
        this.licenseAlertMailStart();
        this.serviceInstallAlert();
    }

    private void initPromotioninELA() {
        try {
            JSONObject productDetails = com.manageengine.ads.fw.util.CommonUtil.getADSProductDetails((String)com.manageengine.ads.fw.util.CommonUtil.getProductName());
            String displayName = (String)productDetails.get("DISPLAY_NAME");
            String leadProduct = RegistryUtil.getValueByKey(displayName, "LeadProduct");
            if (displayName != null) {
                System.setProperty("ADS_PRODUCT_DISPLAY_NAME", displayName);
            }
            if (null != leadProduct) {
                System.setProperty("LeadProduct", leadProduct);
            }
            LOGGER.log(Level.INFO, "Lead product value found from registry is : " + leadProduct);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "An exception occured while reading lead product from registry");
        }
    }

    private void invokeSubscribe() {
        try {
            new ELAAuditMessageSubscriber().subscribeAudit();
        }
        catch (Exception ae) {
            ae.printStackTrace();
        }
    }

    private void invokeFlowRate() {
        long initDelay = 3600L;
        this.scheduler.scheduleAtFixedRate(new flowRateScheduler(), initDelay, initDelay, TimeUnit.SECONDS);
    }

    private void startMemoryListener() throws Exception {
        ELAMemoryWarning elamw = new ELAMemoryWarning();
        elamw.addListener(new ELAMemoryHandling());
    }

    private void initMETracker() {
        try {
            boolean isMETrackEnabled = true;
            String confDir = System.getProperty("server.home") + File.separator + "server" + File.separator + "conf";
            METrack me = new METrack(confDir, System.getProperty("server.home"), "mickeylite", null);
            DataObject dobj = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"isMETrackerEnabled", 0));
            if (!dobj.isEmpty()) {
                isMETrackEnabled = "true".equals((String)dobj.getFirstValue("SystemConfigurations", "CONF_VALUE"));
            }
            if (isMETrackEnabled) {
                Thread metrack = new Thread((Runnable)me);
                metrack.start();
            } else {
                METrack.disable();
            }
        }
        catch (Exception exp) {
            LOGGER.log(Level.WARNING, " Exception while initializing ME Tracker ", exp);
        }
    }

    private void checkportStatus() {
        try {
            DataAccess.delete((Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"failedPorts", 0));
            int[] udpport = new int[]{Integer.parseInt(System.getProperty("sysPort", "5000")), Integer.parseInt(System.getProperty("evtPort", "5001")), Integer.parseInt(System.getProperty("orclPort", "5002"))};
            String failedPorts = "";
            ELAPortCheckerUtil udpforwdport = new ELAPortCheckerUtil();
            DataObject udpDO = DataAccess.constructDataObject();
            for (int i = 0; i < udpport.length; ++i) {
                if (udpforwdport.checkPortAvailability(udpport[i], false)) continue;
                failedPorts = failedPorts + udpport[i] + " ";
            }
            if (!"".equals(failedPorts)) {
                Row fprow = new Row("SystemConfigurations");
                fprow.set("CONF_NAME", (Object)"failedPorts");
                fprow.set("CONF_VALUE", (Object)failedPorts);
                udpDO.addRow(fprow);
                DataAccess.add((DataObject)udpDO);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startListener() {
        RecordStore.init();
        int sysPort = Integer.parseInt(System.getProperty("sysPort", "5000"));
        int evtPort = Integer.parseInt(System.getProperty("evtPort", "5001"));
        int orclPort = Integer.parseInt(System.getProperty("orclPort", "5002"));
        this.sysListener = new SyslogServer(sysPort);
        this.eventListener = new SyslogServer(evtPort);
        this.oracleListener = new SyslogServer(orclPort);
    }

    public int getExceededLogHourRate() {
        int logHourRate = 0;
        if (!this.isAdminServer) {
            logHourRate = this.prevLogHourRate;
            if (System.currentTimeMillis() - startTime >= 300000L) {
                try {
                    String logRateStr = this.getlogRate();
                    LOGGER.log(Level.FINER, "logRateStr = {0} & System.getProperty(maxFlowRate) = {1}", new Object[]{logRateStr, System.getProperty("maxFlowRate", "5000")});
                    logHourRate = Integer.parseInt(logRateStr.split(",")[4]);
                    if (Integer.parseInt(System.getProperty("maxFlowRate", "5000")) >= logHourRate) {
                        logHourRate = 0;
                    }
                    this.prevLogHourRate = logHourRate;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return logHourRate;
    }

    public String getlogRate() {
        ResourceBundle bundle = ProductBundle.getInstance().getBundle();
        long currentTime = System.currentTimeMillis();
        long timeDiff = currentTime - startTime;
        long hourtimeDiff = currentTime - startHourTime;
        String strTimeDiff = new DefaultDataFormatter().formatDuration((int)timeDiff / 1000).trim();
        String[] tempTimeDiff = strTimeDiff.split(" ");
        String strSecTimeDiff = "";
        for (int i = 0; i < tempTimeDiff.length; ++i) {
            strSecTimeDiff = tempTimeDiff[i].trim().matches("[0-9]+") ? strSecTimeDiff + tempTimeDiff[i] + " " : strSecTimeDiff + bundle.getString("DataFormater." + tempTimeDiff[i]) + " ";
        }
        String strHourDiff = new DefaultDataFormatter().formatDuration((int)hourtimeDiff / 1000).trim();
        tempTimeDiff = strHourDiff.split(" ");
        String strHourTimeDiff = "";
        for (int i = 0; i < tempTimeDiff.length; ++i) {
            strHourTimeDiff = tempTimeDiff[i].trim().matches("[0-9]+") ? strHourTimeDiff + tempTimeDiff[i] + " " : strHourTimeDiff + bundle.getString("DataFormater." + tempTimeDiff[i]) + " ";
        }
        long rate = 0L;
        long hourrate = 0L;
        long logCount = 0L;
        if (timeDiff != 0L) {
            logCount = SyslogServer.getLogCount();
            packetCount += logCount;
            logHourCount += logCount;
            rate = logCount * 1000L / timeDiff;
            SyslogServer.resetlogCounter();
        }
        if (hourtimeDiff != 0L) {
            hourrate = logHourCount * 1000L / hourtimeDiff;
        }
        String strRate = rate + "," + logCount + "," + strSecTimeDiff + "," + packetCount + "," + hourrate + "," + strHourTimeDiff;
        startTime = currentTime;
        return strRate;
    }

    public String getLogRateFromDB() throws DataAccessException {
        long currentTime = System.currentTimeMillis();
        long logCount = SyslogServer.getLogCount();
        long previousHourLogCount = LogFlowRateUtil.getPreviousHourLogCount();
        long previousHourLogRate = previousHourLogCount / 3600L;
        long timeDiff = currentTime - startHourTime;
        packetCount += logCount;
        logHourCount += logCount;
        SyslogServer.resetlogCounter();
        startTime = currentTime;
        ResourceBundle bundle = ProductBundle.getInstance().getBundle();
        String strHourDiff = new DefaultDataFormatter().formatDuration((int)timeDiff / 1000).trim();
        String[] tempTimeDiff = strHourDiff.split(" ");
        String strHourTimeDiff = "";
        for (int i = 0; i < tempTimeDiff.length; ++i) {
            strHourTimeDiff = tempTimeDiff[i].trim().matches("[0-9]+") ? strHourTimeDiff + tempTimeDiff[i] + " " : strHourTimeDiff + bundle.getString("DataFormater." + tempTimeDiff[i]) + " ";
        }
        long currentHourLogRate = 0L;
        if (timeDiff != 0L) {
            currentHourLogRate = logHourCount * 1000L / timeDiff;
        }
        String logRateStr = previousHourLogRate + "," + previousHourLogCount + "," + "hour" + "," + packetCount + "," + currentHourLogRate + "," + strHourDiff;
        return logRateStr;
    }

    private void initializeTray() {
        LOGGER.log(Level.INFO, "TRAYICON:::::initializing TrayIconThread");
        Thread trayIconThread = new Thread("TrayIconThread"){

            @Override
            public void run() {
                try {
                    ProductTrayIcon opcTrayIcon = new ProductTrayIcon("../server/conf/TrayIconInfo.xml");
                    opcTrayIcon.startAndRun();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        trayIconThread.start();
    }

    public static boolean isFreeSpaceAvailable() {
        return freeSpace;
    }

    public void stopImport() {
        String importKey = System.getProperty("importdiskcheck", "true");
        if ("false".equals(importKey)) {
            return;
        }
        ImportScheduler.setIsSuspended(true);
        ImportSysEvtLogManager.setSuspendImport(true);
        ImportAppLogManager.setSuspendImport(true);
    }

    private void createTables() {
        String[] module;
        for (String moduleName : module = new String[]{"EventLogAnalyzer", "Correlation"}) {
            this.createTables(moduleName);
        }
    }

    private void createTables(String moduleName) {
        try {
            String DBType2 = System.getProperty("DBType", "postgres");
            LOGGER.log(Level.FINER, "Executing drop table fix for module : " + moduleName);
            CreateSchema cs = new CreateSchema(RelationalAPI.getInstance().getDataSource());
            StringBuffer sb = new StringBuffer();
            sb.append(System.getProperty("server.home"));
            sb.append(File.separator);
            sb.append("conf");
            sb.append(File.separator);
            sb.append(moduleName);
            sb.append(File.separator);
            sb.append(DBType2);
            sb.append(File.separator);
            sb.append("DatabaseSchema.conf");
            File f = new File(sb.toString());
            cs.createSchemas(true, true, (InputStream)new FileInputStream(f));
            cs.createTables(moduleName);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while executing drop table fix for module : " + moduleName);
            e.printStackTrace();
        }
    }

    private void regenerateSQLForMigration() {
        block20: {
            try {
                DataObject regenSqlDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"regenerateSQL", 0));
                if (regenSqlDO.size("SystemConfigurations") <= 0) break block20;
                String confValue = (String)regenSqlDO.getFirstValue("SystemConfigurations", "CONF_VALUE");
                if ("true".equals(confValue)) {
                    LOGGER.log(Level.INFO, "Inside Queries Regenerate:");
                    this.isAdminServer = "true".equals(System.getProperty("isAdminServer", "false"));
                    LOGGER.log(Level.INFO, "isAdminServer:  " + this.isAdminServer);
                    boolean isDatabaseMigration = false;
                    DataObject dbMigrationDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"DatabaseMigration", 0));
                    if (dbMigrationDO.size("SystemConfigurations") > 0) {
                        isDatabaseMigration = true;
                    }
                    LOGGER.log(Level.INFO, "isDatabaseMigration:  " + isDatabaseMigration);
                    this.updateBuildProperties();
                    if (!this.isAdminServer) {
                        // empty if block
                    }
                    if (System.getProperty("os.name").contains("indows") && !this.isAdminServer) {
                        LOGGER.log(Level.INFO, "Restarting agents after upgrade");
                        try {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    EAService.this.restartAgents();
                                }
                            }).start();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Error while restarting agents " + e.getMessage());
                        }
                    }
                    if (!isDatabaseMigration) {
                        Properties eProps = EAService.getInstallProperties(new File(System.getProperty("server.home") + File.separator, "enterprise.txt"));
                        if (eProps != null && eProps.getProperty("isConverted") != null) {
                            this.isConverted = "true".equals(eProps.getProperty("isConverted"));
                        }
                        this.sendMail("upgraded");
                    }
                    if (isDatabaseMigration) {
                        DataAccess.delete((Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"regenerateSQL", 0).or(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"DatabaseMigration", 0)));
                        LOGGER.log(Level.INFO, "Database Migration done hence returning ..........");
                        return;
                    }
                    if (!this.isAdminServer) {
                        try {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        EAService.this.migrateAlerts();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            }).start();
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Error while migrating alerts " + e.getMessage());
                        }
                    } else {
                        try {
                            PersistenceDBUtil.getPersistence().dropTable("LAAlertAudit_old");
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Error while dropping  LAAlertAudit_old table" + e.getMessage());
                        }
                    }
                    if (this.isAdminServer) {
                        try {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    LOGGER.info("Deleting admin server entries for alert related tables");
                                    try {
                                        DeleteQueryImpl query = new DeleteQueryImpl("LAAlertAudit");
                                        query.setCriteria(null);
                                        DataAccess.delete((DeleteQuery)query);
                                        query = new DeleteQueryImpl("ELA_AlertComments");
                                        query.setCriteria(null);
                                        DataAccess.delete((DeleteQuery)query);
                                        query = new DeleteQueryImpl("ELA_AlertAssignMapping");
                                        query.setCriteria(null);
                                        DataAccess.delete((DeleteQuery)query);
                                    }
                                    catch (Exception e) {
                                        LOGGER.info("Error while deleting alert tables " + e.getMessage());
                                    }
                                }
                            }).start();
                        }
                        catch (Exception e) {
                            LOGGER.info("Error while deleting alert tables " + e.getMessage());
                        }
                    }
                }
                DataAccess.delete((Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"regenerateSQL", 0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void migrateAlerts() throws DataAccessException, SQLException {
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"LAAlertAudit_old"));
        sql.addSelectColumn(Column.getColumn((String)"LAAlertAudit_old", (String)"*"));
        sql.addSortColumn(new SortColumn(Column.getColumn((String)"LAAlertAudit_old", (String)"AUDIT_ID"), false));
        int start = 0;
        int limit = 100;
        boolean isProcess = true;
        Long group = 0L;
        Long count = 0L;
        while (isProcess) {
            Long l = group;
            Long l2 = group = Long.valueOf(group + 1L);
            isProcess = false;
            LOGGER.log(Level.INFO, "Processing Alerts group: " + group + " Range : " + limit);
            sql.setRange(new Range(start, limit));
            DataObject doo = PersistenceDBUtil.getPersistence().get((SelectQuery)sql);
            Iterator it = doo.getRows("LAAlertAudit_old");
            DataObject ob = DataAccess.constructDataObject();
            while (it.hasNext()) {
                isProcess = true;
                Row r = (Row)it.next();
                Row r1 = new Row("LAAlertAudit");
                r1.set("NF_ID", r.get("NF_ID"));
                r1.set("NOTIFIEDTIME", r.get("NOTIFIEDTIME"));
                r1.set("TYPE", r.get("TYPE"));
                r1.set("SOURCE", r.get("SOURCE"));
                r1.set("STATUS", r.get("STATUS"));
                r1.set("CRITICALITY", r.get("CRITICALITY"));
                r1.set("ERROR_DETAILS", r.get("ERROR_DETAILS"));
                r1.set("RECORD_COLUMN", r.get("RECORD_COLUMN"));
                r1.set("RECORD_ID", r.get("RECORD_ID"));
                r1.set("OWNERNAME", r.get("OWNERNAME"));
                ob.addRow(r1);
                Long l3 = count;
                Long l4 = count = Long.valueOf(count + 1L);
            }
            if (!isProcess) continue;
            LOGGER.log(Level.INFO, "Processing Row Count : " + count);
            PersistenceDBUtil.getPersistence().update(ob);
            start += 100;
        }
        PersistenceDBUtil.getPersistence().dropTable("LAAlertAudit_old");
    }

    private void migrateMailServerSettings() {
        try {
            DataObject d = DataAccess.get((String)"ADSMailSettings", (Criteria)null);
            d.deleteRows("ADSMailSettings", (Criteria)null);
            DataAccess.update((DataObject)d);
            DataObject ob = DataAccess.constructDataObject();
            Table table = new Table("MailServerSettings");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            sql.addSelectColumn(new Column("MailServerSettings", "*"));
            DataObject doo = DataAccess.get((SelectQuery)sql);
            LOGGER.log(Level.INFO, "MailServerSettings" + doo);
            if (doo != null) {
                Row mailSettings = doo.getRow("MailServerSettings");
                if (mailSettings != null) {
                    Row r1 = new Row("ADSMailSettings");
                    r1.set("SERVER_NAME", mailSettings.get("SMTPSERVER"));
                    r1.set("PORT", mailSettings.get("SMTPSERVERPORT"));
                    r1.set("USER_NAME", mailSettings.get("USERNAME"));
                    r1.set("PASSWORD", mailSettings.get("PASSWORD"));
                    r1.set("FROM_MAIL_ID", mailSettings.get("SENDER_MAILID"));
                    r1.set("ADMIN_MAIL_ID", mailSettings.get("SENDER_MAILID"));
                    String isTls = (String)mailSettings.get("ACTIVE_TLS");
                    table = new Table("ADSConnectionSecurity");
                    SelectQueryImpl sql1 = new SelectQueryImpl(table);
                    sql1.addSelectColumn(new Column("ADSConnectionSecurity", "*"));
                    DataObject dobj = DataAccess.get((SelectQuery)sql1);
                    Long connectionid = (Long)dobj.getValue("ADSConnectionSecurity", "CONNECTION_SECURITY_ID", new Criteria(new Column("ADSConnectionSecurity", "NAME"), (Object)isTls, 0, false));
                    r1.set("CONNECTION_SECURITY_ID", (Object)connectionid);
                    ob.addRow(r1);
                }
                LOGGER.log(Level.INFO, "ADSMailSettings" + ob);
                if (!ob.isEmpty()) {
                    DataAccess.add((DataObject)ob);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "An exception has occured while migrating mail settings");
            e.printStackTrace();
        }
    }

    public void stop() throws Exception {
        LOGGER.log(Level.INFO, "event analyzer Service.stopService invoked");
        boolean bl = this.isAdminServer = "true".equals(System.getProperty("isAdminServer", "false"));
        if (this.isAdminServer) {
            EAService.stopSSHServer();
            LOGGER.log(Level.INFO, "EAStopService inside isAdminServer check ....... and returning !! ");
            return;
        }
        if (this.ipChange != null) {
            this.ipChange.removeIp(System.getProperty("server.dir"));
        }
        ImportAppLogManager.get_instance().shutdown();
        ImportSysEvtLogManager.get_instance().shutdown();
        DataQueueHandler.getInstance().shutdown();
        VulnInput.getInstance().shutdown();
        this.cleanup.stopCleanUp();
        LOGGER.log(Level.INFO, "Called ExportCleanup() stopCleanUp()");
        ArchiveFileManager.getInstance().shutdown();
        LogCollectorProcess.getInstance().stop(LogCollectorStatus.STOPPED_SHUTDOWN);
        this.stopListener();
        CommonUtil.updateSysConfiguration("SQL_Discovery", "2", true);
        LogIndexingAPI.getInstance().handleShutDown();
    }

    private void stopListener() {
        this.sysListener.stopServer();
        this.eventListener.stopServer();
        this.oracleListener.stopServer();
        try {
            RecordStore.destroy();
            this.sysListener.join();
            this.eventListener.join();
            this.oracleListener.join();
        }
        catch (InterruptedException e) {
            LOGGER.info("Exception while waiting for thread to close");
        }
    }

    private void resetDiscoveryStatusTable() throws DataAccessException {
        SelectQueryImpl sql = new SelectQueryImpl(Table.getTable((String)"ELADiscoveryStatus"));
        sql.addSelectColumn(Column.getColumn((String)"ELADiscoveryStatus", (String)"*"));
        DataObject dobj = PersistenceDBUtil.getPersistenceLite().get((SelectQuery)sql);
        BaseStatusCode status = BaseStatusCode.getBaseStatusCode(9734);
        Iterator itr = dobj.getRows("ELADiscoveryStatus");
        while (itr.hasNext()) {
            Row row = (Row)itr.next();
            if (!((Boolean)row.get("STATUS_FLAG")).booleanValue()) continue;
            row.set("STATUS_FLAG", (Object)false);
            row.set("STATUS_CODE", (Object)Long.valueOf(status.getStatusCode()));
            row.set("STATUS_MESSAGE", (Object)status.getDisplayTextKey());
            dobj.updateRow(row);
        }
        PersistenceDBUtil.getPersistence().update(dobj);
    }

    private boolean startDomainDiscovery() {
        try {
            return InitialDeviceConfiguration.startConfiguration();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return false;
        }
    }

    private void startSQLServerDiscovery() {
        try {
            String flag = (String)CommonUtil.getSysConfiguration("SQL_Discovery");
            if (flag != null && Integer.parseInt(flag) == 3) {
                LOGGER.info("SQL Discovery aaramchiten !");
                DiscoveryHandler.startSQLServerDiscovery();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startScheduledImportTask() throws Exception {
        if (this.licenseCheck()) {
            LOGGER.log(Level.INFO, "Inside startScheduledImportTask() for OS:" + System.getProperty("os.name"));
            try {
                if (System.getProperty("os.name").indexOf("indows") < 0) {
                    LOGGER.log(Level.INFO, "Importing EVT files is not supported for the OS [" + System.getProperty("os.name") + "]");
                }
                ImportAppLogManager.get_instance();
                ImportSysEvtLogManager.get_instance();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, "In EAService: Exception while starting the scheduled imported tasks:" + e);
                e.printStackTrace();
            }
        }
    }

    private void populateLogType() {
        String[] logTypes = new String[]{"Application", "Security", "System", "DNS Server", "File Replication Service", "Directory Service"};
        ArrayList<Integer> logTypeValues = new ArrayList<Integer>();
        logTypeValues.add(new Integer(0));
        logTypeValues.add(new Integer(1));
        logTypeValues.add(new Integer(2));
        logTypeValues.add(new Integer(27));
        logTypeValues.add(new Integer(28));
        logTypeValues.add(new Integer(29));
        try {
            DataObject dobj = DataAccess.constructDataObject();
            SelectQueryImpl sql = new SelectQueryImpl(new Table("LogTypeMapping"));
            sql.addSelectColumn(new Column("LogTypeMapping", "*"));
            dobj = DataAccess.get((SelectQuery)sql);
            if (dobj.isEmpty()) {
                dobj = DataAccess.constructDataObject();
                for (int i = 0; i < logTypes.length; ++i) {
                    Row lrow = new Row("LogTypeMapping");
                    lrow.set("LTYPE", (Object)logTypes[i]);
                    lrow.set("LVALUE", logTypeValues.get(i));
                    dobj.addRow(lrow);
                }
                DataAccess.add((DataObject)dobj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getColdStartStauts() throws Exception {
        int coldStartStatus = 1;
        try {
            SelectQueryImpl sql = new SelectQueryImpl(new Table("SystemConfigurations"));
            sql.addSelectColumn(new Column("SystemConfigurations", "*"));
            sql.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"ColdStart", 0));
            DataObject configDO = DataAccess.get((SelectQuery)sql);
            LOGGER.log(Level.FINER, "SystemConfigurans ::::::::  " + configDO);
            if (configDO.size("SystemConfigurations") > 0) {
                coldStartStatus = Integer.parseInt((String)configDO.getFirstValue("SystemConfigurations", "CONF_VALUE"));
            }
            LOGGER.log(Level.INFO, "ColdStart Status <-> " + coldStartStatus);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return coldStartStatus;
    }

    public void updateColdStartStatus() throws Exception {
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("SystemConfigurations");
            uq.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"ColdStart", 0));
            uq.setUpdateColumn("CONF_VALUE", (Object)"1");
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while update cold start status");
            e.printStackTrace();
        }
    }

    private void updateSeqGenState() throws Exception {
        try {
            File enterpriseTxtFile = new File(System.getProperty("server.home") + File.separator + "enterprise.txt");
            if (enterpriseTxtFile.exists()) {
                Properties enterpriseProp = new Properties();
                enterpriseProp.load(new FileInputStream(enterpriseTxtFile));
                String serverType = enterpriseProp.getProperty("server.type");
                String startId = enterpriseProp.getProperty("server.startidrange");
                if ("DS".equals(serverType)) {
                    SelectQueryImpl sql = new SelectQueryImpl(new Table("SeqGenState"));
                    sql.addSelectColumn(new Column("SeqGenState", "*"));
                    DataObject seqDO = DataAccess.get((SelectQuery)sql);
                    String[] seqName = new String[]{"SyslogServers.SLID", "Hosts.HOST_ID", "LAAlertAudit.AuditID", "SysArchivedFiles.AFID"};
                    for (int i = 0; i < seqName.length; ++i) {
                        Row seqRow = seqDO.getRow("SeqGenState", new Criteria(new Column("SeqGenState", "SEQNAME"), (Object)seqName[i], 0));
                        if (seqRow != null) continue;
                        seqRow = new Row("SeqGenState");
                        seqRow.set("SEQNAME", (Object)seqName[i]);
                        seqRow.set("CURRENTBATCHEND", (Object)new Long(startId));
                        seqDO.addRow(seqRow);
                    }
                    DataAccess.update((DataObject)seqDO);
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void startScannerSearch() throws Exception {
        try {
            String line;
            Process pr = ELSInitializer.startScannerSearch(null);
            if (pr == null) {
                return;
            }
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            while ((line = input.readLine()) != null) {
            }
            input.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    public void destroy() throws Exception {
    }

    public void archiveRetention() {
        ArchiveProcessor archivePurge = new ArchiveProcessor();
        ClockDaemon scheduleArchiveDeletion = new ClockDaemon();
        scheduleArchiveDeletion.executePeriodically(43200000L, (Runnable)archivePurge, false);
    }

    public void startLogAlert() {
        try {
            String ThreadStatus = null;
            DataObject obj = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"LAlertStatus", 0));
            if (obj.size("SystemConfigurations") > 0) {
                ThreadStatus = (String)obj.getFirstValue("SystemConfigurations", "CONF_VALUE");
            }
            if ("0".equals(ThreadStatus) || "2".equals(ThreadStatus)) {
                if ("0".equals(ThreadStatus)) {
                    UpdateQueryImpl updatequery = new UpdateQueryImpl("SystemConfigurations");
                    updatequery.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"LAlertStatus", 0));
                    updatequery.setUpdateColumn("CONF_VALUE", (Object)"2");
                    DataAccess.update((UpdateQuery)updatequery);
                }
                LogAlert lalt = new LogAlert();
                ClockDaemon lAlert = new ClockDaemon();
                Object taskid = lAlert.executePeriodically(120000L, (Runnable)lalt, false);
                lalt.setTaskID(taskid);
                LOGGER.log(Level.INFO, "Log Alert Thread Started From EAService");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startElaDownAlert() {
        try {
            LOGGER.log(Level.INFO, "ELA Down Alert Thread Started From EAService");
            DiskSpaceCheck diskmon = new DiskSpaceCheck();
            ClockDaemon sAlert = new ClockDaemon();
            Object thread = sAlert.executePeriodically(900000L, (Runnable)diskmon, true);
            diskmon.set(thread);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while calling ELA DOWN ALERT thread");
            e.printStackTrace();
        }
    }

    private void licenseAlertMailStart() {
        ClockDaemon scheduleLicenseMail = new ClockDaemon();
        scheduleLicenseMail.executePeriodically(86400000L, (Runnable)new LicenseAlertMail(), true);
    }

    private void serviceInstallAlert() {
        if (!ElasticUtils.getIndicesSet((Client)Node.getClient(), (String)"logs_").isEmpty() || !ElasticUtils.getIndicesSet((Client)Node.getClient(), (String)"corr_").isEmpty()) {
            LOGGER.fine("serviceInstallAlertTrigger is set while checking indexset");
            serviceInstallAlertTrigger = true;
        } else {
            LOGGER.fine("Will set trigger after 24 hrs :86400000");
            ClockDaemon scheduleServiceAlert2 = new ClockDaemon();
            scheduleServiceAlert2.executeAfterDelay(86400000L, (Runnable)new scheduleServiceAlert());
        }
    }

    private void LicenseExpired_45days() {
        try {
            LogCollectorProcess.getInstance().stop(LogCollectorStatus.STOPPED_LICENSEEXPIRED);
            ImportSysEvtLogManager.setSuspendImport(true);
            ImportAppLogManager.setSuspendImport(true);
            LOGGER.log(Level.INFO, "Log Collection & Import stopped, on License grace period Expiry ");
            this.sendMail("licenseMessage_45days");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean showPremiumFeatures() {
        return showPremiumFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLanguage() {
        String fileName = System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + "install_lang.txt";
        File file = new File(fileName);
        String installedLang = null;
        if (file.exists()) {
            FileInputStream fi = null;
            Properties installProp = new Properties();
            try {
                fi = new FileInputStream(file);
                installProp.load(fi);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (Exception exception) {}
            }
            installedLang = (String)installProp.get("language");
            if (installedLang == null) {
                installedLang = "en";
            }
        }
        return installedLang.toLowerCase();
    }

    private void getELAConfigurationDetails() {
        String[] params = new String[]{"GDPRCompliant", "EC_range", "EC_diskSpace", "EC_showRowsTopN", "EC_pdfCompliance", "EC_pdfCustom", "EC_pdfDirect", "EC_pdfReport", "EC_reportTimeOut", "EC_dailyMailLimit", "EC_dailySMSLimit", "mailLimitStatus", "EC_ReportSave", "EC_reportSavePath", "EC_AlertMailFormat", "sysEnableArchiving", "sysEnableArchiveEncrypt", "filtBeforeArch", "mvWarmFiles", "Correlation_dailyMailLimit", "Correlation_dailySMSLimit", "CorrelationEngine", "Correlation_Operator", "Correlation_Guest", "Correlation_Email", "Correlation_SMS", "EC_AddOPMHost", "IS_ADAP_ACTIVATED", "CorrelationNetworkLogonType", "DataPoller_MaxThread", "DataPoller_DynamicTiming", "DataPoller_CachedRecordCount", "EC_RunQuery", "EC_HistoricLogs", "Activity_ppm_upd_time"};
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria cri = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)params, 8);
            query.setCriteria(cri);
            DataObject obj = DataAccess.get((SelectQuery)query);
            Iterator iter = obj.getRows("SystemConfigurations");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String confName = (String)row.get("CONF_NAME");
                String confValue = (String)row.get("CONF_VALUE");
                System.setProperty(confName, confValue);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Long getSLUpdateConstant(String key) {
        if (slUpdateConst.isEmpty()) {
            EAService.initSLUpdateConstants();
        }
        return slUpdateConst.get(key);
    }

    private static void initSLUpdateConstants() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SLUpdateConstant"));
            query.addSelectColumn(new Column("SLUpdateConstant", "*"));
            DataObject obj = DataAccess.get((SelectQuery)query);
            Iterator iter = obj.getRows("SLUpdateConstant");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                slUpdateConst.put((String)row.get("NAME"), (Long)row.get("VALUE"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setSQLAuthenticationType() {
        try {
            String dbConFile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
            File dbFile = new File(dbConFile);
            if (dbFile.exists()) {
                Properties dbProp = this.getDBProperies(dbFile);
                String connectionUrl = dbProp.getProperty("url");
                if (connectionUrl.indexOf("Domain=") != -1 || !dbProp.containsKey("username")) {
                    System.setProperty("isWinAuthType", "true");
                } else {
                    System.setProperty("isWinAuthType", "false");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getDBProperies(File dbConfFile) {
        Properties dbProp = new Properties();
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(dbConfFile);
            dbProp.load(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return dbProp;
    }

    private boolean checkInstallationType() {
        long start = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "EAService: Inside checkInstallationType() ....");
        String enterpriseTxt = System.getProperty("server.home") + File.separator + "enterprise.txt";
        File enterpriseTxtFile = new File(enterpriseTxt);
        if (!enterpriseTxtFile.exists()) {
            return false;
        }
        try {
            StartUPUtil sUtil = StartUPUtil.getInstance();
            sUtil.initialize();
            this.isAdminServer = sUtil.isAdminServer();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        long totalTimeTaken = System.currentTimeMillis() - start;
        LOGGER.log(Level.INFO, "total time consumed for checking installation type is " + totalTimeTaken);
        return this.isAdminServer;
    }

    private void checkForCentralArchive() {
        try {
            DataObject sysConfigDO = DataAccess.get((String)"SystemConfigurations", (Criteria)null);
            Criteria nameCrit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"centralArchiveStatus", 0);
            Criteria valueCrit = new Criteria(new Column("SystemConfigurations", "CONF_VALUE"), (Object)"true", 0);
            Row statusRow = sysConfigDO.getRow("SystemConfigurations", nameCrit.and(valueCrit));
            if (statusRow == null) {
                return;
            }
            String sshServerName = "";
            String sshUserName = "";
            String sshPassword = "";
            String sshPort = "";
            String sshHome = "";
            Iterator sshItr = sysConfigDO.getRows("SystemConfigurations");
            while (sshItr.hasNext()) {
                Row sshRow = (Row)sshItr.next();
                if ("SSHServerName".equals((String)sshRow.get("CONF_NAME"))) {
                    sshServerName = (String)sshRow.get("CONF_VALUE");
                    continue;
                }
                if ("SSHUserName".equals((String)sshRow.get("CONF_NAME"))) {
                    sshUserName = (String)sshRow.get("CONF_VALUE");
                    continue;
                }
                if ("SSHPassword".equals((String)sshRow.get("CONF_NAME"))) {
                    sshPassword = Codecs.base64Decode((String)((String)sshRow.get("CONF_VALUE")));
                    continue;
                }
                if ("SSHPort".equals((String)sshRow.get("CONF_NAME"))) {
                    sshPort = (String)sshRow.get("CONF_VALUE");
                    continue;
                }
                if (!"sysArchiveLocation".equals((String)sshRow.get("CONF_NAME"))) continue;
                sshHome = (String)sshRow.get("CONF_VALUE");
            }
            if ("archive".equals(sshHome)) {
                sshHome = System.getProperty("server.home") + File.separator + "archive";
            }
            String sshArgs = "\"" + sshServerName + "\" \"" + sshUserName + "\" \"" + sshPassword + "\" " + sshPort + " \"" + sshHome + "\" \"" + System.getProperty("server.home") + "\"";
            ELAPortCheckerUtil pc = new ELAPortCheckerUtil();
            if (!pc.checkPortAvailability(Integer.parseInt(sshPort), true)) {
                LOGGER.log(Level.INFO, "SSH Server is not started port {0} is already in use ..............", sshPort);
                return;
            }
            EAService.startSSHServer(sshArgs);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while Check for Central Archive status  {0}", e);
            e.printStackTrace();
        }
    }

    private void checkForEnterpriseMigration_11130() {
        String enterpriseMigrationStatus = (String)CommonUtil.getSysConfiguration("EnterpriseSyncMigration_11130");
        try {
            if (enterpriseMigrationStatus != null && enterpriseMigrationStatus.equals("start")) {
                DeleteCollectorDetails.getInstance().scheduleReset();
            }
        }
        catch (EnterpriseException e) {
            e.printStackTrace();
        }
    }

    public static void startSSHServer(String sshArgs) {
        try {
            String java = "\"" + System.getProperty("server.home") + File.separator + "jre" + File.separator + "bin" + File.separator + "java" + "\"";
            String serverDefaultDir = System.getProperty("server.home");
            String classPath = "\"" + serverDefaultDir + File.separator + "lib" + File.separator + "sshd" + File.separator + "maverick-sshd.jar" + File.pathSeparator + serverDefaultDir + File.separator + "lib" + File.separator + "LAClientUtil.jar" + File.pathSeparator + serverDefaultDir + File.separator + "lib" + File.separator + "tomcat" + File.separator + "commons-logging.jar" + "\"";
            String sshMainFileName = " com.adventnet.la.ssh.SSHDServer ";
            String startSSHServerMain = java + " -cp " + classPath + sshMainFileName + sshArgs;
            sshProcess = Runtime.getRuntime().exec(startSSHServerMain);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LOGGER.log(Level.INFO, "Add Shutdown hood called forSSH Server..............");
                    try {
                        LOGGER.log(Level.INFO, "Going to stopping the SSH Server..............");
                        EAService.stopSSHServer();
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.INFO, "Exception while Stopping the SSH Server {0}", e);
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while starting SSH Server  {0}", e);
            e.printStackTrace();
        }
    }

    public static void stopSSHServer() {
        try {
            File sshPidFile = new File(System.getProperty("server.home") + File.separator + "sshServer.pid");
            if (sshProcess != null) {
                LOGGER.log(Level.INFO, "Stopping the SSH Server Process..............");
                sshProcess.destroy();
                if (sshPidFile.exists()) {
                    LOGGER.log(Level.INFO, "Deleting PID file ::::: " + sshPidFile.delete());
                }
            } else {
                LOGGER.log(Level.INFO, "Stopping the SSH Server using PID ..............");
                if (sshPidFile.exists()) {
                    CommonUtil.executeBatch("stopSSHServer", "");
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while stopping SSH Server  {0}", e);
            e.printStackTrace();
        }
    }

    public static int getSSHServerStatus() {
        int sshServerStatus = 0;
        try {
            Criteria nameCrit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"centralArchiveStatus", 0);
            Criteria valueCrit = new Criteria(new Column("SystemConfigurations", "CONF_VALUE"), (Object)"true", 0);
            DataObject sysConfigDO = DataAccess.get((String)"SystemConfigurations", (Criteria)nameCrit.and(valueCrit));
            if (sysConfigDO.size("SystemConfigurations") > 0) {
                File pidFile = new File(System.getProperty("server.home") + File.separator + "sshServer.pid");
                sshServerStatus = pidFile.exists() ? 1 : 2;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while getting SSH Server Status {0}", e);
            e.printStackTrace();
        }
        return sshServerStatus;
    }

    private void setHighFlowParams() {
        if (Integer.parseInt(System.getProperty("maxFlowRate", "5000")) <= 5000) {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            String cmdList = bean.getInputArguments().toString();
            int maxMemorySet = 1024;
            Pattern pattern = Pattern.compile("-Xmx(\\d+)m");
            Matcher matcher = pattern.matcher(cmdList);
            while (matcher.find()) {
                maxMemorySet = Integer.parseInt(matcher.group(1));
                LOGGER.log(Level.INFO, "Max Memory Set is {0} MB", maxMemorySet);
            }
            String logRate = "5000";
            if (maxMemorySet > 2048) {
                logRate = "20000";
            } else if (maxMemorySet > 1024) {
                logRate = "10000";
            }
            LOGGER.log(Level.INFO, "Setting maxFlowRate property as {0} logs/sec", logRate);
            System.setProperty("maxFlowRate", logRate);
        }
    }

    public void insertSystemConfigurations() throws Exception {
        String val;
        DataObject dobj1;
        DataObject dobj = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"filtBeforeArch", 0));
        Row row = new Row("SystemConfigurations");
        row.set("CONF_NAME", (Object)"filtBeforeArch");
        row.set("CONF_VALUE", (Object)"false");
        if (dobj.isEmpty()) {
            dobj.addRow(row);
            DataAccess.update((DataObject)dobj);
        }
        if (!(dobj1 = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"OOMException", 0))).isEmpty() && "true".equals(val = (String)dobj1.getFirstValue("SystemConfigurations", "CONF_VALUE"))) {
            this.sendMail("OOMException");
        }
        try {
            UpdateQueryImpl uq = new UpdateQueryImpl("SystemConfigurations");
            Criteria Crit1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"OOMException", 0);
            uq.setCriteria(Crit1);
            uq.setUpdateColumn("CONF_VALUE", (Object)"false");
            DataAccess.update((UpdateQuery)uq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            Row r;
            DataObject dataObject = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"lowDiskAlert", 0));
            if (dataObject.isEmpty()) {
                r = new Row("SystemConfigurations");
                r.set("CONF_NAME", (Object)"lowDiskAlert");
                r.set("CONF_VALUE", (Object)"true");
                dataObject.addRow(r);
                DataAccess.update((DataObject)dataObject);
            } else {
                r = dataObject.getFirstRow("SystemConfigurations");
                r.set("CONF_VALUE", (Object)"true");
                dataObject.updateRow(r);
                DataAccess.update((DataObject)dataObject);
            }
            dataObject = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"diskAlertStatus", 0));
            if (dataObject.isEmpty()) {
                r = new Row("SystemConfigurations");
                r.set("CONF_NAME", (Object)"diskAlertStatus");
                r.set("CONF_VALUE", (Object)"0");
                dataObject.addRow(r);
                DataAccess.update((DataObject)dataObject);
            } else {
                r = dataObject.getFirstRow("SystemConfigurations");
                r.set("CONF_VALUE", (Object)"0");
                dataObject.updateRow(r);
                DataAccess.update((DataObject)dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startArchiveZipping() throws Exception {
        if (!"true".equals(System.getProperty("sysEnableArchiving", "true"))) {
            return;
        }
        DataObject sysDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"sysZipCreationMode", 0));
        String zipCreationMode = (String)sysDO.getFirstValue("SystemConfigurations", "CONF_VALUE");
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        if ("Days".equals(zipCreationMode)) {
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            ((Calendar)cal).add(5, 1);
        } else {
            cal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), 0, 0);
            ((Calendar)cal).add(11, 1);
        }
        LOGGER.info("Periodic Zip schedule is created at " + cal.getTime());
        ClockDaemon archiveZipTask = new ClockDaemon();
        onceTaskId = archiveZipTask.executeAt(cal.getTime(), (Runnable)new ArchiveZipCreator(false));
    }

    public static void resetArchiveZipping() throws Exception {
        LOGGER.info("Resetting the Archive Zip Task");
        if (periodicTaskId != null) {
            LOGGER.info("Cancelling periodic Archive Zip Task");
            ClockDaemon.cancel((Object)periodicTaskId);
        }
        if (onceTaskId != null) {
            LOGGER.info("Cancelling once Archive Zip Task");
            ClockDaemon.cancel((Object)onceTaskId);
        }
    }

    public static Long getSLID() {
        Long slid = new Long(1L);
        try {
            Criteria crit = new Criteria(new Column("SyslogServers", "PORTS"), (Object)"-", 1);
            DataObject slDO = DataAccess.get((String)"SyslogServers", (Criteria)crit);
            if (slDO.size("SyslogServers") > 0) {
                slid = (Long)slDO.getFirstValue("SyslogServers", "SLID");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, " Exception while getting SLID : {0}", e);
            e.printStackTrace();
        }
        return slid;
    }

    private static void populateFromXml() {
        String[] xmlArray = new String[]{"PrintServiceActionsAndFields.xml"};
        String absolutePath = System.getProperty("server.home") + File.separator + "applications" + File.separator + "extracted" + File.separator + "EventLogAnalyzer.eear" + File.separator + "EventLogAnalyzer.ear" + File.separator + "conf" + File.separator;
        for (String xml : xmlArray) {
            String fileName = absolutePath + xml;
            try {
                DataObject obj = Xml2DoConverter.transform((String)fileName);
                DataAccess.add((DataObject)obj);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    private void migrateCompReports() {
        ComplianceMigration cm = new ComplianceMigration();
        cm.migrateComplianceReports();
    }

    private void updateAgentDetails() {
        Table table = new Table("SyslogServers");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column("SyslogServers", "*"));
        Criteria slCrit = new Criteria(new Column("SyslogServers", "PORTS"), (Object)"-", 1);
        query.setCriteria(slCrit);
        String slsType = "";
        try {
            DataObject dao = DataAccess.get((SelectQuery)query);
            slsType = (String)dao.getFirstValue("SyslogServers", "TYPE");
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        if (slsType.indexOf("indow") >= 0) {
            new AgentUpdate().start();
        }
    }

    private boolean isConvertedMS() {
        boolean isMSConversion = false;
        try {
            DataObject isMSConversionDO = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"isMSConversion", 0));
            if (isMSConversionDO.size("SystemConfigurations") > 0) {
                isMSConversion = true;
            }
            DataAccess.delete((Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"isMSConversion", 0));
            LOGGER.log(Level.INFO, "deleting the flag isMSConversion..........");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMSConversion;
    }

    private void restartAgents() {
        try {
            Table table = new Table("SyslogServers");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(new Column("SyslogServers", "*"));
            Criteria slCrit = new Criteria(new Column("SyslogServers", "PORTS"), (Object)"-", 0).and(new Criteria(new Column("SyslogServers", "STATUS"), (Object)"AGENT_RUNNING", 0));
            query.setCriteria(slCrit);
            DataObject statusDao = DataAccess.get((SelectQuery)query);
            Iterator sIter = statusDao.getRows("SyslogServers");
            while (sIter.hasNext()) {
                Row sRow = (Row)sIter.next();
                LOGGER.log(Level.INFO, "restarting agent :: " + sRow.get("SLID"));
                AgentStatusUpdate.restartAgent((Long)sRow.get("SLID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopELALogThreads() throws Exception {
        LOGGER.log(Level.INFO, "EventLog Analyzer stopELALogThreads invoked , due to low disk space");
        this.stopImport();
        ArchiveFileManager.getInstance().shutdown();
        LogCollectorProcess.getInstance().stop(LogCollectorStatus.STOPPED_NOFREESPACE);
    }

    public void populateFreeSpce() {
        try {
            freeSpace = new DiskSpaceCheck().checkMinDiskSpace();
            DataObject udpDO1 = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"logthread_stopped", 0));
            if (udpDO1.size("SystemConfigurations") > 0) {
                freeSpace = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migExceptionChecker() {
        Scanner scan = null;
        boolean isMigrated = true;
        try {
            StringBuffer buffer = new StringBuffer();
            StringBuffer updateBuffer = new StringBuffer();
            File logfFile = new File(System.getProperty("server.dir") + "\\logs\\Log.txt");
            if (!logfFile.exists()) {
                isMigrated = false;
                return;
            }
            scan = new Scanner(logfFile, "UTF-8");
            String readdata = "";
            while (scan.hasNext() && (readdata = scan.nextLine()) != null) {
                buffer.append(readdata).append('\n');
            }
            scan = new Scanner(new File(System.getProperty("server.dir") + "\\server\\default\\log\\updatemgrlog0.txt"), "UTF-8");
            readdata = "";
            while (scan.hasNext() && (readdata = scan.nextLine()) != null) {
                updateBuffer.append(readdata).append('\n');
            }
            String logtxt = buffer.toString();
            String updatetxt = updateBuffer.toString();
            if (logtxt.contains("Exception ") || updatetxt.contains("Unable to access the file. The file is being used by another process")) {
                this.sendMail("exception");
                DataObject doo = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"migrationFailed", 0));
                Row newRow = new Row("SystemConfigurations");
                newRow.set("CONF_NAME", (Object)"migrationFailed");
                newRow.set("CONF_VALUE", (Object)"true");
                if (doo.isEmpty()) {
                    doo.addRow(newRow);
                    DataAccess.add((DataObject)doo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (scan != null) {
                scan.close();
                scan = null;
            }
        }
    }

    private int getPreviousBuildNumber() {
        int buildNumber = -1;
        try {
            String buildNo = (String)CommonUtil.getSysConfiguration("prevBuildNumber");
            if (buildNo != null) {
                buildNumber = Integer.parseInt(buildNo);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error while obtaining previous buildnumer", e);
        }
        return buildNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNewBuildNumber() {
        String buildFile = System.getProperty("server.home") + File.separator + "troubleshooting" + File.separator + "build.properties";
        FileInputStream fi = null;
        Properties buildProp = new Properties();
        try {
            fi = new FileInputStream(new File(buildFile));
            buildProp.load(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        String buildNo = (String)buildProp.get("buildnumber");
        int buildNumber = Integer.parseInt(buildNo);
        return buildNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getBuildProperties() {
        String buildFile = System.getProperty("server.home") + File.separator + "troubleshooting" + File.separator + "build.properties";
        FileInputStream fi = null;
        Properties buildProp = new Properties();
        try {
            fi = new FileInputStream(new File(buildFile));
            buildProp.load(fi);
            if (!buildProp.containsKey("basebuildversion")) {
                buildProp.setProperty("basebuildversion", buildProp.getProperty("buildversion"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return buildProp;
    }

    private void updateBuildProperties() {
        try {
            Properties prop = this.getBuildProperties();
            if (!prop.isEmpty()) {
                String[] build = new String[]{"basebuildversion", "buildversion"};
                DataObject dobj = DataAccess.get((String)"SystemConfigurations", (Criteria)new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)build, 8));
                for (int i = 0; i < build.length; ++i) {
                    Row row = null;
                    row = dobj.getRow("SystemConfigurations", new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)build[i], 0));
                    if (row != null) {
                        if (i == 0) continue;
                        row.set("CONF_VALUE", (Object)prop.getProperty(build[i]));
                        dobj.updateRow(row);
                        continue;
                    }
                    row = new Row("SystemConfigurations");
                    row.set("CONF_NAME", (Object)build[i]);
                    row.set("CONF_VALUE", (Object)prop.getProperty(build[i]));
                    dobj.addRow(row);
                }
                DataAccess.update((DataObject)dobj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void invokeAgentUpgrader() {
        try {
            DataObject doo = DataAccess.get((String)"SyslogServers", (Criteria)new Criteria(new Column("SyslogServers", "PORTS"), (Object)"-", 0));
            Iterator iter = doo.getRows("SyslogServers");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                Long agentid = (Long)row.get("SLID");
                new AgentUpgrader(agentid, "").start();
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    public static Map getMailAttributes() throws DataAccessException {
        HashMap<String, String> settings = null;
        try {
            Row mailSettings = null;
            Table table = new Table("ADSConnectionSecurity");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            sql.addSelectColumn(new Column("ADSConnectionSecurity", "*"));
            sql.addSelectColumn(new Column("ADSMailSettings", "*"));
            sql.addJoin(new Join(new Table("ADSConnectionSecurity"), new Table("ADSMailSettings"), new String[]{"CONNECTION_SECURITY_ID"}, new String[]{"CONNECTION_SECURITY_ID"}, 1));
            DataObject doo = DataAccess.get((SelectQuery)sql);
            mailSettings = doo.getRow("ADSMailSettings");
            if (mailSettings != null) {
                settings = new HashMap<String, String>();
                String userName = (String)mailSettings.get("USER_NAME");
                settings.put("SmtpServer", (String)mailSettings.get("SERVER_NAME"));
                settings.put("SmtpServerPort", (String)mailSettings.get("PORT"));
                settings.put("uName", userName);
                settings.put("pWord", (String)mailSettings.get("PASSWORD"));
                Long connectionid = (Long)mailSettings.get("CONNECTION_SECURITY_ID");
                String tls = (String)doo.getValue("ADSConnectionSecurity", "NAME", new Criteria(new Column("ADSConnectionSecurity", "CONNECTION_SECURITY_ID"), (Object)connectionid, 0));
                settings.put("tls", tls);
                if (userName != null && !"".equals(userName.trim())) {
                    settings.put("authenticate", "Yes");
                }
                if (mailSettings.get("FROM_MAIL_ID") != null) {
                    settings.put("fromId", (String)mailSettings.get("FROM_MAIL_ID"));
                }
            }
            LOGGER.log(Level.FINER, "DEBUG: MailServer details : {0}", settings);
        }
        catch (Exception dae) {
            LOGGER.log(Level.INFO, " Exception caught : {0}", dae);
            dae.printStackTrace();
        }
        return settings;
    }

    public boolean sendMail(String val) {
        String subject = null;
        String message = null;
        String status = null;
        String msg = null;
        String upOrDown = null;
        boolean result = false;
        int prevBuildNo = 0;
        int newBuildNo = 0;
        if ("upgraded".equals(val)) {
            prevBuildNo = this.getPreviousBuildNumber();
            newBuildNo = this.getNewBuildNumber();
            upOrDown = newBuildNo > prevBuildNo ? "Upgrade.mail" : "Degrade.mail";
        }
        ResourceBundle bundle = null;
        bundle = ProductBundle.getInstance().getBundle();
        try {
            String expiryDate = LicenseHandler.getInstance().getExpiryDateString();
            int remainingDays = LicenseHandler.getInstance().getRemainingDays();
            Map mailServerSettings = EAService.getMailAttributes();
            if (!mailServerSettings.isEmpty()) {
                String fromEmail = "eventloganalyzer@localadmin.com";
                String toAddress = EAService.getAdminAdress();
                if ("upgraded".equals(val)) {
                    subject = newBuildNo > prevBuildNo ? "EventLog Analyzer Upgraded" : "EventLog Analyzer Degraded";
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("reportmail.resultof") + " " + bundle.getString("Product.Title") + " <b>" + bundle.getString(upOrDown) + "</b> " + bundle.getString("pdfHome_FromTime") + "<b> " + bundle.getString("old_version") + prevBuildNo + "  </b>" + bundle.getString("pdf_To") + "<b> " + bundle.getString("new_version") + " " + newBuildNo + "</b><br><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>" + bundle.getString("Upgrade.Note");
                } else if ("OOMException".equals(val)) {
                    subject = "EventLog Analyzer Out Of Memory";
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("reportmail.resultof") + " " + bundle.getString("Upgrade.oom") + "</b><br><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>" + bundle.getString("Upgrade.Note");
                } else if ("exception".equals(val)) {
                    subject = "Exception during EventLog Analyzer Upgrade";
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("reportmail.resultof") + " " + bundle.getString("Upgrade.Issue") + "<br><br> " + bundle.getString("Upgrade.Help") + "</b><br><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>" + bundle.getString("Upgrade.Note");
                } else if ("licenseMessage_beforeExpiry".equals(val)) {
                    subject = "ManageEngine EventLogAnalyzer License Alert !!!!";
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("NewTop.alert10") + " " + remainingDays + " " + bundle.getString("NewTop.alert11") + "<br><br>" + bundle.getString("License.Expirydate") + " : " + expiryDate + "</b><br><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>" + bundle.getString("Upgrade.Note");
                } else if ("licenseMessage_afterExpiry".equals(val)) {
                    subject = "ManageEngine EventLogAnalyzer License Alert !!!!";
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("NewTop.alert9") + "<br><br>" + bundle.getString("NewTop.alert16") + "<br><br>" + bundle.getString("License.Expirydate") + " : " + expiryDate + "</b><br><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>" + bundle.getString("Upgrade.Note");
                } else if ("licenseMessage_trial".equals(val)) {
                    subject = "ManageEngine EventLogAnalyzer License Alert !!!!";
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("NewTop.alert12") + " " + remainingDays + " " + bundle.getString("NewTop.alert13") + "<br><br>" + bundle.getString("License.Expirydate") + " : " + expiryDate + "</b><br><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>" + bundle.getString("Upgrade.Note");
                } else if ("licenseMessage_45days".equals(val)) {
                    subject = "ManageEngine EventLogAnalyzer License Alert !!!!";
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("NewTop.alert9") + "<br><br>" + bundle.getString("NewTop.alert17") + "<br><br>" + bundle.getString("License.Expirydate") + " : " + expiryDate + "</b><br><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>" + bundle.getString("Upgrade.Note");
                } else if ("CachedRecordGrowth".equals(val) && System.getProperty("CachedRecordMail") == null) {
                    LOGGER.info("Setting msg in cachedRecordGrowth");
                    subject = bundle.getString("AlertMail.CachedRecordSubject");
                    message = "<span style='font-size:13px;'>" + bundle.getString("AlertMail.Head1") + ",<br><br> " + bundle.getString("NewTop.alert18") + "<br><br>" + bundle.getString("NewTop.alert19") + "</b><br><br><br>" + bundle.getString("Regards") + "<br> " + bundle.getString("Product.Title") + "<br><br><br> </span>";
                    System.setProperty("CachedRecordMail", "true");
                }
                String server = (String)mailServerSettings.get("SmtpServer");
                if (!"notConfigured".equals(server)) {
                    String port = (String)mailServerSettings.get("SmtpServerPort");
                    String username = (String)mailServerSettings.get("uName");
                    String password = (String)mailServerSettings.get("pWord");
                    String auth = (String)mailServerSettings.get("authenticate");
                    String from = (String)mailServerSettings.get("fromId");
                    String tls = (String)mailServerSettings.get("tls");
                    if (!"".equals(toAddress)) {
                        SmtpMailer mailer = null;
                        if ("CachedRecordGrowth".equals(val) && !"".equals(from)) {
                            LOGGER.info("CachedRecordGrowth mail :" + from);
                            mailer = new SmtpMailer(server, from, toAddress, subject, null, username, password, port, tls);
                        } else {
                            mailer = new SmtpMailer(server, fromEmail, toAddress, subject, null, username, password, port, tls);
                        }
                        if (mailer != null) {
                            status = mailer.sendMessage(message);
                        }
                    } else {
                        LOGGER.log(Level.INFO, "Unable to send ELA mail, as email-id not present");
                    }
                    boolean bl = result = status == null;
                    msg = "upgraded".equals(val) && newBuildNo > prevBuildNo ? "Upgrade" : ("upgraded".equals(val) && newBuildNo <= prevBuildNo ? "Degrade" : ("exception".equals(val) ? "Upgrade Issue" : val));
                    if (result) {
                        LOGGER.log(Level.INFO, "ELA mail regarding " + msg + " sent to : " + toAddress);
                    } else {
                        LOGGER.log(Level.INFO, "Unable to send ELA mail to : " + toAddress);
                    }
                } else {
                    LOGGER.log(Level.INFO, "Unable to send ELA mail as SMTP not configured");
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while sending mail");
            e.printStackTrace();
        }
        return result;
    }

    private static String getAdminAdress() throws Exception {
        String[] userType = new String[]{System.getProperty("userType", "Administrator")};
        String toaddress = "";
        SelectQueryImpl sql_aaaUser = new SelectQueryImpl(new Table("AaaUser"));
        sql_aaaUser.addSelectColumn(new Column("AaaUser", "*"));
        sql_aaaUser.addSelectColumn(new Column("AaaUserContactInfo", "*"));
        sql_aaaUser.addSelectColumn(new Column("AaaContactInfo", "*"));
        sql_aaaUser.addJoin(new Join(new Table("AaaUser"), new Table("AaaUserContactInfo"), new String[]{"USER_ID"}, new String[]{"USER_ID"}, 1));
        sql_aaaUser.addJoin(new Join(new Table("AaaUserContactInfo"), new Table("AaaContactInfo"), new String[]{"CONTACTINFO_ID"}, new String[]{"CONTACTINFO_ID"}, 1));
        sql_aaaUser.setCriteria(new Criteria(new Column("AaaUser", "FIRST_NAME"), (Object)userType, 8).and(new Criteria(new Column("AaaContactInfo", "EMAILID"), (Object)"aaaadmin@adventnet.com", 1)));
        DataObject obj = DataAccess.get((SelectQuery)sql_aaaUser);
        if (!obj.isEmpty()) {
            Iterator getEMail = obj.getRows("AaaContactInfo");
            while (getEMail.hasNext()) {
                Row emailRow = (Row)getEMail.next();
                if (toaddress.equals("")) {
                    toaddress = (String)emailRow.get("EMAILID");
                    continue;
                }
                toaddress = toaddress + "," + emailRow.get("EMAILID");
            }
        }
        return toaddress;
    }

    private void updatePassword(String tableName) {
        try {
            String plainPass = null;
            Table table = new Table(tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(new Column(tableName, "*"));
            DataObject passDao = DataAccess.get((SelectQuery)query);
            Iterator pIter = passDao.getRows(tableName);
            while (pIter.hasNext()) {
                Row pRow = (Row)pIter.next();
                String pass = (String)pRow.get("PASSWORD");
                if (pass == null || "".equals(pass.trim())) continue;
                LOGGER.log(Level.INFO, "PASS :: " + pass);
                plainPass = this.decryptOldPassword(pass);
                String newPass = EnDecryptImplSingleton.getInstance().encrypt(plainPass);
                LOGGER.log(Level.INFO, "newPass :: " + newPass);
                UpdateQueryImpl uq = new UpdateQueryImpl(tableName);
                uq.setCriteria(new Criteria(new Column(tableName, "PASSWORD"), (Object)pass, 0));
                uq.setUpdateColumn("PASSWORD", (Object)newPass);
                DataAccess.update((UpdateQuery)uq);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "New Scheme Password encryption failed for table :: " + tableName);
            e.printStackTrace();
        }
    }

    private String decryptOldPassword(String password) {
        String out;
        String input = password;
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            c[i] = c[i] != '0' ? (char)(c[i] ^ 0x30) : c[i];
        }
        password = out = new String(c);
        return password;
    }

    private void deleteUnwantedXML() throws Exception {
        File xmlToDel1;
        String sa_path = System.getProperty("server.home") + File.separator + "conf" + File.separator + "EventLogAnalyzer" + File.separator;
        File xmlToDel = new File(sa_path + "report-configuration_postgres_9000.xml");
        if (xmlToDel.exists()) {
            xmlToDel.delete();
            LOGGER.log(Level.INFO, "Removed report-configuration_postgres_9000.xml from conf during start");
        }
        if ((xmlToDel1 = new File(sa_path + "mssqlauditActionsAndFields_9000.xml")).exists()) {
            xmlToDel1.delete();
            LOGGER.log(Level.INFO, "Removed mssqlauditActionsAndFields_9000.xml from conf during start");
        }
    }

    private static Properties getInstallProperties(File enterpriseTxtFile) {
        if (enterpriseTxtFile.exists()) {
            Properties eProps = new Properties();
            try {
                eProps.load(new FileInputStream(enterpriseTxtFile));
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
            return eProps.size() > 0 ? eProps : null;
        }
        return null;
    }

    private void deleteReportSelectedTab() {
        try {
            DataObject d = DataAccess.get((String)"UsertoSelGroupType", (Criteria)null);
            d.deleteRows("UsertoSelGroupType", (Criteria)null);
            DataAccess.update((DataObject)d);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void migrateImportTrendTables() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ImportLogMigrationUtil.migrateImportTrendTable();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDynamicEncryption() {
        AbstractEncryptionHandler.setDynamicEncryption(true);
        String archiveLocation = ArchiveConstants.getInstance().getArchiveLocation();
        File encryptedKeyFile = new File(archiveLocation + File.separator + "EncryptedKey.enc");
        if (encryptedKeyFile.exists()) {
            AbstractEncryptionHandler.setDynamicEncryption(true);
        } else {
            File userKeyFile = new File(archiveLocation + File.separator + "DynamicKey.properties");
            if (!userKeyFile.exists()) {
                AbstractEncryptionHandler.setDynamicEncryption(false);
                return;
            }
            FileInputStream fis = null;
            PrintWriter writer = null;
            try {
                fis = new FileInputStream(userKeyFile);
                Properties prop = new Properties();
                prop.load(fis);
                String dynamicKey = prop.getProperty("EncryptionKey");
                if (dynamicKey.length() != 16) {
                    LOGGER.log(Level.SEVERE, "User supplied encryption key should be of 16 chars length. Dynamic encryption not activated");
                    AbstractEncryptionHandler.setDynamicEncryption(false);
                    return;
                }
                writer = new PrintWriter(encryptedKeyFile);
                writer.print(dynamicKey);
                AbstractEncryptionHandler.setDynamicEncryption(true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    static {
        slUpdateConst = new HashMap<String, Long>();
        serviceInstallAlertTrigger = false;
        startTime = System.currentTimeMillis();
        startHourTime = System.currentTimeMillis();
        LogAlert.setStartTime();
    }

    class LicenseAlert
    extends TimerTask {
        int counter = 0;

        LicenseAlert() {
        }

        @Override
        public void run() {
            try {
                LicenseHandler handler = LicenseHandler.getInstance();
                LicenseComponents.LicenseType licenseType = handler.getLicenseType();
                int remainingDays = handler.getRemainingDays();
                if (remainingDays > 0 && remainingDays <= 15 && licenseType == LicenseComponents.LicenseType.REGISTERED) {
                    ++this.counter;
                    if (this.counter <= 2 && remainingDays > 0) {
                        EAService.this.sendMail("licenseMessage_beforeExpiry");
                    } else {
                        EAService.this.sendMail("licenseMessage_afterExpiry");
                    }
                } else if (remainingDays > -45 && remainingDays < 0 && licenseType == LicenseComponents.LicenseType.REGISTERED) {
                    EAService.this.sendMail("licenseMessage_afterExpiry");
                } else if (remainingDays >= 0 && remainingDays <= 5 && licenseType == LicenseComponents.LicenseType.TRIAL) {
                    EAService.this.sendMail("licenseMessage_trial");
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    class LicenseAlertMail
    extends TimerTask {
        LicenseAlertMail() {
        }

        @Override
        public void run() {
            try {
                LicenseHandler handler = LicenseHandler.getInstance();
                LicenseComponents.LicenseType licenseType = handler.getLicenseType();
                int remainingDays = handler.getRemainingDays();
                Timer timer = new Timer();
                if (remainingDays > 0 && remainingDays <= 15 && licenseType == LicenseComponents.LicenseType.REGISTERED || remainingDays >= 0 && remainingDays <= 5 && licenseType == LicenseComponents.LicenseType.TRIAL || remainingDays > -45 && remainingDays <= 0 && licenseType == LicenseComponents.LicenseType.REGISTERED) {
                    timer.scheduleAtFixedRate((TimerTask)new LicenseAlert(), 1000L, 604800000L);
                }
                if (remainingDays == -45 && licenseType == LicenseComponents.LicenseType.REGISTERED) {
                    EAService.this.LicenseExpired_45days();
                }
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    class MigrateIndexThread
    implements Runnable {
        MigrateIndexThread() {
        }

        @Override
        public void run() {
            LOGGER.info("MigrateIndexThread invoked..");
            String hotPropertiesFile = LogIndexingAPI.getInstance().getIndexDirPath() + File.separator + "hot.properties";
            String coldPropertiesFile = LogIndexingAPI.getInstance().getIndexDirPath() + File.separator + "cold.properties";
            if (new File(hotPropertiesFile).exists()) {
                LOGGER.info("Hot properties exists and I am starting hot thread migration");
                MigrateIndex.migrateFromHot((String)LogIndexingAPI.getInstance().getBaseIndexDirName("batch"));
                LOGGER.info("Done with hot thread migration");
            }
            if (new File(coldPropertiesFile).exists()) {
                LOGGER.info("Cold properties exists and I am starting warm thread migration");
                MigrateIndex.migrateFromWarm((String)LogIndexingAPI.getInstance().getBaseIndexDirName("batch"));
                LOGGER.info("Done with warm thread migration");
            }
        }
    }

    class ScheduledImportTaskHandler
    implements Runnable {
        ScheduledImportTaskHandler() {
        }

        @Override
        public void run() {
            try {
                Thread cleanupThread = new Thread(new ImportTempTableCleaner());
                cleanupThread.start();
                cleanupThread.join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (freeSpace) {
                try {
                    EAService.this.startScheduledImportTask();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class flowRateScheduler
    implements Runnable {
        private flowRateScheduler() {
        }

        @Override
        public void run() {
            LOGGER.info("Flow rate Scheduler invoked..");
            logHourCount = 0L;
            SyslogServer.resetlogCounter();
            startHourTime = System.currentTimeMillis();
        }
    }

    class scheduleServiceAlert
    extends TimerTask {
        scheduleServiceAlert() {
        }

        @Override
        public void run() {
            LOGGER.fine("serviceInstallAlertTrigger is set while running clockdaemon");
            serviceInstallAlertTrigger = true;
        }
    }
}

