/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.persistence.DataAccess;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELAExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(ELAExceptionHandler.class.getName());

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            String daemon = t.isDaemon() ? "daemon" : "";
            LOGGER.log(Level.INFO, "ELA-OOMError " + e.toString() + " " + "\"" + t.getName() + "\" " + daemon + " prio=" + t.getPriority() + " id=" + t.getId() + " state=" + (Object)((Object)t.getState()) + " ");
            this.updateDB();
            e.printStackTrace();
            ConsoleOut.println((String)"ELA-OOMError");
        } else {
            e.printStackTrace();
        }
    }

    private void updateDB() {
        try {
            Criteria Crit1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"OOMException", 0);
            Criteria Crit2 = new Criteria(new Column("SystemConfigurations", "CONF_VALUE"), (Object)"false", 0);
            UpdateQueryImpl uq = new UpdateQueryImpl("SystemConfigurations");
            uq.setCriteria(Crit1.and(Crit2));
            uq.setUpdateColumn("CONF_VALUE", (Object)"true");
            DataAccess.update((UpdateQuery)uq);
            UpdateQueryImpl uqtime = new UpdateQueryImpl("SystemConfigurations");
            uqtime.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"OOMException_Time", 0));
            uqtime.setUpdateColumn("CONF_VALUE", (Object)(new Date() + ""));
            DataAccess.update((UpdateQuery)uqtime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

