/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.sa.server.ELAMemoryListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class ELAMemoryWarning {
    private static final Logger LOGGER = Logger.getLogger(ELAMemoryWarning.class.getName());
    double thresholdmemory = 0.8;
    private static String threshold = System.getProperty("ELAThreshold", "80");
    private final Collection<ELAMemoryListener> listeners = new ArrayList<ELAMemoryListener>();
    private static final MemoryPoolMXBean TEPOOL = ELAMemoryWarning.findTenuredGenPool();

    public ELAMemoryWarning() {
        try {
            this.thresholdmemory = Double.parseDouble(threshold) / 100.0;
            MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
            ELAMemoryWarning.setPercentageUsageThreshold(this.thresholdmemory);
            NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
            emitter.addNotificationListener(new NotificationListener(){

                @Override
                public void handleNotification(Notification n, Object hb) {
                    if (n.getType().equals("java.management.memory.threshold.exceeded")) {
                        long maxMemory = TEPOOL.getUsage().getMax();
                        long usedMemory = TEPOOL.getUsage().getUsed();
                        if (ELAMemoryWarning.this.thresholdmemory <= 0.9) {
                            ELAMemoryWarning.setPercentageUsageThreshold(ELAMemoryWarning.this.thresholdmemory + 0.05);
                        }
                        for (ELAMemoryListener listener : ELAMemoryWarning.this.listeners) {
                            listener.memoryUsageLow(usedMemory, maxMemory);
                        }
                    }
                }
            }, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean addListener(ELAMemoryListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ELAMemoryListener listener) {
        return this.listeners.remove(listener);
    }

    public static void setPercentageUsageThreshold(double percentage) {
        if (percentage <= 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage not in range");
        }
        long maxMemory = TEPOOL.getUsage().getMax();
        long warningThreshold = (long)((double)maxMemory * percentage);
        LOGGER.log(Level.INFO, "UsageThreshold --> Maximum memory= " + maxMemory / 0x100000L + "MB" + " warningThreshold Memory= " + warningThreshold / 0x100000L + "MB" + " Threshold Percentage=" + percentage * 100.0 + "%");
        TEPOOL.setUsageThreshold(warningThreshold);
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }
}

