/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class ELAReportData
extends Thread {
    private static ELAReportData elReport = null;
    private Map<String, Long> repMap = new HashMap<String, Long>();
    private Map<Long, String> cmpMap = new HashMap<Long, String>();
    private Map<String, String[]> map = new HashMap<String, String[]>();

    public ELAReportData() {
    }

    public ELAReportData(Map<String, String[]> map) {
        this.map = map;
    }

    @Override
    public void run() {
        if (this.map != null && !this.map.isEmpty()) {
            this.urlFilter();
        }
    }

    public static synchronized ELAReportData getInstance() {
        if (elReport == null) {
            elReport = new ELAReportData();
        }
        return elReport;
    }

    public Properties getPropertiesForMETracker() {
        Properties prop = new Properties();
        if (this.repMap.isEmpty() || this.cmpMap.isEmpty()) {
            this.loadRepMap();
        }
        String getFavData = this.getFavouritesData();
        String getScheduleData = this.getScheduleRepData();
        prop.setProperty("Favourites", getFavData);
        prop.setProperty("Reports", getScheduleData);
        return prop;
    }

    private String getFavouritesData() {
        StringBuilder favData = new StringBuilder();
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ImpGroupstoReport"));
            query.addSelectColumn(new Column("ImpGroupstoReport", "*"));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator iter = doo.getRows("ImpGroupstoReport");
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                String grpName = (String)r.get("GROUPNAME");
                String reports = (String)r.get("REPORTS");
                String repIds = this.getReportIds(reports);
                favData.append(grpName).append("=").append(repIds).append("\n");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return favData.toString();
    }

    private String getScheduleRepData() {
        StringBuilder schData = new StringBuilder();
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ReportConfigToSelectedReports"));
            query.addSelectColumn(new Column("ReportConfigToSelectedReports", "*"));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator iter = doo.getRows("ReportConfigToSelectedReports");
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                Long repoId = (Long)r.get("REPORTID");
                String reports = (String)r.get("REPORTLIST");
                String repIds = this.getReportIds(reports);
                schData.append(repoId.toString()).append("=").append(repIds).append("\n");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schData.toString();
    }

    private String getReportIds(String repS) {
        StringBuilder repBuild = new StringBuilder();
        try {
            String[] repIDArray;
            for (String rep : repIDArray = repS.split(",")) {
                Long rId = this.repMap.get(rep.trim());
                repBuild.append(rId.toString()).append(",");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return repBuild.toString();
    }

    private void loadRepMap() {
        try {
            Long repId;
            String repName;
            Row r;
            SelectQueryImpl query = new SelectQueryImpl(new Table("ImpReportsConstants"));
            query.addSelectColumn(new Column("ImpReportsConstants", "*"));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator iter = doo.getRows("ImpReportsConstants");
            while (iter.hasNext()) {
                r = (Row)iter.next();
                repName = (String)r.get("IMP_REPORTNAME");
                repId = (Long)r.get("IMPID");
                this.repMap.put(repName, repId);
            }
            query = new SelectQueryImpl(new Table("AuditPolicyNames"));
            query.addSelectColumn(new Column("AuditPolicyNames", "*"));
            doo = DataAccess.get((SelectQuery)query);
            iter = doo.getRows("AuditPolicyNames");
            while (iter.hasNext()) {
                r = (Row)iter.next();
                repName = (String)r.get("POLICY_NAME");
                repId = (Long)r.get("POLICY_ID");
                this.cmpMap.put(repId, repName);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<Integer, Properties> convertTableToMap(String tableName, String firstColumn, String secondColumn) {
        HashMap<Integer, Properties> returnMap = new HashMap<Integer, Properties>();
        Properties prop = null;
        int i = 0;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.addSelectColumn(new Column(tableName, "*"));
            DataObject doo = DataAccess.get((SelectQuery)query);
            DataObject udo = (DataObject)doo.clone();
            Iterator iter = doo.getRows(tableName);
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                String repName = (String)r.get(firstColumn);
                Long repId = (Long)r.get(secondColumn);
                prop = new Properties();
                prop.put(firstColumn, repName);
                prop.put(secondColumn + "_field", repId.toString());
                returnMap.put(i++, prop);
                udo.deleteRow(r);
            }
            DataAccess.update((DataObject)udo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    public Map<Integer, Properties> getScheduledPreMap(String formName) {
        HashMap<Integer, Properties> rmap = new HashMap<Integer, Properties>();
        Properties prop = null;
        ArrayList<String> idlist = new ArrayList<String>();
        Criteria crit = null;
        String colName = null;
        String data = null;
        Row r = null;
        boolean inserted = false;
        int i = 0;
        try {
            DataObject doo = this.getDO(formName);
            if (doo != null) {
                Iterator iter = doo.getRows("ReportConfigToSelectedReports");
                while (iter.hasNext()) {
                    inserted = false;
                    r = (Row)iter.next();
                    data = (String)r.get("REPORTLIST");
                    crit = new Criteria(new Column("ImportantReports", "IMP_REPORTNAME"), (Object)data, 0);
                    colName = (String)doo.getRow("ImportantReports", crit).get("IMP_GROUP_NAME");
                    colName = colName.replaceAll("[ /]", "_").trim();
                    if (idlist.contains(data = this.repMap.get(data).toString())) continue;
                    for (i = 0; i < rmap.size() && !inserted; ++i) {
                        prop = (Properties)rmap.get(i);
                        if (prop.containsKey(colName)) continue;
                        prop.put(colName, data);
                        rmap.put(i, prop);
                        inserted = true;
                    }
                    if (!inserted) {
                        prop = new Properties();
                        prop.put(colName, data);
                        rmap.put(i, prop);
                        inserted = true;
                    }
                    idlist.add(data);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rmap;
    }

    private DataObject getDO(String formName) throws DataAccessException {
        SelectQueryImpl query = new SelectQueryImpl(new Table("ReportConfigToSelectedReports"));
        query.addSelectColumn(new Column("ReportConfigToSelectedReports", "*"));
        query.addSelectColumn(new Column("ImportantReports", "*"));
        query.addSelectColumn(new Column("ImportantReportsGroup", "*"));
        String[] imp_group_name = new String[]{"IMP_GROUP_NAME"};
        String[] imp_reportname = new String[]{"IMP_REPORTNAME"};
        String[] reportlist = new String[]{"REPORTLIST"};
        query.addJoin(new Join(new Table("ReportConfigToSelectedReports"), new Table("ImportantReports"), reportlist, imp_reportname, 2));
        query.addJoin(new Join(new Table("ImportantReports"), new Table("ImportantReportsGroup"), imp_group_name, imp_group_name, 2));
        query.setCriteria(new Criteria(new Column("ImportantReportsGroup", "GROUP_TYPE"), (Object)formName, 0));
        return DataAccess.get((SelectQuery)query);
    }

    public Properties getScheduledCmpGroupReports() {
        Properties prop = null;
        Row r = null;
        String data = null;
        String[] splitter = null;
        SelectQueryImpl query = new SelectQueryImpl(new Table("LAExpression"));
        query.addSelectColumn(new Column("LAExpression", "*"));
        query.setCriteria(new Criteria(new Column("LAExpression", "TABLE_NAME"), (Object)"AuditPolicyGroups", 0));
        try {
            DataObject doo = DataAccess.get((SelectQuery)query);
            if (doo != null) {
                prop = new Properties();
                Iterator iter = doo.getRows("LAExpression");
                while (iter.hasNext()) {
                    r = (Row)iter.next();
                    data = (String)r.get("VALUE");
                    if ((data = data.replaceAll("[ /]", "_").trim()).indexOf("','") == -1) {
                        if (!prop.containsKey(data)) {
                            prop.put(data, (Object)1);
                            continue;
                        }
                        prop.put(data, (Object)((Integer)prop.get(data) + 1));
                        continue;
                    }
                    splitter = data.split("','");
                    for (int i = 0; i < splitter.length; ++i) {
                        data = splitter[i];
                        if (!prop.containsKey(data)) {
                            prop.put(data, (Object)1);
                            continue;
                        }
                        prop.put(data, (Object)((Integer)prop.get(data) + 1));
                    }
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return prop;
    }

    public Properties getScheduledCmpNameReports() {
        Properties prop = null;
        Row r = null;
        String data = null;
        Object splitter = null;
        SelectQueryImpl query = new SelectQueryImpl(new Table("LAExpression"));
        query.addSelectColumn(new Column("LAExpression", "*"));
        query.setCriteria(new Criteria(new Column("LAExpression", "TABLE_NAME"), (Object)"COMPTYPE", 0));
        try {
            DataObject doo = DataAccess.get((SelectQuery)query);
            if (doo != null) {
                prop = new Properties();
                Iterator iter = doo.getRows("LAExpression");
                while (iter.hasNext()) {
                    r = (Row)iter.next();
                    data = (String)r.get("VALUE");
                    data = this.cmpMap.get(Long.parseLong(data));
                    if (!prop.containsKey(data = data.replaceAll("[ /]", "_").trim())) {
                        prop.put(data, (Object)1);
                        continue;
                    }
                    prop.put(data, (Object)((Integer)prop.get(data) + 1));
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return prop;
    }

    private void updateCount(String data, String tableName, String reportColumn, String countColumn) {
        if (data == null) {
            return;
        }
        try {
            data = data.replaceAll("','", ",");
            String[] splt = data.split(",");
            for (int i = 0; i < splt.length; ++i) {
                SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
                query.addSelectColumn(new Column(tableName, "*"));
                query.setCriteria(new Criteria(new Column(tableName, reportColumn), (Object)splt[i], 0));
                DataObject doo = DataAccess.get((SelectQuery)query);
                Row r = doo.getRow(tableName);
                if (r != null) {
                    Long count = (Long)r.get(countColumn);
                    r.set(countColumn, (Object)(count + 1L));
                    doo.updateRow(r);
                } else {
                    r = new Row(tableName);
                    r.set(reportColumn, (Object)splt[i]);
                    r.set(countColumn, (Object)1);
                    doo.addRow(r);
                }
                DataAccess.update((DataObject)doo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void urlFilter() {
        String reportName = null;
        reportName = this.getStringFromArray(this.map.get("selectedCompGroups"));
        if ((reportName == null || reportName.indexOf("','") != -1) && (reportName = this.getStringFromArray(this.map.get("COMTYPE"))) != null) {
            reportName = "ComplianceReport:" + reportName;
        }
        if (reportName == null) {
            reportName = this.getStringFromArray(this.map.get("reportName"));
        }
        if (reportName == null) {
            reportName = this.getStringFromArray(this.map.get("repname"));
        }
        if (reportName != null) {
            if (this.map.get("FORMAT") != null) {
                this.updateCount(reportName, "METrackerExportedReports", "REPORT_NAME", "COUNT");
            } else if (this.map.get("predef_new_report") == null) {
                this.updateCount(reportName, "METrackerViewReports", "REPORT_NAME", "COUNT");
            }
        }
    }

    private String getStringFromArray(String[] strArray) {
        if (strArray != null) {
            return strArray[0];
        }
        return null;
    }
}

