/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELAThreadDump
implements Serializable {
    private static int count = 1;
    private static final Logger LOGGER = Logger.getLogger(ELAThreadDump.class.getName());
    private final Map<Thread, StackTraceElement[]> threadtrace = new TreeMap<Thread, StackTraceElement[]>(TCOMP);
    public ThreadMXBean tmbean;
    private static final Comparator<Thread> TCOMP = new Comparator<Thread>(){

        @Override
        public int compare(Thread a, Thread b) {
            int val = a.getName().compareTo(b.getName());
            if (val == 0) {
                Long tid1 = a.getId();
                Long tid2 = b.getId();
                return tid1.compareTo(tid2);
            }
            return val;
        }
    };

    public ELAThreadDump() {
        this.threadtrace.putAll(Thread.getAllStackTraces());
        this.tmbean = ManagementFactory.getThreadMXBean();
    }

    public Collection<Thread> getThreads() {
        return this.threadtrace.keySet();
    }

    public Map<Thread, StackTraceElement[]> getTraces() {
        return this.threadtrace;
    }

    public void threadTraces() {
        LOGGER.log(Level.INFO, "!!!Thread Dump " + count);
        for (Thread t : this.threadtrace.keySet()) {
            StackTraceElement[] arr;
            String daemon = t.isDaemon() ? "daemon" : "";
            long tid = t.getId();
            Thread.State ts = t.getState();
            LOGGER.log(Level.INFO, "\"" + t.getName() + "\" " + daemon + " priority=" + t.getPriority() + " id=" + t.getId() + " state=" + (Object)((Object)t.getState()));
            if (ts == Thread.State.BLOCKED) {
                try {
                    ThreadInfo info = this.tmbean.getThreadInfo(tid);
                    LOGGER.log(Level.INFO, "LockOwnerName= " + info.getLockOwnerName() + " LockOwnerId=" + info.getLockOwnerId() + " LockName=" + info.getLockName());
                    LOGGER.log(Level.INFO, "BlockedTime= " + info.getBlockedTime() + " BlockedCount= " + info.getBlockedCount());
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Exception while getting blocked threads");
                    e.printStackTrace();
                }
            }
            for (StackTraceElement st : arr = this.threadtrace.get(t)) {
                LOGGER.log(Level.INFO, "\t at " + st);
            }
        }
        ++count;
        LOGGER.log(Level.INFO, "Thread Dump Finished!!!");
    }
}

