/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.util.DBUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELSInitializer {
    private static final Logger LOGGER = Logger.getLogger(ELSInitializer.class.getName());
    private static String osName = System.getProperty("os.name");
    public static long startTime;
    public static boolean deleteAllSysEvtColZip;

    public static Process startScannerSearch(String startBatchFileArgs) throws IOException {
        String commandToExecute = "";
        if (osName.equals("Linux") || osName.equals("SunOS")) {
            return null;
        }
        if (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0) {
            commandToExecute = "command.com /c cscript /nologo .\\..\\troubleshooting\\searchscans.vbs " + startBatchFileArgs;
        } else if (osName.contains("indows")) {
            commandToExecute = "cmd  /c cscript /nologo .\\..\\troubleshooting\\searchscans.vbs ";
        }
        LOGGER.log(Level.FINER, "Command to start EventLog server  {0}", commandToExecute);
        return Runtime.getRuntime().exec(commandToExecute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDblink() {
        boolean isMssql = "mssql".equals(System.getProperty("DBType", "postgres"));
        boolean isMysql = "mysql".equals(System.getProperty("DBType", "postgres"));
        boolean isPlugin = false;
        if (!(isMysql || isMssql || !isPlugin || osName.equals("Linux") || osName.equals("SunOS"))) {
            Connection conn = null;
            Statement stmt = null;
            RelationalAPI relapi = RelationalAPI.getInstance();
            try {
                conn = relapi.getConnection();
                stmt = conn.createStatement();
                stmt.executeUpdate("create extension dblink");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildNumber() {
        String buildFile = System.getProperty("server.home") + File.separator + "troubleshooting" + File.separator + "build.properties";
        FileInputStream fi = null;
        Properties buildProp = new Properties();
        try {
            fi = new FileInputStream(new File(buildFile));
            buildProp.load(fi);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        String buildNo = (String)buildProp.get("buildnumber");
        return buildNo;
    }

    private static DataObject GetHostRows(Long hostId) {
        DataObject doo = null;
        try {
            SelectQueryImpl hostsql = new SelectQueryImpl(Table.getTable((String)"HostDetails"));
            Criteria hostTypeCrit = new Criteria(Column.getColumn((String)"HostDetails", (String)"TYPE"), (Object)"WINDOWS", 0);
            Criteria portCrit = new Criteria(Column.getColumn((String)"HostDetails", (String)"SYSLOG_PORT"), null, 0);
            Criteria finalCriteria = hostTypeCrit.and(portCrit);
            Criteria hostIdCrit = null;
            if (hostId != 0L) {
                hostIdCrit = new Criteria(Column.getColumn((String)"HostDetails", (String)"HOST_ID"), (Object)hostId, 0);
                finalCriteria = finalCriteria.and(hostIdCrit);
            }
            hostsql.setCriteria(finalCriteria);
            hostsql.addSelectColumn(Column.getColumn((String)"HostDetails", (String)"*"));
            doo = DataAccess.get((SelectQuery)hostsql);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return doo;
    }

    public static void PopulateHostToLogTypeTable(Long hostId) {
        try {
            DataObject doo = ELSInitializer.GetHostRows(hostId);
            if (doo != null && !doo.isEmpty()) {
                String[] logTypes = new String[]{"Application", "Security", "System", "Setup"};
                Iterator itr = doo.getRows("HostDetails");
                DataObject newDobj = DataAccess.constructDataObject();
                while (itr.hasNext()) {
                    Row hostRow = (Row)itr.next();
                    for (int i = 0; i < logTypes.length; ++i) {
                        Row slRow = new Row("HostToLogTypeMapping");
                        slRow.set("HOST_ID", hostRow.get("HOST_ID"));
                        slRow.set("LOGTYPE", (Object)logTypes[i]);
                        slRow.set("LASTMSGTIME", hostRow.get("LAST_MSG_TIME"));
                        newDobj.addRow(slRow);
                    }
                }
                DataAccess.add((DataObject)newDobj);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void createPredefinedWindowsLogtypes(Long hostID, Long lastMessageTime, Map<String, Boolean> logtypeDetails) {
        for (String logtype : logtypeDetails.keySet()) {
            Row slRow = new Row("HostToLogTypeMapping");
            slRow.set("HOST_ID", (Object)hostID);
            slRow.set("LOGTYPE", (Object)logtype);
            slRow.set("ISENABLED", (Object)logtypeDetails.get(logtype));
            slRow.set("LASTMSGTIME", (Object)lastMessageTime);
            DBUtil.createNewRow(slRow, new boolean[0]);
        }
    }

    static {
        deleteAllSysEvtColZip = true;
    }
}

