/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.LaUtil;
import com.adventnet.la.util.Mailer;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.logcollector.LogCollectorProcess;
import com.manageengine.ela.server.common.device.LogCollectionStatus;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class LogAlert
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LogAlert.class.getName());
    private Map mailServerSettings = null;
    int selectedinterval;
    int sinterval;
    int minterval;
    long timeinterval;
    String name = null;
    String toaddress = null;
    String subject = null;
    String endisabled = null;
    private boolean mailresult = false;
    Object taskid = null;
    String balert = null;
    String lmsgtime = "";
    String ftime = "";
    String currenttime = "";
    private static long startTime = 0L;

    public static void setStartTime() {
        if (startTime == 0L) {
            startTime = System.currentTimeMillis();
        }
    }

    public void setTaskID(Object taskid) {
        this.taskid = taskid;
    }

    @Override
    public void run() {
        try {
            LOGGER.info("IN LOGALET THREAD");
            SelectQueryImpl query1 = new SelectQueryImpl(new Table("SystemConfigurations"));
            query1.addSelectColumn(new Column("SystemConfigurations", "*"));
            Criteria migCrit = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"collectionInterval", 0);
            Criteria migCrit1 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"LAlertMail", 0);
            Criteria migCrit2 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"LAlertSubject", 0);
            Criteria migCrit3 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"LAlertStatus", 0);
            Criteria migCrit4 = new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"LBulkMail", 0);
            Criteria cri = migCrit.or(migCrit1).or(migCrit2).or(migCrit3).or(migCrit4);
            query1.setCriteria(cri);
            DataObject result = DataAccess.get((SelectQuery)query1);
            if (result.size("SystemConfigurations") > 0) {
                this.selectedinterval = this.sinterval = Integer.parseInt((String)result.getValue("SystemConfigurations", "CONF_VALUE", migCrit));
                this.toaddress = (String)result.getValue("SystemConfigurations", "CONF_VALUE", migCrit1);
                this.subject = (String)result.getValue("SystemConfigurations", "CONF_VALUE", migCrit2);
                this.endisabled = (String)result.getValue("SystemConfigurations", "CONF_VALUE", migCrit3);
                this.balert = (String)result.getValue("SystemConfigurations", "CONF_VALUE", migCrit4);
            }
            if (!"1".equals(this.endisabled)) {
                SelectQueryImpl query = new SelectQueryImpl(new Table("HostDetails"));
                query.addSelectColumn(new Column("HostDetails", "*"));
                query.addSelectColumn(new Column("Hosts", "*"));
                query.addSelectColumn(new Column("LogCollectionAlert", "*"));
                query.addSelectColumn(new Column("SyslogServers", "*"));
                Join join = new Join("HostDetails", "LogCollectionAlert", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2);
                Join join1 = new Join("HostDetails", "Hosts", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2);
                Join join2 = new Join("HostDetails", "SyslogServers", new String[]{"SLID"}, new String[]{"SLID"}, 2);
                query.addJoin(join);
                query.addJoin(join1);
                query.addJoin(join2);
                DataObject obj = DataAccess.get((SelectQuery)query);
                ArrayList<String> hostname = new ArrayList<String>();
                ArrayList<Object> lastmsgtime = new ArrayList<Object>();
                ArrayList<Object> statuslist = new ArrayList<Object>();
                ArrayList<Long> monInterval = new ArrayList<Long>();
                ArrayList<LogCollectionStatus> logCollectionStatus = new ArrayList<LogCollectionStatus>();
                ArrayList<Long> hidlist = new ArrayList<Long>();
                ArrayList<Boolean> agentBoolList = new ArrayList<Boolean>();
                Iterator hitr = obj.getRows("Hosts");
                while (hitr.hasNext()) {
                    Row hrow = (Row)hitr.next();
                    hostname.add((String)hrow.get("DISPLAY_NAME"));
                }
                Iterator lasttimeitr = obj.getRows("HostDetails");
                while (lasttimeitr.hasNext()) {
                    Row ltime = (Row)lasttimeitr.next();
                    lastmsgtime.add(ltime.get("LAST_MSG_TIME"));
                    hidlist.add((Long)ltime.get("HOST_ID"));
                    monInterval.add((Long)ltime.get("MON_INTERVAL"));
                    logCollectionStatus.add(LogCollectionStatus.getStatus((Integer)ltime.get("LOG_COLLECTION_STATUS")));
                    Row isAgentRow = obj.getFirstRow("SyslogServers", ltime);
                    if ("-".equalsIgnoreCase((String)isAgentRow.get("PORTS"))) {
                        agentBoolList.add(true);
                        continue;
                    }
                    agentBoolList.add(false);
                }
                Iterator statusitr = obj.getRows("LogCollectionAlert");
                while (statusitr.hasNext()) {
                    Row sta = (Row)statusitr.next();
                    statuslist.add(sta.get("STATUS"));
                }
                StringBuffer sb = new StringBuffer();
                StringBuffer hnameBuffer = new StringBuffer();
                StringBuffer hlist = new StringBuffer();
                StringBuffer contradicted = new StringBuffer();
                String lalert = null;
                long timenow = System.currentTimeMillis();
                long fromtime = timenow - (long)(this.selectedinterval * 60 * 1000);
                long runningTime = (timenow - startTime) / 60000L;
                Calendar calfrom = Calendar.getInstance();
                Calendar calto = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("MMM dd yyyy HH:mm");
                calfrom.setTimeInMillis(fromtime);
                calto.setTimeInMillis(timenow);
                this.ftime = sdf.format(calfrom.getTime());
                this.currenttime = sdf.format(calto.getTime());
                int serialno = 1;
                for (int i = 0; i < obj.size("LogCollectionAlert"); ++i) {
                    String lsttimeempty = (String)lastmsgtime.get(i);
                    if ("".equals(lsttimeempty) || lsttimeempty == null || " ".equals(lsttimeempty)) {
                        lsttimeempty = "0";
                    }
                    long hosttime = Long.parseLong(lsttimeempty);
                    Long hostid = (Long)hidlist.get(i);
                    Integer status = (Integer)statuslist.get(i);
                    this.timeinterval = (timenow - hosttime) / 60000L;
                    this.name = (String)hostname.get(i);
                    this.minterval = ((Long)monInterval.get(i)).intValue();
                    LogCollectionStatus lcStatus = (LogCollectionStatus)((Object)logCollectionStatus.get(i));
                    if (this.timeinterval > (long)this.selectedinterval && this.sinterval > this.minterval && status.toString().equals("0") && runningTime > (long)this.sinterval && lcStatus == LogCollectionStatus.ENABLED) {
                        if (!((Boolean)agentBoolList.get(i)).booleanValue() && !LogCollectorProcess.getInstance().isLogCollectorRunning()) continue;
                        hlist.append("\n" + serialno++ + "." + this.name);
                        lalert = "sendmail";
                        status = new Integer(1);
                        this.updateStatus(status, hostid);
                        continue;
                    }
                    if (this.timeinterval < (long)this.selectedinterval && (status.toString().equals("1") || status.toString().equals("3"))) {
                        status = new Integer(0);
                        this.updateStatus(status, hostid);
                        continue;
                    }
                    if (this.sinterval >= this.minterval || "4".equals(this.balert)) continue;
                    this.updateStatus(new Integer(3), hostid);
                    contradicted.append("\n" + this.name);
                }
                if (lalert != null) {
                    this.sendmail(hlist.toString(), this.ftime, this.currenttime);
                }
                if (contradicted.length() > 0 && !"4".equals(this.balert)) {
                    Row bulk = new Row("SystemConfigurations");
                    bulk.set("CONF_NAME", (Object)"LBulkMail");
                    bulk.set("CONF_VALUE", (Object)"4");
                    result.updateRow(bulk);
                    DataAccess.update((DataObject)result);
                    this.sendmail(contradicted.toString(), this.ftime, "3");
                }
            }
            if ("1".equals(this.endisabled)) {
                ClockDaemon clock = new ClockDaemon();
                ClockDaemon.cancel((Object)this.taskid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateStatus(Integer status, Long hostid) {
        try {
            UpdateQueryImpl updatestatus = new UpdateQueryImpl("LogCollectionAlert");
            updatestatus.setCriteria(new Criteria(new Column("LogCollectionAlert", "HOST_ID"), (Object)hostid, 0));
            updatestatus.setUpdateColumn("STATUS", (Object)status);
            DataAccess.update((UpdateQuery)updatestatus);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendmail(String honame, String fromtime, String currenttime) {
        try {
            ResourceBundle bundle = null;
            String message = "";
            StringBuffer hnbuffer = new StringBuffer();
            bundle = ProductBundle.getInstance().getBundle();
            this.mailServerSettings = LaUtil.getMailAttributes();
            if (!"3".equals(currenttime)) {
                message = bundle.getString("LogAlert.Mail1") + " " + bundle.getString("pdfHome_FromTime") + ":" + fromtime + "\t" + bundle.getString("pdfHome_ToTime") + ":" + currenttime + " " + bundle.getString("LogAlert.followinghosts") + "\n" + honame;
            }
            if ("3".equals(currenttime)) {
                message = bundle.getString("LogAlert.Contradiction") + " " + honame + " " + bundle.getString("LogAlert.ScanInterval") + "\n";
                message = message + bundle.getString("LogAlert.note");
            }
            String server = (String)this.mailServerSettings.get("SmtpServer");
            String port = (String)this.mailServerSettings.get("SmtpServerPort");
            String username = (String)this.mailServerSettings.get("uName");
            String password = (String)this.mailServerSettings.get("pWord");
            String auth = (String)this.mailServerSettings.get("authenticate");
            String from = (String)this.mailServerSettings.get("fromId");
            String tls = (String)this.mailServerSettings.get("tls");
            Mailer mailer = new Mailer();
            mailer.setMailHost(server);
            mailer.setSmtpPort(port);
            mailer.setFromAddress(from);
            mailer.setToAddress(this.toaddress);
            mailer.setMailSubject(this.subject);
            if (username != null && !"".equals(username)) {
                mailer.setUserName(username);
            }
            if (password != null && !"".equals(password)) {
                mailer.setPassword(password);
            }
            if (tls != null && !"".equals(tls)) {
                mailer.setTLS(tls);
            }
            mailer.initialize();
            mailer.setAutoReplyText(message);
            mailer.constructMessage();
            this.mailresult = mailer.sendIt();
            if (this.mailresult) {
                LOGGER.info("Mail send Succesfully for host:::" + honame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

