/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server;

import com.adventnet.la.CorrelationField;
import com.adventnet.nba.engine.NbaEngine;
import com.adventnet.nba.engine.NotifyHandler;
import com.adventnet.nba.meta.Parameter;
import com.adventnet.nba.meta.ParameterCatalog;
import com.adventnet.nba.meta.RuleCatalog;
import com.adventnet.sa.server.cnf.CorrelationNotifyHandle;
import com.adventnet.sa.server.lc.FieldRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class NbaServiceUtil {
    public static boolean isNbaStarted = false;
    public static String nbasession = "EventLog";
    public static Logger sysout = Logger.getLogger("systemprint");

    public static boolean isNbaEngineRunning() {
        return isNbaStarted;
    }

    public static boolean isNbaAddOnEnabled() {
        return true;
    }

    public static boolean shutdownNbaEngine() {
        try {
            NbaEngine.getInstance().shutdown();
            NbaEngine.getInstance().unbuild();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            isNbaStarted = false;
        }
        return isNbaStarted;
    }

    public static boolean stopNbaEngine() {
        try {
            NbaEngine.getInstance().stop();
            NbaEngine.getInstance().unbuild();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            isNbaStarted = false;
        }
        return isNbaStarted;
    }

    public static boolean blockNbaEngine() {
        try {
            sysout.info("Correlation Engine is blocked from NbaServiceUtil");
            NbaEngine.getInstance().block();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return NbaEngine.getInstance().getState() == 3;
    }

    public static boolean UnblockNbaEngine() {
        try {
            sysout.info("Correlation Engine is Unblocked from NbaServiceUtil");
            NbaEngine.getInstance().Unblock();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return NbaEngine.getInstance().getState() == 2;
    }

    public static boolean createSession(String sessionName) {
        return NbaEngine.getInstance().generate(sessionName) != null;
    }

    public static boolean startNbaEngine(String sessionName) {
        try {
            if (NbaServiceUtil.isNbaEngineRunning()) {
                sysout.info("NBA Engine already running.");
                return true;
            }
            if (NbaServiceUtil.isNbaAddOnEnabled()) {
                NbaEngine nbaengi = NbaEngine.getInstance();
                Parameter pram = ParameterCatalog.getInstance().get("isNBAShutdown");
                if (pram == null || pram.getValue().equalsIgnoreCase("false")) {
                    nbaengi.build();
                    nbaengi.start();
                    isNbaStarted = true;
                } else {
                    sysout.info("NBA Engine shutdown");
                }
                if (!NbaServiceUtil.createSession(sessionName)) {
                    sysout.info("NBA Session creation failed with session name" + sessionName);
                } else {
                    sysout.info("-----------------NBA Engine Start Code Called.----------");
                }
                nbaengi.getSession(nbasession).setNotifyHandler((NotifyHandler)CorrelationNotifyHandle.getInstance());
            } else {
                sysout.info("NBA Addon license not found or expired");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isNbaStarted;
    }

    public static void loadFieds() {
        Map ruleIdToStreamFieldsMap = RuleCatalog.getRuleFields();
        List indexedFields = FieldRepository.get_instance().getIndexedFields("CORRELATION");
        List<String> avoidFields = Arrays.asList("LDIST_DHOST", "LDIST_SHOST", "LDIST_SRCUSER");
        HashMap fieldMap = new HashMap();
        for (Map.Entry item : ruleIdToStreamFieldsMap.entrySet()) {
            Long key = (Long)item.getKey();
            String[] fields = (String[])item.getValue();
            ArrayList<String> fieldList = new ArrayList<String>();
            for (String field : fields) {
                if (avoidFields.contains(field)) {
                    field = field.replaceAll("LDIST_", "");
                    fieldList.add(field);
                    continue;
                }
                if (!indexedFields.contains(field)) continue;
                fieldList.add(field);
            }
            fieldList.add("EVID_TO_INDEX");
            fieldList.add("MSGFIELD");
            fieldList.add("TIME");
            fieldMap.put(key, fieldList);
        }
        sysout.info("Correlation Field Map" + fieldMap);
        CorrelationField.get_instance();
        CorrelationField.setFields(fieldMap);
    }

    public static String getNbaUserRole() {
        ParameterCatalog pci = ParameterCatalog.getInstance();
        Parameter aurP = pci == null ? null : pci.get("ALLOWED_USER_ROLES");
        return aurP == null ? null : aurP.getValue();
    }
}

