/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.agent;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.fieldgen.SystemCustomPatternHandler;
import com.adventnet.nba.engine.NbaEngine;
import com.adventnet.nba.engine.NbaSession;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.EAService;
import com.adventnet.sa.server.NbaServiceUtil;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.lc.Log;
import com.adventnet.sa.server.lc.LogDataIndexer;
import com.adventnet.sa.server.nf.NotificationManager;
import com.manageengine.ela.server.common.io.file.FileHandler;
import com.manageengine.ela.server.common.logforwarder.LogForwarderFilter;
import com.manageengine.ela.server.logflowrate.LogCountHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DataProcessor
implements Runnable {
    private static final int BUFFER_SIZE = 2048;
    private static final Logger LOGGER = Logger.getLogger(DataProcessor.class.getName());
    private static LogCountHolder logCountHolder = LogCountHolder.getAgentHolder();
    private String dataFolder = System.getProperty("server.home") + File.separator + "data" + File.separator;
    private String zipName = null;
    private String dataFileName = null;
    private String aggregateFileName = null;
    private String terminalFileName = null;
    private String printServerFileName = null;
    private String mssqlFileName = null;
    private String renameLogData = null;
    private String changeIndexData = null;
    private String trendFileData = null;
    private String terminalLogsData = null;
    private String printServerLogsData = null;
    private String mssqlLogsData = null;
    private String fileType = null;
    private long agentId;
    private Map<Long, Long> hostLastMessageTimes = new HashMap<Long, Long>();
    private ArchiveFileManager afManager = ArchiveFileManager.getInstance();
    private NotificationManager nfManager = NotificationManager.getInstance();
    private LogForwarderFilter logforwarder = LogForwarderFilter.getInstance();
    private Connection conn = null;
    private Statement stat = null;

    public DataProcessor(String zipName) {
        this.zipName = zipName;
    }

    @Override
    public void run() {
        boolean unzipStatus = this.unzipFile();
        try {
            if (unzipStatus) {
                int matchIndex = this.zipName.indexOf("logdata_");
                if (matchIndex != -1) {
                    this.indexData(this.zipName);
                } else if (this.fileType.equals("changedata")) {
                    this.indexData("changeindex");
                }
                this.deleteFiles();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unzipFile() {
        String[] validFiles = new String[]{"aggregate", "rawlogs", "fimtrendfile", "changeindex", "renameconfig", "terminallogs", "terminaltrend", "mssqllogs", "mssqltrend", "printserverlogs", "printservertrend"};
        FilterOutputStream dest = null;
        BufferedInputStream is = null;
        LOGGER.info("Unzippin file : " + this.zipName);
        ZipFile zipFile = null;
        boolean validZipFile = true;
        try {
            zipFile = new ZipFile(this.zipName);
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.info("Exception while opening zip file. Returning");
            return false;
        }
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        String dirName = this.getDirName();
        File dir = new File(this.dataFolder + dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream fos = null;
        while (en.hasMoreElements()) {
            ZipEntry zipEntry = en.nextElement();
            String zipEntryName = zipEntry.getName();
            String fileName = dir.getAbsolutePath() + File.separator + zipEntryName;
            boolean isValid = false;
            boolean isDir = zipEntry.isDirectory();
            for (int i = 0; i < validFiles.length; ++i) {
                if (!isDir && zipEntryName.compareTo(validFiles[i]) == 0) {
                    isValid = true;
                    break;
                }
                validZipFile = false;
            }
            if (isValid) {
                try {
                    int count;
                    is = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    fos = new FileOutputStream(fileName);
                    dest = new BufferedOutputStream(fos, 2048);
                    byte[] data = new byte[2048];
                    int acount = 0;
                    while ((count = is.read(data, 0, 2048)) != -1) {
                        ((BufferedOutputStream)dest).write(data, 0, count);
                        acount += count;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        dest.close();
                        fos.close();
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            LOGGER.info("Got fileName in unzip :" + fileName);
            if (fileName.matches(".*rawlogs*")) {
                this.dataFileName = fileName.replace('\\', '/');
                this.fileType = "logagent";
                LOGGER.info("Got data file :" + this.dataFileName);
                continue;
            }
            if (fileName.matches(".*aggregate*")) {
                this.aggregateFileName = fileName.replace('\\', '/');
                this.fileType = "logagent";
                LOGGER.info("Got aggregate file :" + this.aggregateFileName);
                continue;
            }
            if (fileName.matches(".*terminallogs*")) {
                this.terminalLogsData = fileName.replace('\\', '/');
                this.fileType = "terminalagent";
                LOGGER.info("Got Terminal data file :" + this.terminalLogsData);
                continue;
            }
            if (fileName.matches(".*terminaltrend*")) {
                this.terminalFileName = fileName.replace('\\', '/');
                this.fileType = "terminalagent";
                LOGGER.info("Got Terminal aggregate file :" + this.terminalFileName);
                continue;
            }
            if (fileName.matches(".*printserverlogs*")) {
                this.printServerLogsData = fileName.replace('\\', '/');
                this.fileType = "printserveragent";
                LOGGER.info("Got Print Server Data file :" + this.printServerLogsData);
                continue;
            }
            if (fileName.matches(".*printservertrend*")) {
                this.printServerFileName = fileName.replace('\\', '/');
                this.fileType = "printserveragent";
                LOGGER.info("Got Print Server aggregate file :" + this.printServerFileName);
                continue;
            }
            if (fileName.matches(".*mssqllogs*")) {
                this.mssqlLogsData = fileName.replace('\\', '/');
                this.fileType = "mssqlagent";
                LOGGER.info("Got mssql data file :" + this.mssqlLogsData);
                continue;
            }
            if (fileName.matches(".*mssqltrend*")) {
                this.mssqlFileName = fileName.replace('\\', '/');
                this.fileType = "mssqlagent";
                LOGGER.info("Got mssql aggregate file :" + this.mssqlFileName);
                continue;
            }
            if (fileName.matches(".*renameconfig*")) {
                this.renameLogData = fileName.replace('\\', '/');
                this.fileType = "changedata";
                int zippos = 0;
                zippos = this.zipName.indexOf("zip");
                if (zippos > 0) {
                    int pPos = this.zipName.indexOf("changedata_");
                    String temp = null;
                    temp = this.zipName.substring(pPos += 11, zippos - 1);
                    this.agentId = Long.parseLong(temp);
                } else {
                    LOGGER.info("Error in getting agent id from Zip file name " + this.zipName);
                }
                LOGGER.info("Got renamed files data :" + this.renameLogData);
                continue;
            }
            if (fileName.matches(".*changeindex*")) {
                this.changeIndexData = fileName.replace('\\', '/');
                this.fileType = "changedata";
                LOGGER.info("Got changed index data :" + this.changeIndexData);
                continue;
            }
            if (!fileName.matches(".*fimtrendfile*")) continue;
            this.trendFileData = fileName.replace('\\', '/');
            this.fileType = "changedata";
            LOGGER.info("Got FIM Trend data :" + this.trendFileData);
        }
        if (!validZipFile) {
            try {
                zipFile.close();
                File file = new File(this.zipName);
                this.deleteZip(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexData(String fileName) throws Exception {
        LOGGER.info("Indexing data..");
        BufferedInputStream is = null;
        BufferedInputStream isTerm = null;
        BufferedInputStream isPrnt = null;
        BufferedInputStream isMssql = null;
        try {
            int matchIndex = fileName.indexOf("logdata_");
            if (matchIndex != -1) {
                if (this.aggregateFileName != null) {
                    is = new BufferedInputStream(new FileInputStream(this.dataFileName));
                    LOGGER.info("Indexing Log data..");
                    this.indexActData("logagent", fileName, is);
                    this.updateLastMessageTime();
                    this.dumpAggregate("logagent");
                }
                if (this.terminalLogsData != null) {
                    isTerm = new BufferedInputStream(new FileInputStream(this.terminalLogsData));
                    LOGGER.info("Indexing Terminal data..");
                    this.indexActData("terminalagent", fileName, isTerm);
                    this.dumpAggregate("terminalagent");
                }
                if (this.printServerLogsData != null) {
                    isPrnt = new BufferedInputStream(new FileInputStream(this.printServerLogsData));
                    LOGGER.info("Indexing Print Server data..");
                    this.indexActData("printserveragent", fileName, isPrnt);
                    this.dumpAggregate("printserveragent");
                }
                if (this.mssqlLogsData != null) {
                    isMssql = new BufferedInputStream(new FileInputStream(this.mssqlLogsData));
                    LOGGER.info("Indexing MSSQL data..");
                    this.indexActData("mssqlagent", fileName, isMssql);
                    this.dumpAggregate("mssqlagent");
                }
            } else {
                is = new BufferedInputStream(new FileInputStream(this.changeIndexData));
                LOGGER.info("Indexing FIM data..");
                this.indexActData("changeindex", fileName, is);
                this.dumpAggregate("changedata");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                is = null;
            }
            if (isTerm != null) {
                try {
                    isTerm.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                isTerm = null;
            }
            if (isPrnt != null) {
                try {
                    isPrnt.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                isPrnt = null;
            }
            if (isMssql != null) {
                try {
                    isMssql.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                isMssql = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexActData(String fileType, String fileName, BufferedInputStream is) {
        try {
            int logCount = 0;
            int matchIndex = fileName.indexOf("logdata_");
            byte[] logLength = new byte[2];
            while (true) {
                int count;
                if ((count = is.read(logLength, 0, 2)) == -1) {
                    LOGGER.info("Read complete ");
                    break;
                }
                int length = this.getLogLength(logLength);
                byte[] data = new byte[length];
                data[0] = logLength[0];
                data[1] = logLength[1];
                count = is.read(data, 2, length - 2);
                if (count == -1) break;
                Log log = new Log(data, length);
                if (!log.parseLog()) continue;
                try {
                    if ("changeindex".equals(fileType.toLowerCase())) {
                        LOGGER.finer("Final Log Print for FIM : " + log.toString());
                    }
                    if (EAService.showPremiumFeatures()) {
                        SystemCustomPatternHandler.getInstance().parse((Hashtable)log);
                        LOGGER.finer("After adding user defined fields, the Parsed Contents are : " + log);
                    }
                    LogDataIndexer.getInstance().indexLogData(log);
                    NbaSession sess = NbaEngine.getInstance().getSession(NbaServiceUtil.nbasession);
                    if (sess != null) {
                        sess.input((Object)log);
                    }
                }
                catch (Exception ee) {
                    LOGGER.info("Log Print : " + log.toString());
                    ee.printStackTrace();
                }
                if (matchIndex != -1 && "logagent".equals(fileType.toLowerCase())) {
                    try {
                        this.afManager.archiveLog(log);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                    try {
                        this.logforwarder.filterAndForward(log);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Long lastMsgTimeForHost = this.hostLastMessageTimes.get((Long)log.get("HOSTID"));
                    if (lastMsgTimeForHost == null || lastMsgTimeForHost < (Long)log.get("TIME")) {
                        this.hostLastMessageTimes.put((Long)log.get("HOSTID"), (Long)log.get("TIME"));
                    }
                }
                try {
                    this.nfManager.notify((Log)log.clone());
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                ++logCount;
                logCountHolder.increment();
            }
            LOGGER.info("Got " + logCount + " logs");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private int getLogLength(byte[] data) {
        return (0xFF & data[0]) << 8 | 0xFF & data[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAggregate(String fileType) {
        String fileName = null;
        String trendDir = this.dataFolder + "trends" + File.separator;
        int loopCount = 1;
        int i = 0;
        try {
            this.conn = RelationalAPI.getInstance().getConnection();
            this.stat = this.conn.createStatement();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        LOGGER.info("Inside DumpAggregate,  FileType is ------------- " + fileType);
        try {
            String newFileName = null;
            if ("logagent".equals(fileType.toLowerCase())) {
                fileName = this.aggregateFileName;
                newFileName = trendDir + "eventhrtrend_" + Thread.currentThread().getId() + "_" + System.currentTimeMillis();
            } else if ("terminalagent".equals(fileType.toLowerCase())) {
                fileName = this.terminalFileName;
                newFileName = trendDir + "terminalserverhrtrend_" + Thread.currentThread().getId() + "_" + System.currentTimeMillis();
            } else if ("printserveragent".equals(fileType.toLowerCase())) {
                fileName = this.printServerFileName;
                newFileName = trendDir + "printserverhrtrend_" + Thread.currentThread().getId() + "_" + System.currentTimeMillis();
            } else if ("mssqlagent".equals(fileType.toLowerCase())) {
                fileName = this.mssqlFileName;
                newFileName = trendDir + "mssqlhrtrend_" + Thread.currentThread().getId() + "_" + System.currentTimeMillis();
            } else if ("changedata".equals(fileType.toLowerCase())) {
                fileName = this.trendFileData;
                newFileName = trendDir + "fimhrtrend_" + Thread.currentThread().getId() + "_" + System.currentTimeMillis();
            }
            while (i < loopCount) {
                LOGGER.fine("Agent trend file move from " + fileName + " to " + newFileName);
                File oldFile = new File(fileName);
                File newFile = new File(newFileName);
                if (!FileHandler.renameFile(oldFile, newFile)) {
                    LOGGER.severe("Problem while moving file to trends folder " + fileName);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.stat.close();
                this.conn.close();
            }
            catch (Exception exp) {
                this.stat = null;
                this.conn = null;
            }
        }
    }

    private void updateLastMessageTime() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("HostDetails"));
            query.addSelectColumn(new Column("HostDetails", "*"));
            query.setCriteria(new Criteria(new Column("HostDetails", "HOST_ID"), (Object)this.hostLastMessageTimes.keySet().toArray(), 8));
            DataObject doo = DataAccess.get((SelectQuery)query);
            for (Map.Entry<Long, Long> e : this.hostLastMessageTimes.entrySet()) {
                Row r = doo.getRow("HostDetails", new Criteria(new Column("HostDetails", "HOST_ID"), (Object)e.getKey(), 0));
                if (e.getValue() != null && r != null) {
                    r.set("LAST_MSG_TIME", (Object)e.getValue());
                }
                doo.updateRow(r);
            }
            DataAccess.update((DataObject)doo);
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    private void deleteFiles() {
        File[] files;
        File dir = new File(this.dataFolder + this.getDirName());
        for (File f : files = dir.listFiles()) {
            LOGGER.info("Deleting file : " + f);
            f.delete();
        }
    }

    private String getDirName() {
        String name = new File(this.zipName).getName();
        return name.substring(0, name.lastIndexOf(".zip"));
    }

    public Long getAppID(Long hostId) {
        Long appId = -1L;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("AppResources"));
            query.addSelectColumn(new Column("AppResources", "*"));
            Criteria hostCrt = new Criteria(new Column("AppResources", "HOSTID"), (Object)hostId, 0);
            Criteria formatCrt = new Criteria(new Column("AppResources", "FORMATID"), (Object)new Long(4L), 0);
            query.setCriteria(hostCrt);
            DataObject doo = DataAccess.get((SelectQuery)query);
            if (!doo.isEmpty()) {
                appId = (Long)doo.getFirstValue("AppResources", "APPID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appId;
    }

    private void deleteZip(File fileName) {
        boolean bol = false;
        try {
            bol = fileName.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.finer("file deleted : " + bol);
    }
}

