/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.agent;

import com.adventnet.sa.server.agent.DataProcessor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

public class DataQueueHandler {
    private final int cpus = Runtime.getRuntime().availableProcessors();
    private final ExecutorService exec = Executors.newFixedThreadPool(this.cpus);
    private static DataQueueHandler instance = null;
    private static final Logger LOGGER = Logger.getLogger(DataQueueHandler.class.getName());

    private DataQueueHandler() {
    }

    public static synchronized DataQueueHandler getInstance() {
        if (instance == null) {
            instance = new DataQueueHandler();
        }
        return instance;
    }

    public void addTask(String zipName) {
        LOGGER.info("Adding task with zip name : " + zipName);
        this.exec.submit(new DataProcessor(zipName));
    }

    public void shutdown() {
        LOGGER.info("Shutting down DataQueueHandler");
        this.exec.shutdown();
    }
}

