/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.aggregate;

import com.adventnet.la.tools.ConnectionUtil;
import com.adventnet.la.util.ResourceCheckerUtil;
import com.adventnet.logsearch.index.api.LogIndexingAPI;
import com.adventnet.logsearch.search.BatchResult;
import com.adventnet.logsearch.search.Constraint;
import com.adventnet.logsearch.search.LogSearchAPI;
import com.adventnet.logsearch.search.LongConstraint;
import com.adventnet.logsearch.search.LuceneCriteria;
import com.adventnet.sa.server.aggregate.TrendTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Aggregator
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(Aggregator.class.getName());
    private String tableName;
    private String trendTablename;
    private TrendTable trendTableType;
    private FileWriter trendfWriter;
    private PrintWriter trendpWriter;
    private static final String DELIMITER = "|**|";
    private static final String RECORDDELIMITER = "|**|**|";
    private static int nullstring = 0;
    private static boolean dbType = "mysql".equals(System.getProperty("DBType", "mysql"));
    private Statement stat = null;
    private Connection conn = null;
    private int rowCount = 0;
    ResultSet resultSet = null;
    private static final int RECORDS_PER_ITERATION = 50000;

    public Aggregator(String tableName, TrendTable trendTableType) {
        this.tableName = tableName;
        this.trendTableType = trendTableType;
    }

    @Override
    public void run() {
        try {
            boolean count = false;
            String DBType2 = System.getProperty("DBType", "mysql");
            this.conn = ConnectionUtil.getConnection((String)DBType2);
            this.stat = this.conn.createStatement();
            this.createTable();
            if (this.trendTableType == TrendTable.LOG_HR_TREND) {
                this.process(TrendTable.LOG_HR_TREND_SYS);
                this.process(TrendTable.LOG_HR_TREND_WIN);
            } else {
                this.process(this.trendTableType);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception in processing table:" + this.tableName);
            e.printStackTrace();
        }
        finally {
            try {
                if (this.stat != null) {
                    this.stat.close();
                }
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void process(TrendTable trendType) {
        try {
            long startTime = 0L;
            long endTime = System.currentTimeMillis();
            this.resultSet = this.stat.executeQuery(trendType.getTableTime(this.tableName));
            while (this.resultSet.next()) {
                startTime = this.resultSet.getTimestamp("START_TIME").getTime();
                try {
                    endTime = "0000-00-00 00:00:00".equals(this.resultSet.getString("END_TIME")) ? System.currentTimeMillis() : this.resultSet.getTimestamp("END_TIME").getTime();
                }
                catch (SQLException slqe) {
                    endTime = System.currentTimeMillis();
                }
            }
            List storedColumns = trendType.getStoredColumns();
            LongConstraint[] timeConstraint = new LongConstraint[]{new LongConstraint("TIME", startTime, 5, storedColumns), new LongConstraint("TIME", endTime, 6, storedColumns)};
            LuceneCriteria luceneCrit = new LuceneCriteria(new Constraint[0], (Constraint[])timeConstraint, null, false);
            luceneCrit.setLuceneFieldCriteria(trendType.getFieldContraint(this.conn, this.stat, this.resultSet));
            luceneCrit.setApproxCountNeeded(false);
            this.resultSet = this.stat.executeQuery("Select CONF_NAME,CONF_VALUE from IndexConfigurations where CONF_NAME ='indexPath'");
            String indexPath = System.getProperty("server.home") + File.separator + "server" + File.separator + "indexes";
            String path = null;
            Object univPath = null;
            while (this.resultSet.next()) {
                path = this.resultSet.getString(1);
            }
            if (!path.equals("indexes")) {
                indexPath = path;
            }
            this.setLogIndexingAPI(indexPath);
            BatchResult result = null;
            int[] searchStart = new int[]{0, 0, 0};
            int[] storedPoint = new int[]{-1, -1};
            String[] selectColumns = trendType.getSelectColumns();
            int[] selectColumnIndexes = new int[selectColumns.length];
            int i = 0;
            for (String selectColumn : selectColumns) {
                selectColumnIndexes[i] = storedColumns.contains(selectColumn) ? storedColumns.indexOf(selectColumn) : -1;
                ++i;
            }
            do {
                result = LogSearchAPI.getBatchResult((LuceneCriteria)luceneCrit, (int)50000, (int)searchStart[0], (int)searchStart[1], (int)searchStart[2], (int)storedPoint[0], (int)storedPoint[1], (int)0, (int)0, (int)0, (boolean)false, (String[])new String[]{"HOSTID"});
                this.trendfWriter = new FileWriter(System.getProperty("server.home") + File.separator + "data" + File.separator + this.tableName + "_lc.txt");
                this.trendpWriter = new PrintWriter((Writer)new BufferedWriter(this.trendfWriter), false);
                this.processResults(result, selectColumns, selectColumnIndexes);
                searchStart[0] = result.getIndexID();
                searchStart[1] = result.getDocID();
                searchStart[2] = result.getRowID();
                storedPoint[0] = result.getStoredIndexID();
                storedPoint[1] = result.getStoredDocID();
            } while (result.getSearchCount() >= 50000);
        }
        catch (Exception lse) {
            LOGGER.log(Level.INFO, "Exception in processing table:" + this.tableName);
            lse.printStackTrace();
        }
    }

    private void processResults(BatchResult result, String[] selectColumns, int[] selectColumnIndexes) {
        Iterator hostIdIterator = result.getFieldsValue("HOSTID").entrySet().iterator();
        Map.Entry entryValue = hostIdIterator.hasNext() ? hostIdIterator.next() : null;
        Iterator rowIter = result.getMatchResults().iterator();
        String fieldDelimiter = LogIndexingAPI.getInstance().getFieldDelimiter();
        this.rowCount = 0;
        GregorianCalendar cal = new GregorianCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:00:00");
        Hashtable<String, String> h = new Hashtable<String, String>();
        while (rowIter.hasNext()) {
            String rowString = (String)rowIter.next();
            String[] resultCols = rowString.split(fieldDelimiter);
            for (int i = 0; i < selectColumns.length; ++i) {
                int index = selectColumnIndexes[i];
                if (index < 0) {
                    Map.Entry entry = entryValue;
                    if ((Integer)entry.getKey() <= this.rowCount) {
                        entry = entryValue = hostIdIterator.next();
                    }
                    h.put(selectColumns[i], (String)entry.getValue());
                    continue;
                }
                h.put(selectColumns[i], resultCols[index]);
            }
            cal.setTimeInMillis(Long.valueOf((String)h.get("TIME")));
            h.put("HOUROFDAY", String.valueOf(cal.get(11)));
            h.put("HOUR", dateFormat.format(cal.getTime()));
            this.writingtoflatFile(h);
            ++this.rowCount;
        }
        this.trendpWriter.flush();
        this.trendpWriter.close();
        this.loadfileinTable();
    }

    private void setLogIndexingAPI(String indexPath) {
        LogIndexingAPI api = LogIndexingAPI.getInstance();
        api.setBatchDelimiters("<-->", "<__>", "<-->");
        api.setIndexDirPath(indexPath);
        api.setLastArchivedTime("basic", System.currentTimeMillis());
        api.setLastArchivedTime("batch", System.currentTimeMillis());
        Properties apiProp = new Properties();
        apiProp.setProperty("archiveTime", "7");
        apiProp.setProperty("archiveTime_Basic", "3");
        api.updateIndexConfigVals(apiProp);
    }

    private void writingtoflatFile(Hashtable hashTrend) {
        try {
            StringBuffer trendTemp = new StringBuffer();
            if (this.trendTableType == TrendTable.EVENTLOG_HR_TREND) {
                if (dbType) {
                    trendTemp.append(DELIMITER + nullstring);
                }
                trendTemp.append(DELIMITER + hashTrend.get("HOUROFDAY"));
                trendTemp.append(DELIMITER + hashTrend.get("HOUR"));
                trendTemp.append(DELIMITER + hashTrend.get("HOSTID"));
                trendTemp.append(DELIMITER + hashTrend.get("SOURCE"));
                trendTemp.append(DELIMITER + hashTrend.get("TYPE"));
                trendTemp.append(DELIMITER + hashTrend.get("EVENTID"));
                trendTemp.append(DELIMITER + this.SeverityforWindows((String)hashTrend.get("SEVERITY")));
                trendTemp.append(RECORDDELIMITER);
                this.trendpWriter.println(trendTemp.toString());
            } else if (this.trendTableType == TrendTable.SYSLOG_HR_TREND) {
                if (dbType) {
                    trendTemp.append(DELIMITER + nullstring);
                }
                trendTemp.append(DELIMITER + hashTrend.get("HOUROFDAY"));
                trendTemp.append(DELIMITER + hashTrend.get("HOUR"));
                trendTemp.append(DELIMITER + hashTrend.get("HOSTID"));
                trendTemp.append(DELIMITER + hashTrend.get("SOURCE"));
                trendTemp.append(DELIMITER + hashTrend.get("FACILITY"));
                trendTemp.append(DELIMITER + this.SeverityforSyslog((String)hashTrend.get("SEVERITY")));
                trendTemp.append(RECORDDELIMITER);
                this.trendpWriter.println(trendTemp.toString());
            } else if (this.trendTableType == TrendTable.COMP_EVENTLOG_HR_TREND && "Security".equals(hashTrend.get("TYPE"))) {
                if (dbType) {
                    trendTemp.append(DELIMITER + nullstring);
                }
                trendTemp.append(DELIMITER + hashTrend.get("HOUROFDAY"));
                trendTemp.append(DELIMITER + hashTrend.get("HOUR"));
                trendTemp.append(DELIMITER + hashTrend.get("HOSTID"));
                trendTemp.append(DELIMITER + hashTrend.get("EVENTID"));
                trendTemp.append(DELIMITER + (hashTrend.containsKey("USERNAME") && !"null".equals(hashTrend.get("USERNAME")) ? hashTrend.get("USERNAME") : "-"));
                trendTemp.append(DELIMITER + (hashTrend.containsKey("DOMAIN") && !"null".equals(hashTrend.get("DOMAIN")) ? hashTrend.get("DOMAIN") : "-"));
                trendTemp.append(DELIMITER + (hashTrend.containsKey("LOGONTYPE") && !"null".equals(hashTrend.get("LOGONTYPE")) ? hashTrend.get("LOGONTYPE") : "-"));
                trendTemp.append(DELIMITER + hashTrend.get("SOURCE"));
                trendTemp.append("|**|1");
                trendTemp.append(RECORDDELIMITER);
                this.trendpWriter.println(trendTemp.toString());
            } else if (this.trendTableType == TrendTable.IMPORTANTEVENTS && !"null".equals(hashTrend.get("IENAME")) && !"".equals(hashTrend.get("IENAME"))) {
                if (dbType) {
                    trendTemp.append(DELIMITER + nullstring);
                }
                trendTemp.append(DELIMITER + hashTrend.get("HOUROFDAY"));
                trendTemp.append(DELIMITER + hashTrend.get("HOUR"));
                trendTemp.append(DELIMITER + hashTrend.get("HOSTID"));
                trendTemp.append(DELIMITER + hashTrend.get("IENAME"));
                trendTemp.append(DELIMITER + (hashTrend.containsKey("USERNAME") && !"null".equals(hashTrend.get("USERNAME")) ? hashTrend.get("USERNAME") : "-"));
                trendTemp.append("|**|1");
                trendTemp.append(RECORDDELIMITER);
                this.trendpWriter.println(trendTemp.toString());
            } else if (this.trendTableType == TrendTable.COMP_SYSLOG_HR_TREND) {
                if (dbType) {
                    trendTemp.append(DELIMITER + nullstring);
                }
                trendTemp.append(DELIMITER + hashTrend.get("HOUROFDAY"));
                trendTemp.append(DELIMITER + hashTrend.get("HOUR"));
                trendTemp.append(DELIMITER + hashTrend.get("HOSTID"));
                boolean AS400check = hashTrend.containsKey("MSGID");
                if (!AS400check) {
                    trendTemp.append(DELIMITER + (hashTrend.containsKey("USERNAME") && !"null".equals(hashTrend.get("USERNAME")) ? hashTrend.get("USERNAME") : "-"));
                    trendTemp.append(DELIMITER + (hashTrend.containsKey("CLIENT") && !"null".equals(hashTrend.get("CLIENT")) ? hashTrend.get("CLIENT") : "-"));
                    trendTemp.append(DELIMITER + (hashTrend.containsKey("SEVERITY") && !"null".equals(hashTrend.get("SEVERITY")) ? hashTrend.get("SEVERITY") : "-"));
                    String Source2 = (String)hashTrend.get("SOURCE");
                    String[] temp = Source2.split("-");
                    trendTemp.append(DELIMITER + temp[0]);
                    trendTemp.append(DELIMITER + temp[2]);
                    trendTemp.append(DELIMITER + (hashTrend.containsKey("FIELD1") && !"null".equals(hashTrend.get("FIELD1")) ? hashTrend.get("FIELD1") : "-"));
                    trendTemp.append(DELIMITER + (hashTrend.containsKey("FIELD2") && !"null".equals(hashTrend.get("FIELD2")) ? hashTrend.get("FIELD2") : "-"));
                }
                if (AS400check) {
                    trendTemp.append(DELIMITER + hashTrend.get("USERNAME"));
                    trendTemp.append("|**| ");
                    trendTemp.append("|**| ");
                    trendTemp.append(DELIMITER + hashTrend.get("MSGID"));
                    trendTemp.append(DELIMITER + hashTrend.get("TYPESOURCE"));
                    trendTemp.append(DELIMITER + hashTrend.get("JOBNUMBER"));
                    trendTemp.append(DELIMITER + hashTrend.get("JOBNAME"));
                }
                trendTemp.append("|**|1");
                trendTemp.append(RECORDDELIMITER);
                this.trendpWriter.println(trendTemp.toString());
            } else {
                if (dbType) {
                    trendTemp.append(DELIMITER + nullstring);
                }
                trendTemp.append(DELIMITER + hashTrend.get("HOUROFDAY"));
                trendTemp.append(DELIMITER + hashTrend.get("HOUR"));
                trendTemp.append(DELIMITER + hashTrend.get("HOSTID"));
                trendTemp.append(DELIMITER + hashTrend.get("SOURCE"));
                trendTemp.append(DELIMITER + (hashTrend.containsKey("TYPE") ? hashTrend.get("TYPE") : this.MappingFacility((String)hashTrend.get("FACILITY"))));
                trendTemp.append(DELIMITER + (hashTrend.containsKey("TYPE") ? this.SeverityforWindows((String)hashTrend.get("SEVERITY")) : this.MappingSyslog((String)hashTrend.get("SEVERITY"))));
                trendTemp.append(RECORDDELIMITER);
                this.trendpWriter.println(trendTemp.toString());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception in processing table:" + this.tableName);
            e.printStackTrace();
        }
    }

    private String SeverityforWindows(String severity) {
        if ("0".equals(severity)) {
            return "1|**|0|**|0|**|0|**|0";
        }
        if ("1".equals(severity)) {
            return "0|**|1|**|0|**|0|**|0";
        }
        if ("2".equals(severity)) {
            return "0|**|0|**|1|**|0|**|0";
        }
        if ("3".equals(severity)) {
            return "0|**|0|**|0|**|1|**|0";
        }
        return "0|**|0|**|0|**|0|**|1";
    }

    private String SeverityforSyslog(String severity) {
        if ("0".equals(severity)) {
            return "0|**|0|**|0|**|1|**|0|**|0|**|0|**|0";
        }
        if ("1".equals(severity)) {
            return "0|**|0|**|0|**|0|**|1|**|0|**|0|**|0";
        }
        if ("2".equals(severity)) {
            return "0|**|0|**|0|**|0|**|0|**|1|**|0|**|0";
        }
        if ("3".equals(severity)) {
            return "1|**|0|**|0|**|0|**|0|**|0|**|0|**|0";
        }
        if ("4".equals(severity)) {
            return "0|**|1|**|0|**|0|**|0|**|0|**|0|**|0";
        }
        if ("5".equals(severity)) {
            return "0|**|0|**|0|**|0|**|0|**|0|**|1|**|0";
        }
        if ("6".equals(severity)) {
            return "0|**|0|**|1|**|0|**|0|**|0|**|0|**|0";
        }
        return "0|**|0|**|0|**|0|**|0|**|0|**|0|**|1";
    }

    private String MappingSyslog(String severity) {
        if ("0".equals(severity) || "1".equals(severity) || "2".equals(severity) || "3".equals(severity)) {
            return "1|**|0|**|0|**|0|**|0";
        }
        if ("4".equals(severity) || "5".equals(severity)) {
            return "0|**|1|**|0|**|0|**|0";
        }
        if ("6".equals(severity) || "7".equals(severity)) {
            return "0|**|0|**|1|**|0|**|0";
        }
        return "0|**|0|**|0|**|0|**|0";
    }

    private String MappingFacility(String facility) {
        if ("daemon".equals(facility) || "kernel".equals(facility) || "user".equals(facility)) {
            return "System";
        }
        if ("auth".equals(facility) || "authpriv".equals(facility)) {
            return "Security";
        }
        return "Application";
    }

    private void createTable() {
        String createtable = null;
        this.trendTablename = this.tableName + "";
        try {
            if (dbType) {
                this.stat.executeUpdate("drop table if exists " + this.trendTablename);
                createtable = this.trendTablename.startsWith("EventLog_Hr_Trend") ? "CREATE TABLE IF NOT EXISTS `EventLog_Hr_Trend` (`ELCID` bigint(19) NOT NULL auto_increment,`HOUROFDAY` int(10) NOT NULL default '0',`HOUR` datetime NOT NULL,`HOSTID` bigint(19) NOT NULL default '0',`SOURCE` varchar(100) NOT NULL default '',`TYPE` varchar(50) NOT NULL default '',`EVENTID` int(10) NOT NULL default '0',`ERROR_CNT` bigint(19) NOT NULL default '0',`WARNING_CNT` bigint(19) NOT NULL default '0',`INFORMATION_CNT` bigint(19) NOT NULL default '0',`SUCCESS_CNT` bigint(19) NOT NULL default '0',\t`FAILURE_CNT` bigint(19) NOT NULL default '0',PRIMARY KEY  (`ELCID`),KEY `EventLog_Hr_Trend_CIDX1` (`HOUROFDAY`),KEY `EventLog_Hr_Trend_CIDX2` (`HOUR`),KEY `EventLog_Hr_Trend_CIDX3` (`HOSTID`),KEY `EventLog_Hr_Trend_CIDX4` (`SOURCE`),KEY `EventLog_Hr_Trend_CIDX5` (`EVENTID`),KEY `EventLog_Hr_Trend_CIDX6` (`TYPE`)) TYPE=InnoDB" : (this.trendTablename.startsWith("SysLog_Hr_Trend") ? "CREATE TABLE IF NOT EXISTS `SysLog_Hr_Trend` (`SLCID` bigint(19) NOT NULL auto_increment,`HOUROFDAY` int(10) NOT NULL default '0',`HOUR` datetime NOT NULL,`HOSTID` bigint(19) NOT NULL default '0',`SOURCE` varchar(100) NOT NULL default '',`TYPE` varchar(50) NOT NULL default '',`ERROR_CNT` bigint(19) NOT NULL default '0',`WARNING_CNT` bigint(19) NOT NULL default '0',`INFORMATION_CNT` bigint(19) NOT NULL default '0',`EMERGENCY_CNT` bigint(19) NOT NULL default '0',`ALERT_CNT` bigint(19) NOT NULL default '0',`CRITICAL_CNT` bigint(19) NOT NULL default '0',`NOTICE_CNT` bigint(19) NOT NULL default '0',`DEBUG_CNT` bigint(19) NOT NULL default '0',PRIMARY KEY  (`SLCID`),KEY `SysLog_Hr_Trend_CIDX1` (`HOUROFDAY`),KEY `SysLog_Hr_Trend_CIDX2` (`HOUR`),KEY `SysLog_Hr_Trend_CIDX3` (`HOSTID`),KEY `SysLog_Hr_Trend_CIDX4` (`SOURCE`),KEY `SysLog_Hr_Trend_CIDX5` (`TYPE`)) TYPE=InnoDB" : (this.trendTablename.startsWith("Comp_EventLog_Hr_Trend") ? "CREATE TABLE IF NOT EXISTS `Comp_EventLog_Hr_Trend` (`ELCID` bigint(19) NOT NULL auto_increment,`HOUROFDAY` int(10) NOT NULL default '0',`HOUR` datetime NOT NULL,`HOSTID` bigint(19) NOT NULL default '0',`EVENTID` int(10) NOT NULL default '0',`USER_NAME` varchar(100) NOT NULL default '',`DOMAIN` varchar(100) NOT NULL default '',`CLIENT` varchar(100) NOT NULL default '',`SOURCE` varchar(100) NOT NULL default '',`EVT_CNT` bigint(19) NOT NULL default '0',PRIMARY KEY  (`ELCID`),KEY `Comp_EventLog_Hr_Trend_CIDX1` (`HOSTID`),KEY `Comp_EventLog_Hr_Trend_CIDX2` (`HOUROFDAY`),KEY `Comp_EventLog_Hr_Trend_CIDX3` (`HOUR`),KEY `Comp_EventLog_Hr_Trend_CIDX4` (`EVENTID`),KEY `Comp_EventLog_Hr_Trend_CIDX5` (`USER_NAME`)) TYPE=InnoDB" : (this.trendTablename.startsWith("ImportantEvents") ? "CREATE TABLE IF NOT EXISTS `ImportantEvents` (`LCID` bigint(19) NOT NULL auto_increment,`HOUROFDAY` int(10) NOT NULL default '0',`HOUR` datetime NOT NULL,`HOSTID` bigint(19) NOT NULL default '0',`IE_NAME` varchar(100) NOT NULL default '',`USER_NAME` varchar(100) NOT NULL default '',`EVENT_CNT` bigint(19) NOT NULL default '0',PRIMARY KEY  (`LCID`),KEY `ImportantEvents_CIDX1` (`HOUR`),KEY `ImportantEvents_CIDX2` (`HOSTID`),KEY `ImportantEvents_CIDX3` (`HOUROFDAY`),KEY `ImportantEvents_CIDX4` (`IE_NAME`),KEY `ImportantEvents_CIDX5` (`USER_NAME`)) TYPE=InnoDB" : (this.trendTablename.startsWith("Comp_SysLog_Hr_Trend") ? "CREATE TABLE IF NOT EXISTS `Comp_SysLog_Hr_Trend` (`ELID` bigint(19) NOT NULL auto_increment,`HOUROFDAY` int(10) NOT NULL default '0',`HOUR` datetime default NULL,`HOSTID` bigint(19) NOT NULL default '0',`USER_NAME` varchar(250) default NULL,`CLIENT` varchar(250) NOT NULL default '',`TYPE_SEVERITY` varchar(100) NOT NULL default '',`TYPE_FACILITY` varchar(100) NOT NULL default '',`TYPE_SOURCE` varchar(100) NOT NULL default '',`FIELD1` varchar(250) NOT NULL default '',`FIELD2` varchar(250) NOT NULL default '',`EVT_CNT` int(10) NOT NULL default '0',PRIMARY KEY  (`ELID`),KEY `Comp_SysLog_Hr_Trend_CIDX1` (`HOSTID`),KEY `Comp_SysLog_Hr_Trend_CIDX2` (`HOUROFDAY`),KEY `Comp_SysLog_Hr_Trend_CIDX3` (`HOUR`),KEY `Comp_SysLog_Hr_Trend_CIDX4` (`TYPE_SOURCE`),KEY `Comp_SysLog_Hr_Trend_CIDX5` (`TYPE_SEVERITY`),KEY `Comp_SysLog_Hr_Trend_CIDX6` (`USER_NAME`)) TYPE=InnoDB" : "CREATE TABLE IF NOT EXISTS `Log_Hr_Trend` (`LCID` bigint(19) NOT NULL auto_increment,`HOUROFDAY` int(10) NOT NULL default '0',`HOUR` datetime NOT NULL,`HOSTID` bigint(19) NOT NULL default '0',`SOURCE` varchar(100) NOT NULL default '',`TYPE` varchar(50) NOT NULL default '',`ERR_CNT` bigint(19) NOT NULL default '0',`WAR_CNT` bigint(19) NOT NULL default '0',`INF_CNT` bigint(19) NOT NULL default '0',`SUC_CNT` bigint(19) NOT NULL default '0',`FAIL_CNT` bigint(19) NOT NULL default '0',PRIMARY KEY  (`LCID`),KEY `Log_Hr_Trend_CIDX1` (`HOUR`),KEY `Log_Hr_Trend_CIDX2` (`HOSTID`),KEY `Log_Hr_Trend_CIDX3` (`SOURCE`),KEY `Log_Hr_Trend_CIDX4` (`TYPE`)) TYPE=InnoDB"))));
            } else {
                this.stat.execute("IF EXISTS(select * from sysobjects where name='" + this.trendTablename + "') DROP TABLE " + this.trendTablename);
                createtable = this.trendTablename.startsWith("EventLog_Hr_Trend") ? "CREATE TABLE EventLog_Hr_Trend (ELCID bigint  IDENTITY  NOT NULL ,HOUROFDAY int  DEFAULT  '0' NOT NULL ,HOUR datetime  DEFAULT  GETDATE() NOT NULL ,HOSTID bigint  DEFAULT  '0' NOT NULL ,SOURCE varchar (100) DEFAULT  '' NOT NULL ,TYPE varchar (50) DEFAULT  '' NOT NULL ,EVENTID int  DEFAULT  '0' NOT NULL ,ERROR_CNT bigint  DEFAULT  '0' NOT NULL ,WARNING_CNT bigint  DEFAULT  '0' NOT NULL ,INFORMATION_CNT bigint  DEFAULT  '0' NOT NULL ,SUCCESS_CNT bigint  DEFAULT  '0' NOT NULL ,FAILURE_CNT bigint  DEFAULT  '0' NOT NULL ,PRIMARY KEY (ELCID));CREATE INDEX EventLog_Hr_Trend_CIDX1 ON EventLog_Hr_Trend  ( HOUROFDAY );CREATE INDEX EventLog_Hr_Trend_CIDX2 ON EventLog_Hr_Trend  ( HOUR );CREATE INDEX EventLog_Hr_Trend_CIDX3 ON EventLog_Hr_Trend  ( HOSTID );CREATE INDEX EventLog_Hr_Trend_CIDX4 ON EventLog_Hr_Trend  ( SOURCE );CREATE INDEX EventLog_Hr_Trend_CIDX5 ON EventLog_Hr_Trend  ( EVENTID );CREATE INDEX EventLog_Hr_Trend_CIDX6 ON EventLog_Hr_Trend  ( TYPE )" : (this.trendTablename.startsWith("SysLog_Hr_Trend") ? "CREATE TABLE SysLog_Hr_Trend (SLCID bigint  IDENTITY  NOT NULL ,HOUROFDAY int  DEFAULT  '0' NOT NULL ,HOUR datetime  DEFAULT  GETDATE() NOT NULL ,HOSTID bigint  DEFAULT  '0' NOT NULL ,SOURCE varchar (100) DEFAULT  '' NOT NULL ,TYPE varchar (50) DEFAULT  '' NOT NULL ,ERROR_CNT bigint  DEFAULT  '0' NOT NULL ,WARNING_CNT bigint  DEFAULT  '0' NOT NULL ,INFORMATION_CNT bigint  DEFAULT  '0' NOT NULL ,EMERGENCY_CNT bigint  DEFAULT  '0' NOT NULL ,ALERT_CNT bigint  DEFAULT  '0' NOT NULL ,CRITICAL_CNT bigint  DEFAULT  '0' NOT NULL ,NOTICE_CNT bigint  DEFAULT  '0' NOT NULL ,DEBUG_CNT bigint  DEFAULT  '0' NOT NULL ,PRIMARY KEY (SLCID));CREATE INDEX SysLog_Hr_Trend_CIDX1 ON SysLog_Hr_Trend  ( HOUROFDAY );CREATE INDEX SysLog_Hr_Trend_CIDX2 ON SysLog_Hr_Trend  ( HOUR );CREATE INDEX SysLog_Hr_Trend_CIDX3 ON SysLog_Hr_Trend  ( HOSTID );CREATE INDEX SysLog_Hr_Trend_CIDX4 ON SysLog_Hr_Trend  ( SOURCE );CREATE INDEX SysLog_Hr_Trend_CIDX5 ON SysLog_Hr_Trend  ( TYPE )" : (this.trendTablename.startsWith("Comp_EventLog_Hr_Trend") ? "CREATE TABLE Comp_EventLog_Hr_Trend (ELCID bigint  IDENTITY  NOT NULL ,HOUROFDAY int  DEFAULT  '0' NOT NULL ,HOUR datetime  DEFAULT  GETDATE() NOT NULL ,HOSTID bigint  DEFAULT  '0' NOT NULL ,EVENTID int  DEFAULT  '0' NOT NULL ,USER_NAME varchar (100) DEFAULT  '' NOT NULL ,DOMAIN varchar (100) DEFAULT  '' NOT NULL ,CLIENT varchar (100) DEFAULT  '' NOT NULL ,SOURCE varchar (100) DEFAULT  '' NOT NULL ,EVT_CNT bigint  DEFAULT  '0' NOT NULL ,PRIMARY KEY (ELCID));CREATE INDEX Comp_EventLog_Hr_Trend_CIDX1 ON Comp_EventLog_Hr_Trend  ( HOSTID );CREATE INDEX Comp_EventLog_Hr_Trend_CIDX2 ON Comp_EventLog_Hr_Trend  ( HOUROFDAY );CREATE INDEX Comp_EventLog_Hr_Trend_CIDX3 ON Comp_EventLog_Hr_Trend  ( HOUR );CREATE INDEX Comp_EventLog_Hr_Trend_CIDX4 ON Comp_EventLog_Hr_Trend  ( EVENTID );CREATE INDEX Comp_EventLog_Hr_Trend_CIDX5 ON Comp_EventLog_Hr_Trend  ( USER_NAME )" : (this.trendTablename.startsWith("ImportantEvents") ? "CREATE TABLE ImportantEvents (LCID bigint  IDENTITY  NOT NULL , HOUROFDAY int  DEFAULT  '0' NOT NULL , HOUR datetime  DEFAULT  GETDATE() NOT NULL , HOSTID bigint  DEFAULT  '0' NOT NULL , IE_NAME varchar (100) DEFAULT  '' NOT NULL , USER_NAME varchar (100) DEFAULT  '' NOT NULL , EVENT_CNT bigint  DEFAULT  '0' NOT NULL , PRIMARY KEY (LCID));CREATE INDEX ImportantEvents_CIDX1 ON ImportantEvents  ( HOUR );CREATE INDEX ImportantEvents_CIDX2 ON ImportantEvents  ( HOSTID );CREATE INDEX ImportantEvents_CIDX3 ON ImportantEvents  ( HOUROFDAY );CREATE INDEX ImportantEvents_CIDX4 ON ImportantEvents  ( IE_NAME );CREATE INDEX ImportantEvents_CIDX5 ON ImportantEvents  ( USER_NAME )" : (this.trendTablename.startsWith("Comp_SysLog_Hr_Trend") ? "CREATE TABLE Comp_SysLog_Hr_Trend (ELID bigint  IDENTITY  NOT NULL ,HOUROFDAY int  DEFAULT  '0' NOT NULL ,HOUR datetime  DEFAULT  GETDATE() NOT NULL ,HOSTID bigint  DEFAULT  '0' NOT NULL ,USER_NAME varchar (250) DEFAULT  NULL ,CLIENT varchar (250) DEFAULT  '' NOT NULL ,TYPE_SEVERITY varchar (100) DEFAULT  '' NOT NULL ,TYPE_FACILITY varchar (100) DEFAULT  '' NOT NULL ,TYPE_SOURCE varchar (100) DEFAULT  '' NOT NULL ,FIELD1 varchar (250) DEFAULT  '' NOT NULL ,FIELD2 varchar (250) DEFAULT  '' NOT NULL ,EVT_CNT int  NOT NULL default '0',PRIMARY KEY (ELID));CREATE INDEX Comp_SysLog_Hr_Trend_CIDX1 ON Comp_SysLog_Hr_Trend  ( HOSTID );CREATE INDEX Comp_SysLog_Hr_Trend_CIDX2 ON Comp_SysLog_Hr_Trend  ( HOUROFDAY );CREATE INDEX Comp_SysLog_Hr_Trend_CIDX3 ON Comp_SysLog_Hr_Trend  ( HOUR );CREATE INDEX Comp_SysLog_Hr_Trend_CIDX4 ON Comp_SysLog_Hr_Trend  ( TYPE_SOURCE );CREATE INDEX Comp_SysLog_Hr_Trend_CIDX5 ON Comp_SysLog_Hr_Trend  ( TYPE_SEVERITY );CREATE INDEX Comp_SysLog_Hr_Trend_CIDX6 ON Comp_SysLog_Hr_Trend  ( USER_NAME )" : "CREATE TABLE Log_Hr_Trend (LCID bigint  IDENTITY  NOT NULL ,HOUROFDAY int  DEFAULT  '0' NOT NULL ,HOUR datetime  DEFAULT  GETDATE() NOT NULL ,HOSTID bigint  DEFAULT  '0' NOT NULL ,SOURCE varchar (100) DEFAULT  '' NOT NULL ,TYPE varchar (50) DEFAULT  '' NOT NULL ,ERR_CNT bigint  DEFAULT  '0' NOT NULL ,WAR_CNT bigint  DEFAULT  '0' NOT NULL ,INF_CNT bigint  DEFAULT  '0' NOT NULL ,SUC_CNT bigint  DEFAULT  '0' NOT NULL ,FAIL_CNT bigint  DEFAULT  '0' NOT NULL ,PRIMARY KEY (LCID));CREATE INDEX Log_Hr_Trend_CIDX1 ON Log_Hr_Trend  ( HOUR );CREATE INDEX Log_Hr_Trend_CIDX2 ON Log_Hr_Trend  ( HOSTID );CREATE INDEX Log_Hr_Trend_CIDX3 ON Log_Hr_Trend  ( SOURCE );CREATE INDEX Log_Hr_Trend_CIDX4 ON Log_Hr_Trend  ( TYPE )"))));
            }
            this.stat.executeUpdate(createtable);
        }
        catch (Exception ce) {
            LOGGER.log(Level.INFO, "Exception in processing table:" + this.tableName);
            ce.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeCommand(String command) throws Exception {
        BufferedReader in = null;
        FileOutputStream fos = new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "repairtable.log");
        Process p = Runtime.getRuntime().exec(command);
        try {
            int c;
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (IOException ioex) {
            LOGGER.log(Level.INFO, "Problem in loading flat file");
            ioex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void loadfileinTable() {
        try {
            File flatFilepath = new File(System.getProperty("server.home") + File.separator + "data" + File.separator + this.tableName + "_lc.txt");
            String flatFileCanonicalpath = flatFilepath.getCanonicalPath();
            flatFileCanonicalpath = flatFileCanonicalpath.replace('\\', '/');
            String trendTabletemp = this.tableName + "_lc";
            boolean isWinAuthType = "true".equals(System.getProperty("isWinAuthType", "false"));
            String DBServer = "";
            String DBName = "";
            String DBUser = "";
            String DBPass = "";
            if (dbType) {
                String loadtable = "load data infile '" + flatFileCanonicalpath + "' into table " + trendTabletemp + " fields terminated by '|**|' lines terminated by '|**|**|' starting by '|**|'";
                this.stat.executeUpdate("create table if not exists " + trendTabletemp + " like " + this.trendTablename);
                this.stat.executeUpdate(loadtable);
                LOGGER.log(Level.INFO, "Loaded::::::" + loadtable);
                if (this.trendTablename.startsWith("EventLog_Hr_Trend")) {
                    this.stat.executeUpdate("insert into " + this.trendTablename + " select NULL, HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, EVENTID, SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, SUM(SUCCESS_CNT) as SUCCESS_CNT, SUM(FAILURE_CNT) as FAILURE_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, EVENTID, SOURCE,TYPE");
                } else if (this.trendTablename.startsWith("SysLog_Hr_Trend")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select NULL, HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, SUM(EMERGENCY_CNT) as EMERGENCY_CNT, SUM(ALERT_CNT) as ALERT_CNT, SUM(CRITICAL_CNT) as CRITICAL_CNT, SUM(NOTICE_CNT) as NOTICE_CNT, SUM(DEBUG_CNT) as DEBUG_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, SOURCE,TYPE");
                } else if (this.trendTablename.startsWith("Comp_EventLog_Hr_Trend")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select NULL, HOUROFDAY, HOUR, HOSTID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE, SUM(EVT_CNT) as EVT_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID and (EVENTID in (552,560,576,592,593,595,617,618,619,672,675,676,677,680,681,682,683) or (EVENTID between 512 and 520) or (EVENTID between 528 and 540) or (EVENTID between 562 and 568) or (EVENTID between 624 and 666) or (EVENTID between 609 and 612) or (EVENTID between 4608 and 4612) or EVENTID in (4614,4615,4616,4624,4625,4634,4648,4656,4672,4688,4689,4691,4705,4706,4713,4714,4715,4719,4720,4768,4771,4772) or (EVENTID between 4658 and 4664)  or (EVENTID between 4722 and 4762) or (EVENTID between 4776 and 4779)) group by HOSTID, HOUR, EVENTID, SOURCE, HOUROFDAY, USER_NAME, DOMAIN, CLIENT");
                } else if (this.trendTablename.startsWith("ImportantEvents")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select NULL, HOUROFDAY, HOUR, HOSTID, IE_NAME, USER_NAME, SUM(EVENT_CNT) as EVENT_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, IE_NAME, USER_NAME");
                } else if (this.trendTablename.startsWith("Comp_SysLog_Hr_Trend")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select NULL, HOUROFDAY, HOUR, HOSTID, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, FIELD1, FIELD2, SUM(EVT_CNT) as EVT_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, TYPE_FACILITY, TYPE_SEVERITY, TYPE_SOURCE, USER_NAME, CLIENT, FIELD1, FIELD2");
                } else {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select NULL, HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERR_CNT) as ERR_CNT, SUM(WAR_CNT) as WAR_CNT, SUM(INF_CNT) as INF_CNT, SUM(SUC_CNT) as SUC_CNT, SUM(FAIL_CNT) as FAIL_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, SOURCE, TYPE");
                }
                this.stat.executeUpdate("drop table if exists " + trendTabletemp);
                flatFilepath.delete();
            } else {
                String xmlFilePath = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
                HashMap DBParams = ResourceCheckerUtil.getConstraints((String)xmlFilePath, (String)"eventlog");
                if (DBParams != null) {
                    DBServer = (String)DBParams.get("DBServer");
                    DBName = (String)DBParams.get("DBName");
                    DBUser = (String)DBParams.get("DBUser");
                    DBPass = (String)DBParams.get("DBPass");
                    if (DBPass == null) {
                        DBPass = "";
                    }
                }
                if (isWinAuthType) {
                    Aggregator.executeCommand("cmd /c ..\\bin\\bcp.exe [" + DBName + "].dbo." + trendTabletemp + " in \"" + flatFileCanonicalpath + "\" -S " + DBServer + " -T -t \"|**|\" -r \"|**|**|\\n\\n\" -e ..\\server\\default\\log\\repairerr.txt -c");
                } else {
                    Aggregator.executeCommand("cmd /c ..\\bin\\bcp.exe [" + DBName + "].dbo." + trendTabletemp + " in \"" + flatFileCanonicalpath + "\" -S " + DBServer + " -U " + DBUser + " -P \"" + DBPass + "\" -t \"|**|\" -r \"|**|**|\\n\\n\" -e ..\\server\\default\\log\\repairerr.txt -c");
                }
                this.stat.execute("select * into " + trendTabletemp + " from " + this.trendTablename + " where 1=2");
                if (this.trendTablename.startsWith("EventLog_Hr_Trend")) {
                    this.stat.executeUpdate("insert into " + this.trendTablename + " select HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, EVENTID, SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, SUM(SUCCESS_CNT) as SUCCESS_CNT, SUM(FAILURE_CNT) as FAILURE_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, EVENTID, SOURCE,TYPE");
                    flatFilepath.delete();
                } else if (this.trendTablename.startsWith("SysLog_Hr_Trend")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERROR_CNT) as ERROR_CNT, SUM(WARNING_CNT) as WARNING_CNT, SUM(INFORMATION_CNT) as INFORMATION_CNT, SUM(EMERGENCY_CNT) as EMERGENCY_CNT, SUM(ALERT_CNT) as ALERT_CNT, SUM(CRITICAL_CNT) as CRITICAL_CNT, SUM(NOTICE_CNT) as NOTICE_CNT, SUM(DEBUG_CNT) as DEBUG_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, SOURCE,TYPE");
                } else if (this.trendTablename.startsWith("Comp_EventLog_Hr_Trend")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select HOUROFDAY, HOUR, HOSTID, EVENTID, USER_NAME, DOMAIN, CLIENT, SOURCE, SUM(EVT_CNT) as EVT_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, EVENTID, SOURCE, HOUROFDAY, USER_NAME, DOMAIN, CLIENT");
                } else if (this.trendTablename.startsWith("ImportantEvents")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select HOUROFDAY, HOUR, HOSTID, IE_NAME, USER_NAME, SUM(EVENT_CNT) as EVENT_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, IE_NAME, USER_NAME");
                } else if (this.trendTablename.startsWith("Comp_SysLog_Hr_Trend")) {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select HOUROFDAY, HOUR, HOSTID, USER_NAME, CLIENT, TYPE_SEVERITY, TYPE_FACILITY, TYPE_SOURCE, FIELD1, FIELD2, SUM(EVT_CNT) as EVT_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, TYPE_FACILITY, TYPE_SEVERITY, TYPE_SOURCE, USER_NAME, CLIENT, FIELD1, FIELD2");
                } else {
                    this.stat.executeUpdate("INSERT INTO " + this.trendTablename + " select HOUROFDAY, HOUR, HOSTID, SOURCE, TYPE, SUM(ERR_CNT) as ERR_CNT, SUM(WAR_CNT) as WAR_CNT, SUM(INF_CNT) as INF_CNT, SUM(SUC_CNT) as SUC_CNT, SUM(FAIL_CNT) as FAIL_CNT from " + trendTabletemp + " inner join Hosts on Hosts.HOST_ID= " + trendTabletemp + ".HOSTID group by HOSTID, HOUR, HOUROFDAY, SOURCE, TYPE");
                }
                this.stat.execute("IF EXISTS(select * from sysobjects where name='" + trendTabletemp + "') DROP TABLE " + trendTabletemp);
                flatFilepath.delete();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception in processing table:" + this.tableName);
            e.printStackTrace();
        }
    }
}

