/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.aggregate;

import com.adventnet.la.LuceneUtil;
import com.adventnet.logsearch.search.Constraint;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public enum TrendTable {
    EVENTLOG_HR_TREND("EventLog_Hr_Trend", "Windows"){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            String DBType2 = System.getProperty("DBType", "mysql");
            Constraint constraint = null;
            ArrayList<Constraint> idlist = new ArrayList<Constraint>();
            try {
                rs = stat.executeQuery("select HOST_ID from HostDetails where TYPE='windows'");
                while (rs.next()) {
                    Long htype = (Long)rs.getObject(1);
                    if (this.isNegativeValue(htype.toString())) {
                        idlist.add(new Constraint("HOSTID", "\\" + htype.toString(), 1, this.getStoredColumns()));
                        continue;
                    }
                    idlist.add(new Constraint("HOSTID", htype.toString(), 1, this.getStoredColumns()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idlist.size() > 0) {
                Constraint[] con = new Constraint[idlist.size()];
                con = idlist.toArray(con);
                constraint = new Constraint(con, 0);
                return constraint;
            }
            try {
                return new Constraint("HOSTTYPE", "windows", 1, this.getStoredColumns());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public String[] getSelectColumns() {
            return new String[]{"TIME", "HOSTID", "SOURCE", "TYPE", "EVENTID", "SEVERITY"};
        }
    }
    ,
    COMP_EVENTLOG_HR_TREND("Comp_EventLog_Hr_Trend", "Windows"){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            String DBType2 = System.getProperty("DBType", "mysql");
            Constraint constraint = null;
            ArrayList<Constraint> idlist = new ArrayList<Constraint>();
            try {
                rs = stat.executeQuery("select HOST_ID from HostDetails where TYPE='windows'");
                while (rs.next()) {
                    Long htype = (Long)rs.getObject(1);
                    if (this.isNegativeValue(htype.toString())) {
                        idlist.add(new Constraint("HOSTID", "\\" + htype.toString(), 1, this.getStoredColumns()));
                        continue;
                    }
                    idlist.add(new Constraint("HOSTID", htype.toString(), 1, this.getStoredColumns()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idlist.size() > 0) {
                Constraint[] con = new Constraint[idlist.size()];
                con = idlist.toArray(con);
                try {
                    constraint = new Constraint(con, 0);
                    return constraint;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            try {
                return new Constraint("HOSTTYPE", "windows", 1, this.getStoredColumns());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public String[] getSelectColumns() {
            return new String[]{"TIME", "HOSTID", "EVENTID", "USERNAME", "DOMAIN", "LOGONTYPE", "SOURCE", "SEVERITY"};
        }
    }
    ,
    SYSLOG_HR_TREND("SysLog_Hr_Trend", "Unix"){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            String DBType2 = System.getProperty("DBType", "mysql");
            Constraint constraint = null;
            ArrayList<Constraint> idlist = new ArrayList<Constraint>();
            try {
                rs = stat.executeQuery("select HOST_ID from HostDetails where TYPE !='windows'");
                while (rs.next()) {
                    Long htype = (Long)rs.getObject(1);
                    if (this.isNegativeValue(htype.toString())) {
                        idlist.add(new Constraint("HOSTID", "\\" + htype.toString(), 1, this.getStoredColumns()));
                        continue;
                    }
                    idlist.add(new Constraint("HOSTID", htype.toString(), 1, this.getStoredColumns()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idlist.size() > 0) {
                Constraint[] con = new Constraint[idlist.size()];
                con = idlist.toArray(con);
                constraint = new Constraint(con, 0);
                return constraint;
            }
            try {
                return new Constraint("HOSTTYPE", "windows", 2, this.getStoredColumns());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public String[] getSelectColumns() {
            return new String[]{"TIME", "HOSTID", "SOURCE", "FACILITY", "SEVERITY"};
        }
    }
    ,
    IMPORTANTEVENTS("ImportantEvents", "Unix"){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            String DBType2 = System.getProperty("DBType", "mysql");
            Constraint constraint = null;
            ArrayList<Constraint> idlist = new ArrayList<Constraint>();
            try {
                rs = stat.executeQuery("select HOST_ID from HostDetails where TYPE='unix'");
                while (rs.next()) {
                    Long htype = (Long)rs.getObject(1);
                    if (this.isNegativeValue(htype.toString())) {
                        idlist.add(new Constraint("HOSTID", "\\" + htype.toString(), 1, this.getStoredColumns()));
                        continue;
                    }
                    idlist.add(new Constraint("HOSTID", htype.toString(), 1, this.getStoredColumns()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idlist.size() > 0) {
                Constraint[] con = new Constraint[idlist.size()];
                con = idlist.toArray(con);
                constraint = new Constraint(con, 0);
                return constraint;
            }
            try {
                return new Constraint("HOSTTYPE", "unix", 1, this.getStoredColumns());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public String[] getSelectColumns() {
            return new String[]{"TIME", "HOSTID", "IENAME", "USERNAME"};
        }
    }
    ,
    COMP_SYSLOG_HR_TREND("Comp_SysLog_Hr_Trend", "Cisco Device"){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            String DBType2 = System.getProperty("DBType", "mysql");
            Constraint constraint = null;
            ArrayList<Constraint> idlist = new ArrayList<Constraint>();
            try {
                rs = stat.executeQuery("select HOST_ID from HostDetails where TYPE='Cisco Device' or TYPE='IBM AS/400'");
                while (rs.next()) {
                    Long htype = (Long)rs.getObject(1);
                    if (this.isNegativeValue(htype.toString())) {
                        idlist.add(new Constraint("HOSTID", "\\" + htype.toString(), 1, this.getStoredColumns()));
                        continue;
                    }
                    idlist.add(new Constraint("HOSTID", htype.toString(), 1, this.getStoredColumns()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idlist.size() > 0) {
                Constraint[] con = new Constraint[idlist.size()];
                con = idlist.toArray(con);
                constraint = new Constraint(con, 0);
                return constraint;
            }
            try {
                return new Constraint("HOSTTYPE", "cisco device", 1, this.getStoredColumns());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public String[] getSelectColumns() {
            return new String[]{"TIME", "HOSTID", "USERNAME", "CLIENT", "SEVERITY", "FACILITY", "SOURCE", "FIELD1", "FIELD2"};
        }
    }
    ,
    LOG_HR_TREND_SYS("Log_Hr_Trend", "Unix"){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            String DBType2 = System.getProperty("DBType", "mysql");
            Constraint constraint = null;
            ArrayList<Constraint> idlist = new ArrayList<Constraint>();
            try {
                rs = stat.executeQuery("select HOST_ID from HostDetails where TYPE !='windows'");
                while (rs.next()) {
                    Long htype = (Long)rs.getObject(1);
                    if (this.isNegativeValue(htype.toString())) {
                        idlist.add(new Constraint("HOSTID", "\\" + htype.toString(), 1, this.getStoredColumns()));
                        continue;
                    }
                    idlist.add(new Constraint("HOSTID", htype.toString(), 1, this.getStoredColumns()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idlist.size() > 0) {
                Constraint[] con = new Constraint[idlist.size()];
                con = idlist.toArray(con);
                constraint = new Constraint(con, 0);
                return constraint;
            }
            try {
                return new Constraint("HOSTTYPE", "windows", 2, this.getStoredColumns());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public String[] getSelectColumns() {
            return new String[]{"TIME", "HOSTID", "SOURCE", "FACILITY", "SEVERITY"};
        }
    }
    ,
    LOG_HR_TREND_WIN("Log_Hr_Trend", "Windows"){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            String DBType2 = System.getProperty("DBType", "mysql");
            Constraint constraint = null;
            ArrayList<Constraint> idlist = new ArrayList<Constraint>();
            try {
                rs = stat.executeQuery("select HOST_ID from HostDetails where TYPE='windows'");
                while (rs.next()) {
                    Long htype = (Long)rs.getObject(1);
                    if (this.isNegativeValue(htype.toString())) {
                        idlist.add(new Constraint("HOSTID", "\\" + htype.toString(), 1, this.getStoredColumns()));
                        continue;
                    }
                    idlist.add(new Constraint("HOSTID", htype.toString(), 1, this.getStoredColumns()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (idlist.size() > 0) {
                Constraint[] con = new Constraint[idlist.size()];
                con = idlist.toArray(con);
                constraint = new Constraint(con, 0);
                return constraint;
            }
            try {
                return new Constraint("HOSTTYPE", "windows", 1, this.getStoredColumns());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Override
        public String[] getSelectColumns() {
            return new String[]{"TIME", "HOSTID", "SOURCE", "TYPE", "SEVERITY"};
        }
    }
    ,
    LOG_HR_TREND("Log_Hr_Trend", ""){

        @Override
        Constraint getFieldContraint(Connection conn, Statement stat, ResultSet rs) {
            throw new AssertionError();
        }

        @Override
        public String[] getSelectColumns() {
            throw new AssertionError();
        }
    };

    private final String trendTableName;
    private final String luceneTable;
    private final List storedColumns;

    private TrendTable(String trendTableName, String luceneTable) {
        this.trendTableName = trendTableName;
        this.luceneTable = luceneTable;
        this.storedColumns = LuceneUtil.getColumnsList((String)luceneTable);
    }

    public String getTableTime(String tableName) {
        return "SELECT START_TIME, END_TIME from MetaTable where TABLE_NAME like'" + tableName + "'";
    }

    public List getStoredColumns() {
        return this.storedColumns;
    }

    public boolean isNegativeValue(String key) {
        return key.matches("-\\d+");
    }

    abstract Constraint getFieldContraint(Connection var1, Statement var2, ResultSet var3);

    abstract String[] getSelectColumns();
}

