/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.alert;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.LaUtil;
import com.adventnet.la.util.HTMLFileReader;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.la.util.SmtpMailer;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class MailAlert
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(MailAlert.class.getName());
    long currAlertStatusId;
    long updatedAlertStatusId;
    int currentDay = 1;
    int dailyCount = 0;
    String mLimStatus = "disable";
    Map mailServerSettings;

    public MailAlert(long currAlertStatusId) {
        LOGGER.log(Level.INFO, "MailAlert: new thread created...");
        this.currAlertStatusId = currAlertStatusId;
        this.currentDay = new GregorianCalendar().get(6);
        this.mLimStatus = this.getStatusFromSysConf("mailLimitStatus");
        if (!this.mLimStatus.equals("disableComplete")) {
            this.updateSysConf("disable");
        }
    }

    @Override
    public void run() {
        try {
            this.mailServerSettings = LaUtil.getMailAttributes();
            this.updatedAlertStatusId = Long.parseLong(this.getStatusFromSysConf("AlertStatusId"));
            if (this.currAlertStatusId == this.updatedAlertStatusId) {
                LOGGER.log(Level.INFO, "MailAlert: currAlertStatusId  : " + this.currAlertStatusId + " and updatedAlertStatusId : " + this.updatedAlertStatusId + " is equal.. No mail to send :");
                return;
            }
            int globalLimit = Integer.parseInt(System.getProperty("EC_dailyMailLimit", "500"));
            this.mLimStatus = this.getStatusFromSysConf("mailLimitStatus");
            int today = new GregorianCalendar().get(6);
            if (this.currentDay != today) {
                this.currentDay = today;
                this.dailyCount = 0;
                if (this.mLimStatus.equals("enable") || this.mLimStatus.equals("disableToday")) {
                    this.updateSysConf("disable");
                }
            }
            if (this.updatedAlertStatusId > this.currAlertStatusId) {
                Table table = new Table("LAAlertAudit");
                SelectQueryImpl sql = new SelectQueryImpl(table);
                Column col1 = new Column("LAAlertAudit", "*");
                Column col2 = new Column("NotfnConfigType", "*");
                Column col3 = new Column("NotfnConfiguration", "*");
                Column col4 = new Column("NotificationType", "*");
                Column col5 = new Column("HostNotification", "*");
                Column col6 = new Column("HostGroupNotification", "*");
                sql.addSelectColumn(col1);
                sql.addSelectColumn(col2);
                sql.addSelectColumn(col3);
                sql.addSelectColumn(col4);
                sql.addSelectColumn(col5);
                sql.addSelectColumn(col6);
                String[] notifid = new String[]{"NOTIFID"};
                Join join1 = new Join("LAAlertAudit", "NotfnConfigType", new String[]{"NF_ID"}, notifid, 2);
                Join join2 = new Join("NotfnConfigType", "NotfnConfiguration", notifid, notifid, 2);
                Join join3 = new Join("NotfnConfigType", "NotificationType", notifid, notifid, 2);
                Join join4 = new Join("NotfnConfigType", "HostNotification", notifid, notifid, 1);
                Join join5 = new Join("NotfnConfigType", "HostGroupNotification", notifid, notifid, 1);
                sql.addJoin(join1);
                sql.addJoin(join2);
                sql.addJoin(join3);
                sql.addJoin(join4);
                sql.addJoin(join5);
                Column col = new Column("LAAlertAudit", "AUDIT_ID");
                Criteria cri = new Criteria(col, (Object)new Long(this.currAlertStatusId), 5);
                cri = cri.and(new Criteria(col, (Object)new Long(this.updatedAlertStatusId), 6));
                sql.setCriteria(cri);
                LOGGER.log(Level.FINE, "MailAlert: currAlertStatusId (in memory) : " + this.currAlertStatusId);
                LOGGER.log(Level.FINE, "MailAlert: updatedAlertStatusId (from SystemConfiguration table)" + this.updatedAlertStatusId);
                Long l = this.updatedAlertStatusId - this.currAlertStatusId;
                LOGGER.log(Level.FINE, "MailAlert: Number of mail to be sent in this thread is :" + l);
                DataObject dob = DataAccess.get((SelectQuery)sql);
                if (dob.size("LAAlertAudit") > 0) {
                    LOGGER.log(Level.FINE, "MailAlert: LAAlertAudit has rows");
                    boolean status = false;
                    Iterator laIter = dob.getRows("LAAlertAudit");
                    while (laIter.hasNext()) {
                        String subject;
                        boolean result;
                        Row laAA = (Row)laIter.next();
                        Long notifId = (Long)laAA.get("NF_ID");
                        if (this.dailyCount + 1 > globalLimit && globalLimit != 0) {
                            if (this.mLimStatus.equals("disable") && !status) {
                                status = true;
                                this.updateSysConf("enable");
                            }
                            LOGGER.fine("Daily limit for Mails reached. Skipping Mail notification");
                            continue;
                        }
                        Row nfCon = dob.getRow("NotfnConfiguration", new Criteria(new Column("NotfnConfiguration", "NOTIFID"), (Object)notifId, 0));
                        String to = (String)nfCon.get("MAILID");
                        String mail_sub = (String)nfCon.get("MAIL_SUBJECT");
                        String mail_desc = (String)nfCon.get("MAIL_DESCRIPTION");
                        HashMap<String, Object> msgProps = new HashMap<String, Object>();
                        String host = (String)laAA.get("SOURCE");
                        Long nofnTime = (Long)laAA.get("NOTIFIEDTIME");
                        String logMsg = (String)laAA.get("ERROR_DETAILS");
                        String[] msg = logMsg.split(":", 2);
                        Long auditId = (Long)laAA.get("AUDIT_ID");
                        Row nfnType = dob.getRow("NotificationType", new Criteria(new Column("NotificationType", "NOTIFID"), (Object)notifId, 0));
                        Integer occurance = (Integer)nfnType.get("NOOFOCCURRENCE");
                        String criticality = (String)nfnType.get("CRITICALITY");
                        String notifName = (String)nfnType.get("NOTIFNAME");
                        Calendar cal = Calendar.getInstance();
                        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss, EEE, MMM dd yyyy");
                        cal.setTimeInMillis(nofnTime);
                        String nfnTime = sdf.format(cal.getTime());
                        LOGGER.log(Level.FINER, "NotifId: " + notifId + " Source:" + host);
                        ResourceBundle rb = ProductBundle.getInstance().getBundle();
                        criticality = rb.getString("AddAlert." + criticality);
                        msgProps.put("Host", host);
                        msgProps.put("Application", Matcher.quoteReplacement(msg[0]));
                        msgProps.put("Time", nfnTime);
                        msgProps.put("Criticality", criticality);
                        msgProps.put("NoOfOccurances", occurance);
                        msgProps.put("Message", Matcher.quoteReplacement(msg[1]));
                        msgProps.put("Notes", mail_desc);
                        msgProps.put("AlertName", notifName);
                        if (mail_sub.indexOf("$source") != -1) {
                            mail_sub = mail_sub.replaceAll("\\$source", Matcher.quoteReplacement(msg[0]));
                        }
                        if (mail_sub.indexOf("$hostname") != -1) {
                            mail_sub = mail_sub.replaceAll("\\$hostname", host);
                        }
                        if (mail_sub.indexOf("$alertname") != -1) {
                            mail_sub = mail_sub.replaceAll("\\$alertname", notifName);
                        }
                        if (!(result = this.sendMail(to, msgProps, subject = "".equals(mail_sub) ? notifName + " | " + host + " | " + Matcher.quoteReplacement(msg[0]) : mail_sub))) {
                            this.updatelaAA(auditId);
                            continue;
                        }
                        ++this.dailyCount;
                    }
                }
                this.currAlertStatusId = this.updatedAlertStatusId;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getStatusFromSysConf(String confName) {
        String StatusCount = "0";
        try {
            Table table = new Table("SystemConfigurations");
            SelectQueryImpl sql = new SelectQueryImpl(table);
            Column col = new Column("SystemConfigurations", "CONF_NAME");
            Criteria cri = new Criteria(col, (Object)confName, 0);
            sql.addSelectColumn(new Column("SystemConfigurations", "*"));
            sql.setCriteria(cri);
            DataObject dob = DataAccess.get((SelectQuery)sql);
            if (dob.size("SystemConfigurations") > 0) {
                StatusCount = (String)dob.getValue("SystemConfigurations", "CONF_VALUE", cri);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while getting the alert ID" + StatusCount);
            e.printStackTrace();
        }
        return StatusCount;
    }

    private boolean sendMail(String to, Map msgProps, String subject) {
        boolean result = false;
        try {
            String server = (String)this.mailServerSettings.get("SmtpServer");
            String port = (String)this.mailServerSettings.get("SmtpServerPort");
            String username = (String)this.mailServerSettings.get("uName");
            String password = (String)this.mailServerSettings.get("pWord");
            String auth = (String)this.mailServerSettings.get("authenticate");
            String from = (String)this.mailServerSettings.get("fromId");
            String tls = (String)this.mailServerSettings.get("tls");
            SmtpMailer mailer = new SmtpMailer(server, from, to, subject, null, username, password, port, tls);
            if (msgProps.get("Notes") != null && !"".equals(msgProps.get("Notes"))) {
                msgProps.put("Notes", HTMLFileReader.getMailContent((int)HTMLFileReader.eAALERTNOTESINDEX, (Map)msgProps));
            }
            String message = HTMLFileReader.getMailContent((int)HTMLFileReader.ALERT_MAIL_INDEX, (Map)msgProps);
            String status = mailer.sendMessage(message = message.replaceAll("__message__", (String)msgProps.get("Message")));
            boolean bl = result = status == null;
            if (result) {
                LOGGER.log(Level.INFO, "Alert mail sent to : " + to);
            } else {
                LOGGER.log(Level.INFO, "Unable to send alert email to : " + to);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while sending mail");
            e.printStackTrace();
        }
        return result;
    }

    private void updatelaAA(Long auditId) {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("LAAlertAudit");
            query.setCriteria(new Criteria(new Column("LAAlertAudit", "AUDIT_ID"), (Object)auditId, 0));
            query.setUpdateColumn("STATUS", (Object)new Integer(-1));
            PersistenceDBUtil.getPersistence().update((UpdateQuery)query);
            LOGGER.log(Level.FINER, "Updated LAAlertAudit with mailstatus -1 for auditId: " + auditId);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Exception while updating mail status in LAAlertAudit");
            e.printStackTrace();
        }
    }

    private void updateSysConf(String mLimStatus) {
        try {
            UpdateQueryImpl query = new UpdateQueryImpl("SystemConfigurations");
            query.setCriteria(new Criteria(new Column("SystemConfigurations", "CONF_NAME"), (Object)"mailLimitStatus", 0));
            query.setUpdateColumn("CONF_VALUE", (Object)mLimStatus);
            LOGGER.log(Level.FINE, "Updating mailLimitStatus to " + mLimStatus);
            DataAccess.update((UpdateQuery)query);
        }
        catch (DataAccessException e) {
            LOGGER.log(Level.FINER, " Exception caught : {0}", e);
        }
    }
}

