/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.arch.ArchiveBuffer;
import com.adventnet.sa.server.arch.ArchiveFile;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.arch.ArchiveUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ApplicationArchiveBuffer
implements ArchiveBuffer {
    private static final Logger LOGGER = Logger.getLogger(ApplicationArchiveBuffer.class.getName());
    private String hostName = null;
    private String formatName = null;
    private ArchiveFile aFile = null;
    private List<String> logBuffer = null;
    private int logBufferMaxLimit = "true".equals(System.getProperty("handleHighFlow", "false")) ? 10000 : 300;
    private DataObject archiveFlatFileDo = null;
    private static final String FLATFILETABLE = "ArchiveFlatFiles";
    private long flushTime;
    private long hostID;
    private boolean isDelete = false;

    public ApplicationArchiveBuffer(String formatName, String hostName) {
        this.formatName = formatName;
        this.hostName = hostName;
        this.logBuffer = new ArrayList<String>();
        this.flushTime = System.currentTimeMillis();
        this.hostID = ArchiveUtil.getHostID(this.hostName);
        this.openArchiveFile(false);
        LOGGER.info("Init hostarchive for format : " + formatName + " host : " + this.hostName);
    }

    @Override
    public synchronized void addLogToBuffer(String log) {
        this.logBuffer.add(log);
        if (this.logBuffer.size() >= this.logBufferMaxLimit) {
            this.writeLogsToFile(true);
        }
    }

    @Override
    public synchronized void writeLogsToFile(boolean shutdown) {
        LOGGER.fine("flushing application logs app:" + this.formatName + " host:" + this.hostName + " logcount : " + this.logBuffer.size());
        this.aFile.writeToFile(this.logBuffer);
        if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            long currentTime = System.currentTimeMillis();
            if (!this.isDelete && (shutdown && !this.logBuffer.isEmpty() || currentTime - this.flushTime > 300000L)) {
                this.flushTime = currentTime;
                ArchiveUtil.updateFlushTimeEntry(this.hostID, this.formatName, this.flushTime);
            }
        }
        this.logBuffer.clear();
    }

    @Override
    public synchronized void deleteDeviceHandler() {
        this.isDelete = true;
        this.writeLogsToFile(false);
        this.closeArchiveFile();
    }

    @Override
    public void createArchiveFile(boolean isstartUp) {
        this.aFile = new ArchiveFile(this.formatName + File.separator + this.hostName, isstartUp);
    }

    @Override
    public void openArchiveFile(boolean isstartUp) {
        this.createArchiveFile(isstartUp);
        if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            int tamperStatus = ArchiveUtil.checkArchiveFlatFileTamperStatus(this.hostID, this.formatName, this.aFile);
            if (tamperStatus == 3 || tamperStatus == 4) {
                this.createArchiveFile(true);
            }
            if (tamperStatus != 1) {
                ArchiveUtil.addFlatFileEntry(this.hostID, this.formatName, this.aFile.getFileName());
            }
        }
        this.aFile.openFile();
    }

    @Override
    public synchronized void closeArchiveFile() {
        this.aFile.close();
        if (!this.isDelete && ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            ArchiveUtil.updateCheckSumEntry(this.aFile);
        }
    }

    @Override
    public synchronized void closeAndCreateArchiveFile() {
        ArchiveFile tobeClosed = this.aFile;
        this.openArchiveFile(true);
        tobeClosed.close();
        if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            ArchiveUtil.updateCheckSumEntry(tobeClosed);
        }
    }

    @Override
    public ArchiveFile getArchiveFile() {
        return this.aFile;
    }

    @Override
    public String getHostNameorappKey() {
        return this.formatName + "_" + this.hostName;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getFileCount() {
        int noofFiles = new File(this.aFile.getArchiveDirectory()).listFiles().length;
        return noofFiles;
    }

    @Override
    public boolean islimitReached(long archivesize) {
        long max;
        long deduction;
        long filesizeinBytes = new File(this.aFile.getFileName()).length();
        if (filesizeinBytes - (deduction = (max = archivesize * 1024L * 1024L) * 20L / 100L) > max) {
            LOGGER.info("APP FILE NAME::::<->" + this.aFile.getFileName() + "<->:::filesizeinBytes IS:::::::::" + filesizeinBytes + "MAX:::::::::" + max);
            return true;
        }
        return false;
    }
}

