/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;

public class ArchiveConstants {
    public static final long FLUSH_TIME_INTERVAL = 300000L;
    public static final int FILESTATUS_CURRENT = 1;
    public static final int FILESTATUS_COMPLETED = 2;
    public static final int FILESTATUS_TAMPERED = 3;
    public static final Long ARCHIVE_UNLOADED = 0L;
    public static final Long ARCHIVE_TAMPERED = 4L;
    public static final Long ARCHIVE_NOT_FOUND = 5L;
    public static final String CHECKSUM_MD5 = "MD5";
    public static final String CHECKSUM_SHA = "SHA";
    public static final String CHECKSUM_SHA256 = "SHA256";
    public static final int EXISTING_FILE = 1;
    public static final int NEW_FILE = 2;
    public static final int FILE_TAMPERED = 3;
    public static final int FILE_NOTFOUND = 4;
    public static final String HOST_FORMAT_TYPE = null;
    public static final String DEFAULT_CHECKSUM = null;
    private static ArchiveConstants instance = null;
    private String archiveLocation = null;
    private boolean isEncryptionEnabled = false;
    private boolean isTimeStampingEnabled = false;
    private boolean isArchivingEnabled = true;
    private long fileCreationTimeInMillis = 0L;
    private long zipCreationTimeInMillis = 0L;
    private String zipCreationMode = "Days";
    private boolean locationFailed = false;
    private static AtomicLong failureCount = new AtomicLong(0L);

    private ArchiveConstants() {
        this.loadArchiveSettings();
    }

    public static synchronized ArchiveConstants getInstance() {
        if (instance == null) {
            instance = new ArchiveConstants();
        }
        return instance;
    }

    public void loadArchiveSettings() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("SystemConfigurations"));
            query.addSelectColumn(new Column("SystemConfigurations", "*"));
            DataObject doo = DataAccess.get((SelectQuery)query);
            Iterator iter = doo.getRows("SystemConfigurations");
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                String confName = (String)r.get("CONF_NAME");
                String confValue = (String)r.get("CONF_VALUE");
                if ("sysArchiveLocation".equals(confName)) {
                    this.setArchiveLocation(confValue);
                    continue;
                }
                if ("sysEnableArchiveEncrypt".equals(confName)) {
                    this.setEncryptionStatus(Boolean.valueOf(confValue));
                    continue;
                }
                if ("sysEnableArchiveTimestamping".equals(confName)) {
                    this.setTimeStampingStatus(Boolean.valueOf(confValue));
                    continue;
                }
                if ("sysEnableArchiving".equals(confName)) {
                    this.setArchiveStatus(Boolean.valueOf(confValue));
                    continue;
                }
                if ("sysFileCreationInterval".equals(confName)) {
                    this.setFileCreationTimeInMillis(Long.parseLong(confValue));
                    continue;
                }
                if ("sysZipCreationInterval".equals(confName)) {
                    this.setZipCreationTimeInMillis(Long.parseLong(confValue));
                    continue;
                }
                if (!"sysZipCreationMode".equals(confName)) continue;
                this.setZipCreationMode(confValue);
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    public boolean arrchivingCondition() {
        return !this.locationFailed && this.isArchivingEnabled;
    }

    public long getFailureCount() {
        return failureCount.get();
    }

    public void addFailureCount() {
        failureCount.incrementAndGet();
    }

    public void resetFailureCount() {
        failureCount.set(0L);
    }

    public void setLocationFailed(boolean value) {
        this.locationFailed = value;
    }

    public boolean hasLocationFailed() {
        return this.locationFailed;
    }

    public boolean isArchivingEnabled() {
        return this.isArchivingEnabled;
    }

    private void setArchiveStatus(boolean isArchivingEnabled) {
        this.isArchivingEnabled = isArchivingEnabled;
    }

    public long getFileCreationTimeInMillis() {
        return this.fileCreationTimeInMillis;
    }

    private void setFileCreationTimeInMillis(long intervalInMillis) {
        this.fileCreationTimeInMillis = intervalInMillis;
    }

    public long getZipCreationTimeInMillis() {
        return this.zipCreationTimeInMillis;
    }

    private void setZipCreationTimeInMillis(long intervalInMillis) {
        this.zipCreationTimeInMillis = intervalInMillis;
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    private void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = "archive".equals(archiveLocation) ? System.getProperty("server.dir") + File.separator + "archive" : archiveLocation;
    }

    public boolean isEncryptionEnabled() {
        return this.isEncryptionEnabled;
    }

    private void setEncryptionStatus(boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
    }

    public boolean isTimeStampingEnabled() {
        return this.isTimeStampingEnabled;
    }

    private void setTimeStampingStatus(boolean isTimeStampingEnabled) {
        this.isTimeStampingEnabled = isTimeStampingEnabled;
    }

    public String getZipCreationMode() {
        return this.zipCreationMode;
    }

    private void setZipCreationMode(String zipCreationMode) {
        this.zipCreationMode = zipCreationMode;
    }
}

