/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.arch.ArchiveUtil;
import com.adventnet.sa.server.imp.AbstractEncryptionHandler;
import com.adventnet.sa.server.imp.Encryption256Bit;
import com.adventnet.sa.server.imp.EncryptionAPI;
import com.manageengine.ela.server.common.cache.ServerDetailsBean;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchiveFile {
    private static final Logger LOGGER = Logger.getLogger(ArchiveFile.class.getName());
    private String logDelimiter = System.getProperty("line.separator");
    private String encAlgo = System.getProperty("AESBIT", "128");
    private String archDirName = null;
    private String fileName = null;
    private FileOutputStream foStream = null;
    private OutputStreamWriter osWriter = null;
    private BufferedWriter writer = null;
    private FileLock fLock = null;
    private boolean isEncryptionEnabled = false;
    private AbstractEncryptionHandler encryptionBaseAPI = null;
    private long archiveSize = Long.parseLong(System.getProperty("archivesize", "250"));
    private final long deduction = this.archiveSize * 1024L * 1024L * 80L / 100L;

    public ArchiveFile(String dirName, boolean startUp) {
        this.archDirName = ArchiveConstants.getInstance().getArchiveLocation() + File.separator + dirName;
        File archDir = new File(this.archDirName);
        try {
            if (!archDir.exists()) {
                LOGGER.info("Making archive directory : " + this.archDirName);
                if (!archDir.mkdirs()) {
                    throw new IOException();
                }
            }
            if (ArchiveConstants.getInstance().isEncryptionEnabled()) {
                this.isEncryptionEnabled = true;
                this.getArchiveFileName(startUp);
                this.encryptionBaseAPI = this.encAlgo.equals("256") ? Encryption256Bit.getInstance(this.fileName) : EncryptionAPI.getInstance(this.fileName);
                this.logDelimiter = new String(new char[]{this.encryptionBaseAPI.getLogDelimiter()});
            } else {
                this.getArchiveFileName(startUp);
            }
        }
        catch (IOException e) {
            this.checkArchiveFailure();
            e.printStackTrace();
        }
    }

    public void openFile() {
        try {
            this.foStream = ArchiveFileManager.getInstance().archiveIntegrityEnabled() && ServerDetailsBean.getInstance().isWindows() ? ArchiveUtil.getStreamUsingWindowsHandle(this.fileName) : new FileOutputStream(new File(this.fileName), true);
            this.osWriter = new OutputStreamWriter((OutputStream)this.foStream, "UTF-8");
            this.writer = new BufferedWriter(this.osWriter);
            if (ArchiveFileManager.getInstance().archiveIntegrityEnabled() && !ServerDetailsBean.getInstance().isWindows()) {
                this.fLock = this.foStream.getChannel().lock();
            }
        }
        catch (IOException e) {
            this.checkArchiveFailure();
            e.printStackTrace();
        }
    }

    public void checkArchiveFailure() {
        if (ArchiveConstants.getInstance().getFailureCount() > 10L && ArchiveConstants.getInstance().arrchivingCondition()) {
            LOGGER.log(Level.INFO, "IOException in archiving process, archiving stopped for the next 600 seconds");
            ArchiveConstants.getInstance().setLocationFailed(true);
            ArchiveFileManager.getInstance().restartErrorCheckTask();
        } else {
            ArchiveConstants.getInstance().addFailureCount();
        }
    }

    public void writeToFile(List<String> logs) {
        try {
            if (logs != null) {
                for (String log : logs) {
                    if (this.isEncryptionEnabled) {
                        this.writer.write(this.encryptionBaseAPI.encryptLog(log));
                    } else {
                        this.writer.write(log);
                    }
                    this.writer.write(this.logDelimiter);
                }
            }
            this.writer.flush();
        }
        catch (Exception e) {
            this.checkArchiveFailure();
            e.printStackTrace();
        }
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            if (this.fLock != null && this.fLock.isValid()) {
                this.fLock.release();
            }
            this.writer.close();
            this.osWriter.close();
            this.foStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getArchiveDirectory() {
        return this.archDirName;
    }

    public String toString() {
        return "Archive file with filename " + this.fileName;
    }

    private void getArchiveFileName(boolean isStart) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String fileName = this.archDirName + File.separator + df.format(new Date());
        if (this.isEncryptionEnabled) {
            if (AbstractEncryptionHandler.isDynamicEncryption()) {
                fileName = fileName + "_dyn";
            }
            fileName = "256".equals(this.encAlgo) ? fileName + "_256_enc" : fileName + "_enc";
        }
        this.fileName = fileName;
        if (!isStart) {
            this.todaysExistingFile();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    private void todaysExistingFile() {
        String recentFile = null;
        File hostarchivedir = new File(this.archDirName);
        Object[] todaysFile = hostarchivedir.list(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String fileName) {
                return fileName.startsWith(ArchiveFile.this.getTodaysHostArchive()) && new File(ArchiveFile.this.getArchiveDirectory() + File.separator + fileName).length() < ArchiveFile.this.deduction;
            }
        });
        Arrays.sort(todaysFile);
        if (todaysFile.length > 0) {
            this.fileName = recentFile = this.archDirName + File.separator + (String)todaysFile[todaysFile.length - 1];
            LOGGER.log(Level.INFO, "Using Todays Existing File:::::{0}", this.fileName);
        }
    }

    private String getTodaysHostArchive() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd");
        String fileName = df.format(new Date());
        return fileName;
    }
}

