/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.sa.server.arch.ApplicationArchiveBuffer;
import com.adventnet.sa.server.arch.ArchiveBuffer;
import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.arch.ArchiveFile;
import com.adventnet.sa.server.arch.ArchiveRecord;
import com.adventnet.sa.server.arch.ArchiveUtil;
import com.adventnet.sa.server.arch.HostArchiveBuffer;
import com.adventnet.sa.server.arch.UnixArchiveRecord;
import com.adventnet.sa.server.arch.WinArchiveRecord;
import com.adventnet.sa.server.arch.ZipTask;
import com.adventnet.sa.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ArchiveFileManager {
    private static final Logger LOGGER = Logger.getLogger(ArchiveFileManager.class.getName());
    private final Map<String, ArchiveBuffer> hostArchiveMap = new ConcurrentHashMap<String, ArchiveBuffer>();
    private final Map<String, ArchiveBuffer> appArchiveMap = new ConcurrentHashMap<String, ArchiveBuffer>();
    private ExecutorService zipper = Executors.newSingleThreadExecutor();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledExecutorService errorScheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture fileFlusher = null;
    private ScheduledFuture fileChecker = null;
    private ScheduledFuture splitChecker = null;
    private ScheduledFuture zipChecker = null;
    private ScheduledFuture errorChecker = null;
    private String currentArchDirectory = null;
    private ArchiveConstants archiveConstants = ArchiveConstants.getInstance();
    private static final WinArchiveRecord WIN_ARCHIVE_RECORD = new WinArchiveRecord();
    private static final UnixArchiveRecord UNIX_ARCHIVE_RECORD = new UnixArchiveRecord();
    private static ArchiveFileManager instance = null;
    private ArchiveFile archiveFile = null;
    private long archiveSize = Long.parseLong(System.getProperty("archivesize", "250"));
    private int noofFlatFiles = Integer.parseInt(System.getProperty("flatfiles", "8"));
    private final Object hostArchiveLock = new Object();
    private final Object appArchiveLock = new Object();
    private boolean archiveIntegrity = false;
    private String checkSumType = "MD5";

    private ArchiveFileManager() {
    }

    public static synchronized ArchiveFileManager getInstance() {
        if (instance == null) {
            instance = new ArchiveFileManager();
        }
        return instance;
    }

    public void init() {
        Runnable recordFlusher = new Runnable(){

            @Override
            public void run() {
                ArchiveFileManager.this.flushRecords(false);
            }
        };
        this.fileFlusher = this.scheduler.scheduleAtFixedRate(recordFlusher, 300L, 300L, TimeUnit.SECONDS);
        this.updateArchiveIntegrityStatus();
        this.startFileTask();
        this.startZipTask();
        this.startSplitTask();
        this.currentArchDirectory = this.archiveConstants.getArchiveLocation();
        LOGGER.info("created file flushing schedule");
        LOGGER.info("Current archive directory : " + this.currentArchDirectory);
    }

    public boolean archiveIntegrityEnabled() {
        return this.archiveIntegrity;
    }

    public String getCheckSumType() {
        return this.checkSumType;
    }

    public void updateArchiveIntegrityStatus() {
        String tamperConfValue = (String)CommonUtil.getSysConfiguration("ArchiveIntegrity");
        String checkSumTypeConfValue = (String)CommonUtil.getSysConfiguration("CheckSumType");
        if (tamperConfValue != null && tamperConfValue.equals("true")) {
            this.archiveIntegrity = true;
        } else {
            this.archiveIntegrity = false;
            ArchiveUtil.disableArchiveIntegrityHandler();
        }
        if (checkSumTypeConfValue != null) {
            this.checkSumType = checkSumTypeConfValue;
        }
        LOGGER.info("Archive Integrity Status :" + this.archiveIntegrity);
    }

    public void startErrorCheckTask() {
        long errorFrequency = Long.parseLong(System.getProperty("archErrSchedule", "600"));
        this.errorChecker = this.errorScheduler.scheduleAtFixedRate(new ErrorChecker(), errorFrequency, errorFrequency, TimeUnit.SECONDS);
    }

    public void restartErrorCheckTask() {
        this.errorChecker.cancel(false);
        this.startErrorCheckTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveLog(Hashtable log) {
        if (!this.archiveConstants.arrchivingCondition()) {
            return;
        }
        String hostName = (String)log.get("HOSTNAME");
        ArchiveBuffer h = this.hostArchiveMap.get(hostName);
        if (h == null) {
            Object object = this.hostArchiveLock;
            synchronized (object) {
                h = this.hostArchiveMap.get(hostName);
                if (h == null) {
                    h = new HostArchiveBuffer(hostName, (Long)log.get("HOSTID"));
                    this.hostArchiveMap.put(hostName, h);
                }
            }
        }
        ArchiveRecord record = null;
        record = log.containsKey("ARCHIVETYPE") && "Unix".equals(log.get("ARCHIVETYPE")) ? UNIX_ARCHIVE_RECORD : WIN_ARCHIVE_RECORD;
        try {
            h.addLogToBuffer(record.getArchiveLog(log));
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveAppLog(String appName, String hostName, String appKey, String log) {
        if (!this.archiveConstants.arrchivingCondition()) {
            return;
        }
        ArchiveBuffer app = this.appArchiveMap.get(appKey);
        if (app == null) {
            Object object = this.appArchiveLock;
            synchronized (object) {
                app = this.appArchiveMap.get(appKey);
                if (app == null) {
                    app = new ApplicationArchiveBuffer(appName, hostName);
                    this.appArchiveMap.put(appKey, app);
                }
            }
        }
        try {
            app.addLogToBuffer(log);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    public void deleteDeviceArchiveHandler(String hostName) {
        HashMap<String, ArchiveBuffer> hostAndAppArchiveMap = new HashMap<String, ArchiveBuffer>();
        for (ArchiveBuffer appArchive : this.appArchiveMap.values()) {
            if (!hostName.equals(appArchive.getHostName())) continue;
            hostAndAppArchiveMap.put(appArchive.getHostNameorappKey(), appArchive);
        }
        for (ArchiveBuffer removeAppArchive : hostAndAppArchiveMap.values()) {
            this.appArchiveMap.remove(removeAppArchive.getHostNameorappKey());
        }
        if (this.hostArchiveMap.containsKey(hostName)) {
            hostAndAppArchiveMap.put(hostName, this.hostArchiveMap.get(hostName));
            this.hostArchiveMap.remove(hostName);
            this.createZipforDeletedHost(hostAndAppArchiveMap);
        }
    }

    public void flushRecords(boolean shutdown) {
        if (!this.archiveConstants.arrchivingCondition()) {
            return;
        }
        for (ArchiveBuffer hostArchive : this.hostArchiveMap.values()) {
            hostArchive.writeLogsToFile(shutdown);
        }
        for (ArchiveBuffer appArchive : this.appArchiveMap.values()) {
            appArchive.writeLogsToFile(shutdown);
        }
    }

    public void closeAndCreateNewFiles() {
        LOGGER.info("Closing and creating new files.");
        for (ArchiveBuffer hostArchive : this.hostArchiveMap.values()) {
            hostArchive.closeAndCreateArchiveFile();
        }
        for (ArchiveBuffer appArchive : this.appArchiveMap.values()) {
            appArchive.closeAndCreateArchiveFile();
        }
    }

    public void resetErrorStatus() {
        ArchiveConstants.getInstance().resetFailureCount();
        ArchiveConstants.getInstance().setLocationFailed(false);
    }

    public void closeAndCreateNewFiles(Map<String, ArchiveBuffer> hostArchmap, Map<String, ArchiveBuffer> apparchMap) {
        LOGGER.info("Closing and creating new file...");
        for (ArchiveBuffer hostArchive : hostArchmap.values()) {
            hostArchive.closeAndCreateArchiveFile();
        }
        for (ArchiveBuffer appArchive : apparchMap.values()) {
            appArchive.closeAndCreateArchiveFile();
        }
    }

    public void closeFilesForDeleteHost(Map<String, ArchiveBuffer> hostAndAppArchMap) {
        LOGGER.info("Closing archive files for deleted host...");
        for (ArchiveBuffer archive : hostAndAppArchMap.values()) {
            archive.deleteDeviceHandler();
        }
    }

    public void createInstantZip() {
        this.createZip();
    }

    private void createZip() {
        LOGGER.info("In create zip");
        if (!this.archiveConstants.arrchivingCondition()) {
            return;
        }
        this.closeAndCreateNewFiles();
        this.zipper.execute(new ZipTask(this.currentArchDirectory, Collections.unmodifiableMap(this.hostArchiveMap), Collections.unmodifiableMap(this.appArchiveMap)));
        this.currentArchDirectory = this.archiveConstants.getArchiveLocation();
    }

    private void createZipforHost(Map hostarchMap, Map apparchMap, List hosts, List apphosts) {
        LOGGER.info("In create zip");
        if (!this.archiveConstants.arrchivingCondition()) {
            return;
        }
        this.closeAndCreateNewFiles(hostarchMap, apparchMap);
        this.zipper.execute(new ZipTask(this.currentArchDirectory, Collections.unmodifiableMap(hostarchMap), Collections.unmodifiableMap(apparchMap), hosts, apphosts));
        this.currentArchDirectory = this.archiveConstants.getArchiveLocation();
    }

    private void createZipforDeletedHost(Map<String, ArchiveBuffer> hostAndAppArchiveMap) {
        LOGGER.info("In create zip for deleted host");
        if (!this.archiveConstants.arrchivingCondition()) {
            return;
        }
        this.closeFilesForDeleteHost(hostAndAppArchiveMap);
        this.zipper.execute(new ZipTask(this.currentArchDirectory, hostAndAppArchiveMap));
        this.currentArchDirectory = this.archiveConstants.getArchiveLocation();
    }

    private void startFileTask() {
        long initDelay = this.getInitFileDelay();
        this.fileChecker = this.scheduler.scheduleAtFixedRate(new FileChecker(), initDelay, this.archiveConstants.getFileCreationTimeInMillis(), TimeUnit.MILLISECONDS);
    }

    private void startSplitTask() {
        long initDelay = Long.parseLong(System.getProperty("archivesplit", "3607"));
        this.splitChecker = this.scheduler.scheduleAtFixedRate(new flatFileSplitter(), initDelay, initDelay, TimeUnit.SECONDS);
    }

    public void restartFileTask() {
        this.fileChecker.cancel(false);
        this.startFileTask();
    }

    private void startZipTask() {
        long initDelay = this.getInitZipDelay();
        this.zipChecker = this.scheduler.scheduleAtFixedRate(new ZipChecker(), initDelay, this.archiveConstants.getZipCreationTimeInMillis(), TimeUnit.MILLISECONDS);
    }

    public void restartZipTask() {
        this.zipChecker.cancel(false);
        this.startZipTask();
    }

    public void shutdown() {
        this.scheduler.shutdown();
        this.zipper.shutdown();
        this.flushRecords(true);
        this.closeArchiveFiles();
    }

    private void closeArchiveFiles() {
        for (ArchiveBuffer hostArchive : this.hostArchiveMap.values()) {
            hostArchive.closeArchiveFile();
        }
        for (ArchiveBuffer appArchive : this.appArchiveMap.values()) {
            appArchive.closeArchiveFile();
        }
    }

    private long getInitFileDelay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        ((Calendar)cal).add(5, 1);
        return cal.getTimeInMillis() - System.currentTimeMillis();
    }

    private long getInitZipDelay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        if ("Days".equals(this.archiveConstants.getZipCreationMode())) {
            cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
            ((Calendar)cal).add(5, 1);
        } else {
            cal.set(cal.get(1), cal.get(2), cal.get(5), cal.get(11), 0, 0);
            ((Calendar)cal).add(11, 1);
        }
        LOGGER.info("Archive scheduled at " + cal);
        return cal.getTimeInMillis() - System.currentTimeMillis();
    }

    private void checkandSplit() {
        boolean reachedmaximum;
        HashMap<String, ArchiveBuffer> SplithostArchiveMap = new HashMap<String, ArchiveBuffer>();
        HashMap<String, ArchiveBuffer> SplitappArchiveMap = new HashMap<String, ArchiveBuffer>();
        HashMap<String, ArchiveBuffer> maxArchiveMap = new HashMap<String, ArchiveBuffer>();
        HashMap<String, ArchiveBuffer> maxAppArchiveMap = new HashMap<String, ArchiveBuffer>();
        ArrayList<String> hosts = new ArrayList<String>();
        ArrayList<String> apphosts = new ArrayList<String>();
        for (ArchiveBuffer hostArchive : this.hostArchiveMap.values()) {
            reachedmaximum = false;
            reachedmaximum = hostArchive.islimitReached(this.archiveSize);
            if (hostArchive.getFileCount() > this.noofFlatFiles) {
                LOGGER.info("File Count Exceeded for this archive dir::::" + hostArchive.getArchiveFile().getArchiveDirectory());
                hosts.add(hostArchive.getHostNameorappKey());
                SplithostArchiveMap.put(hostArchive.getHostNameorappKey(), hostArchive);
                continue;
            }
            if (!reachedmaximum) continue;
            LOGGER.info("Reached Maximum for this archive dir::::" + hostArchive.getArchiveFile().getArchiveDirectory());
            maxArchiveMap.put(hostArchive.getHostNameorappKey(), hostArchive);
        }
        for (ArchiveBuffer appArchive : this.appArchiveMap.values()) {
            reachedmaximum = false;
            reachedmaximum = appArchive.islimitReached(this.archiveSize);
            if (appArchive.getFileCount() > this.noofFlatFiles) {
                LOGGER.info("File Count Exceeded for this  App archive dir::::" + appArchive.getArchiveFile().getArchiveDirectory());
                apphosts.add(appArchive.getHostName());
                SplitappArchiveMap.put(appArchive.getHostNameorappKey(), appArchive);
                continue;
            }
            if (!reachedmaximum) continue;
            LOGGER.info("Reached Maximum for this APP archive dir::::" + appArchive.getArchiveFile().getArchiveDirectory());
            maxAppArchiveMap.put(appArchive.getHostNameorappKey(), appArchive);
        }
        if (!SplithostArchiveMap.isEmpty() || !SplitappArchiveMap.isEmpty()) {
            this.createZipforHost(SplithostArchiveMap, SplitappArchiveMap, hosts, apphosts);
        }
        if (!maxArchiveMap.isEmpty() || !maxAppArchiveMap.isEmpty()) {
            this.closeAndCreateNewFiles(maxArchiveMap, maxAppArchiveMap);
        }
    }

    private class ErrorChecker
    implements Runnable {
        private ErrorChecker() {
        }

        @Override
        public void run() {
            ArchiveFileManager.this.resetErrorStatus();
        }
    }

    private class FileChecker
    implements Runnable {
        private FileChecker() {
        }

        @Override
        public void run() {
            ArchiveFileManager.this.closeAndCreateNewFiles();
        }
    }

    private class ZipChecker
    implements Runnable {
        private ZipChecker() {
        }

        @Override
        public void run() {
            ArchiveFileManager.this.createZip();
        }
    }

    private class flatFileSplitter
    implements Runnable {
        private flatFileSplitter() {
        }

        @Override
        public void run() {
            LOGGER.info("Flat file splitter task invoked..");
            ArchiveFileManager.this.checkandSplit();
        }
    }
}

