/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.arch.ArchiveUtil;
import com.adventnet.taskengine.Task;
import com.adventnet.taskengine.TaskContext;
import com.adventnet.taskengine.TaskExecutionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class ArchiveTamperMonitor
implements Task {
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask(TaskContext arg0) throws TaskExecutionException {
        Object object = lock;
        synchronized (object) {
            if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
                ArrayList<String> tamperedFileList = new ArrayList<String>();
                try {
                    SelectQueryImpl sysArchQuery = new SelectQueryImpl(Table.getTable((String)"SysArchivedFiles"));
                    Criteria unloadedArchiveCrit = new Criteria(Column.getColumn((String)"SysArchivedFiles", (String)"STATUS"), (Object)ArchiveConstants.ARCHIVE_UNLOADED, 0);
                    sysArchQuery.setCriteria(unloadedArchiveCrit);
                    sysArchQuery.addSelectColumn(Column.getColumn((String)"SysArchivedFiles", (String)"*"));
                    sysArchQuery.addSortColumn(new SortColumn(Column.getColumn((String)"SysArchivedFiles", (String)"AFID"), true));
                    DataObject sysArchDO = DataAccess.get((SelectQuery)sysArchQuery);
                    Iterator archiveFiles = sysArchDO.getRows("SysArchivedFiles");
                    while (archiveFiles.hasNext()) {
                        Row archiveFile = (Row)archiveFiles.next();
                        String fileName = (String)archiveFile.get("FILE_NAME");
                        String dbCheckSum = (String)archiveFile.get("CHECKSUM");
                        Long archived_time = (Long)archiveFile.get("ARCHIVED_TIME");
                        File file = new File(fileName);
                        if (file.exists()) {
                            if (dbCheckSum.equals(ArchiveConstants.DEFAULT_CHECKSUM)) {
                                if (ArchiveUtil.isArchiveZipFileTampered(fileName, archived_time)) {
                                    tamperedFileList.add(fileName);
                                    continue;
                                }
                                String checkSum = ArchiveUtil.getCheckSum(fileName);
                                archiveFile.set("CHECKSUM", (Object)checkSum);
                                sysArchDO.updateRow(archiveFile);
                                continue;
                            }
                            if (dbCheckSum.equals(ArchiveUtil.getCheckSum(fileName))) continue;
                            tamperedFileList.add(fileName);
                            continue;
                        }
                        archiveFile.set("STATUS", (Object)ArchiveConstants.ARCHIVE_NOT_FOUND);
                        archiveFile.set("FILE_STATUS", (Object)ArchiveConstants.ARCHIVE_NOT_FOUND.intValue());
                        sysArchDO.updateRow(archiveFile);
                    }
                    DataAccess.update((DataObject)sysArchDO);
                    if (!tamperedFileList.isEmpty()) {
                        Criteria tamperedFilesCrit = new Criteria(Column.getColumn((String)"SysArchivedFiles", (String)"FILE_NAME"), (Object)tamperedFileList.toArray(new String[tamperedFileList.size()]), 8);
                        UpdateQueryImpl updQuery = new UpdateQueryImpl("SysArchivedFiles");
                        updQuery.setCriteria(tamperedFilesCrit);
                        updQuery.setCriteria(unloadedArchiveCrit);
                        updQuery.setUpdateColumn("STATUS", (Object)ArchiveConstants.ARCHIVE_TAMPERED);
                        updQuery.setUpdateColumn("FILE_STATUS", (Object)ArchiveConstants.ARCHIVE_TAMPERED.intValue());
                        DataAccess.update((UpdateQuery)updQuery);
                    }
                }
                catch (DataAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void stopTask() throws TaskExecutionException {
    }
}

