/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.la.util.TimeStampingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.arch.ArchiveFile;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.manageengine.ela.server.common.jni.windows.ELANativeHandler;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import sun.misc.SharedSecrets;

public class ArchiveUtil {
    public static Long getHostID(String hostName) {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"Hosts"));
            selectQuery.addSelectColumn(Column.getColumn((String)"Hosts", (String)"*"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"Hosts", (String)"DNS_NAME"), (Object)hostName, 0));
            DataObject dob = DataAccess.get((SelectQuery)selectQuery);
            Row row = dob.getFirstRow("Hosts");
            return (Long)row.get("HOST_ID");
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static DataObject getCurrentArchiveFlatFileDO(Long hostID, String appName) {
        return ArchiveUtil.getArchiveFlatFilesDO(hostID, appName, 1, 0, null);
    }

    public static DataObject getArchiveFlatFilesDO(Long hostID, String appName, Integer status, Integer statusComparator, SortColumn sortCol) {
        try {
            SelectQueryImpl selectFiles = new SelectQueryImpl(Table.getTable((String)"ArchiveFlatFiles"));
            selectFiles.addSelectColumn(Column.getColumn((String)"ArchiveFlatFiles", (String)"*"));
            selectFiles.setCriteria(ArchiveUtil.getArchiveFlatFileCriteria(hostID, appName, status, statusComparator));
            if (sortCol != null) {
                selectFiles.addSortColumn(sortCol);
            }
            return PersistenceDBUtil.getPersistenceLite().get((SelectQuery)selectFiles);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Criteria getArchiveFlatFileCriteria(Long hostID, String appName, Integer status, Integer statusComparator) {
        Criteria crit = new Criteria(Column.getColumn((String)"ArchiveFlatFiles", (String)"HOST_ID"), (Object)hostID, 0);
        crit = crit.and(new Criteria(Column.getColumn((String)"ArchiveFlatFiles", (String)"STATUS"), (Object)status, statusComparator.intValue()));
        crit = crit.and(new Criteria(Column.getColumn((String)"ArchiveFlatFiles", (String)"TYPE"), (Object)appName, 0));
        return crit;
    }

    public static String getCheckSum(ArchiveFile aFile) {
        return ArchiveUtil.getCheckSum(aFile.getFileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCheckSum(String fileName) {
        String checkSumType = ArchiveFileManager.getInstance().getCheckSumType();
        String checkSum = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(fileName));
            switch (checkSumType) {
                case "SHA": {
                    checkSum = DigestUtils.shaHex((InputStream)fis);
                    return checkSum;
                }
                case "SHA256": {
                    checkSum = DigestUtils.sha256Hex((InputStream)fis);
                    return checkSum;
                }
                default: {
                    checkSum = DigestUtils.md5Hex((InputStream)fis);
                    return checkSum;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return checkSum;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isArchiveFlatFileTampered(String dbCheckSum, Long dbFlushTime, ArchiveFile aFile) {
        File fileObj;
        return dbCheckSum == ArchiveConstants.DEFAULT_CHECKSUM ? (fileObj = new File(aFile.getFileName())).lastModified() - dbFlushTime >= 300000L : !dbCheckSum.equalsIgnoreCase(ArchiveUtil.getCheckSum(aFile));
    }

    public static boolean isArchiveFlatFileTampered(String dbCheckSum, Long dbFlushTime, String fileName) {
        File fileObj;
        return dbCheckSum == ArchiveConstants.DEFAULT_CHECKSUM ? (fileObj = new File(fileName)).lastModified() - dbFlushTime >= 300000L : !dbCheckSum.equalsIgnoreCase(ArchiveUtil.getCheckSum(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isArchiveZipFileTampered(String zipName, Long archived_time) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipName);
            String signFileName = zipName.substring(0, zipFile.getName().lastIndexOf(".zip")) + ".sgn";
            ZipEntry signZipEntry = zipFile.getEntry(signFileName);
            if (ArchiveUtil.isFileModified(zipName, archived_time)) {
                boolean bl = true;
                return bl;
            }
            if (signZipEntry != null && TimeStampingAPI.getInstance().verify(zipFile, signFileName) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isFileModified(String fileName, Long modifiedTime) {
        File fileObj = new File(fileName);
        return fileObj.exists() && fileObj.lastModified() != modifiedTime.longValue();
    }

    public static void updateFileStatusBeforeZipping(Long hostID, String formatName) {
        try {
            DataObject listOfFilesDO = ArchiveUtil.getArchiveFlatFilesDO(hostID, formatName, 2, 0, null);
            Iterator filesIT = listOfFilesDO.getRows("ArchiveFlatFiles");
            while (filesIT.hasNext()) {
                Row flatFileRow = (Row)filesIT.next();
                String fileName = (String)flatFileRow.get("FILE_NAME");
                String checkSum = (String)flatFileRow.get("CHECKSUM");
                Long flushTime = (Long)flatFileRow.get("LAST_FLUSH_TIME");
                if (!ArchiveUtil.isFileExists(fileName) || !ArchiveUtil.isArchiveFlatFileTampered(checkSum, flushTime, fileName)) continue;
                flatFileRow.set("STATUS", (Object)3);
                listOfFilesDO.updateRow(flatFileRow);
            }
            DataAccess.update((DataObject)listOfFilesDO);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static void addFlatFileEntry(Long hostID, String appName, String fileName) {
        try {
            DataObject flatFileDo = DataAccess.constructDataObject();
            Row newFlatFileRow = new Row("ArchiveFlatFiles");
            newFlatFileRow.set("HOST_ID", (Object)hostID);
            newFlatFileRow.set("FILE_NAME", (Object)fileName);
            newFlatFileRow.set("STATUS", (Object)1);
            newFlatFileRow.set("TYPE", (Object)appName);
            newFlatFileRow.set("CHECKSUM", (Object)ArchiveConstants.DEFAULT_CHECKSUM);
            newFlatFileRow.set("LAST_FLUSH_TIME", (Object)System.currentTimeMillis());
            flatFileDo.addRow(newFlatFileRow);
            DataAccess.add((DataObject)flatFileDo);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static boolean isFileExists(String file) {
        return new File(file).exists();
    }

    public static void updateCheckSumEntry(ArchiveFile aFile) {
        try {
            File file = new File(aFile.getFileName());
            if (file.length() > 0L) {
                UpdateQueryImpl updateCheckSum = new UpdateQueryImpl("ArchiveFlatFiles");
                updateCheckSum.setCriteria(new Criteria(Column.getColumn((String)"ArchiveFlatFiles", (String)"FILE_NAME"), (Object)aFile.getFileName(), 0));
                updateCheckSum.setUpdateColumn("CHECKSUM", (Object)ArchiveUtil.getCheckSum(aFile));
                DataAccess.update((UpdateQuery)updateCheckSum);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static void updateFlushTimeEntry(Long hostID, String hostFormatType, Long flushTime) {
        try {
            UpdateQueryImpl updateFlushTime = new UpdateQueryImpl("ArchiveFlatFiles");
            updateFlushTime.setCriteria(ArchiveUtil.getArchiveFlatFileCriteria(hostID, hostFormatType, 1, 0));
            updateFlushTime.setUpdateColumn("LAST_FLUSH_TIME", (Object)flushTime);
            DataAccess.update((UpdateQuery)updateFlushTime);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static int checkArchiveFlatFileTamperStatus(Long hostID, String formatName, ArchiveFile aFile) {
        int status = 1;
        try {
            boolean existingFile = false;
            DataObject localFlatFileDo = ArchiveUtil.getCurrentArchiveFlatFileDO(hostID, formatName);
            Iterator filesIT = localFlatFileDo.getRows("ArchiveFlatFiles");
            while (filesIT.hasNext()) {
                Row flatFileRow = (Row)filesIT.next();
                String flatFileName = (String)flatFileRow.get("FILE_NAME");
                if (aFile.getFileName().equalsIgnoreCase(flatFileName)) {
                    existingFile = true;
                    if (ArchiveUtil.isArchiveFlatFileTampered((String)flatFileRow.get("CHECKSUM"), (Long)flatFileRow.get("LAST_FLUSH_TIME"), aFile)) {
                        flatFileRow.set("STATUS", (Object)3);
                        localFlatFileDo.updateRow(flatFileRow);
                        status = 3;
                        continue;
                    }
                    flatFileRow.set("CHECKSUM", (Object)ArchiveConstants.DEFAULT_CHECKSUM);
                    localFlatFileDo.updateRow(flatFileRow);
                    status = 1;
                    continue;
                }
                flatFileRow.set("STATUS", (Object)2);
                localFlatFileDo.updateRow(flatFileRow);
            }
            if (!existingFile) {
                status = 2;
                if (ArchiveUtil.isNewFileAlreadyExists(aFile.getFileName())) {
                    status = 4;
                }
            }
            DataAccess.update((DataObject)localFlatFileDo);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return status;
    }

    public static boolean isNewFileAlreadyExists(String fileName) {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ArchiveFlatFiles"));
            sq.setCriteria(new Criteria(Column.getColumn((String)"ArchiveFlatFiles", (String)"FILE_NAME"), (Object)fileName, 0));
            sq.addSelectColumn(Column.getColumn((String)"ArchiveFlatFiles", (String)"*"));
            DataObject dobj = DataAccess.get((SelectQuery)sq);
            if (dobj.size("ArchiveFlatFiles") > 0) {
                return true;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void disableArchiveIntegrityHandler() {
        try {
            DeleteQueryImpl deleteQuery = new DeleteQueryImpl("ArchiveFlatFiles");
            DataAccess.delete((DeleteQuery)deleteQuery);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public static FileOutputStream getStreamUsingWindowsHandle(String fileName) throws FileNotFoundException {
        FileDescriptor fd = new FileDescriptor();
        long handle = ELANativeHandler.getFileHandleForWriteStream(fileName);
        if (handle != 0L) {
            SharedSecrets.getJavaIOFileDescriptorAccess().setHandle(fd, handle);
            return new FileOutputStream(fd);
        }
        return new FileOutputStream(new File(fileName), true);
    }
}

