/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.sa.server.arch.ArchiveFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HostArchive {
    private static final Logger LOGGER = Logger.getLogger(HostArchive.class.getName());
    private String hostName = null;
    private ArchiveFile aFile = null;
    private String hostArchiveDirectory = null;
    private List<String> logBuffer = null;

    public HostArchive(String hostName) {
        this.hostName = hostName;
        this.aFile = new ArchiveFile(hostName, false);
        this.logBuffer = new ArrayList<String>();
        LOGGER.info("Init hostarchive for host : " + this.hostName);
    }

    public void addLogToBuffer(String log) {
        this.logBuffer.add(log);
        if (this.logBuffer.size() >= 300) {
            this.flushFile();
            this.logBuffer.clear();
        }
    }

    public synchronized void flushFile() {
        LOGGER.info("flushing logs for host " + this.hostName + " logcount : " + this.logBuffer.size());
        this.aFile.writeToFile(this.logBuffer);
        this.logBuffer.clear();
    }

    public synchronized void closeArchiveFile() {
        this.aFile.close();
    }

    public synchronized void closeAndCreateArchiveFile() {
        this.aFile.close();
        this.aFile = new ArchiveFile(this.hostName, false);
    }

    public synchronized void closeAndRenameFolder() {
        this.aFile.close();
        this.aFile = new ArchiveFile(this.hostName, false);
    }

    private void renameHostDirectory() {
        String parentDir;
        String toDir;
        File to;
        String archDirName = this.aFile.getArchiveDirectory();
        File from = new File(archDirName);
        if (from.renameTo(to = new File(toDir = (parentDir = from.getParent()) + File.separator + this.hostName + "_for_archive"))) {
            LOGGER.log(Level.INFO, "Successfully renamed directory {0} to {1}", new Object[]{archDirName, toDir});
        } else {
            LOGGER.log(Level.INFO, "Error renaming directory {0} to {1}", new Object[]{archDirName, toDir});
        }
    }

    public ArchiveFile getArchiveFile() {
        return this.aFile;
    }
}

