/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.sa.server.arch.ArchiveBuffer;
import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.arch.ArchiveFile;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.arch.ArchiveUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class HostArchiveBuffer
implements ArchiveBuffer {
    private static final Logger LOGGER = Logger.getLogger(HostArchiveBuffer.class.getName());
    private String hostName = null;
    private ArchiveFile aFile = null;
    private List<String> logBuffer = null;
    private int logBufferMaxLimit = "true".equals(System.getProperty("handleHighFlow", "false")) ? 10000 : 300;
    private final Object lock = new Object();
    private long hostID;
    private long flushTime;
    private boolean isDelete = false;

    public HostArchiveBuffer(String hostName, Long hostID) {
        this.hostName = hostName;
        this.hostID = hostID;
        this.logBuffer = new ArrayList<String>(this.logBufferMaxLimit);
        this.flushTime = System.currentTimeMillis();
        this.openArchiveFile(false);
        LOGGER.info("Init hostarchive for host : " + this.hostName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogToBuffer(String log) {
        Object object = this.lock;
        synchronized (object) {
            this.logBuffer.add(log);
        }
        if (this.logBuffer.size() >= this.logBufferMaxLimit) {
            this.writeLogsToFile(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeLogsToFile(boolean shutdown) {
        List<String> tempBuffer = this.logBuffer;
        Object object = this.lock;
        synchronized (object) {
            this.logBuffer = new ArrayList<String>(this.logBufferMaxLimit);
            LOGGER.fine("flushing logs for host " + this.hostName + " logcount : " + this.logBuffer.size());
        }
        this.aFile.writeToFile(tempBuffer);
        if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            long currentTime = System.currentTimeMillis();
            if (!this.isDelete && (shutdown && !tempBuffer.isEmpty() || currentTime - this.flushTime > 300000L)) {
                this.flushTime = currentTime;
                ArchiveUtil.updateFlushTimeEntry(this.hostID, ArchiveConstants.HOST_FORMAT_TYPE, this.flushTime);
            }
        }
    }

    @Override
    public void createArchiveFile(boolean newFile) {
        this.aFile = new ArchiveFile(this.hostName, newFile);
    }

    @Override
    public synchronized void deleteDeviceHandler() {
        this.isDelete = true;
        this.writeLogsToFile(false);
        this.closeArchiveFile();
    }

    @Override
    public void openArchiveFile(boolean newFile) {
        this.createArchiveFile(newFile);
        if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            int tamperStatus = ArchiveUtil.checkArchiveFlatFileTamperStatus(this.hostID, ArchiveConstants.HOST_FORMAT_TYPE, this.aFile);
            if (tamperStatus == 3 || tamperStatus == 4) {
                this.createArchiveFile(true);
            }
            if (tamperStatus != 1) {
                ArchiveUtil.addFlatFileEntry(this.hostID, ArchiveConstants.HOST_FORMAT_TYPE, this.aFile.getFileName());
            }
        }
        this.aFile.openFile();
    }

    @Override
    public synchronized void closeArchiveFile() {
        this.aFile.close();
        if (!this.isDelete && ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            ArchiveUtil.updateCheckSumEntry(this.aFile);
        }
    }

    @Override
    public synchronized void closeAndCreateArchiveFile() {
        ArchiveFile tobeClosed = this.aFile;
        this.openArchiveFile(true);
        tobeClosed.close();
        if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            ArchiveUtil.updateCheckSumEntry(tobeClosed);
        }
    }

    @Override
    public ArchiveFile getArchiveFile() {
        return this.aFile;
    }

    @Override
    public String getHostNameorappKey() {
        return this.hostName;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getFileCount() {
        int noofFiles = new File(this.aFile.getArchiveDirectory()).listFiles().length;
        return noofFiles;
    }

    @Override
    public boolean islimitReached(long archivesize) {
        long deduction;
        long max;
        long filesizeinBytes = new File(this.aFile.getFileName()).length();
        if (filesizeinBytes > (max = archivesize * 1024L * 1024L) - (deduction = max * 20L / 100L)) {
            LOGGER.info("FILE NAME::::<->" + this.aFile.getFileName() + "<->:::filesizeinBytes IS:::::::::" + filesizeinBytes + "MAX:::::::::" + max);
            return true;
        }
        return false;
    }
}

