/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.arch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.TimeStampingAPI;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.arch.ArchiveBuffer;
import com.adventnet.sa.server.arch.ArchiveConstants;
import com.adventnet.sa.server.arch.ArchiveFile;
import com.adventnet.sa.server.arch.ArchiveFileManager;
import com.adventnet.sa.server.arch.ArchiveUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Signature;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ZipTask.class.getName());
    private String archiveDirectory = null;
    private Map<String, ArchiveBuffer> hostArchiveMap = null;
    private Map<String, ArchiveBuffer> appArchiveMap = null;
    private Map<String, ArchiveBuffer> hostAndAppArchiveMap = null;
    private boolean isTimeStampingEnabled = false;
    private Criteria hostCriteria = null;
    private Criteria appCriteria = null;
    private SimpleDateFormat zipDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private static SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private static SimpleDateFormat pre7000DateFormat = new SimpleDateFormat("dd_MM_yyyy_HH_mm_ss");
    private static SimpleDateFormat pre7000AS400DateFormat = new SimpleDateFormat("dd_MM_yy_HH_mm_ss");
    private final int dataSize = 8192;
    private boolean isDeleteHandling = false;

    public ZipTask(String archiveDirectory, Map<String, ArchiveBuffer> hostArchiveMap, Map<String, ArchiveBuffer> appArchiveMap) {
        this.archiveDirectory = archiveDirectory;
        this.hostArchiveMap = hostArchiveMap;
        this.appArchiveMap = appArchiveMap;
        this.isTimeStampingEnabled = ArchiveConstants.getInstance().isTimeStampingEnabled();
        this.hostCriteria = new Criteria(new Column("HostDetails", "TYPE"), (Object)"Application", 1);
    }

    public ZipTask(String archiveDirectory, Map<String, ArchiveBuffer> hostAndAppArchiveMap) {
        this.isDeleteHandling = true;
        this.archiveDirectory = archiveDirectory;
        this.hostAndAppArchiveMap = hostAndAppArchiveMap;
    }

    public ZipTask(String archiveDirectory, Map<String, ArchiveBuffer> hostArchiveMap, Map<String, ArchiveBuffer> appArchiveMap, List hosts, List appHosts) {
        this.archiveDirectory = archiveDirectory;
        this.hostArchiveMap = hostArchiveMap;
        this.appArchiveMap = appArchiveMap;
        this.isTimeStampingEnabled = ArchiveConstants.getInstance().isTimeStampingEnabled();
        this.hostCriteria = new Criteria(new Column("HostDetails", "TYPE"), (Object)"Application", 1).and(new Criteria(new Column("Hosts", "DNS_NAME"), (Object)hosts.toArray(), 8));
        this.appCriteria = new Criteria(new Column("Hosts", "DNS_NAME"), (Object)appHosts.toArray(), 8);
    }

    @Override
    public void run() {
        try {
            if (this.isDeleteHandling) {
                this.zipDeleteHostLogs();
            } else {
                LOGGER.info("Starting ZipTask");
                DataObject sysArchiveDO = DataAccess.constructDataObject();
                SelectQueryImpl hostQuery = new SelectQueryImpl(new Table("Hosts"));
                hostQuery.addSelectColumn(new Column("Hosts", "*"));
                hostQuery.addSelectColumn(new Column("HostDetails", "*"));
                hostQuery.addJoin(new Join("Hosts", "HostDetails", new String[]{"HOST_ID"}, new String[]{"HOST_ID"}, 2));
                hostQuery.setCriteria(this.hostCriteria);
                DataObject hostDO = DataAccess.get((SelectQuery)hostQuery);
                LOGGER.fine("HOSTDO in ZipTask::::::::::::::::" + hostDO);
                Iterator hostIter = hostDO.getRows("Hosts");
                while (hostIter.hasNext()) {
                    Row hostRow = (Row)hostIter.next();
                    Long hostId = (Long)hostRow.get("HOST_ID");
                    String dnsName = (String)hostRow.get("DNS_NAME");
                    Row hdRow = hostDO.getRow("HostDetails", new Criteria(new Column("HostDetails", "HOST_ID"), (Object)hostId, 0));
                    String hostType = (String)hdRow.get("TYPE");
                    this.createAndAddZipToDB(dnsName, hostId, hostType, sysArchiveDO);
                }
                sysArchiveDO = DataAccess.add((DataObject)sysArchiveDO);
                Iterator sysIter = sysArchiveDO.getRows("SysArchivedFiles");
                while (sysIter.hasNext()) {
                    Row r = (Row)sysIter.next();
                    r.set("TABLE_NAME", (Object)("ArchivedTable_" + r.get("AFID")));
                    sysArchiveDO.updateRow(r);
                }
                DataAccess.update((DataObject)sysArchiveDO);
                LOGGER.info("Completed ZipTask");
                this.zipApplicationLogs();
            }
        }
        catch (Exception e) {
            LOGGER.info("Exception while creating zip ::::::: " + e);
            e.printStackTrace();
        }
    }

    private void zipDeleteHostLogs() {
        for (ArchiveBuffer archive : this.hostAndAppArchiveMap.values()) {
            File hostDir;
            String hostName = archive.getHostName();
            String formatName = archive.getHostNameorappKey();
            File appDir = new File(this.archiveDirectory + File.separator + formatName + File.separator + hostName);
            if (appDir.exists()) {
                List<File> files = this.getFileList(appDir, hostName, null);
                if (files.size() <= 0) {
                    LOGGER.info("No Files present for host " + hostName);
                    continue;
                }
                String zipFileName = formatName + "_" + hostName + "_" + this.zipDateFormat.format(new Date()) + ".zip";
                this.createZip(zipFileName, formatName, files, true);
                appDir.delete();
            }
            if (!hostName.equals(formatName) || !(hostDir = new File(this.archiveDirectory + File.separator + hostName)).exists()) continue;
            List<File> files = this.getFileList(hostDir, hostName, null);
            if (files.size() <= 0) {
                LOGGER.info("No Files present for host " + hostName);
                continue;
            }
            String zipFileName = hostName + "_" + this.zipDateFormat.format(new Date()) + ".zip";
            this.createZip(zipFileName, formatName, files, true);
            hostDir.delete();
        }
    }

    private void zipApplicationLogs() {
        try {
            SelectQueryImpl appQuery = new SelectQueryImpl(new Table("AppResources"));
            appQuery.addSelectColumn(new Column("AppResources", "*"));
            appQuery.addSelectColumn(new Column("Hosts", "*"));
            appQuery.addSelectColumn(new Column("FormatDetails", "*"));
            appQuery.addJoin(new Join("AppResources", "Hosts", new String[]{"HOSTID"}, new String[]{"HOST_ID"}, 2));
            appQuery.addJoin(new Join("AppResources", "FormatDetails", new String[]{"FORMATID"}, new String[]{"FORMATID"}, 2));
            appQuery.setCriteria(this.appCriteria);
            DataObject doo = DataAccess.get((SelectQuery)appQuery);
            Iterator appIter = doo.getRows("AppResources");
            while (appIter.hasNext()) {
                Row appRow = (Row)appIter.next();
                Row hostRow = doo.getRow("Hosts", new Criteria(new Column("Hosts", "HOST_ID"), appRow.get("HOSTID"), 0));
                Row formatRow = doo.getRow("FormatDetails", new Criteria(new Column("FormatDetails", "FORMATID"), appRow.get("FORMATID"), 0));
                String hostName = (String)hostRow.get("DNS_NAME");
                String formatName = (String)formatRow.get("FORMATNAME");
                Long hostID = (Long)hostRow.get("HOST_ID");
                File hostDir = new File(this.archiveDirectory + File.separator + formatName + File.separator + hostName);
                LOGGER.info("Zipping for format " + formatName + " host " + hostName);
                if (!hostDir.exists()) {
                    LOGGER.info("Folder for host " + hostName + " doesnt exist. Returning");
                    continue;
                }
                List<File> files = this.getFileList(hostDir, hostName, this.appArchiveMap);
                if (files.size() <= 0) {
                    LOGGER.info("No Files present for host " + hostName);
                    continue;
                }
                String zipFileName = formatName + "_" + hostName + "_" + this.zipDateFormat.format(new Date()) + ".zip";
                this.createZip(zipFileName, formatName, files, true);
                DataAccess.delete((Criteria)ArchiveUtil.getArchiveFlatFileCriteria(hostID, formatName, 1, 1));
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
    }

    private void createAndAddZipToDB(String hostName, Long hostId, String hostType, DataObject sysArchiveDO) {
        File hostDir = new File(this.archiveDirectory + File.separator + hostName);
        LOGGER.info("Zipping for host " + hostName);
        if (!hostDir.exists()) {
            LOGGER.info("Folder for host " + hostName + " doesnt exist. Returning");
            return;
        }
        Map<String, File> files = this.getFileMap(hostDir, hostName, this.hostArchiveMap);
        if (files.size() <= 0) {
            LOGGER.info("No Files present for host " + hostName);
            return;
        }
        if (ArchiveFileManager.getInstance().archiveIntegrityEnabled()) {
            this.tamperCheckZipCreation(hostName, hostId, hostType, sysArchiveDO, files);
        } else {
            ArrayList<File> filesList = new ArrayList<File>(files.values());
            this.createAndAddZipToDB(hostName, hostId, hostType, sysArchiveDO, filesList, 0L, null);
        }
    }

    private void createAndAddZipToDB(String hostName, Long hostId, String hostType, DataObject sysArchiveDO, List<File> files, Long status, Long dummyStartTime) {
        long endTime;
        long startTime;
        String zipFileName = hostName + "_" + this.zipDateFormat.format(new Date()) + ".zip";
        boolean dummyEntryForMissingFile = false;
        if (files == null && dummyStartTime != null) {
            dummyEntryForMissingFile = true;
            startTime = dummyStartTime;
            endTime = dummyStartTime;
            zipFileName = hostName + "_deletedFile.zip";
            LOGGER.severe("Archive Integrity Alert: Deleted Archive File Entry found");
        } else {
            endTime = this.endTime(files);
            zipFileName = hostName + "_" + this.zipDateFormat.format(new Date(endTime)) + ".zip";
            startTime = this.createZip(zipFileName, hostType, files, false);
        }
        String zipAbsoluteFileName = this.archiveDirectory + File.separator + zipFileName;
        if (startTime < Long.MAX_VALUE) {
            LOGGER.fine("After create zip: ");
            Row archiveRow = new Row("SysArchivedFiles");
            archiveRow.set("HOST_ID", (Object)hostId);
            archiveRow.set("FILE_NAME", (Object)zipAbsoluteFileName);
            archiveRow.set("START_TIME", (Object)new Long(startTime));
            archiveRow.set("END_TIME", (Object)new Long(endTime));
            if (dummyEntryForMissingFile) {
                archiveRow.set("ARCHIVED_TIME", (Object)new Long(startTime));
                archiveRow.set("SIZE", (Object)0L);
                archiveRow.set("STATUS", (Object)ArchiveConstants.ARCHIVE_NOT_FOUND);
                archiveRow.set("FILE_STATUS", (Object)ArchiveConstants.ARCHIVE_NOT_FOUND.intValue());
            } else {
                long archivedTime = new File(zipAbsoluteFileName).lastModified();
                archiveRow.set("ARCHIVED_TIME", (Object)new Long(archivedTime));
                archiveRow.set("SIZE", (Object)new File(zipAbsoluteFileName).length());
                archiveRow.set("CHECKSUM", (Object)ArchiveUtil.getCheckSum(zipAbsoluteFileName));
                archiveRow.set("STATUS", (Object)ArchiveConstants.ARCHIVE_UNLOADED);
                if (status.intValue() == 3) {
                    archiveRow.set("STATUS", (Object)ArchiveConstants.ARCHIVE_TAMPERED);
                    archiveRow.set("FILE_STATUS", (Object)ArchiveConstants.ARCHIVE_TAMPERED.intValue());
                }
            }
            archiveRow.set("TABLE_NAME", (Object)("ArchivedTable_" + System.currentTimeMillis()));
            archiveRow.set("TYPE", (Object)"ARCHIVE");
            try {
                sysArchiveDO.addRow(archiveRow);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else {
            LOGGER.info("create zip failed");
            new File(zipAbsoluteFileName).delete();
        }
    }

    private void tamperCheckZipCreation(String hostName, Long hostId, String hostType, DataObject sysArchiveDO, Map<String, File> files) {
        ArchiveUtil.updateFileStatusBeforeZipping(hostId, ArchiveConstants.HOST_FORMAT_TYPE);
        try {
            SortColumn sortCol = new SortColumn(Column.getColumn((String)"ArchiveFlatFiles", (String)"FILE_NAME"), true);
            DataObject listOfFilesDO = ArchiveUtil.getArchiveFlatFilesDO(hostId, ArchiveConstants.HOST_FORMAT_TYPE, 1, 1, sortCol);
            Iterator filesIT = listOfFilesDO.getRows("ArchiveFlatFiles");
            long tempStatus = 0L;
            ArrayList<File> tempFilesList = new ArrayList<File>();
            while (filesIT.hasNext()) {
                Row flatFileRow = (Row)filesIT.next();
                long fileStatus = Long.parseLong(flatFileRow.get("STATUS").toString());
                if (files.get(flatFileRow.get("FILE_NAME")) == null) {
                    if (flatFileRow.get("CHECKSUM") == ArchiveConstants.DEFAULT_CHECKSUM) continue;
                    fileStatus = ArchiveConstants.ARCHIVE_NOT_FOUND;
                    Path p = Paths.get((String)flatFileRow.get("FILE_NAME"), new String[0]);
                    Long startTime = this.getStartTimeForFile(p.getFileName().toString());
                    this.createAndAddZipToDB(hostName, hostId, hostType, sysArchiveDO, null, fileStatus, startTime);
                    continue;
                }
                if (tempStatus == 0L || tempStatus == ArchiveConstants.ARCHIVE_NOT_FOUND) {
                    tempStatus = fileStatus;
                }
                if (tempStatus == fileStatus) {
                    tempFilesList.add(files.get(flatFileRow.get("FILE_NAME")));
                    files.remove(flatFileRow.get("FILE_NAME"));
                    continue;
                }
                this.createAndAddZipToDB(hostName, hostId, hostType, sysArchiveDO, tempFilesList, tempStatus, null);
                tempStatus = fileStatus;
                tempFilesList = new ArrayList();
                tempFilesList.add(files.get(flatFileRow.get("FILE_NAME")));
                files.remove(flatFileRow.get("FILE_NAME"));
            }
            if (!tempFilesList.isEmpty()) {
                this.createAndAddZipToDB(hostName, hostId, hostType, sysArchiveDO, tempFilesList, tempStatus, null);
            }
            if (!files.isEmpty()) {
                ArrayList<File> filesList = new ArrayList<File>(files.values());
                this.createAndAddZipToDB(hostName, hostId, hostType, sysArchiveDO, filesList, 0L, null);
            }
            DataAccess.delete((Criteria)ArchiveUtil.getArchiveFlatFileCriteria(hostId, ArchiveConstants.HOST_FORMAT_TYPE, 1, 1));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private List<File> getFileList(File dir, String hostName, Map<String, ArchiveBuffer> bufferMap) {
        File[] files = dir.listFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        for (File flatFile : files) {
            if (!flatFile.exists()) {
                LOGGER.info("file does not exist");
                continue;
            }
            if (bufferMap != null && this.isCurrentFile(hostName, flatFile, bufferMap)) {
                LOGGER.info("Skipping current file ::: " + flatFile.getName());
                continue;
            }
            if (flatFile.length() == 0L) {
                flatFile.delete();
                continue;
            }
            fileList.add(flatFile);
        }
        LOGGER.fine("File list :" + files);
        return fileList;
    }

    private Map<String, File> getFileMap(File dir, String hostName, Map<String, ArchiveBuffer> bufferMap) {
        File[] files = dir.listFiles();
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (File flatFile : files) {
            if (!flatFile.exists()) {
                LOGGER.info("file does not exist");
                continue;
            }
            if (this.isCurrentFile(hostName, flatFile, bufferMap)) {
                LOGGER.info("Skipping current file ::: " + flatFile.getName());
                continue;
            }
            if (flatFile.length() == 0L) {
                flatFile.delete();
                continue;
            }
            fileMap.put(flatFile.getAbsolutePath(), flatFile);
        }
        LOGGER.info("File list :" + ((Object)fileMap).toString());
        return fileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createZip(String zipFileName, String hostType, List<File> files, boolean isApplicationArchive) {
        byte[] data = new byte[8192];
        TimeStampingAPI timeStampingAPI = null;
        Signature sign = null;
        if (this.isTimeStampingEnabled) {
            timeStampingAPI = TimeStampingAPI.getInstance();
            sign = timeStampingAPI.getSignatureObjToSign();
        }
        ZipOutputStream zipStream = null;
        long startTime = Long.MAX_VALUE;
        String zipAbsoluteFileName = this.archiveDirectory + File.separator + zipFileName;
        try {
            zipStream = new ZipOutputStream(new FileOutputStream(zipAbsoluteFileName));
            for (File flatFile : files) {
                long fileStartTime = this.getStartTimeForFile(flatFile.getName());
                if (fileStartTime < startTime) {
                    startTime = fileStartTime;
                }
                BufferedInputStream buffer = null;
                try {
                    int n;
                    zipStream.putNextEntry(new ZipEntry(flatFile.getName()));
                    buffer = new BufferedInputStream(new FileInputStream(flatFile));
                    while ((n = buffer.read(data, 0, 8192)) != -1) {
                        zipStream.write(data, 0, n);
                        if (!this.isTimeStampingEnabled) continue;
                        timeStampingAPI.updateDataIntoSignature(sign, data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (buffer != null) {
                            buffer.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (flatFile.delete()) {
                        LOGGER.fine("Deleted file " + flatFile.getName());
                        continue;
                    }
                    LOGGER.info("Warning! unable to delete file " + flatFile.getName());
                }
            }
            this.createProperty(zipStream, hostType, isApplicationArchive);
            this.createSignature(zipStream, timeStampingAPI, sign, zipFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zipStream != null) {
                    zipStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return startTime;
    }

    private long endTime(List<File> files) {
        long endTime = 0L;
        for (File flatFile : files) {
            long fileEndTime = flatFile.lastModified();
            if (fileEndTime <= endTime) continue;
            endTime = fileEndTime;
        }
        return endTime;
    }

    private boolean isCurrentFile(String hostName, File flatFile, Map<String, ArchiveBuffer> bufferMap) {
        ArchiveFile aFile;
        ArchiveBuffer buffer = bufferMap.get(hostName);
        return buffer != null && (aFile = buffer.getArchiveFile()).getFileName().equals(flatFile.getAbsolutePath());
    }

    private long getStartTimeForFile(String fileName) {
        GregorianCalendar cal = new GregorianCalendar();
        try {
            cal.setTime(fileDateFormat.parse(fileName));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        long time = cal.getTimeInMillis();
        if (time < 0L) {
            try {
                cal.setTime(pre7000DateFormat.parse(fileName));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            time = cal.getTimeInMillis();
            if (time < 0L) {
                try {
                    cal.setTime(pre7000AS400DateFormat.parse(fileName));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                time = cal.getTimeInMillis();
            }
        }
        return time;
    }

    private void createProperty(ZipOutputStream zipStream, String hostType, boolean isApplicationArchive) throws IOException {
        LOGGER.fine("Creation property file");
        String formatName = "sys_archive";
        String os = "Unix";
        String type = "Non-Application";
        if ("Windows".equals(hostType)) {
            formatName = "win_archive";
            os = "Windows";
        } else if ("Cisco Device".equals(hostType)) {
            formatName = "cisco_archive";
            os = "Cisco Device";
        } else if ("IBM AS/400".equals(hostType)) {
            formatName = "ibm_as400";
            os = "IBM AS/400";
        } else if ("SonicWall Device".equals(hostType)) {
            formatName = "sys_archive";
            os = "SonicWall Device";
        } else if (isApplicationArchive) {
            formatName = hostType;
            os = "Application";
            type = "Application";
        }
        zipStream.putNextEntry(new ZipEntry("archivedesc.properties"));
        zipStream.write(("format=" + formatName + "\n").getBytes());
        zipStream.write(("os=" + os + "\n").getBytes());
        zipStream.write(("type=" + type + "\n").getBytes());
    }

    private void createSignature(ZipOutputStream zipStream, TimeStampingAPI timeStamping, Signature sign, String zipName) throws IOException {
        if (sign != null) {
            LOGGER.fine("Creation signature file");
            String signatureStr = timeStamping.getSignedString(sign);
            String sigFileName = zipName.substring(0, zipName.lastIndexOf(".zip")) + ".sgn";
            if (signatureStr != null) {
                zipStream.putNextEntry(new ZipEntry(sigFileName));
                zipStream.write(signatureStr.getBytes());
            }
        }
    }
}

