/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.audit;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.audit.ELAAuditImpl;
import com.adventnet.sa.server.audit.TableNames;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

enum AuditType {
    ARCHIVE{

        @Override
        public TableNames getUniqueTable() {
            return TableNames.ARCHIVES;
        }

        @Override
        public TableNames getTableName() {
            return TableNames.ARCHIVES;
        }

        @Override
        public TableNames getUpdateTable() {
            return TableNames.ARCHIVES;
        }

        @Override
        public List getUpdateTables() {
            return Arrays.asList("SysArchivedFiles");
        }

        @Override
        public boolean getAuditStatus() {
            String status = System.getProperty("archiveaudit", "true");
            return Boolean.valueOf(status);
        }

        @Override
        public List getAddedResource(DataObject dobj, Map auditmap) {
            ArrayList resourceList = new ArrayList();
            return resourceList;
        }

        @Override
        public List getUpdatedResource(DataObject dobj, Map auditmap) {
            ArrayList resourceList = new ArrayList();
            return resourceList;
        }

        @Override
        public List getDeletedResource(DataObject dobj, List deleteCrit, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            try {
                TableNames table = TableNames.ARCHIVES;
                String tablename = table.getTableNamefromTableNames();
                String columnid = table.getColumnID();
                String resourceName = null;
                for (int i = 0; i < deleteCrit.size(); ++i) {
                    Criteria cri = (Criteria)deleteCrit.get(i);
                    Column col = cri.getColumn();
                    if (!col.getColumnName().equals(columnid)) continue;
                    Long criValue = (Long)cri.getValue();
                    resourceName = (String)((Map)auditmap.get((Object)ARCHIVE)).get(criValue);
                    resourceList.add(resourceName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }
    }
    ,
    ALERT{

        @Override
        public TableNames getUniqueTable() {
            return TableNames.NOTIFICATIONTYPE;
        }

        @Override
        public TableNames getTableName() {
            return TableNames.LACRITERIA;
        }

        @Override
        public TableNames getUpdateTable() {
            return TableNames.NOTIFICATIONTYPE;
        }

        @Override
        public List getUpdateTables() {
            return Arrays.asList("LAExpression", "LACriteria2Expressions");
        }

        @Override
        public boolean getAuditStatus() {
            String status = System.getProperty("alertaudit", "true");
            return Boolean.valueOf(status);
        }

        @Override
        public List getAddedResource(DataObject dobj, Map auditmap) {
            HashMap<Long, String> newmap = new HashMap<Long, String>();
            ArrayList<String> resourceList = new ArrayList<String>();
            try {
                TableNames table = TableNames.LACRITERIA;
                String tablename = table.getTableNamefromTableNames();
                String columnname = table.getColumnName();
                String columnid = table.getColumnID();
                Row temp = dobj.getRow(tablename);
                Long id = (Long)temp.get(columnid);
                String value = (String)temp.get(columnname);
                Map existMap = (Map)auditmap.get((Object)ALERT);
                resourceList.add(value);
                newmap.put(id, value);
                newmap.putAll(existMap);
                auditmap.put(ALERT, newmap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getUpdatedResource(DataObject dobj, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.LACRITERIA2EXPRESSIONS;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            try {
                Long critid = (Long)dobj.getFirstValue(tablename, columnid);
                String value = (String)((Map)auditmap.get((Object)ALERT)).get(critid);
                resourceList.add(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getDeletedResource(DataObject dobj, List deleteCrit, Map auditmap) {
            TableNames table = TableNames.LACRITERIA;
            ArrayList<String> resourceList = new ArrayList<String>();
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            String resourceName = null;
            for (int i = 0; i < deleteCrit.size(); ++i) {
                Criteria cri = (Criteria)deleteCrit.get(i);
                Column col = cri.getColumn();
                if (!col.getColumnName().equals(columnid)) continue;
                Long criValue = (Long)cri.getValue();
                resourceName = (String)((Map)auditmap.get((Object)ALERT)).get(criValue);
                resourceList.add(resourceName);
            }
            return resourceList;
        }
    }
    ,
    FILTER{

        @Override
        public TableNames getUniqueTable() {
            return TableNames.SYSLOGFILTER;
        }

        @Override
        public TableNames getTableName() {
            return TableNames.SYSLOGFILTER;
        }

        @Override
        public TableNames getUpdateTable() {
            return TableNames.SYSLOGFILTER;
        }

        @Override
        public List getUpdateTables() {
            return Arrays.asList("LACriteria", "Filter2Criteria", "LAExpression", "LACriteria2Expressions");
        }

        @Override
        public boolean getAuditStatus() {
            String status = System.getProperty("filteraudit", "true");
            return Boolean.valueOf(status);
        }

        @Override
        public List getAddedResource(DataObject dobj, Map auditmap) {
            HashMap<Long, String> newmap = new HashMap<Long, String>();
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.SYSLOGFILTER;
            String tablename = table.getTableNamefromTableNames();
            String columnname = table.getColumnName();
            String columnid = table.getColumnID();
            try {
                Row temp = dobj.getRow(tablename);
                Long id = (Long)temp.get(columnid);
                String value = (String)temp.get(columnname);
                Map existMap = (Map)auditmap.get((Object)FILTER);
                newmap.put(id, value);
                newmap.putAll(existMap);
                resourceList.add(value);
                auditmap.put(FILTER, newmap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getUpdatedResource(DataObject dobj, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.LACRITERIA;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            String columnname = table.getColumnName();
            try {
                Long critid = (Long)dobj.getFirstValue(tablename, columnid);
                String value = AuditType.getfromdatabase(tablename, columnname, columnid, critid);
                resourceList.add(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getDeletedResource(DataObject dobj, List deleteCrit, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.SYSLOGFILTER;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            String resourceName = null;
            for (int i = 0; i < deleteCrit.size(); ++i) {
                Criteria cri = (Criteria)deleteCrit.get(i);
                Column col = cri.getColumn();
                if (!col.getColumnName().equals(columnid)) continue;
                Long criValue = (Long)cri.getValue();
                resourceName = (String)((Map)auditmap.get((Object)FILTER)).get(criValue);
                resourceList.add(resourceName);
            }
            return resourceList;
        }
    }
    ,
    REPORT{

        @Override
        public TableNames getTableName() {
            return TableNames.REPORTCONFIG;
        }

        @Override
        public TableNames getUniqueTable() {
            return TableNames.REPORTCONFIG;
        }

        @Override
        public TableNames getUpdateTable() {
            return TableNames.REPORTCONFIGTORBBMAPPING;
        }

        @Override
        public List getUpdateTables() {
            return Arrays.asList("ReportBuildingBlock", "ReportConfigToRBBMapping", "ReportConfigToRBBPMapping");
        }

        @Override
        public boolean getAuditStatus() {
            String status = System.getProperty("reportaudit", "true");
            return Boolean.valueOf(status);
        }

        @Override
        public List getAddedResource(DataObject dobj, Map auditmap) {
            HashMap<Long, String> newmap = new HashMap<Long, String>();
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.REPORTCONFIG;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            try {
                Long repid = (Long)dobj.getFirstValue(tablename, columnid);
                table = TableNames.REPORTCONFIG;
                tablename = table.getTableNamefromTableNames();
                String columnname = table.getColumnName();
                String value = AuditType.getfromdatabase(tablename, columnname, columnid, repid);
                resourceList.add(value);
                Map existMap = (Map)auditmap.get((Object)REPORT);
                newmap.put(repid, value);
                newmap.putAll(existMap);
                auditmap.put(REPORT, newmap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getUpdatedResource(DataObject dobj, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.REPORTCONFIGTORBBMAPPING;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            try {
                Long repid = (Long)dobj.getFirstValue(tablename, columnid);
                table = TableNames.REPORTCONFIG;
                tablename = table.getTableNamefromTableNames();
                String columnname = table.getColumnName();
                String value = AuditType.getfromdatabase(tablename, columnname, columnid, repid);
                resourceList.add(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getDeletedResource(DataObject dobj, List deleteCrit, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.REPORTCONFIGTORBBMAPPING;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            String resourceName = null;
            for (int i = 0; i < deleteCrit.size(); ++i) {
                Criteria cri = (Criteria)deleteCrit.get(i);
                Column col = cri.getColumn();
                if (!col.getColumnName().equals(columnid)) continue;
                Long criValue = (Long)cri.getValue();
                resourceName = (String)((Map)auditmap.get((Object)REPORT)).get(criValue);
                resourceList.add(resourceName);
            }
            return resourceList;
        }
    }
    ,
    HOST{

        @Override
        public TableNames getTableName() {
            return TableNames.HOSTS;
        }

        @Override
        public TableNames getUpdateTable() {
            return TableNames.HOSTDETAILS;
        }

        @Override
        public TableNames getUniqueTable() {
            return TableNames.HOSTDETAILS;
        }

        @Override
        public List getUpdateTables() {
            return Arrays.asList("HostDetails");
        }

        @Override
        public boolean getAuditStatus() {
            String status = System.getProperty("hostaudit", "true");
            return Boolean.valueOf(status);
        }

        @Override
        public List getAddedResource(DataObject dobj, Map auditmap) {
            HashMap<Long, String> newmap = new HashMap<Long, String>();
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.HOSTS;
            String tablename = table.getTableNamefromTableNames();
            String statuscolumn = TableNames.HOSTDETAILS.getStatusColumn();
            String columnname = table.getColumnName();
            String columnid = table.getColumnID();
            try {
                Long hostid = (Long)dobj.getFirstValue(tablename, columnid);
                String value = (String)dobj.getFirstValue(tablename, columnname);
                int status = (Integer)dobj.getFirstValue("HostDetails", statuscolumn);
                Map existMap = (Map)auditmap.get((Object)HOST);
                newmap.put(hostid, value);
                newmap.putAll(existMap);
                resourceList.add(value);
                auditmap.put(HOST, newmap);
                ELAAuditImpl.getHostStatusMap().put(hostid, status);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getUpdatedResource(DataObject dobj, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.HOSTDETAILS;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            try {
                Long repid = (Long)dobj.getFirstValue(tablename, columnid);
                table = TableNames.REPORTCONFIG;
                tablename = table.getTableNamefromTableNames();
                String columnname = table.getColumnName();
                String value = AuditType.getfromdatabase(tablename, columnid, columnname, repid);
                resourceList.add(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return resourceList;
        }

        @Override
        public List getDeletedResource(DataObject dobj, List deleteCrit, Map auditmap) {
            ArrayList<String> resourceList = new ArrayList<String>();
            TableNames table = TableNames.HOSTS;
            String tablename = table.getTableNamefromTableNames();
            String columnid = table.getColumnID();
            for (int i = 0; i < deleteCrit.size(); ++i) {
                Criteria cri = (Criteria)deleteCrit.get(i);
                Column col = cri.getColumn();
                if (!col.getColumnName().equals(columnid)) continue;
                Long criValue = (Long)cri.getValue();
                String resourceName = (String)((Map)auditmap.get((Object)HOST)).get(criValue);
                resourceList.add(resourceName);
            }
            return resourceList;
        }
    };


    public abstract TableNames getTableName();

    public abstract List getUpdateTables();

    public abstract TableNames getUpdateTable();

    public abstract boolean getAuditStatus();

    public abstract TableNames getUniqueTable();

    public abstract List getAddedResource(DataObject var1, Map var2);

    public abstract List getUpdatedResource(DataObject var1, Map var2);

    public abstract List getDeletedResource(DataObject var1, List var2, Map var3);

    private static String getfromdatabase(String tablename, String columnname, String columnidname, Long id) {
        String resource = null;
        try {
            SelectQueryImpl selectqry = new SelectQueryImpl(new Table(tablename));
            selectqry.addSelectColumn(new Column(tablename, "*"));
            DataObject db = DataAccess.get((String)tablename, (Criteria)new Criteria(new Column(tablename, columnidname), (Object)id, 0));
            resource = (String)db.getFirstValue(tablename, columnname);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resource;
    }
}

