/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.audit;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.la.util.PersistenceDBUtil;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.OperationInfo;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sa.server.audit.AuditType;
import com.adventnet.sa.server.audit.TableNames;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ELAAuditImpl {
    private static Persistence persistence = PersistenceDBUtil.getPersistence();
    private static HashMap<AuditType, Map> auditmap = new HashMap();
    private static HashMap hoststatusmap = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(ELAAuditImpl.class.getName());

    public static HashMap getHostStatusMap() {
        return hoststatusmap;
    }

    public static void addToAuditResource(String type, Long id, String value) {
        AuditType auditType;
        switch (type) {
            case "ARCHIVE": {
                auditType = AuditType.ARCHIVE;
                break;
            }
            case "ALERT": {
                auditType = AuditType.ALERT;
                break;
            }
            case "HOST": {
                auditType = AuditType.HOST;
                break;
            }
            case "FILTER": {
                auditType = AuditType.FILTER;
                break;
            }
            case "REPORT": {
                auditType = AuditType.REPORT;
                break;
            }
            default: {
                return;
            }
        }
        HashMap<Long, String> newmap = new HashMap<Long, String>();
        Map existMap = auditmap.get((Object)auditType);
        newmap.put(id, value);
        newmap.putAll(existMap);
        auditmap.put(auditType, newmap);
    }

    private static Map getMap(String tablename, String columnname, String columnid) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        try {
            SelectQueryImpl selectqry = new SelectQueryImpl(new Table(tablename));
            selectqry.addSelectColumn(new Column(tablename, "*"));
            DataObject db = persistence.get((SelectQuery)selectqry);
            Iterator itr = db.getRows(tablename);
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                Long id = (Long)row.get(columnid);
                String name = (String)row.get(columnname);
                map.put(id, name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    private static void populateHoststatus() {
        TableNames table = TableNames.HOSTDETAILS;
        try {
            String tablename = table.getTableNamefromTableNames();
            SelectQueryImpl selectqry = new SelectQueryImpl(new Table(tablename));
            selectqry.addSelectColumn(new Column(tablename, "*"));
            DataObject db = persistence.get((SelectQuery)selectqry);
            Iterator itr = db.getRows(tablename);
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                Long id = (Long)row.get(table.getColumnID());
                int status = (Integer)row.get(table.getColumnName());
                hoststatusmap.put(id, status);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        for (AuditType elaaudit : AuditType.values()) {
            TableNames tablenameobj = elaaudit.getTableName();
            String tablename = tablenameobj.getTableNamefromTableNames();
            String columnname = tablenameobj.getColumnName();
            String columnid = tablenameobj.getColumnID();
            Map idvsname = ELAAuditImpl.getMap(tablename, columnname, columnid);
            auditmap.put(elaaudit, idvsname);
            LOGGER.log(Level.FINER, "auditmap in ELAAuditImpl{0}:::", auditmap);
        }
        ELAAuditImpl.populateHoststatus();
    }

    public static boolean processAudit(OperationInfo opInfo) {
        List tables = opInfo.getTableNames();
        for (AuditType elaauditcategory : AuditType.values()) {
            TableNames uniqueTableobj = elaauditcategory.getUniqueTable();
            String uniqueTable = uniqueTableobj.getTableNamefromTableNames();
            if (tables.contains("ReportConfig") && tables.size() == 1) {
                return false;
            }
            if (!tables.contains(uniqueTable) && (!tables.containsAll(elaauditcategory.getUpdateTables()) || !elaauditcategory.getUpdateTables().containsAll(tables) || !elaauditcategory.getAuditStatus())) continue;
            ELAAuditImpl.addtodBAuditTable(elaauditcategory, opInfo, tables);
            break;
        }
        return true;
    }

    private static DataObject addtoDB(DataObject addObj, AuditType auditcat, String action, String res, String login) {
        try {
            Row auditRow = new Row("EventLogUserAudit");
            auditRow.set("USERNAME", (Object)login);
            auditRow.set("TIMESTAMP", (Object)System.currentTimeMillis());
            auditRow.set("TYPE", (Object)auditcat.name());
            if (res != null) {
                auditRow.set("RESOURCENAME", (Object)(res.length() > 255 ? res.substring(0, 254) : res));
            } else {
                auditRow.set("RESOURCENAME", (Object)res);
            }
            auditRow.set("ACTION", (Object)action);
            auditRow.set("STATUS", (Object)1L);
            addObj.addRow(auditRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return addObj;
    }

    private static String getfromDB(Long hostid) {
        String resource = null;
        try {
            resource = (String)DataAccess.get((String)"Hosts", (Criteria)new Criteria(new Column("Hosts", "HOST_ID"), (Object)hostid, 0)).getFirstValue("Hosts", "HOST_NAME");
        }
        catch (DataAccessException de) {
            de.printStackTrace();
        }
        return resource;
    }

    private static void addtodBAuditTable(AuditType auditcategory, OperationInfo opinfo, List tablelist) {
        try {
            persistence = PersistenceDBUtil.getPersistence();
            DataObject dobj = opinfo.getDataObject();
            DataObject addObj = persistence.constructDataObject();
            TableNames tablenameobj = auditcategory.getTableName();
            String tablename = tablenameobj.getTableNamefromTableNames();
            String columnname = tablenameobj.getColumnName();
            String columnid = tablenameobj.getColumnID();
            String action = null;
            Object resourceName = null;
            List resourceNamelist = new ArrayList();
            Credential userCredential = AuthUtil.getUserCredential();
            if (userCredential != null) {
                String loginName = userCredential.getLoginName();
                if (loginName == null) {
                    loginName = "EventLog_System";
                }
                if (opinfo.getOperation() == 1 && auditcategory.getUpdateTables().containsAll(tablelist)) {
                    resourceNamelist = auditcategory.getUpdatedResource(dobj, auditmap);
                    action = "UPDATED";
                } else if (opinfo.getOperation() == 1) {
                    resourceNamelist = auditcategory.getAddedResource(dobj, auditmap);
                    action = "ADDED";
                } else if (opinfo.getOperation() == 2 && auditcategory != AuditType.ARCHIVE) {
                    String res;
                    TableNames updatetableObj = auditcategory.getUpdateTable();
                    String updatetable = updatetableObj.getTableNamefromTableNames();
                    String statuscolumn = updatetableObj.getStatusColumn();
                    String colname = updatetableObj.getColumnName();
                    Row enadisRow = dobj.getRow(updatetable);
                    if (auditcategory != AuditType.HOST) {
                        int status = (Integer)enadisRow.get(statuscolumn);
                        action = status == 1 ? "ENABLED" : "DISABLED";
                        res = (String)enadisRow.get(colname);
                        addObj = ELAAuditImpl.addtoDB(addObj, auditcategory, action, res, loginName);
                    } else {
                        Long hostid = (Long)enadisRow.get(columnid);
                        res = (String)auditmap.get((Object)auditcategory).get(hostid);
                        int existingstatus = 1;
                        if (!hoststatusmap.containsKey(hostid)) {
                            res = ELAAuditImpl.getfromDB(hostid);
                            HashMap<Long, String> newmap = new HashMap<Long, String>();
                            Map existMap = auditmap.get((Object)AuditType.HOST);
                            newmap.put(hostid, res);
                            newmap.putAll(existMap);
                            auditmap.put(AuditType.HOST, newmap);
                        } else {
                            existingstatus = (Integer)hoststatusmap.get(hostid);
                        }
                        int status = (Integer)enadisRow.get(statuscolumn);
                        int statusresult = existingstatus ^ status;
                        action = "UPDATED";
                        if (statusresult == 1) {
                            action = status == 1 ? "ENABLED" : "DISABLED";
                            hoststatusmap.put(hostid, status);
                        }
                        addObj = ELAAuditImpl.addtoDB(addObj, auditcategory, action, res, loginName);
                    }
                } else if (opinfo.getOperation() == 3) {
                    action = "DELETED";
                    List deleteCrit = opinfo.getInputDeleteCriterias();
                    resourceNamelist = auditcategory.getDeletedResource(dobj, deleteCrit, auditmap);
                }
                LOGGER.log(Level.FINER, "ResourceNamelist in ELAAuditImpl {0}:::", resourceNamelist);
                for (String resource : resourceNamelist) {
                    addObj = ELAAuditImpl.addtoDB(addObj, auditcategory, action, resource, loginName);
                }
                LOGGER.log(Level.FINER, "DOBJ in ELAAuditImpl to be added in DB {0}", addObj);
                persistence.update(addObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

