/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.auth;

import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.sa.server.dbsync.domain.DomainSyncHandler;
import com.manageengine.ads.fw.domain.ADSDomainHandler;
import com.manageengine.ads.fw.sso.CustomSSOAuthenticator;
import com.manageengine.ads.fw.sso.cookie.Ticket;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class ELACustomSSOAuthenticator
implements CustomSSOAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ELACustomSSOAuthenticator.class.getName());
    private Ticket ticketObj = null;
    private DataObject accountDO = null;

    public void init(Ticket ticketObj) {
        try {
            String domainName = "EventLog Authentication";
            if (ticketObj.isDomainAuthentication) {
                JSONObject domainData = ADSDomainHandler.getDomainDetails((String)ticketObj.domainName);
                if (domainData.length() != 0) {
                    ticketObj.domainName = domainData.getString("DOMAIN_FLAT_NAME");
                }
                domainName = ticketObj.domainName;
            }
            this.accountDO = AuthDBUtil.getAccountDO((String)ticketObj.loginName, (String)ticketObj.serviceName, (String)domainName);
            this.ticketObj = ticketObj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValidAccount() throws LoginException {
        try {
            if (this.ticketObj.isDomainAuthentication) {
                Properties aaaProp = DomainSyncHandler.getDomainFromAAALogin(this.ticketObj.loginName);
                if (aaaProp == null || aaaProp.isEmpty()) {
                    throw new LoginException("ela.ELAAuthenticator.No_such_account_configured");
                }
                Properties properties = DomainSyncHandler.getDomainDetails(aaaProp.getProperty("DOMAINNAME"));
                if (properties == null || properties.isEmpty()) {
                    throw new LoginException("ela.ELAAuthenticator.No_such_account_configured_for_Domain");
                }
                this.accountDO = AuthDBUtil.getAccountDO((String)this.ticketObj.loginName, (String)this.ticketObj.serviceName, (String)aaaProp.getProperty("DOMAINNAME"));
            }
            return this.isValidAccount(this.accountDO);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "An exception has occured while customsso authentication : " + e.getMessage());
            if (e.getMessage() != null) {
                throw new LoginException("Invalid Domain");
            }
            throw new LoginException(e.getMessage());
        }
    }

    private boolean isValidAccount(DataObject accountDO) throws LoginException, DataAccessException {
        String status;
        if (accountDO == null) {
            throw new LoginException("ela.ELAAuthenticator.Account_DO_fetched_is_null");
        }
        if (!accountDO.containsTable("AaaAccount")) {
            throw new LoginException("ela.ELAAuthenticator.No_such_account_configured");
        }
        if (!accountDO.containsTable("AaaPassword")) {
            throw new LoginException("ela.ELAAuthenticator.No_password_configured_for_this");
        }
        if (accountDO.containsTable("AaaUserStatus") && (status = (String)this.accountDO.getFirstValue("AaaUserStatus", "STATUS")).equals("DISABLED")) {
            throw new LoginException("User status is disabled");
        }
        return true;
    }

    public boolean authenticate() throws LoginException {
        try {
            return this.ticketObj.isValidTicket;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public DataObject getDataObject() {
        return this.accountDO;
    }

    public boolean ntlmAuthenticate() throws LoginException {
        return false;
    }

    public void setSessionAttributes(HttpServletRequest request) throws LoginException {
    }

    public void init(Properties ntlmProperties) {
    }
}

