/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.authentication;

import com.adventnet.authentication.PAMException;
import com.adventnet.authentication.lm.Authenticator;
import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.la.util.ProductBundle;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.Row;
import com.manageengine.ads.fw.util.StrUtil;
import com.manageengine.ela.server.common.authentication.AuthenticationUtil;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class ELAAuthenticator
extends Authenticator {
    public static final String ELA_AUTHENTICATION = "EventLog Authentication";
    public static final String SESSION_KEY_TIMEZONE_ID = "clientTimeZoneID";
    public static final String SESSION_DOMAIN_NAME = "domainName";
    public static ResourceBundle rb = ProductBundle.getInstance().getBundle();
    private static final Logger LOGGER = Logger.getLogger(ELAAuthenticator.class.getName());

    public boolean authenticate() throws LoginException {
        boolean result;
        block8: {
            result = false;
            if (this.domainName == null) {
                this.domainName = ELA_AUTHENTICATION;
            }
            try {
                JSONObject loginCookie = AuthenticationUtil.getCredentialCookie(this.request);
                if (loginCookie != null) {
                    this.password = loginCookie.getString("PASSWORD");
                }
                JSONObject loginDetails = StrUtil.parseUserCredential((String)this.domainName, (String)this.loginName);
                LOGGER.log(Level.FINE, "Login details are : " + loginDetails);
                this.domainName = loginDetails.has(SESSION_DOMAIN_NAME) ? loginDetails.getString(SESSION_DOMAIN_NAME) : ELA_AUTHENTICATION;
                this.loginName = loginDetails.getString("loginName").toLowerCase();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LOGGER.log(Level.INFO, "Login Name is : " + this.loginName + " domainName is : " + this.domainName);
            if (ELA_AUTHENTICATION.equals(this.domainName)) {
                try {
                    String salt;
                    String encPwd;
                    this.accountDO = AuthDBUtil.getAccountDO((String)this.loginName, (String)this.serviceName, (String)this.domainName);
                    LOGGER.log(Level.FINE, "Account DO is : " + this.accountDO);
                    if (!AuthenticationUtil.isValidAccount(this.accountDO, this.request)) break block8;
                    Row pwdRow = this.accountDO.getFirstRow("AaaPassword");
                    String pwdFrmDB = (String)pwdRow.get("PASSWORD");
                    result = pwdFrmDB.equals(encPwd = AuthUtil.getEncryptedPassword((String)this.password, (String)(salt = (String)pwdRow.get("SALT"))));
                    if (result) {
                        LOGGER.info("setting common session attributes");
                        ELAAuthenticator.setCommonSessionAttributes(this.request);
                        break block8;
                    }
                    throw new LoginException("ela.ELAADAuthenticator.Invalid_loginNamepassword");
                }
                catch (DataAccessException dae) {
                    throw new PAMException(rb.getString("ela.ELAADAuthenticator.DataAccessException_occured_while_fetching_account"), (Exception)((Object)dae));
                }
            }
        }
        AuthenticationUtil.checkAndHandleKeepMeSignedIn(this.request, result);
        return result;
    }

    public static void setCommonSessionAttributes(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String timeZoneOffset = request.getParameter(SESSION_KEY_TIMEZONE_ID);
        LOGGER.log(Level.INFO, "clientTimeZoneID:" + timeZoneOffset);
        session.setAttribute(SESSION_KEY_TIMEZONE_ID, (Object)timeZoneOffset);
        session.setAttribute(SESSION_DOMAIN_NAME, (Object)request.getParameter(SESSION_DOMAIN_NAME));
    }
}

