/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sa.server.cnf;

import com.adventnet.la.util.ProductBundle;
import com.adventnet.sa.server.nf.EMailNotifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CorrelMailTemplate {
    private static List fields = Arrays.asList("SOURCEOFLOG", "DHOST");
    private String content = null;
    private static StringBuilder messageBuilder = new StringBuilder();
    private static StringBuilder plainText = new StringBuilder();
    private static final List<String> EXCLUDED_KEYS_FOR_CONTENT = Arrays.asList("RULEID", "RULECRITERIA", "Time", "TIME");

    public CorrelMailTemplate(String fileName, String messagePattern, Hashtable logData) {
        this.content = this.loadContent(fileName, messagePattern, logData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadContent(String fileName, String mailPattern, Hashtable logData) {
        StringBuffer buffer = new StringBuffer();
        String templateFile = System.getProperty("server.home") + File.separator + "server" + File.separator + "conf" + File.separator + fileName;
        BufferedReader reader = null;
        String content = null;
        try {
            reader = new BufferedReader(new FileReader(templateFile));
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                buffer.append(temp);
                if (EMailNotifier.isHTMLFormat) continue;
                buffer.append("\n");
            }
            content = CorrelMailTemplate.updateI18NStringsforCorr(buffer.toString(), mailPattern, logData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return content;
    }

    private static String updateI18NStringsforCorr(String content, String mailPattern, Hashtable logData) {
        ResourceBundle rb = ProductBundle.getInstance().getBundle();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("CorrelationMailH1", rb.getString("CorrelationMail.Head1"));
            map.put("CorrelationMailH2", rb.getString("CorrelationMail.Head2"));
            map.put("CorrelationMailH3", rb.getString("CorrelationMail.Head3"));
            map.put("CorrelationMailH4", rb.getString("CorrelationMail.Head4"));
            map.put("CorrelationMailH5", rb.getString("CorrelationMail.Head5"));
            map.put("CorrelationMailH6", rb.getString("CorrelationMail.Head6"));
            map.put("CorrelationMailH7", rb.getString("CorrelationMail.Head7"));
            map.put("CorrelationMailH8", rb.getString("CorrelationMail.Head8"));
            map.put("Year", rb.getString("Copyright.Year"));
            map.put("CorrelationContent", CorrelMailTemplate.getDataForMessage(rb, logData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CorrelMailTemplate.replaceStringsFromMap(content, map);
    }

    private static boolean isExcludedField(String key) {
        return EXCLUDED_KEYS_FOR_CONTENT.contains(key);
    }

    private static String getDataForMessage(ResourceBundle rb, Hashtable logData) {
        StringBuilder finalString = new StringBuilder();
        finalString.append(rb.getString("CorrelationMail.Head9"));
        finalString.append("\n");
        logData.forEach((key, value) -> {
            if (!CorrelMailTemplate.isExcludedField(key.toString())) {
                try {
                    finalString.append(messageBuilder.toString().replaceAll("\\$key", rb.getString("CorrelationKey.".concat(key.toString()))).replaceAll("\\$value", value.toString()));
                    finalString.append("\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return finalString.toString();
    }

    private static String replaceStringsFromMap(String content, Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        Pattern findPattern = Pattern.compile("\\$\\{(\\w+)\\}");
        Matcher m = findPattern.matcher(content);
        while (m.find()) {
            String toBeReplaced = m.group(1);
            String replacement = map.get(toBeReplaced);
            if (replacement == null) {
                replacement = m.group(0);
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String getContent() {
        return this.content;
    }

    static {
        messageBuilder.append("<tr>\n");
        messageBuilder.append("<td style=\"border-right:1px solid #C3D0D7;font:normal 11px Arial, Helvetica, sans-serif;\" bgcolor=\"#F4F4F4\" ><b>$key</b></td>\n");
        messageBuilder.append("\t<td style=\"font:normal 11px Arial, Helvetica, sans-serif;\" bgcolor=\"#F4F4F4\">$value</td>\n");
        messageBuilder.append("</tr>");
        plainText.append("$key  : $value");
    }
}

